/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import xeadEditor.Editor;
import xeadEditor.Editor_EditableField;
import xeadEditor.Editor_TextArea;
import xeadEditor.Editor_TextField;

class Editor_EditableTableField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    Element fieldElement_ = null;
    private String fieldID_ = "";
    private String dbName = "";
    private String fieldCaption = "";
    private String dataType = "";
    private int dataSize = 5;
    private int decimalSize = 0;
    private String dataTypeOptions = "";
    private ArrayList<String> dataTypeOptionList;
    private int fieldRows = 1;
    private JPanel jPanelField = new JPanel();
    private JLabel jLabelField = new JLabel();
    private Editor_TextField textField = null;
    private Editor_TextArea textArea = null;
    private Editor_EditableField component = null;
    private String errorMessage = "";
    private boolean isNullable = true;
    private boolean isKey = false;
    private boolean isEditControlled = false;
    private Editor editor_;
    private Color errorColor = Editor.ERROR_COLOR;
    private Color activeColor = Editor.ACTIVE_COLOR;
    private Color inactiveColor = Editor.INACTIVE_COLOR;

    public Editor_EditableTableField(Element fieldElement, Editor editor) {
        this.editor_ = editor;
        this.fieldElement_ = fieldElement;
        Element tableElement = (Element)this.fieldElement_.getParentNode();
        String dbID = tableElement.getAttribute("DB");
        this.dbName = this.editor_.getDatabaseNameList().get(this.editor_.getDatabaseIDList().indexOf(dbID));
        this.fieldID_ = this.fieldElement_.getAttribute("ID");
        this.dataType = this.fieldElement_.getAttribute("Type");
        this.dataTypeOptions = this.fieldElement_.getAttribute("TypeOptions");
        this.dataTypeOptionList = this.editor_.getOptionList(this.dataTypeOptions);
        this.fieldCaption = this.fieldElement_.getAttribute("Name").equals("") ? this.fieldElement_.getAttribute("ID") : this.fieldElement_.getAttribute("Name");
        this.dataSize = Integer.parseInt(this.fieldElement_.getAttribute("Size"));
        if (!this.fieldElement_.getAttribute("Decimal").equals("")) {
            this.decimalSize = Integer.parseInt(this.fieldElement_.getAttribute("Decimal"));
        }
        if (this.fieldElement_.getAttribute("Nullable").equals("F")) {
            this.isNullable = false;
        }
        this.jLabelField = new JLabel(this.fieldCaption);
        this.jLabelField.setPreferredSize(new Dimension(170, 15));
        this.jLabelField.setHorizontalAlignment(4);
        this.jLabelField.setVerticalAlignment(1);
        this.jLabelField.setFont(new Font(this.editor_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelField.setEnabled(false);
        if (this.dataType.equals("VARCHAR") || this.dataType.equals("LONG VARCHAR")) {
            this.textArea = new Editor_TextArea(this.dataSize, this.dataTypeOptions, this.editor_);
            this.textArea.setLocation(5, 0);
            this.textArea.setEnabled(false);
            this.component = this.textArea;
        } else {
            this.textField = new Editor_TextField(this.getBasicType(), this.dataSize, this.decimalSize, this.dataTypeOptions, this.editor_);
            this.textField.setLocation(5, 0);
            this.textField.setEnabled(false);
            this.component = this.textField;
        }
        this.fieldRows = this.component.getRows();
        this.jPanelField.setLayout(null);
        this.jPanelField.setPreferredSize(new Dimension(this.component.getWidth() + 5, this.component.getHeight()));
        this.jPanelField.add((JComponent)((Object)this.component));
        this.component.setValue(this.getNullValue());
        this.component.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(this.component.getWidth() + 180, this.component.getHeight()));
        this.add((Component)this.jLabelField, "West");
        this.add((Component)this.jPanelField, "Center");
    }

    public ArrayList<String> getDataTypeOptionList() {
        return this.dataTypeOptionList;
    }

    public String getFieldID() {
        return this.fieldID_;
    }

    public String getFieldName() {
        if (this.fieldElement_.getAttribute("Name").equals("")) {
            return this.fieldElement_.getAttribute("ID");
        }
        return this.fieldElement_.getAttribute("Name");
    }

    public boolean isEditControlled() {
        return this.isEditControlled;
    }

    public void setCaption(String caption) {
        this.jLabelField.setText(caption);
    }

    public void setEditControlled(boolean isEditControlled) {
        this.isEditControlled = isEditControlled;
        if (this.isEditControlled) {
            this.setFocusable(false);
        }
    }

    public boolean isLiteralRequired() {
        return this.dataType.equals("CHAR") || this.dataType.equals("VARCHAR") || this.dataType.equals("LONG VARCHAR") || this.dataType.equals("DATE") || this.dataType.equals("DATETIME") || this.dataType.equals("TIME") || this.dataType.equals("TIMETZ") || this.dataType.equals("TIMESTAMP") || this.dataType.equals("TIMESTAMPTZ");
    }

    public int getRows() {
        return this.fieldRows;
    }

    public String getBasicType() {
        return this.editor_.getBasicTypeOf(this.dataType);
    }

    public int getDecimalSize() {
        return this.decimalSize;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setKey(boolean key) {
        this.isKey = key;
        if (this.isKey) {
            this.jLabelField.setFont(new Font(this.editor_.mainFontName, 1, Editor.MAIN_FONT_SIZE));
        }
    }

    public boolean isKey() {
        return this.isKey;
    }

    public boolean isEditable() {
        return this.component.isEditable();
    }

    @Override
    public void requestFocus() {
        this.component.requestFocus();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jLabelField.setEnabled(enabled);
        this.component.setEnabled(enabled);
        this.component.setEditable(false);
    }

    public Object getTableOperationValue() {
        Object returnValue = null;
        String basicType = this.getBasicType();
        if (basicType.equals("INTEGER")) {
            returnValue = Long.parseLong((String)this.getInternalValue());
        }
        if (basicType.equals("FLOAT")) {
            returnValue = Double.parseDouble((String)this.getInternalValue());
        }
        if (basicType.equals("STRING")) {
            String text = (String)this.getInternalValue();
            text = text.replaceAll("'", "''");
            if (this.dbName.contains("jdbc:mysql:")) {
                text = text.replaceAll("\\\\", "\\\\\\\\");
            }
            returnValue = "'" + text + "'";
        }
        if (basicType.equals("DATE")) {
            String strDate = (String)this.getInternalValue();
            returnValue = strDate == null || strDate.equals("") ? "NULL" : (this.dbName.contains("jdbc:ucanaccess:") ? "#" + strDate + "#" : "'" + strDate + "'");
        }
        if (basicType.equals("DATETIME")) {
            String timeDate = (String)this.getInternalValue();
            if (timeDate == null || timeDate.equals("")) {
                returnValue = "NULL";
            } else if (timeDate.equals("CURRENT_TIMESTAMP")) {
                returnValue = timeDate;
            } else {
                timeDate = timeDate.replace("/", "-");
                returnValue = this.dbName.contains("jdbc:ucanaccess:") ? "#" + timeDate + "#" : "'" + timeDate + "'";
            }
        }
        return returnValue;
    }

    public void setEditable(boolean editable) {
        if (editable) {
            this.component.setEditable(true);
            this.component.setBackground(this.activeColor);
        } else {
            this.component.setEditable(false);
            this.component.setBackground(this.inactiveColor);
        }
    }

    public void clear() {
        this.setValue(this.getNullValue());
    }

    public void setValue(Object object) {
        String wrkStr;
        String basicType = this.getBasicType();
        if (basicType.equals("INTEGER")) {
            if (object == null || object.equals("")) {
                this.component.setValue("");
            } else {
                wrkStr = object.toString();
                int pos = wrkStr.indexOf(".");
                if (pos >= 0) {
                    wrkStr = wrkStr.substring(0, pos);
                }
                if ((wrkStr = this.editor_.getStringNumber(wrkStr)).equals("")) {
                    this.component.setValue("");
                } else {
                    this.component.setValue(Long.parseLong(wrkStr));
                }
            }
        }
        if (basicType.equals("FLOAT")) {
            if (object == null || object.equals("")) {
                this.component.setValue("");
            } else {
                wrkStr = this.editor_.getStringNumber(object.toString());
                if (wrkStr.equals("")) {
                    this.component.setValue("");
                } else {
                    this.component.setValue(Double.parseDouble(wrkStr));
                }
            }
        }
        if (basicType.equals("STRING")) {
            if (object == null) {
                this.component.setValue("");
            } else {
                this.component.setValue(object);
            }
        }
        if (basicType.equals("DATE")) {
            if (object == null) {
                this.component.setValue("");
            } else {
                try {
                    this.component.setValue(object.toString().substring(0, 10));
                }
                catch (Exception e) {
                    this.component.setValue(object);
                }
            }
        }
        if (basicType.equals("DATETIME") || basicType.equals("TIME")) {
            if (object == null) {
                this.component.setValue("");
            } else {
                this.component.setValue(object.toString());
            }
        }
    }

    public Object getNullValue() {
        Object value = null;
        String basicType = this.getBasicType();
        if (basicType.equals("INTEGER") || basicType.equals("FLOAT")) {
            value = 0;
        }
        if (basicType.equals("STRING") || basicType.equals("DATETIME") || basicType.equals("TIME")) {
            value = "";
        }
        if (basicType.equals("DATE")) {
            value = "";
        }
        return value;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isNull() {
        Object value;
        boolean isNull = false;
        String basicType = this.getBasicType();
        if ((basicType.equals("INTEGER") || basicType.equals("FLOAT")) && ((value = (String)this.component.getInternalValue()) == null || ((String)value).equals("") || ((String)value).equals("0") || ((String)value).equals("0.0"))) {
            isNull = true;
        }
        if ((basicType.equals("STRING") || basicType.equals("DATETIME") || basicType.equals("TIME")) && ((value = (String)this.component.getInternalValue()) == null || ((String)value).equals(""))) {
            isNull = true;
        }
        if (basicType.equals("DATE") && ((value = (Date)this.component.getInternalValue()) == null || value.equals(""))) {
            isNull = true;
        }
        return isNull;
    }

    public Object getInternalValue() {
        String returnObj = null;
        String basicType = this.getBasicType();
        if (basicType.equals("INTEGER") || basicType.equals("FLOAT") || basicType.equals("STRING")) {
            String value = (String)this.component.getInternalValue();
            if (value == null) {
                value = "";
            }
            returnObj = value;
        }
        if (basicType.equals("DATE")) {
            returnObj = (String)this.component.getInternalValue();
        }
        if (basicType.equals("DATETIME")) {
            returnObj = (String)this.component.getInternalValue();
        }
        return returnObj;
    }

    public void setError(boolean error) {
        if (error) {
            if (this.component.isEditable()) {
                this.component.setBackground(this.errorColor);
            }
        } else {
            this.errorMessage = "";
            if (this.component.isEditable()) {
                this.component.setBackground(this.activeColor);
            } else {
                this.component.setBackground(this.inactiveColor);
            }
        }
    }

    private void setErrorMessage(String msg) {
        if (msg.equals("")) {
            this.setError(false);
            this.errorMessage = "";
        } else {
            this.setError(true);
            this.errorMessage = String.valueOf(this.fieldCaption) + ":" + msg;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void checkNullAndValueSize() {
        this.setErrorMessage("");
        String basicType = this.getBasicType();
        if (basicType.equals("INTEGER")) {
            long value = Long.parseLong((String)this.component.getInternalValue());
            if (!this.dataTypeOptionList.contains("HH_MM") && !this.isNullable && value == 0L) {
                this.setErrorMessage(res.getString("NullCheckMessage"));
            }
        }
        if (basicType.equals("FLOAT")) {
            double value = Double.parseDouble((String)this.component.getInternalValue());
            if (!this.isNullable && value == 0.0) {
                this.setErrorMessage(res.getString("NullCheckMessage"));
            }
        }
        if (basicType.equals("DATE")) {
            String strDate = (String)this.component.getInternalValue();
            if (!this.isNullable && (strDate == null || strDate.equals(""))) {
                this.setErrorMessage(res.getString("NullCheckMessage"));
            }
        }
        if (basicType.equals("STRING")) {
            String strWrk = (String)this.component.getInternalValue();
            if (!this.dataType.contains("VARCHAR") && strWrk.length() > this.dataSize) {
                this.setErrorMessage(res.getString("SizeCheckMessage"));
            }
            if (!this.isNullable && strWrk.equals("")) {
                this.setErrorMessage(res.getString("NullCheckMessage"));
            }
            if (this.dataTypeOptionList.contains("YMONTH") && strWrk.length() > 0 && strWrk.length() < 6) {
                this.setErrorMessage(res.getString("NullCheckMessage"));
            }
        }
    }
}

