/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.InternationalFormatter;

class Editor_NumberEditorFormatter
extends InternationalFormatter {
    private static final long serialVersionUID = 1L;
    private final SpinnerNumberModel model;

    Editor_NumberEditorFormatter(SpinnerNumberModel model, NumberFormat format) {
        super(format);
        this.model = model;
        this.setValueClass(model.getValue().getClass());
    }

    public Comparable getMaximum() {
        return this.model.getMaximum();
    }

    public Comparable getMinimum() {
        return this.model.getMinimum();
    }

    public void setMaximum(Comparable max) {
        this.model.setMaximum(max);
    }

    public void setMinimum(Comparable min) {
        this.model.setMinimum(min);
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        try {
            return super.stringToValue(text);
        }
        catch (ParseException e) {
            int num;
            Object object = this.getFormat().parseObject(text);
            if (object instanceof Integer) {
                num = (Integer)object;
            } else if (object instanceof Number) {
                num = new Integer(((Number)object).intValue());
            } else {
                throw e;
            }
            if (this.getMaximum().compareTo(num) < 0) {
                return this.getMaximum();
            }
            if (this.getMinimum().compareTo(num) > 0) {
                return this.getMinimum();
            }
            throw e;
        }
    }
}

