/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.im.InputSubset;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import xeadEditor.Editor;
import xeadEditor.Editor_EditableField;

class Editor_TextArea
extends JScrollPane
implements Editor_EditableField {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> dataTypeOptionList;
    private JTextArea jTextArea = new JTextArea();
    private int rows_ = 2;
    private int digits_ = 5;
    private Editor editor_;

    public Editor_TextArea(int digits, String dataTypeOptions, Editor editor) {
        this.digits_ = digits;
        if (this.digits_ == 0) {
            this.digits_ = Integer.MAX_VALUE;
        }
        this.editor_ = editor;
        this.dataTypeOptionList = this.editor_.getOptionList(dataTypeOptions);
        InputMap inputMap = this.jTextArea.getInputMap(0);
        ActionMap actionMap = this.jTextArea.getActionMap();
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke altEnter = KeyStroke.getKeyStroke(10, 8);
        inputMap.put(altEnter, inputMap.get(enter));
        inputMap.put(enter, "none");
        inputMap.put(tab, "Exit");
        AbstractAction exitAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor_TextArea.this.exitFromComponent();
            }
        };
        actionMap.put("Exit", exitAction);
        this.jTextArea.addFocusListener(new ComponentFocusListener());
        this.jTextArea.setFont(new Font(this.editor_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextArea.setLineWrap(true);
        this.getViewport().add((Component)this.jTextArea, null);
        this.jTextArea.setDocument(new LimitedDocument(this));
        int fieldWidth = 800;
        int fieldHeight = this.rows_ * 25;
        this.setSize(fieldWidth, fieldHeight);
    }

    public void exitFromComponent() {
        this.jTextArea.transferFocus();
    }

    @Override
    public boolean isEditable() {
        return this.jTextArea.isEditable();
    }

    @Override
    public void setBackground(Color color) {
        if (this.jTextArea != null) {
            this.jTextArea.setBackground(color);
        }
    }

    @Override
    public void setValue(Object text) {
        this.jTextArea.setText((String)text);
    }

    @Override
    public Object getInternalValue() {
        return this.jTextArea.getText();
    }

    @Override
    public void requestFocus() {
        this.jTextArea.requestFocus();
    }

    @Override
    public void setEditable(boolean editable) {
        this.jTextArea.setEditable(editable);
        if (editable) {
            this.jTextArea.setBackground(SystemColor.white);
        } else {
            this.jTextArea.setBackground(SystemColor.control);
        }
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    class ComponentFocusListener
    implements FocusListener {
        ComponentFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            Character.Subset[] subsets = new Character.Subset[]{InputSubset.LATIN_DIGITS};
            Editor_TextArea.this.getInputContext().setCharacterSubsets(subsets);
        }

        @Override
        public void focusGained(FocusEvent event) {
            Character.Subset[] subsets = new Character.Subset[]{InputSubset.LATIN_DIGITS};
            String lang = Locale.getDefault().getLanguage();
            if (Editor_TextArea.this.dataTypeOptionList.equals("KANJI")) {
                if (lang.equals("ja")) {
                    subsets = new Character.Subset[]{InputSubset.KANJI};
                }
                if (lang.equals("ko")) {
                    subsets = new Character.Subset[]{InputSubset.HANJA};
                }
                if (lang.equals("zh")) {
                    subsets = new Character.Subset[]{InputSubset.TRADITIONAL_HANZI};
                }
            }
            if (Editor_TextArea.this.dataTypeOptionList.equals("KATAKANA") && lang.equals("ja")) {
                subsets = new Character.Subset[]{InputSubset.HALFWIDTH_KATAKANA};
            }
            Editor_TextArea.this.getInputContext().setCharacterSubsets(subsets);
        }
    }

    class LimitedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        Editor_TextArea adaptee;

        LimitedDocument(Editor_TextArea adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) {
            try {
                if (offset + str.length() <= this.adaptee.digits_ && super.getLength() + str.length() <= this.adaptee.digits_) {
                    super.insertString(offset, str, a);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

