/*
 * Decompiled with CFR 0.152.
 */
package xeadServer;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadDriver.XFUtility;
import xeadServer.Session;
import xeadServer.XFExecutable;
import xeadServer.XFScriptable;
import xeadServer.XFTableEvaluator;
import xeadServer.XFTableOperator;

public class ScriptLauncher
implements XFExecutable,
XFScriptable {
    private Element functionElement_ = null;
    private HashMap<String, Object> parmMap_ = null;
    private HashMap<String, Object> returnMap_ = new HashMap();
    private Session session_ = null;
    private boolean errorHasOccured = false;
    private int programSequence;
    private StringBuffer processLog = new StringBuffer();
    private ScriptEngine scriptEngine;
    private Bindings engineScriptBindings;
    private ByteArrayOutputStream exceptionLog;
    private PrintStream exceptionStream;
    private String exceptionHeader = "";
    private HashMap<String, Object> variantMap = new HashMap();

    public ScriptLauncher(String functionID, Session session) {
        this.session_ = session;
        this.functionElement_ = null;
        NodeList functionElementList = this.session_.getFunctionList();
        int i = 0;
        while (i < functionElementList.getLength()) {
            Element element = (Element)functionElementList.item(i);
            if (element.getAttribute("ID").equals(functionID) && element.getAttribute("Type").equals("XF000")) {
                this.functionElement_ = element;
                break;
            }
            ++i;
        }
        if (this.functionElement_ == null) {
            this.exceptionHeader = "Invalid function ID: " + functionID;
            this.errorHasOccured = true;
            this.closeFunction();
        }
    }

    @Override
    public void callFunction(String functionID) {
        try {
            this.returnMap_ = this.session_.executeFunction(functionID, this.parmMap_);
        }
        catch (Exception e) {
            this.exceptionHeader = e.getMessage();
            this.errorHasOccured = true;
            this.closeFunction();
        }
        if (this.returnMap_.get("RETURN_CODE").equals("99")) {
            this.errorHasOccured = true;
        }
    }

    @Override
    public void cancelWithException(Exception e) {
        e.printStackTrace(this.exceptionStream);
        this.rollback();
        this.errorHasOccured = true;
        this.closeFunction();
    }

    @Override
    public void cancelWithMessage(String message) {
        this.returnMap_.put("RETURN_MESSAGE", message);
        this.rollback();
        this.errorHasOccured = true;
        this.closeFunction();
    }

    @Override
    public void cancelWithScriptException(ScriptException e, String scriptName) {
        this.exceptionHeader = scriptName.equals("") ? "'Script error in the function'\n" : "'" + scriptName + "' Script error\n";
        e.printStackTrace(this.exceptionStream);
        this.rollback();
        this.errorHasOccured = true;
        this.closeFunction();
    }

    @Override
    public void setErrorAndCloseFunction() {
        this.errorHasOccured = true;
        this.closeFunction();
    }

    @Override
    public Session getSession() {
        return this.session_;
    }

    @Override
    public String getUserValueOf(String dataSourceName) {
        return this.session_.getFilterValue(this.getFunctionID(), dataSourceName);
    }

    @Override
    public void setUserValueOf(String dataSourceName, Object value) {
        this.session_.setFilterValue(this.getFunctionID(), dataSourceName, value.toString());
    }

    @Override
    public void commit() {
        this.session_.commit(true, this.processLog);
    }

    @Override
    public XFTableOperator createTableOperator(String sqlText) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this.session_, this.processLog, sqlText);
        }
        catch (Exception e) {
            e.printStackTrace(this.exceptionStream);
            this.errorHasOccured = true;
            this.closeFunction();
        }
        return operator;
    }

    @Override
    public XFTableOperator createTableOperator(String operation, String tableID) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this.session_, this.processLog, operation, tableID);
        }
        catch (Exception e) {
            e.printStackTrace(this.exceptionStream);
            this.errorHasOccured = true;
            this.closeFunction();
        }
        return operator;
    }

    @Override
    public XFTableEvaluator createTableEvaluator(String tableID) {
        return new XFTableEvaluator(this, tableID, this.session_);
    }

    @Override
    public Object getFieldObjectByID(String arg0, String arg1) {
        return null;
    }

    @Override
    public HashMap<String, Object> getParmMap() {
        return this.parmMap_;
    }

    @Override
    public StringBuffer getProcessLog() {
        return this.processLog;
    }

    @Override
    public HashMap<String, Object> getReturnMap() {
        return this.returnMap_;
    }

    @Override
    public PrintStream getExceptionStream() {
        return this.exceptionStream;
    }

    @Override
    public void rollback() {
        this.session_.commit(false, this.processLog);
    }

    @Override
    public void setProcessLog(String text) {
        XFUtility.appendLog((String)text, (StringBuffer)this.processLog);
    }

    @Override
    public void endProgress() {
    }

    @Override
    public HashMap<String, Object> execute(HashMap<String, Object> parmMap) {
        try {
            this.parmMap_ = parmMap;
            if (this.parmMap_ == null) {
                this.parmMap_ = new HashMap();
            }
            this.returnMap_.clear();
            this.returnMap_.putAll(this.parmMap_);
            this.returnMap_.put("RETURN_CODE", "00");
            this.returnMap_.put("RESULT", "OK");
            this.errorHasOccured = false;
            this.exceptionLog = new ByteArrayOutputStream();
            this.exceptionStream = new PrintStream(this.exceptionLog);
            this.exceptionHeader = "";
            this.processLog.delete(0, this.processLog.length());
            this.variantMap.clear();
            this.scriptEngine = this.session_.getScriptEngineManager().getEngineByName("js");
            this.engineScriptBindings = this.scriptEngine.getBindings(100);
            this.runScript();
        }
        catch (ScriptException e) {
            this.cancelWithScriptException(e, "");
        }
        catch (Exception e) {
            this.cancelWithException(e);
        }
        return this.returnMap_;
    }

    @Override
    public Object getVariant(String variantID) {
        if (this.variantMap.containsKey(variantID)) {
            return this.variantMap.get(variantID);
        }
        return "";
    }

    @Override
    public void setVariant(String variantID, Object value) {
        this.variantMap.put(variantID, value);
    }

    public void runScript() throws ScriptException, Exception {
        this.programSequence = this.session_.writeLogOfFunctionStarted(this.functionElement_.getAttribute("ID"), this.functionElement_.getAttribute("Name"));
        this.engineScriptBindings.clear();
        this.engineScriptBindings.put("instance", (Object)this);
        this.engineScriptBindings.put("session", (Object)this.session_);
        String scriptText = XFUtility.substringLinesWithTokenOfEOL((String)this.functionElement_.getAttribute("Script"), (String)"\n");
        if (!scriptText.equals("")) {
            StringBuffer bf = new StringBuffer();
            bf.append(scriptText);
            bf.append(this.session_.getScriptFunctions());
            this.scriptEngine.eval(bf.toString());
        }
        this.closeFunction();
    }

    void closeFunction() {
        if (this.errorHasOccured) {
            this.returnMap_.put("RETURN_CODE", "99");
            this.rollback();
        }
        if (this.returnMap_.get("RETURN_MESSAGE") != null && !this.returnMap_.get("RETURN_MESSAGE").equals("")) {
            this.setProcessLog(this.returnMap_.get("RETURN_MESSAGE").toString());
        }
        String errorLog = "";
        if (this.exceptionLog.size() > 0 || !this.exceptionHeader.equals("")) {
            errorLog = String.valueOf(this.exceptionHeader) + this.exceptionLog.toString();
        }
        String wrkStr = this.processLog.toString();
        this.session_.writeLogOfFunctionClosed(this.programSequence, this.returnMap_.get("RETURN_CODE").toString(), wrkStr, errorLog);
    }

    @Override
    public HashMap<String, Object> execute(Element arg0, HashMap<String, Object> arg1) {
        return null;
    }

    @Override
    public String getFunctionID() {
        return this.functionElement_.getAttribute("ID");
    }

    @Override
    public void incrementProgress() {
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void setFunctionSpecifications(Element arg0) throws Exception {
    }

    @Override
    public void startProgress(String arg0, int arg1) {
    }
}

