/*
 * Decompiled with CFR 0.152.
 */
package xeadServer;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.w3c.dom.Document;
import xeadServer.ScriptLauncher;
import xeadServer.Session;

public class Service
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String APPLICATION_NAME = "X-TEA Server/ WEB-Service Controler";
    public static final String VERSION = "1.0.3";
    private String fileName = "";
    private String fixedUserID = "";
    private String fixedPassword = "";
    private String dateTimeServeletStarted = "";
    private String dateTimeFirstSessionStarted = "";
    private String dateTimeLastSessionStarted = "";
    private int countOfRequestsRejected = 0;
    private int countOfSessionsAborted = 0;
    private int countOfSessionsSucceeded = 0;

    public void init() throws ServletException {
        super.init();
        this.fileName = this.getServletConfig().getInitParameter("SystemDefinition");
        this.fixedUserID = this.getServletConfig().getInitParameter("User");
        if (this.fixedUserID == null) {
            this.fixedUserID = "";
        }
        this.fixedPassword = this.getServletConfig().getInitParameter("Password");
        if (this.fixedPassword == null) {
            this.fixedPassword = "";
        }
        Calendar cal = Calendar.getInstance();
        this.dateTimeServeletStarted = cal.getTime().toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            res.setContentType("text/html; charset=UTF-8");
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<head>");
            sb.append("<title>X-TEA Server/ Web Service Controler</title>");
            sb.append("</head>");
            sb.append("<body>");
            sb.append("<h3>X-TEA Server/ Web Service Controler(");
            sb.append(VERSION);
            sb.append(") Session Status</h3>");
            sb.append("<table border='2' cellpadding='2'>");
            sb.append("<tr><td style='background:#ccccff'>Servelet Started at</td><td>" + this.dateTimeServeletStarted + "</td></tr>");
            sb.append("<tr><td style='background:#ccccff'>First Session Started at</td><td>" + this.dateTimeFirstSessionStarted + "</td></tr>");
            sb.append("<tr><td style='background:#ccccff'>Last Session Started at</td><td>" + this.dateTimeLastSessionStarted + "</td></tr>");
            sb.append("<tr><td style='background:#ccccff'>Count of Requests Rejected</td><td>" + this.countOfRequestsRejected + "</td></tr>");
            sb.append("<tr><td style='background:#ccccff'>Count of Sessions Succeeded</td><td>" + this.countOfSessionsSucceeded + "</td></tr>");
            sb.append("<tr><td style='background:#ccccff'>Count of Sessions Aborted</td><td>" + this.countOfSessionsAborted + "</td></tr>");
            sb.append("</table>");
            sb.append("*Refer to session log for details.");
            sb.append("</body>");
            sb.append("</html>");
            PrintWriter out = res.getWriter();
            out.print(sb.toString());
            out.close();
        }
        catch (Exception e) {
            res.sendError(500, e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String userID = request.getParameter("USER");
            String password = request.getParameter("PASSWORD");
            if (userID == null || userID.equals("")) {
                userID = this.fixedUserID;
            }
            if (password == null || password.equals("")) {
                password = this.fixedPassword;
            }
            if (userID.equals("") || password.equals("")) {
                ++this.countOfRequestsRejected;
                response.setContentType("text/html;charset=UTF-8");
                PrintWriter out = response.getWriter();
                out.print("User and password is not specified in Web.xml and http request.");
                out.close();
            } else if (request.getParameter("FUNCTION") == null) {
                ++this.countOfRequestsRejected;
                response.setContentType("text/html;charset=UTF-8");
                PrintWriter out = response.getWriter();
                out.print("Parameter FUNCTION is missing int the request.");
                out.close();
            } else {
                PrintWriter writer;
                Session session = new Session(this.fileName, userID, password, VERSION);
                ScriptLauncher launcher = new ScriptLauncher(request.getParameter("FUNCTION"), session);
                HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                Enumeration names = request.getParameterNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    if (name.equals("FUNCTION")) continue;
                    String[] values = request.getParameterValues(name);
                    if (values.length == 1) {
                        paramsMap.put(name.toUpperCase(), values[0]);
                        continue;
                    }
                    if (values.length < 2) continue;
                    paramsMap.put(name.toUpperCase(), values);
                }
                HashMap<String, Object> returnMap = launcher.execute(paramsMap);
                session.closeSession(true);
                Calendar cal = Calendar.getInstance();
                if (this.dateTimeFirstSessionStarted.equals("")) {
                    this.dateTimeFirstSessionStarted = cal.getTime().toString();
                }
                this.dateTimeLastSessionStarted = cal.getTime().toString();
                if (returnMap.get("RETURN_CODE").toString().equals("99")) {
                    ++this.countOfSessionsAborted;
                } else {
                    ++this.countOfSessionsSucceeded;
                }
                Object result = returnMap.get("RESULT");
                if (result instanceof JSONObject) {
                    response.setContentType("application/json;charset=UTF-8");
                    JSONObject jsonObj = (JSONObject)result;
                    String resultString = jsonObj.toString();
                    writer = response.getWriter();
                    writer.print(resultString);
                    writer.close();
                }
                if (result instanceof Document) {
                    response.setContentType("text/xml;charset=UTF-8");
                    Document document = (Document)result;
                    OutputFormat outputFormat = new OutputFormat(document);
                    outputFormat.setEncoding("UTF-8");
                    writer = response.getWriter();
                    XMLSerializer xmlSerializer = new XMLSerializer(writer, outputFormat);
                    xmlSerializer.serialize(document.getDocumentElement());
                    writer.close();
                }
                if (result instanceof String) {
                    response.setContentType("");
                    String resultString = (String)result;
                    PrintWriter writer2 = response.getWriter();
                    writer2.print(resultString);
                    writer2.close();
                }
            }
        }
        catch (Exception e) {
            ++this.countOfRequestsRejected;
            response.sendError(500, e.getMessage());
        }
    }
}

