/*
 * Decompiled with CFR 0.152.
 */
package xeadServer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.xerces.parsers.DOMParser;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import xeadDriver.XFExcelFileOperator;
import xeadDriver.XFHttpRequest;
import xeadDriver.XFTextFileOperator;
import xeadDriver.XFUtility;
import xeadServer.DigestAdapter;
import xeadServer.ScriptLauncher;
import xeadServer.XFTableOperator;

public class Session {
    private String systemName = "";
    private String systemVersion = "";
    private String sessionID = "";
    private String sessionStatus = "";
    private String processorVersion = "";
    private boolean noErrorsOccured = true;
    private String databaseName = "";
    private String databaseUser = "";
    private String databasePassword = "";
    private String appServerName = "";
    private String fileName = "";
    private String userID = "";
    private String userName = "";
    private String userEmployeeNo = "";
    private String userEmailAddress = "";
    private String digestAlgorithmForUser = "MD5";
    private int countOfExpandForUser = 1;
    private boolean isValueSaltedForUser = false;
    private String userTable = "";
    private String userFilterValueTable = "";
    private String variantsTable = "";
    private String userVariantsTable = "";
    private String sessionTable = "";
    private String sessionDetailTable = "";
    private String numberingTable = "";
    private String calendarTable = "";
    public String taxTable = "";
    private String exchangeRateAnnualTable = "";
    private String exchangeRateMonthlyTable = "";
    private String imageFileFolder = "";
    private File outputFolder = null;
    private String logFileFolder = "";
    private int loggingSize = 0;
    private String dateFormat = "";
    public String systemFont = "";
    private int sqProgram = 0;
    private String currentFolder = "";
    private String loginScript = "";
    private String scriptFunctions = "";
    private String smtpHost = "";
    private String smtpPort = "";
    private String smtpUser = "";
    private String smtpPassword = "";
    private String smtpAdminEmail = "";
    private Connection connectionManualCommit = null;
    private Connection connectionAutoCommit = null;
    private ArrayList<String> subDBIDList = new ArrayList();
    private ArrayList<String> subDBNameList = new ArrayList();
    private ArrayList<String> subDBUserList = new ArrayList();
    private ArrayList<String> subDBPasswordList = new ArrayList();
    private ArrayList<Connection> subDBConnectionList = new ArrayList();
    private Calendar calendar = GregorianCalendar.getInstance();
    private Document domDocument;
    private NodeList functionList = null;
    private NodeList tableList = null;
    private ArrayList<String> offDateList = new ArrayList();
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private Bindings globalScriptBindings = null;
    private ScriptEngine scriptEngine = null;
    private DOMParser domParser = new DOMParser();
    private Document responseDoc = null;
    private HttpGet httpGet = new HttpGet();
    private static final String ZIP_URL = "http://zip.cgis.biz/xml/zip.php?";
    private HashMap<String, String> attributeMap = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Session(String fileName, String user, String password, String xeadServerVersion) throws Exception {
        if (!this.parseSystemDefinition(fileName)) throw new Exception("Failed to parse the system definition file.");
        if (!this.setupSessionVariants()) throw new Exception("System definition file is invalid to setup session.");
        if (!this.isAuthenticatedUser(user, password)) {
            throw new Exception("User or password is invalid.");
        }
        this.processorVersion = "S" + xeadServerVersion;
        this.writeLogAndStartSession();
    }

    boolean isAuthenticatedUser(String user, String password) throws Exception {
        boolean validated = false;
        if (user.matches("[0-9a-zA-Z]+") && !password.equals("")) {
            StringBuffer statementBuf = new StringBuffer();
            statementBuf.append("select * from ");
            statementBuf.append(this.getTableNameOfUserVariants());
            statementBuf.append(" where IDUSERKUBUN = 'KBCALENDAR'");
            XFTableOperator operator = new XFTableOperator(this, null, statementBuf.toString(), true);
            if (!operator.next()) {
                throw new Exception(XFUtility.RESOURCE.getString("LogInError5"));
            }
            if (this.getSystemVariantString("LOGIN_PERMITTED").equals("")) {
                throw new Exception(XFUtility.RESOURCE.getString("LogInError4"));
            }
            if (this.getSystemVariantString("LOGIN_PERMITTED").equals("F")) {
                throw new Exception(XFUtility.RESOURCE.getString("LogInError3"));
            }
            String passwordDigested = this.getDigestedValueForUser(user, password);
            statementBuf = new StringBuffer();
            statementBuf.append("select * from ");
            statementBuf.append(this.getTableNameOfUser());
            statementBuf.append(" where IDUSER = '");
            statementBuf.append(user);
            statementBuf.append("' and TXPASSWORD = '");
            statementBuf.append(passwordDigested);
            statementBuf.append("'");
            int retryCount = 0;
            while (retryCount < 3) {
                try {
                    ++retryCount;
                    operator = new XFTableOperator(this, null, statementBuf.toString(), true);
                    if (operator.next()) {
                        Date resultDateFrom = null;
                        Date resultDateThru = null;
                        Date today = new Date();
                        resultDateFrom = (Date)operator.getValueOf("DTVALID");
                        resultDateThru = (Date)operator.getValueOf("DTEXPIRE");
                        if (today.after(resultDateFrom) && (resultDateThru == null || today.before(resultDateThru))) {
                            this.userID = user;
                            this.userName = operator.getValueOf("TXNAME").toString().trim();
                            this.userEmployeeNo = operator.getValueOf("NREMPLOYEE").toString().trim();
                            this.userEmailAddress = operator.getValueOf("TXEMAIL").toString().trim();
                            validated = true;
                        }
                    }
                    retryCount = 3;
                }
                catch (Exception e) {
                    if (retryCount < 3) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    throw e;
                }
            }
        }
        return validated;
    }

    private boolean parseSystemDefinition(String fileName) throws Exception {
        if (fileName.startsWith("http:") || fileName.startsWith("https:") || fileName.startsWith("file:")) {
            URL url = new URL(fileName);
            URLConnection connection = url.openConnection();
            InputStream inputStream = connection.getInputStream();
            this.domParser.parse(new InputSource(inputStream));
            this.domDocument = this.domParser.getDocument();
            return true;
        }
        File xeafFile = new File(fileName);
        if (xeafFile.exists()) {
            this.currentFolder = xeafFile.getParent();
            this.domParser.parse(new InputSource(new FileInputStream(fileName)));
            this.domDocument = this.domParser.getDocument();
            return true;
        }
        throw new Exception(String.valueOf(XFUtility.RESOURCE.getString("SessionError21")) + fileName + XFUtility.RESOURCE.getString("SessionError22"));
    }

    private boolean setupSessionVariants() throws Exception {
        boolean isOkay;
        String wrkStr;
        NodeList nodeList = this.domDocument.getElementsByTagName("System");
        Element element = (Element)nodeList.item(0);
        this.systemName = element.getAttribute("Name");
        this.systemVersion = element.getAttribute("Version");
        this.dateFormat = element.getAttribute("DateFormat");
        this.systemFont = element.getAttribute("SystemFont");
        if (this.systemFont.equals("")) {
            this.systemFont = "SanSerif";
        }
        this.calendar.setLenient(false);
        String hashFormat = element.getAttribute("HashFormat");
        if (!hashFormat.equals("")) {
            try {
                StringTokenizer workTokenizer = new StringTokenizer(hashFormat, ";");
                this.digestAlgorithmForUser = workTokenizer.nextToken();
                if (!this.digestAlgorithmForUser.equals("MD5")) {
                    new DigestAdapter(this.digestAlgorithmForUser);
                }
                if (workTokenizer.hasMoreTokens()) {
                    this.countOfExpandForUser = Integer.parseInt(workTokenizer.nextToken());
                }
                if (workTokenizer.hasMoreTokens()) {
                    this.isValueSaltedForUser = Boolean.parseBoolean(workTokenizer.nextToken());
                }
            }
            catch (Exception workTokenizer) {
                // empty catch block
            }
        }
        this.imageFileFolder = (wrkStr = element.getAttribute("ImageFileFolder")).equals("") ? String.valueOf(this.currentFolder) + File.separator : (wrkStr.contains("<CURRENT>") ? String.valueOf(wrkStr.replace("<CURRENT>", this.currentFolder)) + File.separator : String.valueOf(wrkStr) + File.separator);
        wrkStr = element.getAttribute("OutputFolder");
        if (wrkStr.equals("")) {
            this.outputFolder = null;
        } else {
            if (wrkStr.contains("<CURRENT>")) {
                wrkStr = wrkStr.replace("<CURRENT>", this.currentFolder);
            }
            this.outputFolder = new File(wrkStr);
            if (!this.outputFolder.exists()) {
                this.outputFolder = null;
            }
        }
        wrkStr = element.getAttribute("LogFileFolder");
        if (wrkStr.equals("")) {
            this.logFileFolder = String.valueOf(this.currentFolder) + File.separator + "log" + File.separator;
        } else {
            this.imageFileFolder = wrkStr.contains("<CURRENT>") ? String.valueOf(wrkStr.replace("<CURRENT>", this.currentFolder)) + File.separator : String.valueOf(wrkStr) + File.separator;
        }
        wrkStr = element.getAttribute("LoggingSize");
        if (wrkStr.equals("")) {
            this.loggingSize = 3000;
        } else {
            try {
                this.loggingSize = Integer.parseInt(wrkStr);
            }
            catch (Exception e) {
                this.loggingSize = 3000;
            }
        }
        this.userTable = element.getAttribute("UserTable");
        this.userFilterValueTable = element.getAttribute("UserFilterValueTable");
        this.variantsTable = element.getAttribute("VariantsTable");
        this.userVariantsTable = element.getAttribute("UserVariantsTable");
        this.numberingTable = element.getAttribute("NumberingTable");
        this.sessionTable = element.getAttribute("SessionTable");
        this.sessionDetailTable = element.getAttribute("SessionDetailTable");
        this.taxTable = element.getAttribute("TaxTable");
        this.calendarTable = element.getAttribute("CalendarTable");
        this.exchangeRateAnnualTable = element.getAttribute("ExchangeRateAnnualTable");
        this.exchangeRateMonthlyTable = element.getAttribute("ExchangeRateMonthlyTable");
        this.loginScript = XFUtility.substringLinesWithTokenOfEOL((String)element.getAttribute("LoginScript"), (String)"\n");
        this.scriptFunctions = XFUtility.substringLinesWithTokenOfEOL((String)element.getAttribute("ScriptFunctions"), (String)"\n");
        this.functionList = this.domDocument.getElementsByTagName("Function");
        this.tableList = this.domDocument.getElementsByTagName("Table");
        this.databaseName = element.getAttribute("DatabaseName");
        if (this.databaseName.contains("<CURRENT>")) {
            this.databaseName = this.databaseName.replace("<CURRENT>", this.currentFolder);
        }
        this.databaseUser = element.getAttribute("DatabaseUser");
        this.databasePassword = element.getAttribute("DatabasePassword");
        NodeList subDBList = this.domDocument.getElementsByTagName("SubDB");
        int i = 0;
        while (i < subDBList.getLength()) {
            Element subDBElement = (Element)subDBList.item(i);
            this.subDBIDList.add(subDBElement.getAttribute("ID"));
            this.subDBUserList.add(subDBElement.getAttribute("User"));
            this.subDBPasswordList.add(subDBElement.getAttribute("Password"));
            wrkStr = subDBElement.getAttribute("Name");
            if (wrkStr.contains("<CURRENT>")) {
                wrkStr = wrkStr.replace("<CURRENT>", this.currentFolder);
            }
            this.subDBNameList.add(wrkStr);
            ++i;
        }
        if (!element.getAttribute("AppServerName").equals("")) {
            this.appServerName = element.getAttribute("AppServerName");
        }
        if (this.appServerName.equals("") && !(isOkay = this.setupConnectionToDatabase(true))) {
            return false;
        }
        this.smtpHost = element.getAttribute("SmtpHost");
        this.smtpPort = element.getAttribute("SmtpPort");
        this.smtpUser = element.getAttribute("SmtpUser");
        this.smtpPassword = element.getAttribute("SmtpPassword");
        this.smtpAdminEmail = element.getAttribute("SmtpAdminEmail");
        return true;
    }

    public boolean setupConnectionToDatabase(boolean isToStartSession) throws Exception {
        XFUtility.loadDriverClass((String)this.databaseName);
        this.connectionManualCommit = DriverManager.getConnection(this.databaseName, this.databaseUser, this.databasePassword);
        this.connectionManualCommit.setAutoCommit(false);
        this.connectionAutoCommit = DriverManager.getConnection(this.databaseName, this.databaseUser, this.databasePassword);
        this.connectionAutoCommit.setAutoCommit(true);
        Connection subDBConnection = null;
        this.subDBConnectionList.clear();
        int i = 0;
        while (i < this.subDBIDList.size()) {
            XFUtility.loadDriverClass((String)this.subDBNameList.get(i));
            subDBConnection = DriverManager.getConnection(this.subDBNameList.get(i), this.subDBUserList.get(i), this.subDBPasswordList.get(i));
            subDBConnection.setReadOnly(true);
            this.subDBConnectionList.add(subDBConnection);
            ++i;
        }
        return true;
    }

    private void writeLogAndStartSession() throws ScriptException, Exception {
        this.sessionID = this.getNextNumber("NRSESSION");
        this.sessionStatus = "ACT";
        String sql = "insert into " + this.sessionTable + " (NRSESSION, IDUSER, DTLOGIN, TXIPADDRESS, VLVERSION, KBSESSIONSTATUS) values (" + "'" + this.sessionID + "'," + "'" + this.userID + "'," + "CURRENT_TIMESTAMP," + "'" + this.getIpAddress() + "','" + this.processorVersion + "','" + this.sessionStatus + "')";
        XFTableOperator operator = new XFTableOperator(this, null, sql, true);
        operator.execute();
        operator = new XFTableOperator(this, null, "select * from " + this.calendarTable, true);
        while (operator.next()) {
            this.offDateList.add(String.valueOf(operator.getValueOf("KBCALENDAR").toString()) + ";" + operator.getValueOf("DTOFF").toString());
        }
        this.globalScriptBindings = this.scriptEngineManager.getBindings();
        this.globalScriptBindings.put("session", (Object)this);
        this.scriptEngine = this.scriptEngineManager.getEngineByName("js");
        if (!this.loginScript.equals("")) {
            this.scriptEngine.eval(this.loginScript);
        }
    }

    private String getIpAddress() {
        String value;
        block18: {
            HttpPost httpPost;
            block16: {
                value = "N/A";
                httpPost = null;
                DefaultHttpClient httpClient = null;
                try {
                    try {
                        InetAddress ip = InetAddress.getLocalHost();
                        value = ip.getHostAddress();
                        if (this.getAppServerName().equals("")) break block16;
                        httpPost = new HttpPost(this.getAppServerName());
                        ArrayList<BasicNameValuePair> objValuePairs = new ArrayList<BasicNameValuePair>(1);
                        objValuePairs.add(new BasicNameValuePair("METHOD", "IP"));
                        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(objValuePairs, "UTF-8"));
                        try {
                            try {
                                httpClient = new DefaultHttpClient();
                                HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                HttpEntity responseEntity = response.getEntity();
                                if (responseEntity != null) {
                                    value = String.valueOf(EntityUtils.toString((HttpEntity)responseEntity)) + " - " + ip.getHostAddress();
                                }
                            }
                            catch (Exception exception) {
                                if (httpClient != null) {
                                    httpClient.getConnectionManager().shutdown();
                                }
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            if (httpClient != null) {
                                httpClient.getConnectionManager().shutdown();
                            }
                            throw throwable;
                        }
                        if (httpClient != null) {
                            httpClient.getConnectionManager().shutdown();
                        }
                    }
                    catch (Exception ip) {
                        if (httpPost != null) {
                            httpPost.abort();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (httpPost != null) {
                        httpPost.abort();
                    }
                    throw throwable;
                }
            }
            if (httpPost != null) {
                httpPost.abort();
            }
        }
        Element ipAddressField = this.getFieldElement(this.sessionTable, "TXIPADDRESS");
        int ipAddressSize = Integer.parseInt(ipAddressField.getAttribute("Size"));
        if (value.length() > ipAddressSize) {
            value = value.substring(0, ipAddressSize);
        }
        return value;
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    public String getTimeStamp() {
        return XFUtility.getUserExpressionOfUtilDate(null, (String)"", (boolean)true);
    }

    public String getToday() {
        return this.getToday("");
    }

    public String getToday(String dateFormat) {
        return XFUtility.getUserExpressionOfUtilDate(null, (String)dateFormat, (boolean)false);
    }

    public String getTodayTime(String dateFormat) {
        return XFUtility.getUserExpressionOfUtilDate(null, (String)dateFormat, (boolean)true);
    }

    public String getThisMonth() {
        SimpleDateFormat dfm = new SimpleDateFormat("yyyyMM");
        Calendar cal = Calendar.getInstance();
        return dfm.format(cal.getTime());
    }

    public String getErrorOfAccountDate(String dateValue) {
        String message = "";
        try {
            int yyyyMSeq = this.getSystemVariantInteger("ALLOWED_FISCAL_MONTH");
            if (yyyyMSeq > 200000 && yyyyMSeq < 210000) {
                int mSeq;
                int yyyy;
                int yyyyMSeqTarget;
                String date = dateValue.replace("/", "");
                if ((date = date.replace("-", "")).length() >= 8 && (yyyyMSeqTarget = (yyyy = this.getFYearOfDate(date = date.substring(0, 8))) * 100 + (mSeq = this.getMSeqOfDate(dateValue))) < yyyyMSeq) {
                    message = XFUtility.RESOURCE.getString("FunctionError49");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return message;
    }

    public String formatTime(int timeFrom) {
        if (timeFrom > 9999) {
            return null;
        }
        return this.formatTime(Integer.toString(timeFrom));
    }

    public String formatTime(String timeFrom) {
        if (timeFrom.contains(":")) {
            return timeFrom;
        }
        if (timeFrom.length() > 4) {
            return null;
        }
        String wrkStr = "00:00";
        if (timeFrom.length() == 1) {
            wrkStr = "00:0" + timeFrom;
        }
        if (timeFrom.length() == 2) {
            wrkStr = "00:" + timeFrom;
        }
        if (timeFrom.length() == 3) {
            wrkStr = "0" + timeFrom.substring(0, 1) + ":" + timeFrom.substring(1, 3);
        }
        if (timeFrom.length() == 4) {
            wrkStr = String.valueOf(timeFrom.substring(0, 2)) + ":" + timeFrom.substring(2, 4);
        }
        return wrkStr;
    }

    public String getOffsetTime(int timeFrom, int minutes) {
        if (timeFrom > 9999) {
            return null;
        }
        String strTimeFrom = Integer.toString(timeFrom);
        if (strTimeFrom.length() == 1) {
            strTimeFrom = "00:0" + strTimeFrom;
        }
        if (strTimeFrom.length() == 2) {
            strTimeFrom = "00:" + strTimeFrom;
        }
        if (strTimeFrom.length() == 3) {
            strTimeFrom = "0" + strTimeFrom.substring(0, 1) + ":" + strTimeFrom.substring(1, 3);
        }
        if (strTimeFrom.length() == 4) {
            strTimeFrom = String.valueOf(strTimeFrom.substring(0, 2)) + ":" + strTimeFrom.substring(2, 4);
        }
        return this.getOffsetTime(strTimeFrom, minutes);
    }

    private String getOffsetTime(String hhmmFrom, int minutes) {
        if (!hhmmFrom.contains(":")) {
            if (hhmmFrom.length() == 1) {
                hhmmFrom = "00:0" + hhmmFrom;
            }
            if (hhmmFrom.length() == 2) {
                hhmmFrom = "00:" + hhmmFrom;
            }
            if (hhmmFrom.length() == 3) {
                hhmmFrom = "0" + hhmmFrom.substring(0, 1) + ":" + hhmmFrom.substring(1, 3);
            }
            if (hhmmFrom.length() == 4) {
                hhmmFrom = String.valueOf(hhmmFrom.substring(0, 2)) + ":" + hhmmFrom.substring(2, 4);
            }
        }
        double days = 0.0;
        double hh = Double.parseDouble(hhmmFrom.substring(0, 2));
        double mm = Double.parseDouble(hhmmFrom.substring(3, 5)) + (double)minutes;
        if (mm >= 60.0) {
            hh += Math.floor(mm / 60.0);
            mm %= 60.0;
        }
        if (mm <= -60.0) {
            hh += Math.ceil(mm / 60.0);
            mm %= 60.0;
        }
        if (mm < 0.0) {
            hh -= 1.0;
            mm += 60.0;
        }
        mm = Math.abs(mm);
        if (hh >= 24.0) {
            days = Math.floor(hh / 24.0);
            hh %= 24.0;
        }
        if (hh <= -24.0) {
            days = Math.ceil(hh / 24.0);
            hh %= 24.0;
        }
        if (hh < 0.0) {
            days -= 1.0;
            hh += 24.0;
        }
        hh = Math.abs(hh);
        String strDays = Double.toString(days).replace(".0", "");
        String strHH = Double.toString(hh).replace(".0", "");
        if (hh < 10.0) {
            strHH = "0" + strHH;
        }
        String strMM = Double.toString(mm).replace(".0", "");
        if (mm < 10.0) {
            strMM = "0" + strMM;
        }
        return String.valueOf(strDays) + ":" + strHH + ":" + strMM;
    }

    public String getOffsetDateTime(String dateFrom, int timeFrom, int minutes) {
        return this.getOffsetDateTime(dateFrom, timeFrom, minutes, 0, "00");
    }

    public String getOffsetDateTime(String dateFrom, int timeFrom, int minutes, int countType) {
        return this.getOffsetDateTime(dateFrom, timeFrom, minutes, countType, "00");
    }

    public String getOffsetDateTime(String dateFrom, int timeFrom, int minutes, int countType, String kbCalendar) {
        if (timeFrom > 9999) {
            return null;
        }
        String strTimeFrom = Integer.toString(timeFrom);
        if (strTimeFrom.length() == 1) {
            strTimeFrom = "00:0" + strTimeFrom;
        }
        if (strTimeFrom.length() == 2) {
            strTimeFrom = "00:" + strTimeFrom;
        }
        if (strTimeFrom.length() == 3) {
            strTimeFrom = "0" + strTimeFrom.substring(0, 1) + ":" + strTimeFrom.substring(1, 3);
        }
        if (strTimeFrom.length() == 4) {
            strTimeFrom = String.valueOf(strTimeFrom.substring(0, 2)) + ":" + strTimeFrom.substring(2, 4);
        }
        return this.getOffsetDateTime(dateFrom, strTimeFrom, minutes, countType, kbCalendar);
    }

    public String getOffsetDateTime(String dateFrom, String timeFrom, int minutes, int countType) {
        return this.getOffsetDateTime(dateFrom, timeFrom, minutes, countType, "00");
    }

    public String getOffsetDateTime(String dateFrom, String timeFrom, int minutes) {
        return this.getOffsetDateTime(dateFrom, timeFrom, minutes, 0, "00");
    }

    public String getOffsetDateTime(String dateFrom, String timeFrom, int minutes, int countType, String kbCalendar) {
        if (!timeFrom.contains(":")) {
            if (timeFrom.length() == 1) {
                timeFrom = "00:0" + timeFrom;
            }
            if (timeFrom.length() == 2) {
                timeFrom = "00:" + timeFrom;
            }
            if (timeFrom.length() == 3) {
                timeFrom = "0" + timeFrom.substring(0, 1) + ":" + timeFrom.substring(1, 3);
            }
            if (timeFrom.length() == 4) {
                timeFrom = String.valueOf(timeFrom.substring(0, 2)) + ":" + timeFrom.substring(2, 4);
            }
        }
        String dateTime = "";
        String daysHhMm = this.getOffsetTime(timeFrom, minutes);
        StringTokenizer workTokenizer = new StringTokenizer(daysHhMm, ":");
        try {
            int days = Integer.parseInt(workTokenizer.nextToken());
            String date = this.getOffsetDate(dateFrom, days, countType);
            String hh = workTokenizer.nextToken();
            String mm = workTokenizer.nextToken();
            dateTime = String.valueOf(date) + " " + hh + ":" + mm;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dateTime;
    }

    public String getOffsetDate(String dateFrom, int days, int countType) {
        return this.getOffsetDate(dateFrom, days, countType, "00");
    }

    public String getOffsetDate(String dateFrom, int days, int countType, String kbCalendar) {
        Date workDate;
        String offsetDate = "";
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
        dateFrom = dateFrom.replaceAll("-", "").replaceAll("/", "").trim();
        int y = Integer.parseInt(dateFrom.substring(0, 4));
        int m = Integer.parseInt(dateFrom.substring(4, 6));
        int d = Integer.parseInt(dateFrom.substring(6, 8));
        Calendar cal = Calendar.getInstance();
        cal.set(y, m - 1, d);
        if (countType == 0) {
            cal.add(5, days);
        }
        if (countType == 1) {
            if (days >= 0) {
                int i = 0;
                while (i < days) {
                    cal.add(5, 1);
                    workDate = cal.getTime();
                    if (this.offDateList.contains(String.valueOf(kbCalendar) + ";" + dfm.format(workDate))) {
                        ++days;
                    }
                    ++i;
                }
            } else {
                days *= -1;
                int i = 0;
                while (i < days) {
                    cal.add(5, -1);
                    workDate = cal.getTime();
                    if (this.offDateList.contains(String.valueOf(kbCalendar) + ";" + dfm.format(workDate))) {
                        ++days;
                    }
                    ++i;
                }
            }
        }
        workDate = cal.getTime();
        offsetDate = dfm.format(workDate);
        return offsetDate;
    }

    public String getOffsetYearMonth(String yearMonthFrom, int months) {
        String offsetYearMonth = "";
        try {
            int year = Integer.parseInt(yearMonthFrom.substring(0, 4));
            int month = Integer.parseInt(yearMonthFrom.substring(4, 6));
            if (months > 0) {
                int i = 0;
                while (i < months) {
                    if (++month > 12) {
                        month = 1;
                        ++year;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i > months) {
                    if (--month < 1) {
                        month = 12;
                        --year;
                    }
                    --i;
                }
            }
            offsetYearMonth = month >= 10 ? String.valueOf(Integer.toString(year)) + Integer.toString(month) : String.valueOf(Integer.toString(year)) + "0" + Integer.toString(month);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return offsetYearMonth;
    }

    public String getLastDateOfTheYearMonth(String yearMonth) {
        String date = "";
        try {
            String processedYearMonth = yearMonth.replaceAll("-", "").replaceAll("/", "").trim();
            processedYearMonth = processedYearMonth.substring(0, 6);
            int y = Integer.parseInt(processedYearMonth.substring(0, 4));
            int m = Integer.parseInt(processedYearMonth.substring(4, 6));
            SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
            Calendar cal = Calendar.getInstance();
            cal.set(y, m, 1, 0, 0, 0);
            cal.add(5, -1);
            date = dfm.format(cal.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public int getDaysBetweenDates(String strDateFrom, String strDateThru, int countType) {
        return this.getDaysBetweenDates(strDateFrom, strDateThru, countType, "00");
    }

    public int getDaysBetweenDates(String strDateFrom, String strDateThru, int countType, String kbCalendar) {
        int days = 0;
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        strDateFrom = strDateFrom.replaceAll("-", "").replaceAll("/", "").trim();
        int y = Integer.parseInt(strDateFrom.substring(0, 4));
        int m = Integer.parseInt(strDateFrom.substring(4, 6));
        int d = Integer.parseInt(strDateFrom.substring(6, 8));
        cal.set(y, m - 1, d, 0, 0, 0);
        Date dateFrom = cal.getTime();
        strDateThru = strDateThru.replaceAll("-", "").replaceAll("/", "").trim();
        y = Integer.parseInt(strDateThru.substring(0, 4));
        m = Integer.parseInt(strDateThru.substring(4, 6));
        d = Integer.parseInt(strDateThru.substring(6, 8));
        cal.set(y, m - 1, d, 0, 0, 0);
        Date dateThru = cal.getTime();
        if (countType == 0) {
            long diff = dateThru.getTime() - dateFrom.getTime();
            days = (int)(diff / 86400000L);
        }
        if (countType == 1) {
            if (dateThru.getTime() == dateFrom.getTime()) {
                days = 0;
            }
            if (dateThru.getTime() > dateFrom.getTime()) {
                y = Integer.parseInt(strDateFrom.substring(0, 4));
                m = Integer.parseInt(strDateFrom.substring(4, 6));
                d = Integer.parseInt(strDateFrom.substring(6, 8));
                cal.set(y, m - 1, d, 0, 0, 0);
                long timeThru = dateThru.getTime();
                long timeWork = dateFrom.getTime();
                while (timeThru > timeWork) {
                    cal.add(5, 1);
                    if (!this.offDateList.contains(String.valueOf(kbCalendar) + ";" + dfm.format(cal.getTime()))) {
                        ++days;
                    }
                    timeWork = cal.getTime().getTime();
                }
            }
            if (dateThru.getTime() < dateFrom.getTime()) {
                y = Integer.parseInt(strDateThru.substring(0, 4));
                m = Integer.parseInt(strDateThru.substring(4, 6));
                d = Integer.parseInt(strDateThru.substring(6, 8));
                cal.set(y, m - 1, d, 0, 0, 0);
                long timeWork = dateThru.getTime();
                long timeFrom = dateFrom.getTime();
                while (timeFrom > timeWork) {
                    cal.add(5, 1);
                    if (!this.offDateList.contains(String.valueOf(kbCalendar) + ";" + dfm.format(cal.getTime()))) {
                        ++days;
                    }
                    timeWork = cal.getTime().getTime();
                }
                days *= -1;
            }
        }
        return days;
    }

    public int getMonthsBetweenYearMonths(String strYearMonthFrom, String strYearMonthThru) {
        int months = 0;
        try {
            int yearFrom = Integer.parseInt(strYearMonthFrom.substring(0, 4));
            int monthFrom = Integer.parseInt(strYearMonthFrom.substring(4, 6));
            int yearThru = Integer.parseInt(strYearMonthThru.substring(0, 4));
            int monthThru = Integer.parseInt(strYearMonthThru.substring(4, 6));
            if (monthFrom > monthThru) {
                --yearFrom;
                monthFrom += 12;
            }
            months = (yearThru - yearFrom) * 12;
            months = months + monthThru - monthFrom;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return months;
    }

    public boolean isValidDate(String date) {
        boolean result = true;
        String argDate = date.replaceAll("[^0-9]", "").trim();
        try {
            int y = Integer.parseInt(argDate.substring(0, 4));
            int m = Integer.parseInt(argDate.substring(4, 6));
            int d = Integer.parseInt(argDate.substring(6, 8));
            this.calendar.set(y, m - 1, d);
            this.calendar.getTime();
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean isValidDateFormat(String date, String separator) {
        boolean result = false;
        if (this.isValidDate(date) && date.length() == 10 && date.substring(4, 5).equals(separator) && date.substring(7, 8).equals(separator)) {
            result = true;
        }
        return result;
    }

    public boolean isOffDate(String date) {
        return this.isOffDate(date, "00");
    }

    public boolean isOffDate(String date, String kbCalendar) {
        return this.offDateList.contains(String.valueOf(kbCalendar) + ";" + date);
    }

    public boolean isValidTime(String time, String format) {
        boolean result = false;
        try {
            int min;
            int hour;
            if (format.toUpperCase().equals("HH:MM") && time.length() == 5 && time.substring(2, 3).equals(":")) {
                hour = Integer.parseInt(time.substring(0, 2));
                min = Integer.parseInt(time.substring(3, 5));
                if (hour >= 0 && hour < 24 && min >= 0 && min < 60) {
                    result = true;
                }
            }
            if (format.toUpperCase().equals("HH:MM:SS") && time.length() >= 7 && time.length() <= 12 && time.substring(2, 3).equals(":") && time.substring(5, 6).equals(":")) {
                hour = Integer.parseInt(time.substring(0, 2));
                min = Integer.parseInt(time.substring(3, 5));
                float sec = Float.parseFloat(time.substring(6, time.length()));
                if (hour >= 0 && hour < 24 && min >= 0 && min < 60 && sec >= 0.0f && sec < 60.0f) {
                    result = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Object getMinutesBetweenTimes(int timeFrom, int timeThru) {
        String strTimeThru;
        if (timeFrom > 9999 || timeThru > 9999) {
            return null;
        }
        String strTimeFrom = Integer.toString(timeFrom);
        if (strTimeFrom.length() == 1) {
            strTimeFrom = "00:0" + strTimeFrom;
        }
        if (strTimeFrom.length() == 2) {
            strTimeFrom = "00:" + strTimeFrom;
        }
        if (strTimeFrom.length() == 3) {
            strTimeFrom = "0" + strTimeFrom.substring(0, 1) + ":" + strTimeFrom.substring(1, 3);
        }
        if (strTimeFrom.length() == 4) {
            strTimeFrom = String.valueOf(strTimeFrom.substring(0, 2)) + ":" + strTimeFrom.substring(2, 4);
        }
        if ((strTimeThru = Integer.toString(timeThru)).length() == 1) {
            strTimeThru = "00:0" + strTimeThru;
        }
        if (strTimeThru.length() == 2) {
            strTimeThru = "00:" + strTimeThru;
        }
        if (strTimeThru.length() == 3) {
            strTimeThru = "0" + strTimeThru.substring(0, 1) + ":" + strTimeThru.substring(1, 3);
        }
        if (strTimeThru.length() == 4) {
            strTimeThru = String.valueOf(strTimeThru.substring(0, 2)) + ":" + strTimeThru.substring(2, 4);
        }
        return this.getMinutesBetweenTimes(strTimeFrom, strTimeThru);
    }

    public Object getMinutesBetweenTimes(String timeFrom, String timeThru) {
        int minDiff;
        block3: {
            minDiff = 0;
            try {
                if (timeFrom.substring(2, 3).equals(":") && timeThru.substring(2, 3).equals(":")) {
                    int hourFrom = Integer.parseInt(timeFrom.substring(0, 2));
                    int minFrom = Integer.parseInt(timeFrom.substring(3, 5));
                    int hourThru = Integer.parseInt(timeThru.substring(0, 2));
                    int minThru = Integer.parseInt(timeThru.substring(3, 5));
                    minDiff = (hourThru - hourFrom) * 60 + (minThru - minFrom);
                    break block3;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return minDiff;
    }

    public String getNextNumber(String numberID) {
        String nextNumber = "";
        try {
            String sql = "select * from " + this.numberingTable + " where IDNUMBER = '" + numberID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                nextNumber = this.getFormattedNextNumber(Integer.parseInt(operator.getValueOf("NRCURRENT").toString()), Integer.parseInt(operator.getValueOf("NRNUMDIGIT").toString()), operator.getValueOf("TXPREFIX").toString().trim(), operator.getValueOf("FGWITHCD").toString());
                int number = this.countUpNumber(Integer.parseInt(operator.getValueOf("NRCURRENT").toString()), Integer.parseInt(operator.getValueOf("NRNUMDIGIT").toString()));
                sql = "update " + this.numberingTable + " set NRCURRENT = " + number + ", UPDCOUNTER = " + (Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString()) + 1) + " where IDNUMBER = '" + numberID + "'" + " and UPDCOUNTER = " + Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString());
                operator = new XFTableOperator(this, null, sql, true);
                operator.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nextNumber;
    }

    public void setNextNumber(String numberID, int nextNumber) {
        try {
            String sql = "select * from " + this.numberingTable + " where IDNUMBER = '" + numberID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                sql = "update " + this.numberingTable + " set NRCURRENT = " + nextNumber + ", UPDCOUNTER = " + (Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString()) + 1) + " where IDNUMBER = '" + numberID + "'" + " and UPDCOUNTER = " + Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString());
                operator = new XFTableOperator(this, null, sql, true);
                operator.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getFormattedNextNumber(int number, int digit, String prefix, String withCD) {
        String nextNumber = "";
        DecimalFormat decimalFormat = new DecimalFormat();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < digit) {
            buf.append("0");
            ++i;
        }
        decimalFormat.applyPattern(buf.toString());
        String outputdata = decimalFormat.format(number);
        if (withCD.equals("T")) {
            int wrkInt;
            int wrkSum = 0;
            int i2 = 0;
            while (i2 < outputdata.length()) {
                String wrkStr = outputdata.substring(i2, i2 + 1);
                wrkInt = Integer.parseInt(wrkStr);
                if (wrkInt % 2 == 1) {
                    wrkInt *= 3;
                }
                wrkSum += wrkInt;
                ++i2;
            }
            wrkInt = wrkSum % 10;
            wrkInt = 10 - wrkInt;
            nextNumber = String.valueOf(prefix) + outputdata + wrkInt;
        } else {
            nextNumber = String.valueOf(prefix) + outputdata;
        }
        return nextNumber;
    }

    private int countUpNumber(int number, int digit) {
        if (digit == 1 && ++number == 10) {
            number = 1;
        }
        if (digit == 2 && number == 100) {
            number = 1;
        }
        if (digit == 3 && number == 1000) {
            number = 1;
        }
        if (digit == 4 && number == 10000) {
            number = 1;
        }
        if (digit == 5 && number == 100000) {
            number = 1;
        }
        if (digit == 6 && number == 1000000) {
            number = 1;
        }
        if (digit == 7 && number == 10000000) {
            number = 1;
        }
        if (digit == 8 && number == 100000000) {
            number = 1;
        }
        if (digit == 9 && number == 1000000000) {
            number = 1;
        }
        return number;
    }

    public String getSystemVariantString(String itemID) {
        String strValue = "";
        String sql = "";
        try {
            sql = "select * from " + this.variantsTable + " where IDVARIANT = '" + itemID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next() && (strValue = operator.getValueOf("TXVALUE").toString().trim()).contains("<CURRENT>")) {
                strValue = strValue.replace("<CURRENT>", this.currentFolder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strValue;
    }

    public int getSystemVariantInteger(String itemID) {
        String strValue = "";
        int intValue = 0;
        try {
            String sql = "select * from " + this.variantsTable + " where IDVARIANT = '" + itemID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                strValue = operator.getValueOf("TXVALUE").toString().trim();
                if (operator.getValueOf("TXTYPE").toString().trim().equals("NUMBER")) {
                    intValue = Integer.parseInt(strValue);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return intValue;
    }

    public float getSystemVariantFloat(String itemID) {
        String strValue = "";
        float floatValue = 0.0f;
        try {
            String sql = "select * from " + this.variantsTable + " where IDVARIANT = '" + itemID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                strValue = operator.getValueOf("TXVALUE").toString().trim();
                if (operator.getValueOf("TXTYPE").toString().trim().equals("NUMBER")) {
                    floatValue = Float.parseFloat(strValue);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return floatValue;
    }

    public void setSystemVariant(String itemID, String value) {
        try {
            String sql = "select * from " + this.variantsTable + " where IDVARIANT = '" + itemID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                sql = "update " + this.variantsTable + " set TXVALUE = '" + value + "'" + ", UPDCOUNTER = " + (Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString()) + 1) + " where IDVARIANT = '" + itemID + "'" + " and UPDCOUNTER = " + Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString());
                operator = new XFTableOperator(this, null, sql, true);
                operator.execute();
            } else {
                sql = "insert into " + this.variantsTable + " (IDVARIANT, TXNAME, TXTYPE, TXVALUE) values (" + "'" + itemID + "', '" + itemID.substring(0, 10) + "', 'STRING', '" + value + "')";
                operator = new XFTableOperator(this, null, sql, true);
                operator.execute();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getUserVariantDescription(String variantID, String value) {
        String strValue = "";
        try {
            String sql = "select * from " + this.userVariantsTable + " where IDUSERKUBUN = '" + variantID + "' and KBUSERKUBUN = '" + value + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                strValue = operator.getValueOf("TXUSERKUBUN").toString().trim();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Accessing to the user variant table failed.\n" + e.getMessage());
        }
        return strValue;
    }

    public HashMap getFilterValueMap(String functionID) {
        HashMap<String, String> valueMap = null;
        if (!this.userFilterValueTable.equals("")) {
            try {
                valueMap = new HashMap<String, String>();
                String sql = "select * from " + this.userFilterValueTable + " where IDUSER ='" + this.getUserID() + "' AND IDFUNCTION = '" + functionID + "'";
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                while (operator.next()) {
                    valueMap.put(operator.getValueOf("IDFILTER").toString(), operator.getValueOf("TXVALUE").toString());
                }
            }
            catch (Exception e) {
                valueMap = null;
            }
        }
        return valueMap;
    }

    public String getFilterValue(String functionID, String filterID) {
        String value = "";
        if (!this.userFilterValueTable.equals("")) {
            try {
                String sql = "select * from " + this.userFilterValueTable + " where IDUSER ='" + this.getUserID() + "' AND IDFUNCTION = '" + functionID + "' AND IDFILTER = '" + filterID + "'";
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                if (operator.next()) {
                    value = operator.getValueOf("TXVALUE").toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public void setFilterValue(String functionID, String filterID, String value) {
        if (!this.userFilterValueTable.equals("")) {
            try {
                String sql = "select * from " + this.userFilterValueTable + " where IDUSER ='" + this.getUserID() + "' AND IDFUNCTION = '" + functionID + "' AND IDFILTER = '" + filterID + "'";
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                sql = operator.next() ? "update " + this.userFilterValueTable + " set TXVALUE = '" + value + "' where IDUSER ='" + this.getUserID() + "' AND IDFUNCTION = '" + functionID + "' AND IDFILTER = '" + filterID + "'" : "insert into " + this.userFilterValueTable + " (IDUSER, IDFUNCTION, IDFILTER, TXVALUE) values (" + "'" + this.getUserID() + "', '" + functionID + "', '" + filterID + "', '" + value + "')";
                operator = new XFTableOperator(this, null, sql, true);
                operator.execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public float getAnnualExchangeRate(String currencyCode, int fYear, String type) {
        float rateReturn = 0.0f;
        if (currencyCode.equals(this.getSystemVariantString("SYSTEM_CURRENCY"))) {
            rateReturn = 1.0f;
        } else {
            try {
                String sql = "select * from " + this.exchangeRateAnnualTable + " where KBCURRENCY = '" + currencyCode + "' and DTNEND = " + fYear;
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                if (operator.next()) {
                    rateReturn = Float.parseFloat(operator.getValueOf("VLRATEM").toString());
                    if (type.equals("TTB")) {
                        rateReturn = Float.parseFloat(operator.getValueOf("VLRATEB").toString());
                    }
                    if (type.equals("TTS")) {
                        rateReturn = Float.parseFloat(operator.getValueOf("VLRATES").toString());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rateReturn;
    }

    public float getMonthlyExchangeRate(String currencyCode, String date, String type) {
        return this.getMonthlyExchangeRate(currencyCode, this.getFYearOfDate(date), this.getMSeqOfDate(date), type);
    }

    public float getMonthlyExchangeRate(String currencyCode, int fYear, int mSeq, String type) {
        float rateReturn = 0.0f;
        if (currencyCode.equals(this.getSystemVariantString("SYSTEM_CURRENCY"))) {
            rateReturn = 1.0f;
        } else {
            try {
                String sql = "select * from " + this.exchangeRateMonthlyTable + " where KBCURRENCY = '" + currencyCode + "' and DTNEND = " + fYear + " and DTMSEQ = " + mSeq;
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                if (operator.next()) {
                    rateReturn = Float.parseFloat(operator.getValueOf("VLRATEM").toString());
                    if (type.equals("TTB")) {
                        rateReturn = Float.parseFloat(operator.getValueOf("VLRATEB").toString());
                    }
                    if (type.equals("TTS")) {
                        rateReturn = Float.parseFloat(operator.getValueOf("VLRATES").toString());
                    }
                }
                if (rateReturn == 0.0f) {
                    rateReturn = this.getAnnualExchangeRate(currencyCode, fYear, type);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rateReturn;
    }

    public int getTaxAmount(String date, int amount) {
        int fromDate = 0;
        int taxAmount = 0;
        if (date != null && !date.equals("")) {
            int targetDate = Integer.parseInt(date.replaceAll("-", "").replaceAll("/", ""));
            float rate = 0.0f;
            try {
                String sql = "select * from " + this.taxTable + " order by DTSTART DESC";
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                while (operator.next()) {
                    fromDate = Integer.parseInt(operator.getValueOf("DTSTART").toString().replaceAll("-", ""));
                    if (targetDate < fromDate) continue;
                    rate = Float.parseFloat(operator.getValueOf("VLTAXRATE").toString());
                    break;
                }
                taxAmount = amount >= 0 ? (int)Math.floor((float)amount * rate) : (int)Math.ceil((float)amount * rate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return taxAmount;
    }

    public int getTaxAmount(String date, int amount, String kbKazei) {
        int fromDate = 0;
        int taxAmount = 0;
        if (date != null && !date.equals("")) {
            int targetDate = Integer.parseInt(date.replaceAll("-", "").replaceAll("/", ""));
            float rate = 0.0f;
            try {
                String sql = "select * from " + this.taxTable + " where KBKAZEI = '" + kbKazei + "' order by DTSTART DESC";
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                while (operator.next()) {
                    fromDate = Integer.parseInt(operator.getValueOf("DTSTART").toString().replaceAll("-", ""));
                    if (targetDate < fromDate) continue;
                    rate = Float.parseFloat(operator.getValueOf("VLTAXRATE").toString());
                    break;
                }
                taxAmount = amount >= 0 ? (int)Math.floor((float)amount * rate) : (int)Math.ceil((float)amount * rate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return taxAmount;
    }

    public int getMSeqOfDate(String parmDate) {
        int mSeq = 0;
        if (!parmDate.equals("")) {
            int value2;
            parmDate = parmDate.replaceAll("-", "").replaceAll("/", "").trim();
            parmDate = parmDate.replaceAll("/", "");
            int month = Integer.parseInt(parmDate.substring(4, 6));
            int date = Integer.parseInt(parmDate.substring(6, 8));
            boolean isWithinMonth = false;
            int startMonth = 1;
            int lastDay = 31;
            int value1 = this.getSystemVariantInteger("FIRST_MONTH");
            if (value1 != 0) {
                startMonth = value1;
            }
            if ((value2 = this.getSystemVariantInteger("LAST_DAY")) != 0) {
                lastDay = value2;
            }
            if (lastDay >= 31 && (month == 1 && date <= 31 || month == 2 && date <= 29 || month == 3 && date <= 31 || month == 4 && date <= 30 || month == 5 && date <= 31 || month == 6 && date <= 30 || month == 7 && date <= 31 || month == 8 && date <= 31 || month == 9 && date <= 30 || month == 10 && date <= 31 || month == 11 && date <= 30 || month == 12 && date <= 31)) {
                isWithinMonth = true;
            }
            if (lastDay == 30 && (month == 1 && date <= 30 || month == 2 && date <= 29 || month == 3 && date <= 30 || month == 4 && date <= 30 || month == 5 && date <= 30 || month == 6 && date <= 30 || month == 7 && date <= 30 || month == 8 && date <= 30 || month == 9 && date <= 30 || month == 10 && date <= 30 || month == 11 && date <= 30 || month == 12 && date <= 30)) {
                isWithinMonth = true;
            }
            if (lastDay <= 29 && date <= lastDay) {
                isWithinMonth = true;
            }
            if ((mSeq = isWithinMonth ? month - startMonth + 1 : month - startMonth + 2) <= 0) {
                mSeq += 12;
            }
        }
        return mSeq;
    }

    public int getFYearOfDate(String parmDate) {
        int fYear = 0;
        int mSeq = 0;
        if (!parmDate.equals("") && parmDate != null) {
            int value2;
            parmDate = parmDate.replaceAll("-", "").replaceAll("/", "").trim();
            fYear = Integer.parseInt(parmDate.substring(0, 4));
            int month = Integer.parseInt(parmDate.substring(4, 6));
            int date = Integer.parseInt(parmDate.substring(6, 8));
            boolean isWithinMonth = false;
            int startMonth = 1;
            int lastDay = 31;
            int value1 = this.getSystemVariantInteger("FIRST_MONTH");
            if (value1 != 0) {
                startMonth = value1;
            }
            if ((value2 = this.getSystemVariantInteger("LAST_DAY")) != 0) {
                lastDay = value2;
            }
            if (lastDay >= 31 && (month == 1 && date <= 31 || month == 2 && date <= 29 || month == 3 && date <= 31 || month == 4 && date <= 30 || month == 5 && date <= 31 || month == 6 && date <= 30 || month == 7 && date <= 31 || month == 8 && date <= 31 || month == 9 && date <= 30 || month == 10 && date <= 31 || month == 11 && date <= 30 || month == 12 && date <= 31)) {
                isWithinMonth = true;
            }
            if (lastDay == 30 && (month == 1 && date <= 30 || month == 2 && date <= 29 || month == 3 && date <= 30 || month == 4 && date <= 30 || month == 5 && date <= 30 || month == 6 && date <= 30 || month == 7 && date <= 30 || month == 8 && date <= 30 || month == 9 && date <= 30 || month == 10 && date <= 30 || month == 11 && date <= 30 || month == 12 && date <= 30)) {
                isWithinMonth = true;
            }
            if (lastDay <= 29 && date <= lastDay) {
                isWithinMonth = true;
            }
            if ((mSeq = isWithinMonth ? month - startMonth + 1 : month - startMonth + 2) <= 0) {
                --fYear;
            }
        }
        return fYear;
    }

    public String getYearMonthOfFYearMSeq(String fYearMSeq) {
        String resultYear = "";
        String resultMonth = "";
        int startMonth = this.getSystemVariantInteger("FIRST_MONTH");
        int fYear = Integer.parseInt(fYearMSeq.substring(0, 4));
        int mSeq = Integer.parseInt(fYearMSeq.substring(4, 6));
        int workInt = startMonth + mSeq - 1;
        if (workInt > 12) {
            resultMonth = Integer.toString(workInt -= 12);
            workInt = fYear + 1;
            resultYear = Integer.toString(workInt);
        } else {
            resultMonth = Integer.toString(workInt);
            workInt = fYear;
            resultYear = Integer.toString(workInt);
        }
        return String.valueOf(resultYear) + resultMonth;
    }

    public void closeSession(boolean isToWriteLogAndClose) {
        block10: {
            if (isToWriteLogAndClose) {
                this.sessionStatus = this.noErrorsOccured ? "END" : "ERR";
                try {
                    String sql = "update " + this.sessionTable + " set DTLOGOUT=CURRENT_TIMESTAMP, KBSESSIONSTATUS='" + this.sessionStatus + "' where " + "NRSESSION='" + this.sessionID + "'";
                    XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                    operator.execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.commit(true, null);
            if (this.scriptEngine != null && !this.loginScript.equals("")) {
                try {
                    this.scriptEngine.eval(this.loginScript);
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
            }
            if (this.appServerName.equals("")) {
                try {
                    this.connectionManualCommit.close();
                    this.connectionAutoCommit.close();
                    if (this.databaseName.contains("jdbc:derby")) {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                }
                catch (SQLException e) {
                    if (!this.databaseName.contains("jdbc:derby") || e.getSQLState() == null || e.getSQLState().equals("XJ015")) break block10;
                    e.printStackTrace();
                }
            }
        }
    }

    public String getLogFileFolder() {
        File logFileDir = new File(this.logFileFolder);
        return logFileDir.getPath();
    }

    public int writeLogOfFunctionStarted(String functionID, String functionName) {
        ++this.sqProgram;
        try {
            String sql = "insert into " + this.sessionDetailTable + " (NRSESSION, SQPROGRAM, IDMENU, IDPROGRAM, TXPROGRAM, DTSTART, KBPROGRAMSTATUS) values (" + "'" + this.getSessionID() + "'," + this.sqProgram + "," + "'**'," + "'" + functionID + "'," + "'" + functionName + "'," + "CURRENT_TIMESTAMP,'')";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            operator.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.sqProgram;
    }

    public void writeLogOfFunctionClosed(int sqProgramOfFunction, String programStatus, String tableOperationLog, String errorLog) {
        String logString = "";
        StringBuffer bf = new StringBuffer();
        bf.append(tableOperationLog);
        if (!errorLog.equals("")) {
            bf.append("\n<ERROR LOG>\n");
            bf.append(errorLog);
        }
        if ((logString = bf.toString()).length() > this.loggingSize) {
            String logFileName = "";
            try {
                File logFileDir = new File(this.logFileFolder);
                if (!logFileDir.exists()) {
                    logFileDir.mkdir();
                }
                logFileName = String.valueOf(logFileDir.getPath()) + File.separator + "Log" + this.getSessionID() + "_" + sqProgramOfFunction + ".txt";
                FileOutputStream fileOutputStream = new FileOutputStream(logFileName);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                BufferedWriter writer = new BufferedWriter(outputStreamWriter);
                writer.write(logString);
                ((Writer)writer).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            logString = "Ref Log" + this.getSessionID() + "_" + sqProgramOfFunction + ".txt";
        }
        logString = logString.replaceAll("'", "\"");
        if (this.databaseName.contains("ucanaccess:") && logString.contains("#")) {
            logString = logString.replaceAll("#", "\"");
        }
        if (programStatus.equals("99")) {
            this.noErrorsOccured = false;
        }
        try {
            String sql = "update " + this.sessionDetailTable + " set DTEND=CURRENT_TIMESTAMP, KBPROGRAMSTATUS='" + programStatus + "', TXERRORLOG='" + logString + "' where " + "NRSESSION='" + this.getSessionID() + "' and " + "SQPROGRAM=" + sqProgramOfFunction;
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            operator.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAppServerName() {
        return this.appServerName;
    }

    public String getSubDBName(String id) {
        return this.subDBNameList.get(this.subDBIDList.indexOf(id));
    }

    public int getSubDBListSize() {
        return this.subDBNameList.size();
    }

    public String getSubDBName(int index) {
        return this.subDBNameList.get(index);
    }

    public String getSubDBUser(int index) {
        return this.subDBUserList.get(index);
    }

    public String getSubDBPassword(int index) {
        return this.subDBPasswordList.get(index);
    }

    public Connection getConnectionManualCommit() {
        return this.connectionManualCommit;
    }

    public Connection getConnectionAutoCommit() {
        return this.connectionAutoCommit;
    }

    public Connection getConnectionReadOnly(String id) {
        return this.subDBConnectionList.get(this.subDBIDList.indexOf(id));
    }

    public void commit() {
        this.commit(true, null);
    }

    public void commit(boolean isCommit, StringBuffer logBuf) {
        block19: {
            if (this.appServerName.equals("")) {
                try {
                    if (isCommit) {
                        this.connectionManualCommit.commit();
                        if (logBuf != null) {
                            XFUtility.appendLog((String)"Local-commit succeeded.", (StringBuffer)logBuf);
                        }
                    } else {
                        this.connectionManualCommit.rollback();
                        if (logBuf != null) {
                            XFUtility.appendLog((String)"Local-rollback succeeded.", (StringBuffer)logBuf);
                        }
                    }
                    break block19;
                }
                catch (SQLException e) {
                    if (logBuf != null) {
                        XFUtility.appendLog((String)e.getMessage(), (StringBuffer)logBuf);
                    }
                    break block19;
                }
            }
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpPost httpPost = null;
            try {
                try {
                    httpPost = new HttpPost(this.appServerName);
                    ArrayList<BasicNameValuePair> objValuePairs = new ArrayList<BasicNameValuePair>(2);
                    objValuePairs.add(new BasicNameValuePair("SESSION", this.sessionID));
                    if (isCommit) {
                        objValuePairs.add(new BasicNameValuePair("METHOD", "COMMIT"));
                    } else {
                        objValuePairs.add(new BasicNameValuePair("METHOD", "ROLLBACK"));
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(objValuePairs, "UTF-8"));
                    HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity responseEntity = response.getEntity();
                    if (logBuf == null) break block19;
                    if (responseEntity == null) {
                        XFUtility.appendLog((String)"Response is NULL.", (StringBuffer)logBuf);
                        break block19;
                    }
                    XFUtility.appendLog((String)EntityUtils.toString((HttpEntity)responseEntity), (StringBuffer)logBuf);
                }
                catch (Exception e) {
                    String msg = "";
                    msg = isCommit ? "Connection failed to commit with the servlet '" + this.appServerName + "'" : "Connection failed to rollback with the servlet '" + this.appServerName + "'";
                    if (logBuf != null) {
                        XFUtility.appendLog((String)(String.valueOf(msg) + "\n" + e.getMessage()), (StringBuffer)logBuf);
                    }
                    httpClient.getConnectionManager().shutdown();
                    if (httpPost != null) {
                        httpPost.abort();
                    }
                }
            }
            finally {
                httpClient.getConnectionManager().shutdown();
                if (httpPost != null) {
                    httpPost.abort();
                }
            }
        }
    }

    public Object requestWebService(String uri) {
        return this.requestWebService(uri, "UTF-8");
    }

    public Object requestWebService(String uri, String encoding) {
        String response = null;
        HttpResponse httpResponse = null;
        InputStream inputStream = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            try {
                this.httpGet.setURI(new URI(uri));
                httpResponse = httpClient.execute((HttpUriRequest)this.httpGet);
                response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)encoding);
            }
            catch (Exception exception) {
                httpClient.getConnectionManager().shutdown();
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            httpClient.getConnectionManager().shutdown();
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return response;
    }

    public XFHttpRequest createWebServiceRequest(String uri) {
        return new XFHttpRequest(uri, "UTF-8");
    }

    public XFHttpRequest createWebServiceRequest(String uri, String encoding) {
        return new XFHttpRequest(uri, encoding);
    }

    public Document parseStringToGetXmlDocument(String data) {
        Document doc = null;
        try {
            this.domParser.parse(new InputSource(new ByteArrayInputStream(data.getBytes("UTF-8"))));
            doc = this.domParser.getDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    public Document parseStringToGetXmlDocument(String data, String encoding) {
        Document doc = null;
        try {
            this.domParser.parse(new InputSource(new ByteArrayInputStream(data.getBytes(encoding))));
            doc = this.domParser.getDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    public String parseXmlDocumentToGetString(Document document) throws Exception {
        StringWriter sw = new StringWriter();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer transformer = tfactory.newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(sw));
        return sw.toString();
    }

    public Document createXmlDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.newDocument();
    }

    public Document createXmlDocument(String name) throws Exception {
        Document document = this.createXmlDocument();
        Element element = document.createElement(name);
        document.appendChild(element);
        return document;
    }

    public Element createXmlNode(Document document, String name) throws Exception {
        return document.createElement(name);
    }

    public Element getXmlNode(Document document, String name) throws Exception {
        NodeList elementList = document.getElementsByTagName(name);
        return (Element)elementList.item(0);
    }

    public Element getXmlNode(Element element, String name) throws Exception {
        NodeList elementList = element.getElementsByTagName(name);
        return (Element)elementList.item(0);
    }

    public ArrayList<Element> getXmlNodeList(Document document, String name) throws Exception {
        ArrayList<Element> elementList = new ArrayList<Element>();
        NodeList nodeList = document.getElementsByTagName(name);
        int i = 0;
        while (i < nodeList.getLength()) {
            elementList.add((Element)nodeList.item(i));
            ++i;
        }
        return elementList;
    }

    public ArrayList<Element> getXmlNodeList(Element element, String name) throws Exception {
        ArrayList<Element> elementList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName(name);
        int i = 0;
        while (i < nodeList.getLength()) {
            elementList.add((Element)nodeList.item(i));
            ++i;
        }
        return elementList;
    }

    public String getXmlNodeContent(Element element, String name) throws Exception {
        Element workElement = this.getXmlNode(element, name);
        return workElement.getTextContent();
    }

    public JSONObject createJsonObject(String text) {
        JSONObject obj = null;
        try {
            obj = new JSONObject(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    public JSONObject createJsonObject() throws Exception {
        return new JSONObject();
    }

    public JSONArray createJsonArray(String text) {
        JSONArray array = null;
        try {
            array = new JSONArray(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return array;
    }

    public JSONArray createJsonArray() throws Exception {
        return new JSONArray();
    }

    public JSONObject getJsonObject(JSONObject object, String name) throws Exception {
        return object.getJSONObject(name);
    }

    public JSONArray getJsonArray(JSONObject object, String name) throws Exception {
        return object.getJSONArray(name);
    }

    public JSONObject getJsonObject(JSONArray array, int index) throws Exception {
        return array.getJSONObject(index);
    }

    public String getDigestedValueForUser(String user, String value) {
        if (this.isValueSaltedForUser) {
            return this.getDigestedValue(value, this.digestAlgorithmForUser, this.countOfExpandForUser, user);
        }
        return this.getDigestedValue(value, this.digestAlgorithmForUser, this.countOfExpandForUser, "");
    }

    public String getDigestedValueForUser(String value) {
        if (this.isValueSaltedForUser) {
            return this.getDigestedValue(value, this.digestAlgorithmForUser, this.countOfExpandForUser, this.userID);
        }
        return this.getDigestedValue(value, this.digestAlgorithmForUser, this.countOfExpandForUser, "");
    }

    public String getDigestedValue(String value) {
        return this.getDigestedValueForUser(value);
    }

    public String getDigestedValue(String value, String algorithm) {
        return this.getDigestedValue(value, algorithm, 1, "");
    }

    public String getDigestedValue(String value, String algorithm, int expand, String salt) {
        String digestedValue = "";
        int count = expand - 1;
        try {
            DigestAdapter adapter = new DigestAdapter(algorithm);
            digestedValue = adapter.digest(String.valueOf(value) + salt);
            int i = 0;
            while (i < count) {
                digestedValue = adapter.digest(String.valueOf(digestedValue) + salt);
                ++i;
            }
        }
        catch (NoSuchAlgorithmException e) {
            return digestedValue;
        }
        return digestedValue;
    }

    public String getRandomString(int length, String characters) {
        return RandomStringUtils.random((int)length, (String)characters);
    }

    public String getAddressFromZipNo(String zipNo) {
        String value = "";
        String zipNo_ = zipNo.replace("-", "");
        HttpResponse response = null;
        InputStream inputStream = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            try {
                this.httpGet.setURI(new URI("http://zip.cgis.biz/xml/zip.php?zn=" + zipNo_));
                response = httpClient.execute((HttpUriRequest)this.httpGet);
                if (response.getStatusLine().getStatusCode() < 400) {
                    inputStream = response.getEntity().getContent();
                    this.domParser.parse(new InputSource(inputStream));
                    this.responseDoc = this.domParser.getDocument();
                    Element rootNode = (Element)this.responseDoc.getElementsByTagName("ZIP_result").item(0);
                    if (rootNode.getElementsByTagName("value").getLength() != 0) {
                        String company;
                        Element stateNode = (Element)rootNode.getElementsByTagName("value").item(4);
                        Element cityNode = (Element)rootNode.getElementsByTagName("value").item(5);
                        Element addressNode = (Element)rootNode.getElementsByTagName("value").item(6);
                        Element companyNode = (Element)rootNode.getElementsByTagName("value").item(7);
                        String state = stateNode.getAttribute("state");
                        String city = cityNode.getAttribute("city");
                        String address = addressNode.getAttribute("address");
                        if (address.equals("none")) {
                            address = "";
                        }
                        if ((company = companyNode.getAttribute("company")).equals("none")) {
                            company = "";
                        }
                        value = String.valueOf(state) + city + address + company;
                    }
                }
            }
            catch (Exception exception) {
                httpClient.getConnectionManager().shutdown();
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            httpClient.getConnectionManager().shutdown();
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return value;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public HashMap<String, Object> executeFunction(String functionID, HashMap<String, Object> parmMap) throws Exception {
        ScriptLauncher launcher = new ScriptLauncher(functionID, this);
        return launcher.execute(parmMap);
    }

    public String executeProgram(String pgmName) {
        String message = "";
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(pgmName);
            if (p != null) {
                int count = 0;
                String result = "";
                StringBuffer buf = new StringBuffer();
                InputStream is = p.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                while ((result = br.readLine()) != null) {
                    if (count > 0) {
                        buf.append("\n");
                    }
                    buf.append(result);
                    ++count;
                }
                message = buf.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return message;
    }

    public String getImageFileFolder() {
        return this.imageFileFolder;
    }

    public File createTempFile(String functionID, String extension) throws IOException {
        String header = "XeadDriver_";
        if (extension.equals(".pdf")) {
            header = "PDF_" + header;
        }
        if (extension.equals(".xls")) {
            header = "XLS_" + header;
        }
        if (extension.equals(".log")) {
            header = "LOG_" + header;
        }
        File tempFile = File.createTempFile(String.valueOf(header) + functionID + "_", extension, this.outputFolder);
        if (this.outputFolder == null) {
            tempFile.deleteOnExit();
        }
        return tempFile;
    }

    public boolean existsFile(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public boolean deleteFile(String fileName) {
        File file = new File(fileName);
        return file.delete();
    }

    public boolean renameFile(String currentName, String newName) {
        File currentFile = new File(currentName);
        File newFile = new File(newName);
        return currentFile.renameTo(newFile);
    }

    public boolean copyFile(String originalName, String newName) {
        boolean result = false;
        try {
            File originalFile;
            if (originalName.contains("<CURRENT>")) {
                originalName = originalName.replace("<CURRENT>", this.currentFolder);
            }
            if (newName.contains("<CURRENT>")) {
                newName = newName.replace("<CURRENT>", this.currentFolder);
            }
            if (!(originalFile = new File(originalName)).exists()) {
                return result;
            }
            File newFile = new File(newName);
            if (!newFile.exists()) {
                newFile.createNewFile();
            }
            FileInputStream fis = new FileInputStream(originalFile);
            FileOutputStream fos = new FileOutputStream(newFile);
            try {
                try {
                    byte[] buf = new byte[1024];
                    int i = 0;
                    while ((i = fis.read(buf)) != -1) {
                        fos.write(buf, 0, i);
                    }
                    result = true;
                }
                catch (Exception exception) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public XFExcelFileOperator createExcelFileOperator(String fileName) {
        return new XFExcelFileOperator(fileName);
    }

    public XFTextFileOperator createTextFileOperator(String operation, String fileName, String separator) {
        return this.createTextFileOperator(operation, fileName, separator, "");
    }

    public XFTextFileOperator createTextFileOperator(String operation, String fileName, String separator, String charset) {
        File file = new File(fileName);
        if (operation.equals("Read") && !file.exists()) {
            return null;
        }
        return new XFTextFileOperator(operation, fileName, separator, charset);
    }

    public XFTableOperator createTableOperator(String oparation, String tableID) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this, null, oparation, tableID, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return operator;
    }

    public XFTableOperator createTableOperator(String sqlText) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this, null, sqlText, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return operator;
    }

    public int copyTableRecords(String fromTable, String toTable, String type) {
        return this.copyTableRecords(fromTable, toTable, type, 0, true);
    }

    public int copyTableRecords(String fromTable, String toTable, String type, int recordCount) {
        return this.copyTableRecords(fromTable, toTable, type, recordCount, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int copyTableRecords(String fromTable, String toTable, String type, int recordCount, boolean isToCommitEachTime) {
        int totalCount;
        block38: {
            totalCount = 0;
            int index = 0;
            try {
                int count;
                XFTableOperator insertToTable;
                ArrayList dataTypeOptionList;
                String dataTypeOptions;
                Element workElement;
                if (!(type.equals("REPLACE") || type.equals("ADD") || type.equals("MERGE"))) {
                    return -1;
                }
                Element tableElementFrom = this.getTableElement(fromTable);
                NodeList fieldListFrom = tableElementFrom.getElementsByTagName("Field");
                XFTableOperator selectFromTable = this.createTableOperator("SELECT", fromTable);
                Element tableElementTo = this.getTableElement(toTable);
                if (!tableElementTo.getAttribute("DB").equals("")) {
                    return -1;
                }
                NodeList fieldListTo = tableElementTo.getElementsByTagName("Field");
                NodeList keyListTo = tableElementTo.getElementsByTagName("Key");
                ArrayList<String> fieldIDListFrom = new ArrayList<String>();
                ArrayList<String> fieldTypeListFrom = new ArrayList<String>();
                ArrayList<Integer> fieldLengthListFrom = new ArrayList<Integer>();
                int i = 0;
                while (i < fieldListFrom.getLength()) {
                    workElement = (Element)fieldListFrom.item(i);
                    dataTypeOptions = workElement.getAttribute("TypeOptions");
                    dataTypeOptionList = XFUtility.getOptionList((String)dataTypeOptions);
                    if (!dataTypeOptionList.contains("VIRTUAL")) {
                        fieldIDListFrom.add(workElement.getAttribute("ID"));
                        fieldTypeListFrom.add(workElement.getAttribute("Type"));
                        fieldLengthListFrom.add(Integer.parseInt(workElement.getAttribute("Size")));
                    }
                    ++i;
                }
                ArrayList<String> keyFieldIDListTo = new ArrayList<String>();
                int i2 = 0;
                while (i2 < keyListTo.getLength()) {
                    workElement = (Element)keyListTo.item(i2);
                    if (workElement.getAttribute("Type").equals("PK")) {
                        StringTokenizer workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
                        while (workTokenizer.hasMoreTokens()) {
                            keyFieldIDListTo.add(workTokenizer.nextToken());
                        }
                        break;
                    }
                    ++i2;
                }
                ArrayList<String> fieldIDListTo = new ArrayList<String>();
                ArrayList<String> fieldTypeListTo = new ArrayList<String>();
                ArrayList<Integer> fieldLengthListTo = new ArrayList<Integer>();
                ArrayList<String> fieldNullableListTo = new ArrayList<String>();
                int i3 = 0;
                while (i3 < fieldListTo.getLength()) {
                    workElement = (Element)fieldListTo.item(i3);
                    dataTypeOptions = workElement.getAttribute("TypeOptions");
                    dataTypeOptionList = XFUtility.getOptionList((String)dataTypeOptions);
                    if (!dataTypeOptionList.contains("VIRTUAL")) {
                        fieldIDListTo.add(workElement.getAttribute("ID"));
                        fieldTypeListTo.add(workElement.getAttribute("Type"));
                        fieldLengthListTo.add(Integer.parseInt(workElement.getAttribute("Size")));
                        fieldNullableListTo.add(workElement.getAttribute("Nullable"));
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < fieldIDListTo.size()) {
                    index = fieldIDListFrom.indexOf(fieldIDListTo.get(i3));
                    if (index == -1) {
                        if (((String)fieldNullableListTo.get(i3)).equals("F")) {
                            return -1;
                        }
                    } else if (((String)fieldTypeListFrom.get(index)).equals(fieldTypeListTo.get(i3))) {
                        if ((((String)fieldTypeListFrom.get(index)).equals("CHAR") || ((String)fieldTypeListFrom.get(index)).equals("TEXT")) && (Integer)fieldLengthListFrom.get(index) > (Integer)fieldLengthListTo.get(i3)) {
                            return -1;
                        }
                    } else {
                        return -1;
                    }
                    ++i3;
                }
                if (type.equals("REPLACE") || type.equals("ADD")) {
                    if (type.equals("REPLACE")) {
                        XFTableOperator deleteToTable = this.createTableOperator("DELETE", toTable);
                        deleteToTable.execute();
                        if (isToCommitEachTime) {
                            this.commit();
                        }
                    }
                    while (selectFromTable.next()) {
                        insertToTable = this.createTableOperator("INSERT", toTable);
                        i3 = 0;
                        while (i3 < fieldIDListFrom.size()) {
                            if (fieldIDListTo.contains(fieldIDListFrom.get(i3))) {
                                insertToTable.addValue((String)fieldIDListFrom.get(i3), selectFromTable.getValueOf((String)fieldIDListFrom.get(i3)));
                            }
                            ++i3;
                        }
                        count = insertToTable.execute();
                        if (count == 1) {
                            if (isToCommitEachTime) {
                                this.commit();
                            }
                            if (recordCount <= 0 || ++totalCount != recordCount) continue;
                            break;
                        }
                        this.commit(false, null);
                        return -1;
                    }
                }
                if (!type.equals("MERGE")) break block38;
                while (selectFromTable.next()) {
                    XFTableOperator selectToTable = this.createTableOperator("SELECT", toTable);
                    i3 = 0;
                    while (i3 < keyFieldIDListTo.size()) {
                        selectToTable.addKeyValue((String)keyFieldIDListTo.get(i3), selectFromTable.getValueOf((String)keyFieldIDListTo.get(i3)));
                        ++i3;
                    }
                    if (selectToTable.next()) {
                        XFTableOperator updateToTable = this.createTableOperator("UPDATE", toTable);
                        i3 = 0;
                        while (i3 < fieldIDListFrom.size()) {
                            if (fieldIDListTo.contains(fieldIDListFrom.get(i3))) {
                                updateToTable.addValue((String)fieldIDListFrom.get(i3), selectFromTable.getValueOf((String)fieldIDListFrom.get(i3)));
                            }
                            ++i3;
                        }
                        i3 = 0;
                        while (i3 < keyFieldIDListTo.size()) {
                            updateToTable.addKeyValue((String)keyFieldIDListTo.get(i3), selectFromTable.getValueOf((String)keyFieldIDListTo.get(i3)));
                            ++i3;
                        }
                        count = updateToTable.execute();
                        if (count == 1) {
                            if (isToCommitEachTime) {
                                this.commit();
                            }
                            if (recordCount <= 0 || ++totalCount != recordCount) continue;
                            break;
                        }
                        this.commit(false, null);
                        return -1;
                    }
                    insertToTable = this.createTableOperator("INSERT", toTable);
                    i3 = 0;
                    while (i3 < fieldIDListFrom.size()) {
                        if (fieldIDListTo.contains(fieldIDListFrom.get(i3))) {
                            insertToTable.addValue((String)fieldIDListFrom.get(i3), selectFromTable.getValueOf((String)fieldIDListFrom.get(i3)));
                        }
                        ++i3;
                    }
                    count = insertToTable.execute();
                    if (count == 1) {
                        if (isToCommitEachTime) {
                            this.commit();
                        }
                        if (recordCount <= 0 || ++totalCount != recordCount) continue;
                        break;
                    }
                    this.commit(false, null);
                    return -1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.commit(false, null);
                return -1;
            }
        }
        return totalCount;
    }

    Document getDomDocument() {
        return this.domDocument;
    }

    public void sendMail(String addressFrom, String addressTo, String addressCc, String subject, String message, String fileName, String attachedName, String charset) {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", this.smtpHost);
            props.put("mail.host", this.smtpHost);
            props.put("mail.from", addressFrom);
            if (!this.smtpPassword.equals("")) {
                props.setProperty("mail.smtp.auth", "true");
            }
            if (!this.smtpPort.equals("")) {
                props.put("mail.smtp.port", this.smtpPort);
            }
            javax.mail.Session mailSession = javax.mail.Session.getDefaultInstance((Properties)props, null);
            MimeMessage mailObj = new MimeMessage(mailSession);
            InternetAddress[] toList = new InternetAddress[]{new InternetAddress(addressTo)};
            mailObj.setRecipients(Message.RecipientType.TO, (Address[])toList);
            InternetAddress[] ccList = new InternetAddress[]{new InternetAddress(addressCc)};
            mailObj.setRecipients(Message.RecipientType.CC, (Address[])ccList);
            mailObj.setFrom((Address)new InternetAddress(addressFrom));
            mailObj.setSentDate(new Date());
            if (charset.equals("")) {
                mailObj.setSubject(subject);
            } else {
                mailObj.setSubject(subject, charset);
            }
            MimeBodyPart bodyMessage = new MimeBodyPart();
            MimeBodyPart bodyAttachedFile = new MimeBodyPart();
            if (charset.equals("")) {
                bodyMessage.setText(message);
            } else {
                bodyMessage.setText(message, charset);
            }
            if (!fileName.equals("")) {
                FileDataSource fds = new FileDataSource(fileName);
                bodyAttachedFile.setDataHandler(new DataHandler((DataSource)fds));
                if (!attachedName.equals("")) {
                    if (charset.equals("")) {
                        bodyAttachedFile.setFileName(MimeUtility.encodeWord((String)attachedName));
                    } else {
                        bodyAttachedFile.setFileName(MimeUtility.encodeWord((String)attachedName, (String)charset, (String)"B"));
                    }
                }
            }
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)bodyMessage);
            if (!fileName.equals("")) {
                multipart.addBodyPart((BodyPart)bodyAttachedFile);
            }
            mailObj.setContent((Multipart)multipart);
            if (this.smtpPassword.equals("")) {
                Transport.send((Message)mailObj);
            } else {
                Transport tp = mailSession.getTransport("smtp");
                tp.connect(this.smtpHost, this.smtpUser, this.smtpPassword);
                tp.sendMessage((Message)mailObj, (Address[])toList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getSystemName() {
        return this.systemName;
    }

    String getVersion() {
        return this.systemVersion;
    }

    public String getAdminEmail() {
        return this.smtpAdminEmail;
    }

    String getTableNameOfUser() {
        return this.userTable;
    }

    String getTableNameOfVariants() {
        return this.variantsTable;
    }

    String getTableNameOfUserVariants() {
        return this.userVariantsTable;
    }

    String getTableNameOfNumbering() {
        return this.numberingTable;
    }

    String getTableNameOfCalendar() {
        return this.calendarTable;
    }

    int getNextSQPROGRAM() {
        ++this.sqProgram;
        return this.sqProgram;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void compressTable(String tableID) throws Exception {
        Statement statement = null;
        HttpPost httpPost = null;
        String msg = "";
        boolean isTarget = false;
        if (this.databaseName.contains("jdbc:derby:")) {
            try {
                try {
                    if (this.appServerName.equals("")) {
                        statement = this.connectionManualCommit.createStatement();
                    }
                    int i = 0;
                    while (i < this.tableList.getLength()) {
                        Element element = (Element)this.tableList.item(i);
                        isTarget = false;
                        if (element.getAttribute("ID").equals(tableID) || tableID.equals("")) {
                            isTarget = true;
                        } else if (tableID.endsWith("*") && element.getAttribute("ID").startsWith(tableID.replace("*", ""))) {
                            isTarget = true;
                        }
                        if (isTarget) {
                            StringBuffer statementBuf = new StringBuffer();
                            statementBuf.append("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE('");
                            statementBuf.append(this.databaseUser);
                            statementBuf.append("', '");
                            statementBuf.append(element.getAttribute("ID"));
                            statementBuf.append("', 1)");
                            if (this.appServerName.equals("")) {
                                statement.executeUpdate(statementBuf.toString());
                            } else {
                                DefaultHttpClient httpClient = new DefaultHttpClient();
                                try {
                                    httpPost = new HttpPost(this.appServerName);
                                    ArrayList<BasicNameValuePair> objValuePairs = new ArrayList<BasicNameValuePair>(1);
                                    objValuePairs.add(new BasicNameValuePair("METHOD", statementBuf.toString()));
                                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(objValuePairs, "UTF-8"));
                                    HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                    HttpEntity responseEntity = response.getEntity();
                                    if (responseEntity == null) {
                                        msg = "Compressing table " + element.getAttribute("ID") + " failed.";
                                        throw new Exception(msg);
                                    }
                                }
                                finally {
                                    httpClient.getConnectionManager().shutdown();
                                    if (httpPost != null) {
                                        httpPost.abort();
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (SQLException e) {
                    throw new Exception(e.getMessage());
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
            }
            finally {
                if (this.appServerName.equals("")) {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getStatus() {
        return this.sessionStatus;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserEmployeeNo() {
        return this.userEmployeeNo;
    }

    public String getUserEmailAddress() {
        return this.userEmailAddress;
    }

    public String getAttribute(String id) {
        return this.attributeMap.get(id);
    }

    public String getSystemProperty(String id) {
        return System.getProperty(id);
    }

    public void setAttribute(String id, String value) {
        this.attributeMap.put(id.trim(), value.trim());
    }

    public NodeList getFunctionList() {
        return this.functionList;
    }

    public String getScriptFunctions() {
        return this.scriptFunctions;
    }

    public String getFunctionName(String functionID) {
        String functionName = "";
        int k = 0;
        while (k < this.functionList.getLength()) {
            Element workElement = (Element)this.functionList.item(k);
            if (workElement.getAttribute("ID").equals(functionID)) {
                functionName = workElement.getAttribute("Name");
                break;
            }
            ++k;
        }
        return functionName;
    }

    Element getTablePKElement(String tableID) {
        Element element3 = null;
        int i = 0;
        block0: while (i < this.tableList.getLength()) {
            Element element1 = (Element)this.tableList.item(i);
            if (element1.getAttribute("ID").equals(tableID)) {
                NodeList nodeList = element1.getElementsByTagName("Key");
                int j = 0;
                while (j < nodeList.getLength()) {
                    Element element2 = (Element)nodeList.item(j);
                    if (element2.getAttribute("Type").equals("PK")) {
                        element3 = element2;
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return element3;
    }

    Element getTableElement(String tableID) {
        Element element2 = null;
        int i = 0;
        while (i < this.tableList.getLength()) {
            Element element1 = (Element)this.tableList.item(i);
            if (element1.getAttribute("ID").equals(tableID)) {
                element2 = element1;
                break;
            }
            ++i;
        }
        return element2;
    }

    public String getTableName(String tableID) {
        String tableName = "";
        Element element2 = null;
        int i = 0;
        while (i < this.tableList.getLength()) {
            Element element1 = (Element)this.tableList.item(i);
            if (element1.getAttribute("ID").equals(tableID)) {
                element2 = element1;
                tableName = element2.getAttribute("Name");
                break;
            }
            ++i;
        }
        return tableName;
    }

    public NodeList getTableNodeList() {
        return this.tableList;
    }

    public Element getFieldElement(String tableID, String fieldID) {
        Element element3 = null;
        int i = 0;
        block0: while (i < this.tableList.getLength()) {
            Element element1 = (Element)this.tableList.item(i);
            if (element1.getAttribute("ID").equals(tableID)) {
                NodeList nodeList = element1.getElementsByTagName("Field");
                int j = 0;
                while (j < nodeList.getLength()) {
                    Element element2 = (Element)nodeList.item(j);
                    if (element2.getAttribute("ID").equals(fieldID)) {
                        element3 = element2;
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return element3;
    }

    public String getFieldName(String tableID, String fieldID) {
        String name = "";
        Element element = this.getFieldElement(tableID, fieldID);
        if (element != null) {
            name = element.getAttribute("Name");
        }
        return name;
    }

    public String getFieldType(String tableID, String fieldID) {
        String name = "";
        Element element = this.getFieldElement(tableID, fieldID);
        if (element != null) {
            name = element.getAttribute("Type");
        }
        return name;
    }

    public String getFieldSize(String tableID, String fieldID) {
        String name = "";
        Element element = this.getFieldElement(tableID, fieldID);
        if (element != null) {
            name = element.getAttribute("Size");
        }
        return name;
    }

    public String getFieldDecimal(String tableID, String fieldID) {
        String name = "";
        Element element = this.getFieldElement(tableID, fieldID);
        if (element != null) {
            name = element.getAttribute("Decimal");
        }
        return name;
    }
}

