/*
 * Decompiled with CFR 0.152.
 */
package xeadServer;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadDriver.XFUtility;
import xeadServer.Session;
import xeadServer.SortableDomElementListModel;
import xeadServer.XFScriptable;
import xeadServer.XFTableEvaluator_Field;
import xeadServer.XFTableEvaluator_ReferTable;
import xeadServer.XFTableOperator;

public class XFTableEvaluator {
    private Session session_ = null;
    private XFScriptable instance_ = null;
    private String tableID_ = "";
    private String moduleID = "";
    private String dbName = "";
    private String orderBy = "";
    private String activeWhere = "";
    private String updateValueToInactivate = "";
    private String fixedWhere = "";
    private ArrayList<XFTableEvaluator_ReferTable> referTableList = new ArrayList();
    private ArrayList<XFTableEvaluator_Field> fieldList = new ArrayList();
    private ArrayList<String> keyFieldList = new ArrayList();
    private ArrayList<String> withKeyList_ = new ArrayList();
    private ArrayList<String> uniqueKeyList = new ArrayList();
    private ArrayList<XFScript> scriptList = new ArrayList();
    private StringTokenizer workTokenizer;
    private String updateCounterID = "";
    private int updateCounterValue = 0;
    private String detailRowNoID = "";
    private ScriptEngine scriptEngine;
    private Bindings scriptBindings;
    private String scriptNameRunning = "";
    private XFTableOperator tableOperatorToSelect = null;
    private XFTableOperator tableOperator = null;
    private SortableDomElementListModel sortingList;

    public XFTableEvaluator(XFScriptable instance, String tableID, Session session) {
        Element workElement;
        this.instance_ = instance;
        this.tableID_ = tableID;
        this.session_ = session;
        Element tableElement = this.session_.getTableElement(tableID);
        this.activeWhere = tableElement.getAttribute("ActiveWhere");
        this.dbName = tableElement.getAttribute("DB").equals("") ? this.session_.getDatabaseName() : this.session_.getSubDBName(tableElement.getAttribute("DB"));
        this.moduleID = tableID;
        if (!tableElement.getAttribute("ModuleID").equals("")) {
            this.moduleID = tableElement.getAttribute("ModuleID");
        }
        NodeList nodeList = tableElement.getElementsByTagName("Key");
        int i = 0;
        while (i < nodeList.getLength()) {
            workElement = (Element)nodeList.item(i);
            if (workElement.getAttribute("Type").equals("PK")) {
                this.workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
                while (this.workTokenizer.hasMoreTokens()) {
                    String wrkStr1 = this.workTokenizer.nextToken();
                    if (wrkStr1.equals("")) continue;
                    this.keyFieldList.add(wrkStr1);
                    workElement = this.session_.getFieldElement(tableID, wrkStr1);
                    if (!XFUtility.getBasicTypeOf((String)workElement.getAttribute("Type")).equals("INTEGER") || !tableElement.getAttribute("DetailRowNumberAuto").equals("T")) continue;
                    this.detailRowNoID = wrkStr1;
                }
            }
            if (workElement.getAttribute("Type").equals("SK")) {
                this.uniqueKeyList.add(workElement.getAttribute("Fields"));
            }
            ++i;
        }
        NodeList tableFieldList = tableElement.getElementsByTagName("Field");
        this.sortingList = XFTableEvaluator.getSortedListModel(tableFieldList, "Order");
        int i2 = 0;
        while (i2 < this.sortingList.getSize()) {
            workElement = (Element)this.sortingList.getElementAt(i2);
            XFTableEvaluator_Field workField = new XFTableEvaluator_Field(tableID, "", workElement.getAttribute("ID"), this);
            this.fieldList.add(workField);
            ++i2;
        }
        NodeList referNodeList = tableElement.getElementsByTagName("Refer");
        this.sortingList = XFTableEvaluator.getSortedListModel(referNodeList, "Order");
        int i3 = 0;
        while (i3 < this.sortingList.getSize()) {
            Element element = (Element)this.sortingList.getElementAt(i3);
            XFTableEvaluator_ReferTable referTable = new XFTableEvaluator_ReferTable(element, this);
            this.referTableList.add(referTable);
            int j = 0;
            while (j < referTable.getFieldList().size()) {
                this.fieldList.add(referTable.getFieldList().get(j));
                ++j;
            }
            ++i3;
        }
        this.updateValueToInactivate = tableElement.getAttribute("DeleteOperation");
        this.updateCounterID = tableElement.getAttribute("UpdateCounter");
        if (this.updateCounterID.equals("")) {
            this.updateCounterID = "UPDCOUNTER";
        } else if (this.updateCounterID.toUpperCase().equals("*NONE")) {
            this.updateCounterID = "";
        }
        NodeList workList = tableElement.getElementsByTagName("Script");
        SortableDomElementListModel sortList = XFTableEvaluator.getSortedListModel(workList, "Order");
        int i4 = 0;
        while (i4 < sortList.size()) {
            Element element = (Element)sortList.getElementAt(i4);
            this.scriptList.add(new XFScript(tableID, element, this.session_.getTableNodeList()));
            ++i4;
        }
        this.scriptEngine = this.session_.getScriptEngineManager().getEngineByName("js");
        this.scriptBindings = this.scriptEngine.createBindings();
        this.scriptBindings.put("instance", (Object)this.instance_);
        i4 = 0;
        while (i4 < this.fieldList.size()) {
            this.scriptBindings.put(this.fieldList.get(i4).getDataSourceID(), (Object)this.fieldList.get(i4));
            ++i4;
        }
    }

    public static SortableDomElementListModel getSortedListModel(NodeList list, String attName) {
        SortableDomElementListModel sortableDomElementListModel = new SortableDomElementListModel(attName);
        int i = 0;
        while (i < list.getLength()) {
            sortableDomElementListModel.addElement(list.item(i));
            ++i;
        }
        sortableDomElementListModel.sortElements();
        return sortableDomElementListModel;
    }

    public Session getSession() {
        return this.session_;
    }

    public void evalScript(String scriptName, String scriptText) throws ScriptException {
        if (!scriptText.equals("")) {
            this.scriptNameRunning = scriptName;
            StringBuffer bf = new StringBuffer();
            bf.append(scriptText);
            bf.append(this.session_.getScriptFunctions());
            this.scriptEngine.eval(bf.toString(), this.scriptBindings);
        }
    }

    public String getTableID() {
        return this.tableID_;
    }

    public String getDetailRowNoID() {
        return this.detailRowNoID;
    }

    public void setOrderBy(String text) {
        this.orderBy = text;
    }

    public void clear() {
        this.orderBy = "";
        this.tableOperatorToSelect = null;
        int i = 0;
        while (i < this.fieldList.size()) {
            this.fieldList.get(i).setValue(this.fieldList.get(i).getNullValue());
            ++i;
        }
    }

    public void addKeyValue(String fieldID, Object value) {
        String fieldID_ = fieldID;
        String operand_ = " = ";
        if (fieldID.contains("!=")) {
            fieldID_ = fieldID.replace("!=", "");
            operand_ = " != ";
        } else if (fieldID.contains("<=")) {
            fieldID_ = fieldID.replace("<=", "");
            operand_ = " <= ";
        } else if (fieldID.contains(">=")) {
            fieldID_ = fieldID.replace(">=", "");
            operand_ = " >= ";
        } else {
            if (fieldID.contains("=")) {
                fieldID_ = fieldID.replace("=", "");
                operand_ = " = ";
            }
            if (fieldID.contains("<")) {
                fieldID_ = fieldID.replace("<", "");
                operand_ = " < ";
            }
            if (fieldID.contains(">")) {
                fieldID_ = fieldID.replace(">", "");
                operand_ = " > ";
            }
        }
        fieldID_ = fieldID_.trim();
        if (this.withKeyList_.size() > 0) {
            this.withKeyList_.add(" and ");
        }
        if (value.toString().trim().startsWith("'") && value.toString().trim().endsWith("'")) {
            this.withKeyList_.add(String.valueOf(fieldID_) + operand_ + value);
        } else {
            Element workElement = this.session_.getFieldElement(this.tableID_, fieldID_);
            if (workElement == null) {
                this.withKeyList_.add(String.valueOf(fieldID_) + operand_ + value);
            } else if ((workElement.getAttribute("Type").contains("DATE") || workElement.getAttribute("Type").contains("TIME")) && operand_.equals(" = ") && value.toString().trim().equals("")) {
                this.withKeyList_.add(String.valueOf(fieldID_) + " is NULL");
            } else {
                String basicType = XFUtility.getBasicTypeOf((String)workElement.getAttribute("Type"));
                if (XFUtility.isLiteralRequiredBasicType((String)basicType)) {
                    int length = Integer.parseInt(workElement.getAttribute("Size"));
                    this.withKeyList_.add(String.valueOf(fieldID_) + operand_ + this.getLiteraledStringValue(value.toString(), length));
                } else {
                    this.withKeyList_.add(String.valueOf(fieldID_) + operand_ + value);
                }
            }
        }
        this.tableOperatorToSelect = null;
    }

    private String getLiteraledStringValue(String value, int length) {
        StringBuffer bf = new StringBuffer();
        bf.append("'");
        if (value.length() > length) {
            bf.append(value.substring(0, length));
        } else {
            bf.append(value);
            int i = 0;
            while (i < length - value.length()) {
                bf.append(" ");
                ++i;
            }
        }
        bf.append("'");
        return bf.toString();
    }

    public void addKeyValue(String prefix, String fieldID, Object value, String postfix) {
        String fieldID_ = fieldID;
        String operand_ = " = ";
        if (fieldID.contains("!=")) {
            fieldID_ = fieldID.replace("!=", "");
            operand_ = " != ";
        } else if (fieldID.contains("<=")) {
            fieldID_ = fieldID.replace("<=", "");
            operand_ = " <= ";
        } else if (fieldID.contains(">=")) {
            fieldID_ = fieldID.replace(">=", "");
            operand_ = " >= ";
        } else {
            if (fieldID.contains("=")) {
                fieldID_ = fieldID.replace("=", "");
                operand_ = " = ";
            }
            if (fieldID.contains("<")) {
                fieldID_ = fieldID.replace("<", "");
                operand_ = " < ";
            }
            if (fieldID.contains(">")) {
                fieldID_ = fieldID.replace(">", "");
                operand_ = " > ";
            }
        }
        fieldID_ = fieldID_.trim();
        if (value.toString().trim().startsWith("'") && value.toString().trim().endsWith("'")) {
            this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + operand_ + value + " " + postfix);
        } else {
            Element workElement = this.session_.getFieldElement(this.tableID_, fieldID_);
            if (workElement == null) {
                this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + operand_ + value + " " + postfix);
            } else if (workElement.getAttribute("Type").contains("DATE") || workElement.getAttribute("Type").contains("TIME")) {
                if (value.toString().trim().equals("")) {
                    if (operand_.equals(" = ")) {
                        this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + " is NULL " + postfix);
                    }
                    if (operand_.equals(" != ")) {
                        this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + " is not NULL " + postfix);
                    }
                } else {
                    this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + operand_ + "'" + value + "' " + postfix);
                }
            } else {
                String basicType = XFUtility.getBasicTypeOf((String)workElement.getAttribute("Type"));
                this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + operand_ + XFUtility.getTableOperationValue((String)basicType, (Object)value, (String)this.dbName) + " " + postfix);
            }
        }
        this.tableOperatorToSelect = null;
    }

    public void addValue(String dataSourceID, Object value) {
        this.setValueOf(dataSourceID, value);
    }

    public void setValueOf(String dataSourceID, Object value) {
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).getDataSourceID().equals(dataSourceID)) {
                this.fieldList.get(i).setValue(value);
                break;
            }
            ++i;
        }
    }

    public Object getValueOf(String dataSourceID) {
        Object fieldValue = null;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).getDataSourceID().equals(dataSourceID)) {
                fieldValue = this.fieldList.get(i).getValue();
                break;
            }
            ++i;
        }
        return fieldValue;
    }

    public XFTableEvaluator_Field getFieldOf(String dataSourceID) {
        XFTableEvaluator_Field fieldObject = null;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).getDataSourceID().equals(dataSourceID)) {
                fieldObject = this.fieldList.get(i);
                break;
            }
            ++i;
        }
        return fieldObject;
    }

    public int getFieldCount() {
        return this.fieldList.size();
    }

    public XFScriptable getInstance() {
        return this.instance_;
    }

    public XFTableEvaluator_Field getFieldAt(int index) {
        XFTableEvaluator_Field fieldObject = null;
        if (index >= 0 && index < this.fieldList.size()) {
            fieldObject = this.fieldList.get(index);
        }
        return fieldObject;
    }

    public PrintStream getExceptionStream() {
        return this.instance_.getExceptionStream();
    }

    public void setErrorAndCloseFunction() {
        this.instance_.setErrorAndCloseFunction();
    }

    public ArrayList<XFTableEvaluator_Field> getFieldList() {
        return this.fieldList;
    }

    public ArrayList<String> getKeyFieldList() {
        return this.keyFieldList;
    }

    public ArrayList<XFTableEvaluator_ReferTable> getReferTableList() {
        return this.referTableList;
    }

    public int select() {
        int countOfRows = 0;
        try {
            this.tableOperatorToSelect = this.instance_.createTableOperator(this.getSQLToSelect());
            int i = 0;
            while (i < this.fieldList.size()) {
                this.fieldList.get(i).setValue(this.fieldList.get(i).getNullValue());
                ++i;
            }
            this.runScript("BR", "");
            countOfRows = this.tableOperatorToSelect.execute();
        }
        catch (ScriptException e) {
            this.instance_.cancelWithScriptException(e, this.scriptNameRunning);
        }
        catch (Exception e) {
            this.instance_.cancelWithException(e);
        }
        return countOfRows;
    }

    public boolean next() {
        boolean hasFound = false;
        try {
            if (this.tableOperatorToSelect == null) {
                this.select();
            }
            if (hasFound = this.tableOperatorToSelect.next()) {
                int i = 0;
                while (i < this.fieldList.size()) {
                    if (this.fieldList.get(i).isFieldOnPrimaryTable() && this.tableOperatorToSelect.hasValueOf(this.fieldList.get(i).getTableID(), this.fieldList.get(i).getFieldID())) {
                        this.fieldList.get(i).setValueOfResultSet(this.tableOperatorToSelect);
                    }
                    ++i;
                }
                if (!this.updateCounterID.equals("")) {
                    String wrkStr = this.tableOperatorToSelect.getValueOf(this.updateCounterID).toString();
                    this.updateCounterValue = Integer.parseInt(wrkStr);
                }
                this.runScript("AR", "BR()");
                i = 0;
                while (i < this.referTableList.size()) {
                    XFTableOperator referTableOperator;
                    this.runScript("AR", "BR(" + this.referTableList.get(i).getTableAlias() + ")");
                    String sql = this.referTableList.get(i).getSelectSQL();
                    if (!sql.equals("") && (referTableOperator = this.instance_.createTableOperator(sql)).next()) {
                        int j = 0;
                        while (j < this.fieldList.size()) {
                            if (this.fieldList.get(j).getTableID().equals(this.referTableList.get(i).getTableID()) && this.fieldList.get(j).getTableAlias().equals(this.referTableList.get(i).getTableAlias()) && referTableOperator.hasValueOf(this.fieldList.get(j).getTableID(), this.fieldList.get(j).getFieldID())) {
                                this.fieldList.get(j).setValueOfResultSet(referTableOperator);
                            }
                            ++j;
                        }
                        this.runScript("AR", "AR(" + this.referTableList.get(i).getTableAlias() + ")");
                    }
                    ++i;
                }
                this.runScript("AR", "AR()");
                i = 0;
                while (i < this.fieldList.size()) {
                    if (this.fieldList.get(i).isFieldOnPrimaryTable()) {
                        this.fieldList.get(i).setOldValue(this.fieldList.get(i).getValue());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.instance_.cancelWithException(e);
        }
        return hasFound;
    }

    public int insert() {
        return this.insert(false);
    }

    public int insert(boolean isCheckOnly) {
        int countOfProcessed;
        block18: {
            countOfProcessed = 0;
            int countOfErrors = 0;
            try {
                int i = 0;
                while (i < this.fieldList.size()) {
                    this.fieldList.get(i).setError(false);
                    ++i;
                }
                this.runScript("BC", "BR()");
                i = 0;
                while (i < this.referTableList.size()) {
                    if (!this.referTableList.get(i).isKeyNullable() || !this.referTableList.get(i).isKeyNull()) {
                        this.runScript("BC", "BR(" + this.referTableList.get(i).getTableAlias() + ")");
                        this.tableOperator = this.instance_.createTableOperator(this.referTableList.get(i).getSelectSQL());
                        if (this.tableOperator.next()) {
                            int j = 0;
                            while (j < this.fieldList.size()) {
                                if (this.fieldList.get(j).getTableID().equals(this.referTableList.get(i).getTableID()) && this.fieldList.get(j).getTableAlias().equals(this.referTableList.get(i).getTableAlias())) {
                                    this.fieldList.get(j).setValueOfResultSet(this.tableOperator);
                                }
                                ++j;
                            }
                        } else if (!this.referTableList.get(i).isOptional()) {
                            this.referTableList.get(i).setErrorOnRelatedFields();
                        }
                        this.runScript("BC", "AR(" + this.referTableList.get(i).getTableAlias() + ")");
                    }
                    ++i;
                }
                this.runScript("BC", "AR()");
                i = 0;
                while (i < this.fieldList.size()) {
                    if (this.fieldList.get(i).isError()) {
                        ++countOfErrors;
                    }
                    ++i;
                }
                if (countOfErrors != 0 || !this.hasNoErrorWithKey("INSERT") || isCheckOnly) break block18;
                i = 0;
                while (i < this.fieldList.size()) {
                    if (this.fieldList.get(i).isAutoNumberField()) {
                        this.fieldList.get(i).setValue(this.fieldList.get(i).getAutoNumber());
                    }
                    if (this.fieldList.get(i).isAutoDetailRowNumber()) {
                        int lastNumber = 0;
                        this.tableOperator = this.instance_.createTableOperator(this.getSQLToGetLastDetailRowNumberValue());
                        if (this.tableOperator.next()) {
                            lastNumber = Integer.parseInt(this.tableOperator.getValueOf(this.detailRowNoID).toString());
                        }
                        this.fieldList.get(i).setValue(lastNumber + 1);
                    }
                    ++i;
                }
                this.tableOperator = this.instance_.createTableOperator(this.getSQLToInsert());
                countOfProcessed = this.tableOperator.execute();
                if (countOfProcessed == 1) {
                    this.runScript("AC", "");
                    break block18;
                }
                throw new Exception("Failed in inserting");
            }
            catch (ScriptException e) {
                this.instance_.cancelWithScriptException(e, this.scriptNameRunning);
            }
            catch (Exception e) {
                this.instance_.cancelWithException(e);
            }
        }
        return countOfProcessed;
    }

    public int update() {
        return this.update(false);
    }

    public int update(boolean isCheckOnly) {
        int countOfProcessed;
        block15: {
            countOfProcessed = 0;
            try {
                int i = 0;
                while (i < this.fieldList.size()) {
                    this.fieldList.get(i).setError(false);
                    ++i;
                }
                this.runScript("BU", "BR()");
                i = 0;
                while (i < this.referTableList.size()) {
                    if (!this.referTableList.get(i).isKeyNullable() || !this.referTableList.get(i).isKeyNull()) {
                        this.runScript("BU", "BR(" + this.referTableList.get(i).getTableAlias() + ")");
                        this.tableOperator = this.instance_.createTableOperator(this.referTableList.get(i).getSelectSQL());
                        if (this.tableOperator.next()) {
                            int j = 0;
                            while (j < this.fieldList.size()) {
                                if (this.fieldList.get(j).getTableID().equals(this.referTableList.get(i).getTableID()) && this.fieldList.get(j).getTableAlias().equals(this.referTableList.get(i).getTableAlias())) {
                                    this.fieldList.get(j).setValueOfResultSet(this.tableOperator);
                                }
                                ++j;
                            }
                        } else if (!this.referTableList.get(i).isOptional()) {
                            this.referTableList.get(i).setErrorOnRelatedFields();
                        }
                        this.runScript("BU", "AR(" + this.referTableList.get(i).getTableAlias() + ")");
                    }
                    ++i;
                }
                this.runScript("BU", "AR()");
                int countOfErrors = 0;
                int i2 = 0;
                while (i2 < this.fieldList.size()) {
                    if (this.fieldList.get(i2).isFieldOnPrimaryTable()) {
                        this.fieldList.get(i2).checkError();
                        if (this.fieldList.get(i2).isError()) {
                            ++countOfErrors;
                        }
                    }
                    ++i2;
                }
                if (countOfErrors != 0 || !this.hasNoErrorWithKey("UPDATE") || isCheckOnly) break block15;
                this.tableOperator = this.instance_.createTableOperator(this.getSQLToUpdate());
                countOfProcessed = this.tableOperator.execute();
                if (countOfProcessed == 1) {
                    this.runScript("AU", "");
                    break block15;
                }
                throw new Exception("Failed in updating");
            }
            catch (ScriptException e) {
                this.instance_.cancelWithScriptException(e, this.scriptNameRunning);
            }
            catch (Exception e) {
                this.instance_.cancelWithException(e);
            }
        }
        return countOfProcessed;
    }

    public int delete() {
        return this.delete(false);
    }

    public int delete(boolean isCheckOnly) {
        int countOfProcessed;
        block14: {
            countOfProcessed = 0;
            int countOfErrors = 0;
            try {
                int i = 0;
                while (i < this.fieldList.size()) {
                    this.fieldList.get(i).setError(false);
                    ++i;
                }
                this.runScript("BD", "BR()");
                i = 0;
                while (i < this.referTableList.size()) {
                    if (!this.referTableList.get(i).isKeyNullable() || !this.referTableList.get(i).isKeyNull()) {
                        this.runScript("BD", "BR(" + this.referTableList.get(i).getTableAlias() + ")");
                        this.tableOperator = this.instance_.createTableOperator(this.referTableList.get(i).getSelectSQL());
                        if (this.tableOperator.next()) {
                            int j = 0;
                            while (j < this.fieldList.size()) {
                                if (this.fieldList.get(j).getTableID().equals(this.referTableList.get(i).getTableID()) && this.fieldList.get(j).getTableAlias().equals(this.referTableList.get(i).getTableAlias())) {
                                    this.fieldList.get(j).setValueOfResultSet(this.tableOperator);
                                }
                                ++j;
                            }
                        } else if (!this.referTableList.get(i).isOptional()) {
                            this.referTableList.get(i).setErrorOnRelatedFields();
                        }
                        this.runScript("BD", "AR(" + this.referTableList.get(i).getTableAlias() + ")");
                    }
                    ++i;
                }
                this.runScript("BD", "AR()");
                i = 0;
                while (i < this.fieldList.size()) {
                    if (this.fieldList.get(i).isError()) {
                        ++countOfErrors;
                    }
                    ++i;
                }
                if (countOfErrors != 0 || isCheckOnly) break block14;
                this.tableOperator = this.instance_.createTableOperator(this.getSQLToDelete());
                countOfProcessed = this.tableOperator.execute();
                if (countOfProcessed == 1) {
                    this.runScript("AD", "");
                    break block14;
                }
                throw new Exception("Failed in deleting");
            }
            catch (ScriptException e) {
                this.instance_.cancelWithScriptException(e, this.scriptNameRunning);
            }
            catch (Exception e) {
                this.instance_.cancelWithException(e);
            }
        }
        return countOfProcessed;
    }

    private boolean hasNoErrorWithKey(String operation) {
        boolean hasNoError = true;
        ArrayList<String> keyFieldList = new ArrayList<String>();
        String sql = "";
        try {
            int i;
            if (operation.equals("INSERT")) {
                boolean hasAutoNumberKey = false;
                i = 0;
                while (i < this.fieldList.size()) {
                    if (this.fieldList.get(i).isAutoNumberField()) {
                        hasAutoNumberKey = true;
                        break;
                    }
                    if (this.fieldList.get(i).isAutoDetailRowNumber()) {
                        hasAutoNumberKey = true;
                        break;
                    }
                    ++i;
                }
                if (!hasAutoNumberKey) {
                    this.tableOperator = this.instance_.createTableOperator(this.getSQLToCheckPKDuplication());
                    if (this.tableOperator.next()) {
                        hasNoError = false;
                        i = 0;
                        while (i < this.fieldList.size()) {
                            if (this.fieldList.get(i).isKey()) {
                                this.fieldList.get(i).setError(XFUtility.RESOURCE.getString("FunctionError31"));
                            }
                            ++i;
                        }
                    }
                }
            }
            if (operation.equals("UPDATE")) {
                int i2 = 0;
                while (i2 < this.fieldList.size()) {
                    if (this.fieldList.get(i2).isKey()) {
                        if (!this.fieldList.get(i2).isError() && this.fieldList.get(i2).isValueChanged()) {
                            this.fieldList.get(i2).setError(XFUtility.RESOURCE.getString("FunctionError32"));
                            break;
                        }
                        if (!this.fieldList.get(i2).isError() && this.fieldList.get(i2).isNull()) {
                            this.fieldList.get(i2).setError(XFUtility.RESOURCE.getString("FunctionError54"));
                            break;
                        }
                    }
                    ++i2;
                }
            }
            if (hasNoError) {
                i = 0;
                while (i < this.uniqueKeyList.size()) {
                    keyFieldList.clear();
                    StringTokenizer workTokenizer = new StringTokenizer(this.uniqueKeyList.get(i), ";");
                    while (workTokenizer.hasMoreTokens()) {
                        keyFieldList.add(workTokenizer.nextToken());
                    }
                    sql = operation.equals("UPDATE") ? this.getSQLToCheckSKDuplication(keyFieldList, true) : this.getSQLToCheckSKDuplication(keyFieldList, false);
                    if (!sql.equals("")) {
                        this.tableOperator = this.instance_.createTableOperator(sql);
                        if (this.tableOperator.next()) {
                            hasNoError = false;
                            int j = 0;
                            while (j < this.fieldList.size()) {
                                if (keyFieldList.contains(this.fieldList.get(j).getFieldID())) {
                                    this.fieldList.get(j).setError(XFUtility.RESOURCE.getString("FunctionError22"));
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.instance_.cancelWithException(e);
        }
        return hasNoError;
    }

    public String getSQLToSelect() {
        StringBuffer buf = new StringBuffer();
        buf.append("select ");
        boolean firstField = true;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).isFieldOnPrimaryTable() && !this.fieldList.get(i).isVirtualField()) {
                if (!firstField) {
                    buf.append(",");
                }
                buf.append(this.fieldList.get(i).getFieldID());
                firstField = false;
            }
            ++i;
        }
        if (!this.updateCounterID.equals("")) {
            buf.append(",");
            buf.append(this.updateCounterID);
        }
        buf.append(" from ");
        buf.append(this.moduleID);
        int countOfWhereKey = 0;
        int i2 = 0;
        while (i2 < this.withKeyList_.size()) {
            if (countOfWhereKey == 0) {
                buf.append(" where ");
            }
            buf.append(this.withKeyList_.get(i2));
            ++countOfWhereKey;
            ++i2;
        }
        if (!this.activeWhere.equals("")) {
            if (countOfWhereKey == 0) {
                buf.append(" where (");
            } else {
                buf.append(" and (");
            }
            buf.append(this.activeWhere);
            buf.append(") ");
            ++countOfWhereKey;
        }
        if (!this.fixedWhere.equals("")) {
            if (countOfWhereKey == 0) {
                buf.append(" where (");
            } else {
                buf.append(" and (");
            }
            buf.append(this.fixedWhere);
            buf.append(") ");
            ++countOfWhereKey;
        }
        if (!this.orderBy.equals("")) {
            buf.append(" order by ");
            buf.append(this.orderBy);
        }
        return buf.toString();
    }

    public String getSQLToGetLastDetailRowNumberValue() {
        StringBuffer buf = new StringBuffer();
        if (!this.detailRowNoID.equals("")) {
            buf.append("select ");
            buf.append(this.detailRowNoID);
            buf.append(" from ");
            buf.append(this.moduleID);
            buf.append(" where ");
            int orderOfFieldInKey = 0;
            int i = 0;
            while (i < this.fieldList.size()) {
                if (this.fieldList.get(i).isKey() && !this.fieldList.get(i).getFieldID().equals(this.detailRowNoID)) {
                    if (orderOfFieldInKey > 0) {
                        buf.append(" and ");
                    }
                    buf.append(this.fieldList.get(i).getFieldID());
                    buf.append("=");
                    buf.append(XFUtility.getTableOperationValue((String)this.fieldList.get(i).getBasicType(), (Object)this.fieldList.get(i).getValue(), (String)this.dbName));
                    ++orderOfFieldInKey;
                }
                ++i;
            }
            if (!this.activeWhere.equals("")) {
                buf.append(" and ");
                buf.append(this.activeWhere);
            }
            buf.append(" order by ");
            buf.append(this.detailRowNoID);
            buf.append(" desc");
        }
        return buf.toString();
    }

    String getSQLToInsert() {
        StringBuffer statementBuf = new StringBuffer();
        statementBuf.append("insert into ");
        statementBuf.append(this.moduleID);
        statementBuf.append(" (");
        boolean firstField = true;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).isFieldOnPrimaryTable() && !this.fieldList.get(i).isVirtualField()) {
                if (!firstField) {
                    statementBuf.append(", ");
                }
                statementBuf.append(this.fieldList.get(i).getFieldID());
                firstField = false;
            }
            ++i;
        }
        statementBuf.append(") values(");
        firstField = true;
        i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).isFieldOnPrimaryTable() && !this.fieldList.get(i).isVirtualField()) {
                if (!firstField) {
                    statementBuf.append(", ");
                }
                statementBuf.append(XFUtility.getTableOperationValue((String)this.fieldList.get(i).getBasicType(), (Object)this.fieldList.get(i).getValue(), (String)this.dbName));
                firstField = false;
            }
            ++i;
        }
        statementBuf.append(")");
        return statementBuf.toString();
    }

    String getSQLToCheckPKDuplication() {
        StringBuffer statementBuf = new StringBuffer();
        statementBuf.append("select ");
        boolean firstField = true;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).isFieldOnPrimaryTable() && !this.fieldList.get(i).isVirtualField()) {
                if (!firstField) {
                    statementBuf.append(",");
                }
                statementBuf.append(this.fieldList.get(i).getFieldID());
                firstField = false;
            }
            ++i;
        }
        statementBuf.append(" from ");
        statementBuf.append(this.moduleID);
        statementBuf.append(" where ");
        firstField = true;
        i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).isKey()) {
                if (!firstField) {
                    statementBuf.append(" and ");
                }
                statementBuf.append(this.fieldList.get(i).getFieldID());
                statementBuf.append("=");
                statementBuf.append(XFUtility.getTableOperationValue((String)this.fieldList.get(i).getBasicType(), (Object)this.fieldList.get(i).getValue(), (String)this.dbName));
                firstField = false;
            }
            ++i;
        }
        return statementBuf.toString();
    }

    public ArrayList<String> getUniqueKeyList() {
        return this.uniqueKeyList;
    }

    public String getSQLToCheckSKDuplication(ArrayList<String> keyFieldList, boolean isToUpdate) {
        StringBuffer statementBuf = new StringBuffer();
        statementBuf.append("select ");
        boolean firstField = true;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).isFieldOnPrimaryTable() && !this.fieldList.get(i).isVirtualField()) {
                if (!firstField) {
                    statementBuf.append(",");
                }
                statementBuf.append(this.fieldList.get(i).getFieldID());
                firstField = false;
            }
            ++i;
        }
        statementBuf.append(" from ");
        statementBuf.append(this.moduleID);
        statementBuf.append(" where ");
        firstField = true;
        int j = 0;
        while (j < this.fieldList.size()) {
            if (this.fieldList.get(j).isFieldOnPrimaryTable()) {
                int p = 0;
                while (p < keyFieldList.size()) {
                    if (this.fieldList.get(j).getFieldID().equals(keyFieldList.get(p))) {
                        if (!isToUpdate && this.fieldList.get(j).isAutoNumberField()) {
                            return "";
                        }
                        if (!firstField) {
                            statementBuf.append(" and ");
                        }
                        statementBuf.append(this.fieldList.get(j).getFieldID());
                        statementBuf.append("=");
                        statementBuf.append(XFUtility.getTableOperationValue((String)this.fieldList.get(j).getBasicType(), (Object)this.fieldList.get(j).getValue(), (String)this.dbName));
                        firstField = false;
                    }
                    ++p;
                }
            }
            ++j;
        }
        if (isToUpdate) {
            firstField = true;
            j = 0;
            while (j < this.fieldList.size()) {
                if (this.fieldList.get(j).isFieldOnPrimaryTable() && this.fieldList.get(j).isKey()) {
                    if (firstField) {
                        statementBuf.append(" and (");
                    } else {
                        statementBuf.append(" or ");
                    }
                    statementBuf.append(this.fieldList.get(j).getFieldID());
                    statementBuf.append("!=");
                    statementBuf.append(XFUtility.getTableOperationValue((String)this.fieldList.get(j).getBasicType(), (Object)this.fieldList.get(j).getValue(), (String)this.dbName));
                    firstField = false;
                }
                ++j;
            }
            statementBuf.append(")");
        }
        return statementBuf.toString();
    }

    String getSQLToUpdate() {
        StringBuffer statementBuf = new StringBuffer();
        statementBuf.append("update ");
        statementBuf.append(this.moduleID);
        statementBuf.append(" set ");
        boolean firstField = true;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).isFieldOnPrimaryTable() && !this.fieldList.get(i).isKey() && !this.fieldList.get(i).isVirtualField()) {
                if (!firstField) {
                    statementBuf.append(", ");
                }
                statementBuf.append(this.fieldList.get(i).getFieldID());
                statementBuf.append("=");
                statementBuf.append(XFUtility.getTableOperationValue((String)this.fieldList.get(i).getBasicType(), (Object)this.fieldList.get(i).getValue(), (String)this.dbName));
                firstField = false;
            }
            ++i;
        }
        if (!this.updateCounterID.equals("")) {
            statementBuf.append(", ");
            statementBuf.append(this.updateCounterID);
            statementBuf.append("=");
            statementBuf.append(this.updateCounterValue + 1);
        }
        statementBuf.append(" where ");
        firstField = true;
        i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).isFieldOnPrimaryTable() && this.fieldList.get(i).isKey()) {
                if (!firstField) {
                    statementBuf.append(" and ");
                }
                statementBuf.append(this.fieldList.get(i).getFieldID());
                statementBuf.append("=");
                statementBuf.append(XFUtility.getTableOperationValue((String)this.fieldList.get(i).getBasicType(), (Object)this.fieldList.get(i).getValue(), (String)this.dbName));
                firstField = false;
            }
            ++i;
        }
        if (!this.updateCounterID.equals("")) {
            statementBuf.append(" and ");
            statementBuf.append(this.updateCounterID);
            statementBuf.append("=");
            statementBuf.append(this.updateCounterValue);
        }
        return statementBuf.toString();
    }

    String getSQLToDelete() {
        StringBuffer statementBuf = new StringBuffer();
        if (this.updateValueToInactivate.equals("")) {
            statementBuf.append("delete from ");
            statementBuf.append(this.moduleID);
        } else {
            statementBuf.append("update ");
            statementBuf.append(this.moduleID);
            statementBuf.append(" set ");
            statementBuf.append(this.updateValueToInactivate);
            if (!this.updateCounterID.equals("")) {
                statementBuf.append(", ");
                statementBuf.append(this.updateCounterID);
                statementBuf.append("=");
                statementBuf.append(this.updateCounterValue + 1);
            }
        }
        statementBuf.append(" where ");
        boolean firstField = true;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).isFieldOnPrimaryTable() && this.fieldList.get(i).isKey()) {
                if (!firstField) {
                    statementBuf.append(" and ");
                }
                statementBuf.append(this.fieldList.get(i).getFieldID());
                statementBuf.append("=");
                statementBuf.append(XFUtility.getTableOperationValue((String)this.fieldList.get(i).getBasicType(), (Object)this.fieldList.get(i).getValue(), (String)this.dbName));
                firstField = false;
            }
            ++i;
        }
        if (!this.updateCounterID.equals("")) {
            statementBuf.append(" and ");
            statementBuf.append(this.updateCounterID);
            statementBuf.append("=");
            statementBuf.append(this.updateCounterValue);
        }
        return statementBuf.toString();
    }

    public void runScript(String event1, String event2) throws ScriptException {
        ArrayList<XFScript> validScriptList = new ArrayList<XFScript>();
        int i = 0;
        while (i < this.scriptList.size()) {
            XFScript script = this.scriptList.get(i);
            if (script.isToBeRunAtEvent(event1, event2)) {
                validScriptList.add(script);
            }
            ++i;
        }
        if (validScriptList.size() > 0) {
            i = 0;
            while (i < validScriptList.size()) {
                this.evalScript(((XFScript)validScriptList.get(i)).getName(), ((XFScript)validScriptList.get(i)).getScriptText());
                ++i;
            }
        }
    }

    class XFScript {
        private ArrayList<String> fieldList = new ArrayList();
        private String tableID = "";
        private String scriptName = "";
        private String scriptText = "";
        private String eventP = "";
        private String eventR = "";
        private boolean isSuspended = false;

        public XFScript(String tableID, Element scriptElement, NodeList tableNodeList) {
            this.tableID = tableID;
            this.eventP = scriptElement.getAttribute("EventP");
            this.eventR = scriptElement.getAttribute("EventR");
            this.scriptName = scriptElement.getAttribute("Name");
            this.scriptText = XFUtility.substringLinesWithTokenOfEOL((String)scriptElement.getAttribute("Text"), (String)"\n");
            this.fieldList = XFUtility.getDSNameListInScriptText((String)XFUtility.removeCommentsFromScriptText((String)this.scriptText), (NodeList)tableNodeList);
            if (scriptElement.getAttribute("Hold").equals("T")) {
                this.isSuspended = true;
            }
        }

        public String getScriptText() {
            return this.scriptText;
        }

        public boolean isToBeRunAtEvent(String event1, String event2) {
            boolean result = false;
            if (!this.isSuspended) {
                ArrayList<String> event1List = new ArrayList<String>();
                StringTokenizer workTokenizer = new StringTokenizer(event1, ",");
                while (workTokenizer.hasMoreTokens()) {
                    event1List.add(workTokenizer.nextToken());
                }
                int i = 0;
                while (i < event1List.size()) {
                    if (this.eventP.contains((CharSequence)event1List.get(i))) {
                        if (event2.equals("")) {
                            result = true;
                            break;
                        }
                        if (event2.equals(this.eventR)) {
                            result = true;
                            break;
                        }
                    }
                    ++i;
                }
            }
            return result;
        }

        public ArrayList<String> getFieldList() {
            return this.fieldList;
        }

        public String getName() {
            return String.valueOf(this.tableID) + " " + this.scriptName;
        }
    }
}

