/*
 * Decompiled with CFR 0.152.
 */
package xeadServer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Element;
import xeadDriver.XFUtility;
import xeadServer.Relation;
import xeadServer.Session;

public class XFTableOperator {
    private Session session_ = null;
    private Relation relation_ = null;
    private String operation_ = "";
    private String tableID_ = "";
    private String moduleID = "";
    private String dbID = "";
    private String dbName = "";
    private String selectFields_ = "";
    private String orderBy_ = "";
    private String additionalWhere_ = "";
    private String sqlText_ = "";
    private ArrayList<String> fieldIDList_ = new ArrayList();
    private ArrayList<Object> fieldValueList_ = new ArrayList();
    private ArrayList<String> withKeyList_ = new ArrayList();
    private StringBuffer logBuf_ = null;
    private boolean hasFoundRecord_ = false;
    private boolean isAutoCommit_ = false;

    public XFTableOperator(Session session, StringBuffer logBuf, String operation, String tableID) throws Exception {
        this(session, logBuf, operation, tableID, false);
    }

    public XFTableOperator(Session session, StringBuffer logBuf, String operation, String tableID, boolean isAutoCommit) throws Exception {
        this.session_ = session;
        this.logBuf_ = logBuf;
        this.operation_ = operation;
        this.tableID_ = tableID;
        this.isAutoCommit_ = isAutoCommit;
        Element tableElement = this.session_.getTableElement(this.tableID_);
        if (tableElement == null) {
            throw new Exception("'" + this.tableID_ + "' is invalid to get Table-Operator.");
        }
        this.moduleID = tableElement.getAttribute("ModuleID");
        if (this.moduleID.equals("")) {
            this.moduleID = this.tableID_;
        }
        this.dbID = tableElement.getAttribute("DB");
        this.dbName = this.dbID.equals("") ? this.session_.getDatabaseName() : this.session_.getSubDBName(this.dbID);
    }

    public XFTableOperator(Session session, StringBuffer logBuf, String sqlText) throws Exception {
        this(session, logBuf, sqlText, false);
    }

    public XFTableOperator(Session session, StringBuffer logBuf, String sqlText, boolean isAutoCommit) throws Exception {
        int pos2;
        int pos1;
        this.session_ = session;
        this.logBuf_ = logBuf;
        this.sqlText_ = sqlText;
        if (this.sqlText_.toUpperCase().startsWith("SELECT ")) {
            this.operation_ = this.sqlText_.toUpperCase().startsWith("SELECT COUNT(*)") ? "COUNT" : "SELECT";
            pos1 = this.sqlText_.toUpperCase().indexOf(" FROM ") + 6;
            pos2 = this.sqlText_.indexOf(" ", pos1);
            if (pos2 < 0) {
                pos2 = this.sqlText_.length();
            }
            this.tableID_ = this.sqlText_.substring(pos1, pos2);
            if (this.tableID_.startsWith("(")) {
                pos1 = this.sqlText_.toUpperCase().indexOf(" FROM ", pos1 + 1) + 6;
                pos2 = this.sqlText_.indexOf(" ", pos1);
                if (pos2 < 0) {
                    pos2 = this.sqlText_.length();
                }
                this.tableID_ = this.sqlText_.toUpperCase().substring(pos1, pos2);
            }
        }
        if (this.sqlText_.toUpperCase().startsWith("INSERT ")) {
            this.operation_ = "INSERT";
            pos1 = this.sqlText_.toUpperCase().indexOf("INSERT INTO ") + 12;
            pos2 = this.sqlText_.indexOf(" ", pos1);
            if (pos2 < 0) {
                pos2 = this.sqlText_.length();
            }
            this.tableID_ = this.sqlText_.toUpperCase().substring(pos1, pos2);
        }
        if (this.sqlText_.toUpperCase().startsWith("UPDATE ")) {
            this.operation_ = "UPDATE";
            pos1 = this.sqlText_.toUpperCase().indexOf("UPDATE ") + 7;
            pos2 = this.sqlText_.indexOf(" ", pos1);
            if (pos2 < 0) {
                pos2 = this.sqlText_.length();
            }
            this.tableID_ = this.sqlText_.toUpperCase().substring(pos1, pos2);
        }
        if (this.sqlText_.toUpperCase().startsWith("DELETE ")) {
            this.operation_ = "DELETE";
            pos1 = this.sqlText_.toUpperCase().indexOf("DELETE FROM ") + 12;
            pos2 = this.sqlText_.indexOf(" ", pos1);
            if (pos2 < 0) {
                pos2 = this.sqlText_.length();
            }
            this.tableID_ = this.sqlText_.toUpperCase().substring(pos1, pos2);
        }
        this.isAutoCommit_ = isAutoCommit;
        Element tableElement = this.session_.getTableElement(this.tableID_);
        if (tableElement == null) {
            throw new Exception("'" + this.tableID_ + "' is invalid to get Table-Operator.");
        }
        this.moduleID = tableElement.getAttribute("ModuleID");
        if (this.moduleID.equals("")) {
            this.moduleID = this.tableID_;
        }
        this.dbID = tableElement.getAttribute("DB");
        this.dbName = this.dbID.equals("") ? this.session_.getDatabaseName() : this.session_.getSubDBName(this.dbID);
        if (this.dbName.contains("jdbc:mysql:")) {
            this.sqlText_ = this.sqlText_.replaceAll("\\\\", "\\\\\\\\");
        }
    }

    public void setSelectFields(String fields) {
        this.sqlText_ = "";
        this.selectFields_ = fields;
    }

    public void setDistinctFields(String fields) {
        this.sqlText_ = "";
        this.selectFields_ = "distinct " + fields;
    }

    public void setValueOf(String fieldID, Object value) {
        this.addValue(fieldID, value);
    }

    public void addValue(String fieldID, Object value) {
        this.sqlText_ = "";
        int index = this.fieldIDList_.indexOf(fieldID);
        if (index > -1) {
            this.fieldIDList_.remove(index);
            this.fieldValueList_.remove(index);
        }
        this.fieldIDList_.add(fieldID);
        if (value.toString().trim().startsWith("'") && value.toString().trim().endsWith("'")) {
            if (value.toString().contains("''")) {
                this.fieldValueList_.add(value.toString());
            } else {
                String strValue = value.toString().substring(1, value.toString().length());
                strValue = strValue.substring(0, strValue.length() - 1);
                strValue = strValue.replaceAll("'", "''");
                this.fieldValueList_.add("'" + strValue + "'");
            }
        } else {
            Element workElement = this.session_.getFieldElement(this.tableID_, fieldID);
            if (workElement == null) {
                this.fieldValueList_.add(value);
            } else if ((workElement.getAttribute("Type").contains("DATE") || workElement.getAttribute("Type").contains("TIME")) && value.toString().trim().equals("")) {
                this.fieldValueList_.add("NULL");
            } else {
                String basicType = XFUtility.getBasicTypeOf((String)workElement.getAttribute("Type"));
                if (basicType.equals("DATETIME") && value.equals("CURRENT_TIMESTAMP")) {
                    this.fieldValueList_.add(value);
                } else {
                    this.fieldValueList_.add(XFUtility.getTableOperationValue((String)basicType, (Object)value, (String)this.dbName));
                }
            }
        }
    }

    public void addKeyValue(String fieldID, Object value) {
        this.sqlText_ = "";
        String fieldID_ = fieldID;
        String operand_ = " = ";
        if (fieldID.contains("<>")) {
            fieldID_ = fieldID.replace("<>", "");
            operand_ = " <> ";
        } else if (fieldID.contains("!=")) {
            fieldID_ = fieldID.replace("!=", "");
            operand_ = " != ";
        } else if (fieldID.contains("<=")) {
            fieldID_ = fieldID.replace("<=", "");
            operand_ = " <= ";
        } else if (fieldID.contains(">=")) {
            fieldID_ = fieldID.replace(">=", "");
            operand_ = " >= ";
        } else {
            if (fieldID.contains("=")) {
                fieldID_ = fieldID.replace("=", "");
                operand_ = " = ";
            }
            if (fieldID.contains("<")) {
                fieldID_ = fieldID.replace("<", "");
                operand_ = " < ";
            }
            if (fieldID.contains(">")) {
                fieldID_ = fieldID.replace(">", "");
                operand_ = " > ";
            }
            if (fieldID.contains(" LIKE")) {
                fieldID_ = fieldID.replace(" LIKE", "");
                operand_ = " LIKE ";
            }
        }
        fieldID_ = fieldID_.trim();
        if (this.withKeyList_.size() > 0) {
            this.withKeyList_.add(" and ");
        }
        if (value.toString().trim().startsWith("'") && value.toString().trim().endsWith("'")) {
            this.withKeyList_.add(String.valueOf(fieldID_) + operand_ + value);
        } else {
            Element workElement = this.session_.getFieldElement(this.tableID_, fieldID_);
            if (workElement == null) {
                this.withKeyList_.add(String.valueOf(fieldID_) + operand_ + value);
            } else if (workElement.getAttribute("Type").contains("DATE") || workElement.getAttribute("Type").contains("TIME")) {
                if (value.toString().trim().equals("")) {
                    if (operand_.equals(" = ")) {
                        this.withKeyList_.add(String.valueOf(fieldID_) + " is null ");
                    }
                    if (operand_.equals(" != ")) {
                        this.withKeyList_.add(String.valueOf(fieldID_) + " is not null ");
                    }
                } else {
                    this.withKeyList_.add(String.valueOf(fieldID_) + operand_ + "'" + value + "' ");
                }
            } else if (operand_.equals(" LIKE ")) {
                this.withKeyList_.add(String.valueOf(fieldID_) + operand_ + "'" + value + "'");
            } else {
                String basicType = XFUtility.getBasicTypeOf((String)workElement.getAttribute("Type"));
                if (XFUtility.isLiteralRequiredBasicType((String)basicType)) {
                    int length = Integer.parseInt(workElement.getAttribute("Size"));
                    if (workElement.getAttribute("Type").contains("VARCHAR")) {
                        length = value.toString().length();
                    }
                    this.withKeyList_.add(String.valueOf(fieldID_) + operand_ + this.getLiteraledStringValue(value.toString(), length));
                } else {
                    this.withKeyList_.add(String.valueOf(fieldID_) + operand_ + value);
                }
            }
        }
    }

    private String getLiteraledStringValue(String value, int length) {
        StringBuffer bf = new StringBuffer();
        bf.append("'");
        if (value.length() > length) {
            bf.append(value.substring(0, length));
        } else {
            bf.append(value);
            int i = 0;
            while (i < length - value.length()) {
                bf.append(" ");
                ++i;
            }
        }
        bf.append("'");
        return bf.toString();
    }

    public void addKeyValue(String prefix, String fieldID, Object value, String postfix) {
        this.sqlText_ = "";
        String fieldID_ = fieldID;
        String operand_ = " = ";
        if (fieldID.contains("<>")) {
            fieldID_ = fieldID.replace("<>", "");
            operand_ = " <> ";
        } else if (fieldID.contains("!=")) {
            fieldID_ = fieldID.replace("!=", "");
            operand_ = " != ";
        } else if (fieldID.contains("<=")) {
            fieldID_ = fieldID.replace("<=", "");
            operand_ = " <= ";
        } else if (fieldID.contains(">=")) {
            fieldID_ = fieldID.replace(">=", "");
            operand_ = " >= ";
        } else {
            if (fieldID.contains("=")) {
                fieldID_ = fieldID.replace("=", "");
                operand_ = " = ";
            }
            if (fieldID.contains("<")) {
                fieldID_ = fieldID.replace("<", "");
                operand_ = " < ";
            }
            if (fieldID.contains(">")) {
                fieldID_ = fieldID.replace(">", "");
                operand_ = " > ";
            }
            if (fieldID.contains(" LIKE")) {
                fieldID_ = fieldID.replace(" LIKE", "");
                operand_ = " LIKE ";
            }
        }
        fieldID_ = fieldID_.trim();
        if (value.toString().trim().startsWith("'") && value.toString().trim().endsWith("'")) {
            this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + operand_ + value + " " + postfix);
        } else {
            Element workElement = this.session_.getFieldElement(this.tableID_, fieldID_);
            if (workElement == null) {
                this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + operand_ + value + " " + postfix);
            } else if (workElement.getAttribute("Type").contains("DATE") || workElement.getAttribute("Type").contains("TIME")) {
                if (value.toString().trim().equals("")) {
                    if (operand_.equals(" = ")) {
                        this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + " is null " + postfix);
                    }
                    if (operand_.equals(" != ")) {
                        this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + " is not null " + postfix);
                    }
                } else {
                    this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + operand_ + "'" + value + "' " + postfix);
                }
            } else if (operand_.equals(" LIKE ")) {
                this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + operand_ + "'" + value + "' " + postfix);
            } else {
                String basicType = XFUtility.getBasicTypeOf((String)workElement.getAttribute("Type"));
                if (XFUtility.isLiteralRequiredBasicType((String)basicType)) {
                    int length = Integer.parseInt(workElement.getAttribute("Size"));
                    if (workElement.getAttribute("Type").contains("VARCHAR")) {
                        length = value.toString().length();
                    }
                    this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + operand_ + this.getLiteraledStringValue(value.toString(), length) + " " + postfix);
                } else {
                    this.withKeyList_.add(String.valueOf(prefix) + " " + fieldID_ + operand_ + XFUtility.getTableOperationValue((String)basicType, (Object)value, (String)this.dbName) + " " + postfix);
                }
            }
        }
    }

    public void setOrderBy(String text) {
        this.sqlText_ = "";
        this.orderBy_ = text;
    }

    public void addWhere(String text) {
        this.additionalWhere_ = text;
    }

    public void setSqlText(String text) {
        this.sqlText_ = text;
    }

    public String getSqlText() {
        String text = this.sqlText_;
        if (text.equals("")) {
            int i;
            StringBuffer bf = new StringBuffer();
            if (this.operation_.toUpperCase().equals("SELECT")) {
                bf.append("select ");
                if (this.selectFields_.equals("")) {
                    bf.append("*");
                } else {
                    bf.append(this.selectFields_);
                }
                bf.append(" from ");
                bf.append(this.moduleID);
                if (this.withKeyList_.size() > 0) {
                    bf.append(" where ");
                    i = 0;
                    while (i < this.withKeyList_.size()) {
                        bf.append(this.withKeyList_.get(i));
                        ++i;
                    }
                }
                if (!this.additionalWhere_.equals("")) {
                    if (!bf.toString().contains(" where ")) {
                        bf.append(" where ");
                    }
                    if (this.additionalWhere_.toLowerCase().startsWith("AND ") || this.additionalWhere_.toLowerCase().startsWith("AND(")) {
                        bf.append(" ");
                        bf.append(this.additionalWhere_);
                    } else if (this.additionalWhere_.toLowerCase().startsWith(" AND ") || this.additionalWhere_.toLowerCase().startsWith(" AND(")) {
                        bf.append(this.additionalWhere_);
                    } else {
                        bf.append(" and (");
                        bf.append(this.additionalWhere_);
                        bf.append(")");
                    }
                }
                if (!this.orderBy_.equals("")) {
                    bf.append(" order by ");
                    bf.append(this.orderBy_);
                }
            }
            if (this.operation_.toUpperCase().equals("COUNT")) {
                bf.append("select count(*) from ");
                bf.append(this.moduleID);
                if (this.withKeyList_.size() > 0) {
                    bf.append(" where ");
                    i = 0;
                    while (i < this.withKeyList_.size()) {
                        bf.append(this.withKeyList_.get(i));
                        ++i;
                    }
                }
                if (!this.additionalWhere_.equals("")) {
                    if (!bf.toString().contains(" where ")) {
                        bf.append(" where ");
                    }
                    if (this.additionalWhere_.toLowerCase().startsWith("AND ") || this.additionalWhere_.toLowerCase().startsWith("AND(")) {
                        bf.append(" ");
                        bf.append(this.additionalWhere_);
                    } else if (this.additionalWhere_.toLowerCase().startsWith(" AND ") || this.additionalWhere_.toLowerCase().startsWith(" AND(")) {
                        bf.append(this.additionalWhere_);
                    } else {
                        bf.append(" and (");
                        bf.append(this.additionalWhere_);
                        bf.append(")");
                    }
                }
            }
            if (this.operation_.toUpperCase().equals("INSERT")) {
                bf.append(this.operation_);
                bf.append(" ");
                bf.append(" into ");
                bf.append(this.moduleID);
                bf.append(" (");
                i = 0;
                while (i < this.fieldIDList_.size()) {
                    if (i > 0) {
                        bf.append(", ");
                    }
                    bf.append(this.fieldIDList_.get(i));
                    ++i;
                }
                bf.append(") ");
                bf.append(" values(");
                i = 0;
                while (i < this.fieldIDList_.size()) {
                    if (i > 0) {
                        bf.append(", ");
                    }
                    bf.append(this.fieldValueList_.get(i));
                    ++i;
                }
                bf.append(") ");
            }
            if (this.operation_.toUpperCase().equals("UPDATE")) {
                bf.append(this.operation_);
                bf.append(" ");
                bf.append(this.moduleID);
                bf.append(" set ");
                i = 0;
                while (i < this.fieldIDList_.size()) {
                    if (i > 0) {
                        bf.append(", ");
                    }
                    bf.append(this.fieldIDList_.get(i));
                    bf.append(" = ");
                    bf.append(this.fieldValueList_.get(i));
                    ++i;
                }
                if (this.withKeyList_.size() > 0) {
                    bf.append(" where ");
                    i = 0;
                    while (i < this.withKeyList_.size()) {
                        bf.append(this.withKeyList_.get(i));
                        ++i;
                    }
                }
                if (!this.additionalWhere_.equals("")) {
                    if (!bf.toString().contains(" where ")) {
                        bf.append(" where ");
                    }
                    if (this.additionalWhere_.toLowerCase().startsWith("AND ") || this.additionalWhere_.toLowerCase().startsWith("AND(")) {
                        bf.append(" ");
                        bf.append(this.additionalWhere_);
                    } else if (this.additionalWhere_.toLowerCase().startsWith(" AND ") || this.additionalWhere_.toLowerCase().startsWith(" AND(")) {
                        bf.append(this.additionalWhere_);
                    } else {
                        bf.append(" and (");
                        bf.append(this.additionalWhere_);
                        bf.append(")");
                    }
                }
            }
            if (this.operation_.toUpperCase().equals("DELETE")) {
                bf.append(this.operation_);
                bf.append(" ");
                bf.append(" from ");
                bf.append(this.moduleID);
                if (this.withKeyList_.size() > 0) {
                    bf.append(" where ");
                    i = 0;
                    while (i < this.withKeyList_.size()) {
                        bf.append(this.withKeyList_.get(i));
                        ++i;
                    }
                }
                if (!this.additionalWhere_.equals("")) {
                    if (!bf.toString().contains(" where ")) {
                        bf.append(" where ");
                    }
                    if (this.additionalWhere_.toLowerCase().startsWith("AND ") || this.additionalWhere_.toLowerCase().startsWith("AND(")) {
                        bf.append(" ");
                        bf.append(this.additionalWhere_);
                    } else if (this.additionalWhere_.toLowerCase().startsWith(" AND ") || this.additionalWhere_.toLowerCase().startsWith(" AND(")) {
                        bf.append(this.additionalWhere_);
                    } else {
                        bf.append(" and (");
                        bf.append(this.additionalWhere_);
                        bf.append(")");
                    }
                }
            }
            text = bf.toString();
            if (this.dbName.contains("jdbc:mysql:")) {
                text = text.replaceAll("\\\\", "\\\\\\\\");
            }
        } else {
            text = text.replaceFirst(" " + this.tableID_ + " ", " " + this.moduleID + " ");
        }
        return text;
    }

    public int execute() throws Exception {
        int count = -1;
        if (this.logBuf_ != null) {
            String text = this.getSqlText();
            if (text.length() > 1000) {
                XFUtility.appendLog((String)(String.valueOf(text.substring(0, 1000)) + "..."), (StringBuffer)this.logBuf_);
            } else {
                XFUtility.appendLog((String)text, (StringBuffer)this.logBuf_);
            }
        }
        if (this.session_.getAppServerName().equals("")) {
            try {
                count = this.executeOnLocal();
            }
            catch (SQLException sQLException) {}
        } else {
            count = this.executeOnServer();
        }
        return count;
    }

    private int executeOnLocal() throws Exception {
        int processRowCount = -1;
        Connection connection = null;
        Statement statement = null;
        if (!(this.dbID.equals("") || this.operation_.toUpperCase().equals("SELECT") || this.operation_.toUpperCase().equals("COUNT"))) {
            throw new Exception("Update/Insert/Delete are not permitted to the read-only database.");
        }
        while (true) {
            try {
                do {
                    if (this.dbID.equals("")) {
                        if (this.isAutoCommit_) {
                            connection = this.session_.getConnectionAutoCommit();
                            continue;
                        }
                        connection = this.session_.getConnectionManualCommit();
                        continue;
                    }
                    connection = this.session_.getConnectionReadOnly(this.dbID);
                } while (connection == null);
                if (this.operation_.toUpperCase().equals("SELECT")) {
                    statement = connection.createStatement();
                    ResultSet result = statement.executeQuery(this.getSqlText());
                    this.relation_ = new Relation(result);
                    processRowCount = this.relation_.getRowCount();
                    result.close();
                } else if (this.operation_.toUpperCase().equals("COUNT")) {
                    statement = connection.createStatement();
                    ResultSet result = statement.executeQuery(this.getSqlText());
                    if (result.next()) {
                        processRowCount = result.getInt(1);
                    }
                    result.close();
                } else {
                    statement = connection.createStatement();
                    processRowCount = statement.executeUpdate(this.getSqlText());
                }
                statement.close();
            }
            catch (SQLException e) {
                if (this.logBuf_ != null) {
                    XFUtility.appendLog((String)e.getMessage(), (StringBuffer)this.logBuf_);
                }
                try {
                    statement.executeQuery("SELECT * FROM " + this.session_.taxTable);
                    throw new Exception(e.getMessage());
                }
                catch (SQLException e1) {
                    System.exit(0);
                    continue;
                }
            }
            catch (OutOfMemoryError e) {
                if (this.logBuf_ != null) {
                    XFUtility.appendLog((String)e.getMessage(), (StringBuffer)this.logBuf_);
                }
                throw new Exception(e.getMessage());
            }
            catch (Exception e) {
                if (this.logBuf_ != null) {
                    XFUtility.appendLog((String)e.getMessage(), (StringBuffer)this.logBuf_);
                }
                throw e;
            }
            break;
        }
        return processRowCount;
    }

    private int executeOnServer() throws Exception {
        int processRowCount = -1;
        HttpPost httpPost = null;
        ArrayList<BasicNameValuePair> objValuePairs = null;
        ObjectInputStream inputStream = null;
        DefaultHttpClient httpClient = null;
        if (!(this.dbID.equals("") || this.operation_.toUpperCase().equals("SELECT") || this.operation_.toUpperCase().equals("COUNT"))) {
            throw new Exception("Update/Insert/Delete are not permitted to the read-only database.");
        }
        if (!this.isAutoCommit_ && this.session_.getSessionID().equals("")) {
            throw new Exception("Manual-commit transaction is not allowed with blank session ID.");
        }
        try {
            try {
                while (true) {
                    httpPost = new HttpPost(this.session_.getAppServerName());
                    if (!this.isAutoCommit_) {
                        objValuePairs = new ArrayList<BasicNameValuePair>(3);
                        objValuePairs.add(new BasicNameValuePair("SESSION", this.session_.getSessionID()));
                        objValuePairs.add(new BasicNameValuePair("METHOD", this.getSqlText()));
                        objValuePairs.add(new BasicNameValuePair("DB", this.dbID));
                    } else {
                        objValuePairs = new ArrayList(2);
                        objValuePairs.add(new BasicNameValuePair("METHOD", this.getSqlText()));
                        objValuePairs.add(new BasicNameValuePair("DB", this.dbID));
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(objValuePairs, "UTF-8"));
                    httpClient = new DefaultHttpClient();
                    try {
                        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                        HttpEntity responseEntity = response.getEntity();
                        if (responseEntity == null) {
                            if (this.logBuf_ == null) break;
                            XFUtility.appendLog((String)"Response is NULL.", (StringBuffer)this.logBuf_);
                            break;
                        }
                        if (this.operation_.toUpperCase().equals("SELECT")) {
                            inputStream = new ObjectInputStream(responseEntity.getContent());
                            this.relation_ = (Relation)inputStream.readObject();
                            processRowCount = this.relation_.getRowCount();
                            break;
                        }
                        processRowCount = Integer.parseInt(EntityUtils.toString((HttpEntity)responseEntity));
                    }
                    catch (Exception ex) {
                        System.exit(0);
                        continue;
                    }
                    break;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (httpClient != null) {
                    httpClient.getConnectionManager().shutdown();
                }
            }
            catch (Exception e) {
                String message = "HttpClient error with DB server.\u3000Session is aborted.";
                if (this.logBuf_ != null) {
                    XFUtility.appendLog((String)(String.valueOf(message) + "\n" + e.getMessage()), (StringBuffer)this.logBuf_);
                }
                throw new Exception(String.valueOf(message) + "\n" + e.getMessage());
            }
        }
        finally {
            if (httpPost != null) {
                httpPost.abort();
            }
        }
        return processRowCount;
    }

    public void resetCursor() {
        this.relation_.setRowIndex(-1);
    }

    public boolean next() throws Exception {
        boolean hasNext = false;
        if (this.operation_.toUpperCase().equals("SELECT")) {
            if (this.relation_ == null || !this.hasFoundRecord_) {
                this.execute();
            }
            if (this.relation_ != null && (hasNext = this.relation_.next())) {
                this.hasFoundRecord_ = true;
            }
        }
        return hasNext;
    }

    public void setCursorAt(int index) {
        if (this.relation_ != null) {
            this.relation_.setRowIndex(index);
        }
    }

    public boolean previous() {
        boolean hasPrevious = false;
        if (this.operation_.toUpperCase().equals("SELECT") && this.relation_ != null) {
            hasPrevious = this.relation_.previous();
        }
        return hasPrevious;
    }

    public int getRowCount() {
        return this.relation_.getRowCount();
    }

    public Object getValueOf(String fieldID) throws Exception {
        Object value = "";
        if (this.relation_ != null) {
            value = this.relation_.getValueOf(fieldID);
        }
        if (value == null) {
            if (!(value instanceof Blob)) {
                value = "";
            }
        } else if (value instanceof String) {
            value = value.toString().trim();
        }
        return value;
    }

    public boolean hasValueOf(String tableID, String fieldID) {
        if (tableID.equals(this.tableID_)) {
            if (this.relation_ == null) {
                return false;
            }
            return this.relation_.hasValueOf(fieldID);
        }
        return false;
    }
}

