/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BlobLocatorOutputStream;
import org.apache.derby.client.am.BlobOutputStream;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UpdateSensitiveBlobLocatorInputStream;

public class Blob
extends Lob
implements java.sql.Blob {
    private boolean isValid = true;
    byte[] binaryString_ = null;
    InputStream binaryStream_ = null;
    int dataOffset_;

    public Blob(byte[] byArray, Agent agent, int n) {
        super(agent, false);
        this.binaryString_ = byArray;
        this.dataType_ |= 0x40;
        this.setSqlLength(byArray.length - n);
        this.dataOffset_ = n;
    }

    public Blob(Agent agent, InputStream inputStream, int n) {
        super(agent, false);
        this.binaryStream_ = inputStream;
        this.dataType_ |= 0x20;
        this.setSqlLength(n);
    }

    public Blob(Agent agent, InputStream inputStream) {
        super(agent, Blob.isLayerBStreamingPossible(agent));
        this.binaryStream_ = inputStream;
        this.dataType_ |= 0x20;
    }

    public Blob(Agent agent, int n) {
        super(agent, false);
        this.locator_ = n;
        this.dataType_ |= 0x80;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "length");
                }
                this.checkForClosedConnection();
                long l = super.sqlLength();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "length", l);
                }
                return l;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    long getLocatorLength() throws SqlException {
        return this.agent_.connection_.locatorProcedureCall().blobGetLength(this.locator_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBytes", (int)l, n);
                }
                if (l <= 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(l));
                }
                if (l > this.sqlLength() + 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), new Long(l));
                }
                if (n < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), new Integer(n));
                }
                byte[] byArray = this.getBytesX(l, n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBytes", byArray);
                }
                return byArray;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private byte[] getBytesX(long l, int n) throws SqlException {
        byte[] byArray;
        this.checkForClosedConnection();
        long l2 = Math.min(this.sqlLength() - l + 1L, (long)n);
        if (this.isLocator()) {
            byArray = this.agent_.connection_.locatorProcedureCall().blobGetBytes(this.locator_, l, (int)l2);
        } else {
            byArray = new byte[(int)l2];
            System.arraycopy(this.binaryString_, (int)l + this.dataOffset_ - 1, byArray, 0, (int)l2);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBinaryStream");
                }
                InputStream inputStream = this.getBinaryStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", inputStream);
                }
                return inputStream;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    InputStream getBinaryStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isBinaryStream()) {
            return this.binaryStream_;
        }
        if (this.isLocator()) {
            return new UpdateSensitiveBlobLocatorInputStream(this.agent_.connection_, this);
        }
        return new ByteArrayInputStream(this.binaryString_, this.dataOffset_, this.binaryString_.length - this.dataOffset_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(byte[] byArray, long l) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "position(byte[], long)", (Object)byArray, l);
                }
                if (byArray == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"));
                }
                if (l < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(l));
                }
                long l2 = this.positionX(byArray, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(byte[], long)", l2);
                }
                return l2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private long positionX(byte[] byArray, long l) throws SqlException {
        this.checkForClosedConnection();
        if (this.isLocator()) {
            return this.agent_.connection_.locatorProcedureCall().blobGetPositionFromBytes(this.locator_, byArray, l);
        }
        return this.binaryStringPosition(byArray, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(java.sql.Blob blob, long l) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "position(Blob, long)", (Object)blob, l);
                }
                if (blob == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"));
                }
                if (l < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(l));
                }
                long l2 = this.positionX(blob, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(Blob, long)", l2);
                }
                return l2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private long positionX(java.sql.Blob blob, long l) throws SqlException {
        this.checkForClosedConnection();
        try {
            if (this.isLocator()) {
                if (blob instanceof Blob && ((Blob)blob).isLocator()) {
                    return this.agent_.connection_.locatorProcedureCall().blobGetPositionFromLocator(this.locator_, ((Blob)blob).getLocator(), l);
                }
                return this.agent_.connection_.locatorProcedureCall().blobGetPositionFromBytes(this.locator_, blob.getBytes(1L, (int)blob.length()), l);
            }
            return this.binaryStringPosition(blob.getBytes(1L, (int)blob.length()), l);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long l, byte[] byArray) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBytes", (int)l, byArray);
                }
                int n = this.setBytesX(l, byArray, 0, byArray.length);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setBytes", n);
                }
                return n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBytes", (int)l, (Object)byArray, n, n2);
                }
                int n3 = this.setBytesX(l, byArray, n, n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setBytes", n3);
                }
                return n3;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int setBytesX(long l, byte[] byArray, int n, int n2) throws SqlException {
        int n3 = 0;
        if (l <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(l));
        }
        if (l >= Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), new Long(l));
        }
        if (l - 1L > this.sqlLength()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), new Long(l));
        }
        if (n < 0 || n > byArray.length) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ078.S"), new Integer(n));
        }
        if (n2 < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), new Integer(n3));
        }
        if (n2 == 0) {
            return 0;
        }
        n3 = Math.min(byArray.length - n, n2);
        if (this.isLocator()) {
            byte[] byArray2 = byArray;
            if (n > 0 || n3 < byArray.length) {
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n, byArray2, 0, n3);
            }
            this.agent_.connection_.locatorProcedureCall().blobSetBytes(this.locator_, l, n3, byArray2);
            if (l + (long)n3 - 1L > this.sqlLength()) {
                this.setSqlLength(l + (long)n3 - 1L);
            }
            this.incrementUpdateCount();
        } else {
            if (this.binaryString_.length - this.dataOffset_ - (int)l + 1 < n3) {
                byte[] byArray3 = new byte[(int)l + n3 + this.dataOffset_ - 1];
                System.arraycopy(this.binaryString_, 0, byArray3, 0, this.binaryString_.length);
                this.binaryString_ = byArray3;
            }
            System.arraycopy(byArray, n, this.binaryString_, (int)l + this.dataOffset_ - 1, n3);
            this.binaryStream_ = new ByteArrayInputStream(this.binaryString_);
            this.setSqlLength(this.binaryString_.length - this.dataOffset_);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream setBinaryStream(long l) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBinaryStream", (int)l);
                }
                if (l < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(l));
                }
                OutputStream outputStream = this.isLocator() ? new BlobLocatorOutputStream(this.agent_.connection_, this, l) : new BlobOutputStream(this, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setBinaryStream", outputStream);
                }
                return outputStream;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long l) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, " truncate", (int)l);
                }
                if (l < 0L || l > this.sqlLength()) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Long(l), (Object)"len", "Blob.truncate()");
                }
                if (l == this.sqlLength()) {
                    return;
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().blobTruncate(this.locator_, l);
                    this.setSqlLength(l);
                    this.incrementUpdateCount();
                } else {
                    long l2 = (int)l + this.dataOffset_;
                    byte[] byArray = new byte[(int)l + this.dataOffset_];
                    System.arraycopy(this.binaryString_, 0, byArray, 0, (int)l2);
                    this.binaryString_ = byArray;
                    this.binaryStream_ = new ByteArrayInputStream(this.binaryString_);
                    this.setSqlLength(this.binaryString_.length - this.dataOffset_);
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() throws SQLException {
        if (!this.isValid) {
            return;
        }
        this.isValid = false;
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "free");
                }
                if (this.isBinaryStream()) {
                    try {
                        this.binaryStream_.close();
                    }
                    catch (IOException iOException) {
                        throw new SqlException(null, new ClientMessageId("XJ214.S"));
                    }
                } else if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().blobReleaseLocator(this.locator_);
                } else {
                    this.binaryString_ = null;
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBinaryStream", (int)l, l2);
                }
                this.checkPosAndLength(l, l2);
                InputStream inputStream = this.isLocator() ? new UpdateSensitiveBlobLocatorInputStream(this.agent_.connection_, this, l, l2) : new ByteArrayInputStream(this.binaryString_, (int)((long)this.dataOffset_ + l - 1L), (int)l2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", inputStream);
                }
                return inputStream;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isBinaryString() {
        return (this.dataType_ & 0x40) == 64;
    }

    public boolean isBinaryStream() {
        return (this.dataType_ & 0x20) == 32;
    }

    public byte[] getBinaryString() {
        return this.binaryString_;
    }

    protected long binaryStringPosition(byte[] byArray, long l) {
        int n = (int)l + this.dataOffset_ - 1;
        while (n + byArray.length <= this.binaryString_.length) {
            if (this.isSubString(byArray, n)) {
                return n - this.dataOffset_ + 1;
            }
            ++n;
        }
        return -1L;
    }

    protected boolean isSubString(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != this.binaryString_[n]) {
                return false;
            }
            ++n2;
            ++n;
        }
        return true;
    }

    private void checkValidity() throws SQLException {
        if (!this.isValid) {
            throw new SqlException(null, new ClientMessageId("XJ215.S")).getSQLException();
        }
    }

    protected void materializeStream() throws SqlException {
        this.binaryStream_ = super.materializeStream(this.binaryStream_, "java.sql.Blob");
    }
}

