/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.optional.lucene.DerbyIndexInput;
import org.apache.derby.optional.lucene.DerbyIndexOutput;
import org.apache.derby.optional.utils.ToolUtilities;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;

class DerbyLuceneDir
extends Directory {
    private final StorageFactory _storageFactory;
    private final StorageFile _directory;
    private final String _schema;
    private final String _table;
    private final String _textcol;
    private HashMap<String, DerbyIndexOutput> _outputFiles = new HashMap();
    private LockFactory _lockFactory;
    private boolean _closed = false;
    private static HashMap<String, DerbyLuceneDir> _openDirectories = new HashMap();

    static synchronized DerbyLuceneDir getDirectory(StorageFactory storageFactory, String string, String string2, String string3) throws SQLException {
        DerbyLuceneDir derbyLuceneDir = new DerbyLuceneDir(storageFactory, string, string2, string3);
        String string4 = DerbyLuceneDir.getKey(derbyLuceneDir);
        DerbyLuceneDir derbyLuceneDir2 = _openDirectories.get(string4);
        if (derbyLuceneDir2 == null) {
            derbyLuceneDir2 = derbyLuceneDir;
            derbyLuceneDir2.setLockFactory((LockFactory)new SingleInstanceLockFactory());
            _openDirectories.put(string4, derbyLuceneDir2);
        }
        return derbyLuceneDir2;
    }

    private static synchronized void removeDir(DerbyLuceneDir derbyLuceneDir) {
        _openDirectories.remove(DerbyLuceneDir.getKey(derbyLuceneDir));
    }

    private static String getKey(DerbyLuceneDir derbyLuceneDir) {
        return derbyLuceneDir._directory.getPath();
    }

    private DerbyLuceneDir(StorageFactory storageFactory, String string, String string2, String string3) throws SQLException {
        this._storageFactory = storageFactory;
        this._schema = string;
        this._table = string2;
        this._textcol = string3;
        this._directory = DerbyLuceneDir.createPath(this._storageFactory, this._schema, this._table, this._textcol);
    }

    StorageFile getFile(String string) {
        return this._storageFactory.newStorageFile(this._directory, string);
    }

    StorageFile getDirectory() {
        return this._directory;
    }

    public void setLockFactory(LockFactory lockFactory) {
        this._lockFactory = lockFactory;
    }

    public LockFactory getLockFactory() {
        return this._lockFactory;
    }

    public void clearLock(String string) throws IOException {
        this._lockFactory.clearLock(string);
    }

    public Lock makeLock(String string) {
        return this._lockFactory.makeLock(string);
    }

    public void close() throws IOException {
        for (String string : this._outputFiles.keySet()) {
            this._outputFiles.get(string).close();
        }
        this._outputFiles.clear();
        this._closed = true;
        DerbyLuceneDir.removeDir(this);
    }

    public DerbyIndexOutput createOutput(String string, IOContext iOContext) throws IOException {
        StorageFile storageFile;
        this.checkIfClosed();
        DerbyIndexOutput derbyIndexOutput = this._outputFiles.get(string);
        if (derbyIndexOutput != null) {
            derbyIndexOutput.close();
        }
        if ((storageFile = this.getStorageFile(string)).exists()) {
            this.deleteFile(string);
        }
        derbyIndexOutput = new DerbyIndexOutput(storageFile, this);
        this._outputFiles.put(string, derbyIndexOutput);
        return derbyIndexOutput;
    }

    public void deleteFile(String string) throws IOException {
        this.checkIfClosed();
        StorageFile storageFile = this.getStorageFile(string);
        if (storageFile.exists() && !storageFile.delete()) {
            throw this.newIOException("XBM0R.D", storageFile.getPath());
        }
    }

    public boolean fileExists(String string) throws IOException {
        this.checkIfClosed();
        return this.getStorageFile(string).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fileLength(String string) throws IOException {
        this.checkIfClosed();
        DerbyIndexInput derbyIndexInput = this.openInput(string, null);
        try {
            long l = derbyIndexInput.length();
            return l;
        }
        finally {
            derbyIndexInput.close();
        }
    }

    public String[] listAll() throws IOException {
        this.checkIfClosed();
        return this._directory.list();
    }

    public DerbyIndexInput openInput(String string, IOContext iOContext) throws IOException {
        this.checkIfClosed();
        StorageFile storageFile = this.getStorageFile(string);
        if (!storageFile.exists()) {
            throw new FileNotFoundException(storageFile.getPath());
        }
        return this.getIndexInput(storageFile);
    }

    public void sync(Collection<String> collection) throws IOException {
        for (String string : collection) {
            DerbyIndexOutput derbyIndexOutput = this._outputFiles.get(string);
            if (derbyIndexOutput == null) continue;
            derbyIndexOutput.flush();
        }
    }

    void removeIndexOutput(String string) {
        this._outputFiles.remove(string);
    }

    private DerbyIndexInput getIndexInput(String string) throws IOException {
        return this.getIndexInput(this.getStorageFile(string));
    }

    private DerbyIndexInput getIndexInput(StorageFile storageFile) throws IOException {
        return new DerbyIndexInput(storageFile);
    }

    private StorageFile getStorageFile(String string) {
        return this._storageFactory.newStorageFile(this._directory, string);
    }

    private IOException newIOException(String string, Object ... objectArray) {
        return new IOException(ToolUtilities.newSQLException(string, objectArray).getMessage());
    }

    private void checkIfClosed() throws IOException {
        if (this._closed) {
            throw this.newIOException("40XD0", new Object[0]);
        }
    }

    private static StorageFile createPath(StorageFactory storageFactory, String string, String string2, String string3) throws SQLException {
        StorageFile storageFile = DerbyLuceneDir.createPathLeg(storageFactory, null, "LUCENE");
        StorageFile storageFile2 = DerbyLuceneDir.createPathLeg(storageFactory, storageFile, string);
        StorageFile storageFile3 = DerbyLuceneDir.createPathLeg(storageFactory, storageFile2, string2);
        StorageFile storageFile4 = DerbyLuceneDir.createPathLeg(storageFactory, storageFile3, string3);
        return storageFile4;
    }

    private static StorageFile createPathLeg(final StorageFactory storageFactory, final StorageFile storageFile, final String string) throws SQLException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<StorageFile>(){

                @Override
                public StorageFile run() throws SQLException {
                    StorageFile storageFile3;
                    String string2 = ToolUtilities.derbyIdentifier(string);
                    StorageFile storageFile2 = storageFile3 = storageFile == null ? storageFactory.newStorageFile(string2) : storageFactory.newStorageFile(storageFile, string2);
                    if (!storageFile3.exists()) {
                        storageFile3.mkdir();
                    }
                    if (!storageFile3.exists()) {
                        throw ToolUtilities.newSQLException("XBM0H.D", string2);
                    }
                    return storageFile3;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SQLException)privilegedActionException.getCause();
        }
    }
}

