/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.optional.lucene.LuceneSupport;
import org.apache.derby.optional.utils.ToolUtilities;
import org.apache.derby.vti.StringColumnVTI;

class LuceneListIndexesVTI
extends StringColumnVTI {
    private Connection connection = LuceneSupport.getDefaultConnection();
    private StorageFile[] indexes;
    private int row = -1;
    private String schema;
    private String table;
    private String column;
    private Properties rowProperties;

    public LuceneListIndexesVTI() throws SQLException {
        super(new String[]{"SCHEMANAME", "TABLENAME", "COLUMNNAME", "LASTUPDATED", "LUCENEVERSION", "ANALYZER", "INDEXDESCRIPTORMAKER"});
        StorageFactory storageFactory = LuceneSupport.getStorageFactory(this.connection);
        StorageFile storageFile = storageFactory.newStorageFile("LUCENE");
        ArrayList<StorageFile> arrayList = new ArrayList<StorageFile>();
        StorageFile[] storageFileArray = LuceneListIndexesVTI.listDirectories(storageFactory, storageFile);
        if (storageFileArray != null) {
            for (StorageFile storageFile2 : storageFileArray) {
                StorageFile[] storageFileArray2;
                for (StorageFile storageFile3 : storageFileArray2 = LuceneListIndexesVTI.listDirectories(storageFactory, storageFile2)) {
                    StorageFile[] storageFileArray3;
                    for (StorageFile storageFile4 : storageFileArray3 = LuceneListIndexesVTI.listDirectories(storageFactory, storageFile3)) {
                        arrayList.add(storageFile4);
                    }
                }
            }
        }
        this.indexes = new StorageFile[arrayList.size()];
        arrayList.toArray(this.indexes);
    }

    public void close() throws SQLException {
        this.connection = null;
        this.indexes = null;
        this.schema = null;
        this.table = null;
        this.column = null;
        this.rowProperties = null;
    }

    public boolean next() throws SQLException {
        this.schema = null;
        this.table = null;
        this.column = null;
        this.rowProperties = null;
        ++this.row;
        return this.row < this.indexes.length;
    }

    protected String getRawColumn(int n) throws SQLException {
        this.readSchemaTableColumn();
        switch (n) {
            case 1: {
                return this.schema;
            }
            case 2: {
                return this.table;
            }
            case 3: {
                return this.column;
            }
            case 5: {
                return this.getProperty("derby.lucene.version");
            }
            case 6: {
                return this.getProperty("derby.lucene.analyzer");
            }
            case 7: {
                return this.getProperty("derby.lucene.index.descriptor.maker");
            }
        }
        throw ToolUtilities.newSQLException("XCL14.S", new Integer(n), new Integer(this.getColumnCount()));
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (n != 4) {
            throw ToolUtilities.newSQLException("XCL14.S", new Integer(n), new Integer(this.getColumnCount()));
        }
        try {
            long l = Long.parseLong(this.getProperty("derby.lucene.last.updated"));
            return new Timestamp(l);
        }
        catch (NumberFormatException numberFormatException) {
            throw ToolUtilities.wrap(numberFormatException);
        }
    }

    private void readSchemaTableColumn() throws SQLException {
        if (this.column != null) {
            return;
        }
        StorageFile storageFile = this.indexes[this.row];
        this.column = storageFile.getName();
        StorageFile storageFile2 = storageFile.getParentDir();
        this.table = storageFile2.getName();
        StorageFile storageFile3 = storageFile2.getParentDir();
        this.schema = storageFile3.getName();
    }

    private String getProperty(String string) throws SQLException {
        return this.getRowProperties().getProperty(string);
    }

    private Properties getRowProperties() throws SQLException {
        if (this.rowProperties == null) {
            try {
                this.readSchemaTableColumn();
                String string = LuceneSupport.delimitID(this.column);
                StorageFile storageFile = LuceneSupport.getIndexPropertiesFile(this.connection, this.schema, this.table, string);
                this.rowProperties = LuceneListIndexesVTI.readIndexProperties(storageFile);
            }
            catch (IOException iOException) {
                throw ToolUtilities.wrap(iOException);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw ToolUtilities.wrap(privilegedActionException);
            }
        }
        return this.rowProperties;
    }

    private static StorageFile[] listDirectories(final StorageFactory storageFactory, final StorageFile storageFile) {
        return AccessController.doPrivileged(new PrivilegedAction<StorageFile[]>(){

            @Override
            public StorageFile[] run() {
                String[] stringArray;
                ArrayList<StorageFile> arrayList = new ArrayList<StorageFile>();
                for (String string : stringArray = storageFile.list()) {
                    StorageFile storageFile2 = storageFactory.newStorageFile(storageFile, string);
                    if (!storageFile2.isDirectory()) continue;
                    arrayList.add(storageFile2);
                }
                String[] stringArray2 = new StorageFile[arrayList.size()];
                arrayList.toArray(stringArray2);
                return stringArray2;
            }
        });
    }

    private static Properties readIndexProperties(final StorageFile storageFile) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return LuceneSupport.readIndexPropertiesNoPrivs(storageFile);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }
}

