/*
 * Decompiled with CFR 0.152.
 */
package xeadServer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import xeadServer.Relation;

public class DBMethod
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String APPLICATION_NAME = "X-TEA Server/ DB Method Controler";
    public static final String VERSION = "1.1.0";
    private static final String DRIVER_DERBY = "org.apache.derby.jdbc.ClientDriver";
    private static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    private static final String DRIVER_POSTGRESQL = "org.postgresql.Driver";
    private static final String DRIVER_ORACLE = "oracle.jdbc.driver.OracleDriver";
    private static final String DRIVER_SQLSERVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String DRIVER_ACCESS = "net.ucanaccess.jdbc.UcanaccessDriver";
    private static final String DRIVER_H2 = "org.h2.Driver";
    private ArrayList<String> databaseIDList = new ArrayList();
    private ArrayList<Integer> errorCountList = new ArrayList();
    private ArrayList<Integer> clearedCountList = new ArrayList();
    private ArrayList<Boolean> databaseReadOnlyEnableList = new ArrayList();
    private ArrayList<String> lastCommandList = new ArrayList();
    private ArrayList<BasicDataSource> dataSourceList = new ArrayList();
    private HashMap<String, Connection> manualCommitConnectionMapBySession = new HashMap();
    private HashMap<String, String> manualCommitLastCommandMapBySession = new HashMap();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public void init() throws ServletException {
        String currentFolder = "";
        Document domDocument = null;
        super.init();
        String fileName = this.getServletConfig().getInitParameter("SystemDefinition");
        try {
            File xeafFile = new File(fileName);
            if (xeafFile.exists()) {
                currentFolder = xeafFile.getParent();
                DOMParser parser = new DOMParser();
                parser.parse(new InputSource(new FileInputStream(fileName)));
                domDocument = parser.getDocument();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NodeList nodeList = domDocument.getElementsByTagName("System");
        Element systemElement = (Element)nodeList.item(0);
        HashMap<String, Object> dbOptionMap = this.getMainDbOptionMap(systemElement, currentFolder);
        this.databaseIDList.add((String)dbOptionMap.get("ID"));
        this.errorCountList.add(0);
        this.clearedCountList.add(0);
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName((String)dbOptionMap.get("DriverClassName"));
        dataSource.setUsername((String)dbOptionMap.get("UserName"));
        dataSource.setPassword((String)dbOptionMap.get("Password"));
        dataSource.setUrl((String)dbOptionMap.get("Url"));
        dataSource.setMaxActive(((Integer)dbOptionMap.get("MaxActive")).intValue());
        dataSource.setMaxIdle(((Integer)dbOptionMap.get("MaxIdle")).intValue());
        dataSource.setMaxWait((long)((Integer)dbOptionMap.get("MaxWait")).intValue());
        dataSource.setDefaultAutoCommit(false);
        dataSource.setDefaultReadOnly(false);
        dataSource.setDefaultTransactionIsolation(2);
        this.dataSourceList.add(dataSource);
        this.databaseReadOnlyEnableList.add((Boolean)dbOptionMap.get("ReadOnlyEnabled"));
        this.lastCommandList.add("");
        NodeList subDBList = domDocument.getElementsByTagName("SubDB");
        int i = 0;
        while (i < subDBList.getLength()) {
            dbOptionMap = this.getSubDbOptionMap((Element)subDBList.item(i), currentFolder);
            this.databaseIDList.add((String)dbOptionMap.get("ID"));
            this.errorCountList.add(0);
            this.clearedCountList.add(0);
            dataSource = new BasicDataSource();
            dataSource.setDriverClassName((String)dbOptionMap.get("DriverClassName"));
            dataSource.setUsername((String)dbOptionMap.get("UserName"));
            dataSource.setPassword((String)dbOptionMap.get("Password"));
            dataSource.setUrl((String)dbOptionMap.get("Url"));
            dataSource.setMaxActive(((Integer)dbOptionMap.get("MaxActive")).intValue());
            dataSource.setMaxIdle(((Integer)dbOptionMap.get("MaxIdle")).intValue());
            dataSource.setMaxWait((long)((Integer)dbOptionMap.get("MaxWait")).intValue());
            dataSource.setDefaultAutoCommit(true);
            dataSource.setDefaultReadOnly(true);
            dataSource.setDefaultTransactionIsolation(2);
            this.dataSourceList.add(dataSource);
            this.databaseReadOnlyEnableList.add((Boolean)dbOptionMap.get("ReadOnlyEnabled"));
            this.lastCommandList.add("");
            ++i;
        }
    }

    private HashMap<String, Object> getMainDbOptionMap(Element element, String currentFolder) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaxActive", 10);
        map.put("MaxIdle", 10);
        map.put("MaxWait", 5000);
        map.put("ID", "");
        String dbName = element.getAttribute("DatabaseName");
        dbName = dbName.replace("<CURRENT>", currentFolder);
        map.put("Url", dbName);
        map.put("DriverClassName", this.getDriverClassName(dbName));
        map.put("UserName", element.getAttribute("DatabaseUser"));
        map.put("Password", element.getAttribute("DatabasePassword"));
        if (dbName.contains("jdbc:postgresql")) {
            map.put("ReadOnlyEnabled", false);
        } else {
            map.put("ReadOnlyEnabled", true);
        }
        String options = element.getAttribute("DBCP").replaceAll(" ", "");
        StringTokenizer tokenizer1 = new StringTokenizer(options, ",");
        while (tokenizer1.hasMoreTokens()) {
            String option = tokenizer1.nextToken();
            StringTokenizer tokenizer2 = new StringTokenizer(option, "=");
            String key = tokenizer2.nextToken();
            String value = tokenizer2.nextToken();
            if (key.equals("MaxActive")) {
                map.put(key, Integer.parseInt(value));
            }
            if (key.equals("MaxIdle")) {
                map.put(key, Integer.parseInt(value));
            }
            if (!key.equals("MaxWait")) continue;
            map.put(key, Integer.parseInt(value));
        }
        return map;
    }

    private HashMap<String, Object> getSubDbOptionMap(Element element, String currentFolder) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaxActive", 10);
        map.put("MaxIdle", 10);
        map.put("MaxWait", 5000);
        map.put("ID", element.getAttribute("ID"));
        String dbName = element.getAttribute("Name");
        dbName = dbName.replace("<CURRENT>", currentFolder);
        map.put("Url", dbName);
        map.put("DriverClassName", this.getDriverClassName(dbName));
        map.put("UserName", element.getAttribute("User"));
        map.put("Password", element.getAttribute("Password"));
        if (dbName.contains("jdbc:postgresql")) {
            map.put("ReadOnlyEnabled", false);
        } else {
            map.put("ReadOnlyEnabled", true);
        }
        String options = element.getAttribute("DBCP").replaceAll(" ", "");
        StringTokenizer tokenizer1 = new StringTokenizer(options, ",");
        while (tokenizer1.hasMoreTokens()) {
            String option = tokenizer1.nextToken();
            StringTokenizer tokenizer2 = new StringTokenizer(option, "=");
            String key = tokenizer2.nextToken();
            String value = tokenizer2.nextToken();
            if (key.equals("MaxActive")) {
                map.put(key, Integer.parseInt(value));
            }
            if (key.equals("MaxIdle")) {
                map.put(key, Integer.parseInt(value));
            }
            if (!key.equals("MaxWait")) continue;
            map.put(key, Integer.parseInt(value));
        }
        return map;
    }

    private String getDriverClassName(String url) {
        String name = "";
        if (url.contains("jdbc:derby")) {
            name = DRIVER_DERBY;
        }
        if (url.contains("jdbc:mysql")) {
            name = DRIVER_MYSQL;
        }
        if (url.contains("jdbc:postgresql")) {
            name = DRIVER_POSTGRESQL;
        }
        if (url.contains("jdbc:oracle")) {
            name = DRIVER_ORACLE;
        }
        if (url.contains("jdbc:sqlserver")) {
            name = DRIVER_SQLSERVER;
        }
        if (url.contains("jdbc:ucanaccess")) {
            name = DRIVER_ACCESS;
        }
        if (url.contains("jdbc:h2")) {
            name = DRIVER_H2;
        }
        return name;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String sessionID2 = "";
            String lastCommand = "";
            res.setContentType("text/html; charset=UTF-8");
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<head>");
            sb.append("<title>X-TEA Server/ DB-Method Controler</title>");
            sb.append("</head>");
            sb.append("<body>");
            sb.append("<h3>X-TEA Server/ DB-Method Controler(");
            sb.append(VERSION);
            sb.append(") DB Connections</h3>");
            sb.append("<table border='2' cellpadding='2'>");
            sb.append("<tr style='background:#ccccff'><th>DB ID</th><th>MaxActive</th><th>MaxIdle</th><th>MaxWait</th><th>Active</th><th>Idle</th><th>Error</th><th>Cleared</th></tr>");
            int i = 0;
            while (i < this.databaseIDList.size()) {
                if (this.databaseIDList.get(i).equals("")) {
                    sb.append("<tr><td>Main</td><td align='right'>" + this.dataSourceList.get(i).getMaxActive() + "</td><td align='right'>" + this.dataSourceList.get(i).getMaxIdle() + "</td><td align='right'>" + this.dataSourceList.get(i).getMaxWait() + "</td><td align='right'>" + this.dataSourceList.get(i).getNumActive() + "</td><td align='right'>" + this.dataSourceList.get(i).getNumIdle() + "</td><td align='right'>" + this.errorCountList.get(i) + "</td><td align='right'>" + this.clearedCountList.get(i) + "</td></tr>");
                } else {
                    sb.append("<tr><td>" + this.databaseIDList.get(i) + "</td><td align='right'>" + this.dataSourceList.get(i).getMaxActive() + "</td><td align='right'>" + this.dataSourceList.get(i).getMaxIdle() + "</td><td align='right'>" + this.dataSourceList.get(i).getMaxWait() + "</td><td align='right'>" + this.dataSourceList.get(i).getNumActive() + "</td><td align='right'>" + this.dataSourceList.get(i).getNumIdle() + "</td><td align='right'>" + this.errorCountList.get(i) + "</td><td align='right'>" + this.clearedCountList.get(i) + "</td></tr>");
                }
                ++i;
            }
            sb.append("</table><br>");
            int rowNumber = 0;
            sb.append("<table border='2' cellpadding='2'>");
            sb.append("<tr style='background:#ccccff'><th>No.</th><th>DB ID</th><th>Session ID</th><th>Last Command Processed</th></tr>");
            int i2 = 0;
            while (i2 < this.databaseIDList.size()) {
                if (this.databaseIDList.get(i2).equals("")) {
                    lastCommand = this.lastCommandList.get(i2);
                    sb.append("<tr><td align='right'>" + ++rowNumber + "</td><td>Main</td><td>" + "*SYSTEM" + "</td><td>" + lastCommand + "</td></tr>");
                    for (String sessionID2 : this.manualCommitConnectionMapBySession.keySet()) {
                        lastCommand = this.manualCommitLastCommandMapBySession.get(sessionID2);
                        sb.append("<tr><td align='right'>" + ++rowNumber + "</td><td>Main</td><td>" + sessionID2 + "</td><td>" + lastCommand + "</td></tr>");
                    }
                } else {
                    lastCommand = this.lastCommandList.get(i2);
                    sb.append("<tr><td align='right'>" + ++rowNumber + "</td><td>" + this.databaseIDList.get(i2) + "</td><td>" + "*SYSTEM" + "</td><td>" + lastCommand + "</td></tr>");
                }
                ++i2;
            }
            sb.append("</table>");
            sb.append("</body>");
            sb.append("</html>");
            PrintWriter out = res.getWriter();
            out.print(new String(sb));
            out.close();
        }
        catch (Exception e) {
            res.sendError(500, e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html; charset=UTF-8");
        String parmSessionID = "";
        String parmMethod = "";
        String parmDBID = "";
        if (req.getParameter("SESSION") != null) {
            parmSessionID = req.getParameter("SESSION");
        }
        if (req.getParameter("METHOD") != null) {
            parmMethod = req.getParameter("METHOD");
        }
        if (req.getParameter("DB") != null) {
            parmDBID = req.getParameter("DB");
        }
        try {
            PrintWriter out;
            if (parmMethod.toUpperCase().startsWith("SELECT ")) {
                if (parmMethod.toUpperCase().contains("COUNT(")) {
                    out = res.getWriter();
                    out.print(this.getCountOfRecordProcessed(parmSessionID, parmMethod, parmDBID));
                    out.close();
                } else {
                    ObjectOutputStream stream = new ObjectOutputStream((OutputStream)res.getOutputStream());
                    Relation relation = this.getResultOfSelect(parmSessionID, parmMethod, parmDBID);
                    stream.writeObject(relation);
                    stream.flush();
                    stream.close();
                }
            }
            if (parmMethod.toUpperCase().startsWith("INSERT ") || parmMethod.toUpperCase().startsWith("UPDATE ") || parmMethod.toUpperCase().startsWith("DELETE ")) {
                out = res.getWriter();
                out.print(this.getCountOfRecordProcessed(parmSessionID, parmMethod, parmDBID));
                out.close();
            }
            if (parmMethod.toUpperCase().equals("COMMIT")) {
                this.closeConnectionForSession(parmSessionID, parmMethod);
                out = res.getWriter();
                out.print("The transaction was commited.");
                out.close();
            }
            if (parmMethod.toUpperCase().equals("ROLLBACK")) {
                this.closeConnectionForSession(parmSessionID, parmMethod);
                out = res.getWriter();
                out.print("The transaction was rollbacked.");
                out.close();
            }
            if (parmMethod.toUpperCase().startsWith("CALL ")) {
                this.callProcedure(parmSessionID, parmMethod, parmDBID);
                out = res.getWriter();
                out.print("The procedure was executed.");
                out.close();
            }
            if (parmMethod.toUpperCase().equals("IP")) {
                out = res.getWriter();
                out.print(req.getRemoteAddr());
                out.close();
            }
        }
        catch (Exception e) {
            String sessionID = this.getSessionIDFromMethod(parmMethod);
            if (!sessionID.equals("")) {
                try {
                    this.closeConnectionForSession(sessionID, "ROLLBACK");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            this.lastCommandList.add(this.databaseIDList.indexOf(parmDBID), String.valueOf(parmMethod) + "<br>Exception: " + e.getMessage() + "<br>" + stringWriter.toString());
            this.errorCountList.add(this.databaseIDList.indexOf(parmDBID), this.errorCountList.get(this.databaseIDList.indexOf(parmDBID)) + 1);
            res.sendError(500, "Error:<br>" + e.getMessage());
        }
    }

    private Relation getResultOfSelect(String sessionID, String method, String dbID) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rset = null;
        Relation relation = null;
        if (method.toUpperCase().startsWith("SELECT ")) {
            try {
                conn = this.getConnectionForSession(sessionID, dbID, method);
                if (conn == null) {
                    throw new Exception("DB-connection is not available now.");
                }
                if (this.databaseReadOnlyEnableList.get(this.databaseIDList.indexOf(dbID)).booleanValue()) {
                    conn.setReadOnly(true);
                }
                if (conn.isClosed()) {
                    throw new Exception("DB-connection for this session is already closed.");
                }
                stmt = conn.createStatement();
                rset = stmt.executeQuery(method);
                relation = new Relation(rset);
            }
            finally {
                if (conn != null && (sessionID.equals("") || !dbID.equals(""))) {
                    conn.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (rset != null) {
                    rset.close();
                }
            }
        }
        return relation;
    }

    private String getSessionIDFromMethod(String method) {
        int pos1;
        String sessionID = "";
        String methodWork = method.replaceAll(" ", "").toUpperCase();
        if (methodWork.contains("(NRSESSION,") && (pos1 = methodWork.indexOf("VALUES('")) > 0) {
            int pos2 = methodWork.indexOf("'", pos1 + 8);
            sessionID = methodWork.substring(pos1 + 8, pos2);
        }
        return sessionID;
    }

    private int getCountOfRecordProcessed(String sessionID, String method, String dbID) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rset = null;
        int count = -1;
        if (method.toUpperCase().startsWith("INSERT ") || method.toUpperCase().startsWith("UPDATE ") || method.toUpperCase().startsWith("DELETE ")) {
            try {
                conn = this.getConnectionForSession(sessionID, dbID, method);
                if (conn == null) {
                    throw new Exception("DB-connection is not available now.");
                }
                if (conn.isClosed()) {
                    throw new Exception("DB-connection for this session is already closed.");
                }
                if (this.databaseReadOnlyEnableList.get(this.databaseIDList.indexOf(dbID)).booleanValue()) {
                    conn.setReadOnly(false);
                }
                stmt = conn.createStatement();
                count = stmt.executeUpdate(method);
            }
            finally {
                if (conn != null && sessionID.equals("")) {
                    conn.commit();
                    conn.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        if (method.toUpperCase().contains("COUNT(")) {
            try {
                conn = this.getConnectionForSession(sessionID, dbID, method);
                if (conn == null) {
                    throw new Exception("DB-connection is not available now.");
                }
                if (conn.isClosed()) {
                    throw new Exception("DB-connection for this session is already closed.");
                }
                if (this.databaseReadOnlyEnableList.get(this.databaseIDList.indexOf(dbID)).booleanValue()) {
                    conn.setReadOnly(true);
                }
                if ((rset = (stmt = conn.createStatement()).executeQuery(method)).next()) {
                    count = rset.getInt(1);
                }
            }
            finally {
                if (conn != null && (sessionID.equals("") || !dbID.equals(""))) {
                    conn.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (rset != null) {
                    rset.close();
                }
            }
        }
        return count;
    }

    private Connection getConnectionForSession(String sessionID, String dbID, String command) throws Exception {
        Connection connection = null;
        BasicDataSource dataSource = this.dataSourceList.get(this.databaseIDList.indexOf(dbID));
        Date currentDate = new Date();
        String currentTime = " (" + this.sdf.format(currentDate) + ")";
        if (dataSource.getNumActive() + 1 >= dataSource.getMaxActive()) {
            String oldestSessionID = "";
            long currentTimeLong = currentDate.getTime();
            long diffTime = 0L;
            ArrayList<String> listLastCommand = new ArrayList<String>(this.manualCommitLastCommandMapBySession.values());
            ArrayList<String> listSessionID = new ArrayList<String>(this.manualCommitLastCommandMapBySession.keySet());
            int i = 0;
            while (i < listLastCommand.size()) {
                int pos1 = ((String)listLastCommand.get(i)).lastIndexOf(" (");
                int pos2 = ((String)listLastCommand.get(i)).lastIndexOf(")");
                if (pos1 > 0 && pos2 > 0) {
                    String wrkStr = ((String)listLastCommand.get(i)).substring(pos1 + 2, pos2);
                    try {
                        Date dateTime = this.sdf.parse(wrkStr);
                        long timeLong = dateTime.getTime();
                        long diffWork = currentTimeLong - timeLong;
                        if (diffWork > diffTime) {
                            diffTime = diffWork;
                            oldestSessionID = (String)listSessionID.get(i);
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (diffTime > 300000L && !oldestSessionID.equals("")) {
                try {
                    this.closeConnectionForSession(oldestSessionID, "ROLLBACK");
                    this.clearedCountList.add(this.databaseIDList.indexOf(dbID), this.clearedCountList.get(this.databaseIDList.indexOf(dbID)) + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (dbID.equals("")) {
            if (sessionID.equals("")) {
                connection = dataSource.getConnection();
                this.lastCommandList.add(this.databaseIDList.indexOf(dbID), String.valueOf(command) + currentTime);
            } else {
                if (this.manualCommitConnectionMapBySession.containsKey(sessionID)) {
                    connection = this.manualCommitConnectionMapBySession.get(sessionID);
                } else {
                    connection = dataSource.getConnection();
                    this.manualCommitConnectionMapBySession.put(sessionID, connection);
                }
                this.manualCommitLastCommandMapBySession.put(sessionID, String.valueOf(command) + currentTime);
            }
        } else {
            connection = dataSource.getConnection();
            if (this.databaseReadOnlyEnableList.get(this.databaseIDList.indexOf(dbID)).booleanValue()) {
                connection.setReadOnly(true);
            }
            this.lastCommandList.add(this.databaseIDList.indexOf(dbID), String.valueOf(command) + currentTime);
        }
        return connection;
    }

    private void callProcedure(String sessionID, String method, String dbID) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnectionForSession(sessionID, dbID, method);
            if (conn == null) {
                throw new Exception("DB-connection is not available now.");
            }
            stmt = conn.createStatement();
            stmt.executeUpdate(method);
        }
        finally {
            if (conn != null && (sessionID.equals("") || !dbID.equals(""))) {
                conn.commit();
                conn.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void closeConnectionForSession(String sessionID, String method) throws Exception {
        if (!sessionID.equals("") && (method.toUpperCase().equals("COMMIT") || method.toUpperCase().equals("ROLLBACK")) && this.manualCommitConnectionMapBySession.containsKey(sessionID)) {
            Connection connection = this.manualCommitConnectionMapBySession.get(sessionID);
            if (method.toUpperCase().equals("COMMIT")) {
                connection.commit();
            }
            if (method.toUpperCase().equals("ROLLBACK")) {
                connection.rollback();
            }
            this.manualCommitConnectionMapBySession.remove(sessionID);
            this.manualCommitLastCommandMapBySession.remove(sessionID);
            connection.close();
        }
    }
}

