/*
 * Decompiled with CFR 0.152.
 */
package xeadServer;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class Relation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> fieldIDList = new ArrayList();
    private ArrayList<ArrayList<Object>> fieldValueList = new ArrayList();
    private int currentRowIndex;
    private String tableID_ = "";

    public Relation(ResultSet rset) {
        try {
            this.currentRowIndex = -1;
            ResultSetMetaData metaData = rset.getMetaData();
            this.tableID_ = metaData.getTableName(1).toUpperCase();
            int columnCount = metaData.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                this.fieldIDList.add(metaData.getColumnName(i + 1).toUpperCase());
                ++i;
            }
            while (rset.next()) {
                ArrayList<Object> valueList = new ArrayList<Object>();
                int fieldIndex = 1;
                while (fieldIndex <= columnCount) {
                    Object value = rset.getObject(fieldIndex);
                    valueList.add(value);
                    ++fieldIndex;
                }
                this.fieldValueList.add(valueList);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean setRowIndex(int index) {
        this.currentRowIndex = index;
        if (this.fieldValueList.size() > 0 && this.currentRowIndex >= 0 && this.currentRowIndex < this.fieldValueList.size()) {
            return true;
        }
        this.currentRowIndex = -1;
        return false;
    }

    public boolean next() {
        ++this.currentRowIndex;
        if (this.fieldValueList.size() > 0 && this.currentRowIndex >= 0 && this.currentRowIndex < this.fieldValueList.size()) {
            return true;
        }
        this.currentRowIndex = -1;
        return false;
    }

    public boolean previous() {
        --this.currentRowIndex;
        if (this.fieldValueList.size() > 0 && this.currentRowIndex >= 0 && this.currentRowIndex < this.fieldValueList.size()) {
            return true;
        }
        this.currentRowIndex = -1;
        return false;
    }

    public Object getValueOf(String fieldID) throws Exception {
        Object value = null;
        if (this.fieldValueList.size() > 0 && this.currentRowIndex >= 0 && this.currentRowIndex < this.fieldValueList.size()) {
            ArrayList<Object> valueList = this.fieldValueList.get(this.currentRowIndex);
            int fieldIndex = this.fieldIDList.indexOf(fieldID);
            if (fieldIndex == -1) {
                String message = "Field not contained in the result set is required.\n" + this.tableID_ + ", " + fieldID;
                JOptionPane.showMessageDialog(null, message);
                throw new Exception(message);
            }
            value = valueList.get(fieldIndex);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public boolean hasValueOf(String fieldID) {
        return this.fieldIDList.contains(fieldID);
    }

    public int getIndexOfFieldId(String fieldID) {
        return this.fieldIDList.indexOf(fieldID);
    }

    public String getFieldIdOfIndex(int index) {
        return this.fieldIDList.get(index);
    }

    public int getRowCount() {
        return this.fieldValueList.size();
    }

    public int getColumnCount() {
        return this.fieldIDList.size();
    }
}

