/*
 * Decompiled with CFR 0.152.
 */
package xeadServer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class XFExcelFileOperator {
    private File file_ = null;
    private Workbook workbook_ = null;
    private boolean isError = false;

    public XFExcelFileOperator(String fileName) {
        this.file_ = new File(fileName);
        if (this.file_.exists()) {
            try {
                FileInputStream is = new FileInputStream(this.file_);
                this.workbook_ = WorkbookFactory.create((InputStream)is);
                ((InputStream)is).close();
            }
            catch (Exception e) {
                this.isError = true;
            }
        }
    }

    public boolean commit() {
        try {
            FileOutputStream os = new FileOutputStream(this.file_);
            this.workbook_.write((OutputStream)os);
        }
        catch (Exception e) {
            this.isError = true;
        }
        return this.isError;
    }

    public int getLastRowIndex(int indexOfSheet) {
        int num = 0;
        try {
            Sheet sheet = this.workbook_.getSheetAt(indexOfSheet);
            num = sheet.getLastRowNum();
        }
        catch (Exception e) {
            num = -1;
        }
        return num;
    }

    public Object getValueAt(int indexOfSheet, int indexOfRow, int indexOfColumn) {
        Comparable<Date> value = "";
        try {
            Sheet sheet = this.workbook_.getSheetAt(indexOfSheet);
            Row row = sheet.getRow(indexOfRow);
            Cell cell = row.getCell(indexOfColumn);
            if (cell.getCellType() == 1) {
                value = cell.getStringCellValue();
            }
            if (cell.getCellType() == 0) {
                value = DateUtil.isCellDateFormatted((Cell)cell) ? cell.getDateCellValue() : Double.valueOf(cell.getNumericCellValue());
            }
            if (cell.getCellType() == 4) {
                value = cell.getBooleanCellValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public boolean setValueAt(int indexOfSheet, int indexOfRow, int indexOfColumn, String value) {
        boolean isOkay = true;
        try {
            Sheet sheet = this.workbook_.getSheetAt(indexOfSheet);
            Row row = sheet.getRow(indexOfRow);
            Cell cell = row.getCell(indexOfColumn);
            int type = cell.getCellType();
            if (type == 0) {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    String date = value.replaceAll("/", "");
                    date = value.replaceAll("-", "").trim();
                    int year = Integer.parseInt(date.substring(0, 4));
                    int month = Integer.parseInt(date.substring(4, 6));
                    int day = Integer.parseInt(date.substring(6, 8));
                    Calendar cal = Calendar.getInstance();
                    cal.set(year, month - 1, day);
                    cell.setCellValue(cal);
                } else {
                    Double doubleValue = Double.parseDouble(value);
                    cell.setCellValue(doubleValue.doubleValue());
                }
            } else {
                cell.setCellValue(value);
            }
            cell.setCellType(type);
        }
        catch (Exception e) {
            isOkay = false;
        }
        return isOkay;
    }
}

