/*
 * Decompiled with CFR 0.152.
 */
package xeadServer;

import java.awt.Color;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import xeadDriver.XFUtility;
import xeadServer.XFFieldScriptable;
import xeadServer.XFTableEvaluator;
import xeadServer.XFTableOperator;

class XFTableEvaluator_Field
implements XFFieldScriptable {
    private String tableID_ = "";
    private String tableAlias_ = "";
    private String fieldID_ = "";
    private String fieldName = "";
    private int dataSize = 5;
    private String dataType = "";
    private String dataTypeOptions = "";
    private ArrayList<String> dataTypeOptionList;
    private String autoNumberKey = "";
    private String errorMessage = "";
    private Object value_ = null;
    private Object oldValue_ = null;
    private boolean isNullable = true;
    private boolean isKey = false;
    private boolean isNoUpdate = false;
    private boolean isFieldOnPrimaryTable = false;
    private boolean isError = false;
    private boolean isVirtualField = false;
    private boolean isEditable = true;
    private boolean isAutoDetailRowNumber = false;
    private Color foreground = Color.black;
    private XFTableEvaluator evaluator_;

    public XFTableEvaluator_Field(String tableID, String tableAlias, String fieldID, XFTableEvaluator evaluator) {
        String wrkStr;
        this.tableID_ = tableID;
        this.tableAlias_ = tableAlias;
        if (this.tableAlias_.equals("")) {
            this.tableAlias_ = tableID;
        }
        this.fieldID_ = fieldID;
        this.evaluator_ = evaluator;
        Element fieldElement = this.evaluator_.getSession().getFieldElement(this.tableID_, this.fieldID_);
        this.dataType = fieldElement.getAttribute("Type");
        this.fieldName = fieldElement.getAttribute("Name");
        this.dataSize = Integer.parseInt(fieldElement.getAttribute("Size"));
        this.dataTypeOptions = fieldElement.getAttribute("TypeOptions");
        this.dataTypeOptionList = XFUtility.getOptionList((String)this.dataTypeOptions);
        if (fieldElement.getAttribute("Nullable").equals("F")) {
            this.isNullable = false;
        }
        if (fieldElement.getAttribute("NoUpdate").equals("T")) {
            this.isNoUpdate = true;
        }
        if (this.dataTypeOptionList.contains("VIRTUAL")) {
            this.isVirtualField = true;
        }
        if (this.tableID_.equals(this.evaluator_.getTableID()) && this.tableAlias_.equals(this.tableID_)) {
            this.isFieldOnPrimaryTable = true;
            this.isEditable = false;
            ArrayList<String> keyFieldIDList = this.evaluator_.getKeyFieldList();
            int i = 0;
            while (i < keyFieldIDList.size()) {
                if (keyFieldIDList.get(i).equals(this.fieldID_)) {
                    this.isKey = true;
                    break;
                }
                ++i;
            }
            if (this.fieldID_.equals(this.evaluator_.getDetailRowNoID())) {
                this.isAutoDetailRowNumber = true;
            }
        } else {
            this.isEditable = true;
        }
        if (!(wrkStr = XFUtility.getOptionValueWithKeyword((String)this.dataTypeOptions, (String)"AUTO_NUMBER")).equals("")) {
            this.autoNumberKey = wrkStr;
        }
        this.setValue(this.getNullValue());
        this.setOldValue(this.getNullValue());
    }

    @Override
    public String getDataSourceID() {
        return String.valueOf(this.tableAlias_) + "_" + this.fieldID_;
    }

    @Override
    public String getFieldID() {
        return this.fieldID_;
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    public String getTableAlias() {
        return this.tableAlias_;
    }

    @Override
    public String getTableID() {
        return this.tableID_;
    }

    public boolean isAutoDetailRowNumber() {
        return this.isAutoDetailRowNumber;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isVirtualField() {
        return this.isVirtualField;
    }

    public String getBasicType() {
        return XFUtility.getBasicTypeOf((String)this.dataType);
    }

    public ArrayList<String> getTypeOptionList() {
        return this.dataTypeOptionList;
    }

    public boolean isFieldOnPrimaryTable() {
        return this.isFieldOnPrimaryTable;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setError(boolean error) {
        this.isError = error;
    }

    @Override
    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    public boolean isNoUpdate() {
        return this.isNoUpdate;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    public void setValueOfResultSet(XFTableOperator operator) {
        try {
            if (!this.isVirtualField) {
                this.value_ = operator.getValueOf(this.getFieldID());
                String basicType = this.getBasicType();
                if (basicType.equals("INTEGER")) {
                    this.value_ = Integer.parseInt(operator.getValueOf(this.getFieldID()).toString());
                }
                if (basicType.equals("FLOAT")) {
                    this.value_ = Float.valueOf(Float.parseFloat(operator.getValueOf(this.getFieldID()).toString()));
                }
                if (basicType.equals("STRING") || basicType.equals("TIME") || basicType.equals("DATETIME") || basicType.equals("DATE") || basicType.equals("BYTEA")) {
                    this.value_ = operator.getValueOf(this.getFieldID()).toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.evaluator_.getExceptionStream());
            this.evaluator_.setErrorAndCloseFunction();
        }
    }

    @Override
    public void setValue(Object object) {
        this.value_ = object;
    }

    public Object getNullValue() {
        return XFUtility.getNullValueOfBasicType((String)this.getBasicType());
    }

    public boolean isNull() {
        return XFUtility.isNullValue((String)this.getBasicType(), (Object)this.value_);
    }

    public boolean isTooLong() {
        String wrkStr;
        boolean isError = false;
        if (this.dataType.equals("CHAR") && this.value_ != null && (wrkStr = this.value_.toString()).length() > this.dataSize) {
            isError = true;
        }
        return isError;
    }

    @Override
    public void setOldValue(Object object) {
        this.oldValue_ = object;
    }

    @Override
    public Object getOldValue() {
        return this.oldValue_;
    }

    public void checkError() {
        if (!this.isNullable() && this.getNullValue().equals(this.value_)) {
            this.setError(XFUtility.RESOURCE.getString("FunctionError16"));
        }
        if (this.isNoUpdate() && this.isValueChanged()) {
            this.setError(XFUtility.RESOURCE.getString("FunctionError51"));
        }
        if (this.isTooLong()) {
            this.setError(XFUtility.RESOURCE.getString("FunctionError55"));
        }
        if (!this.isError) {
            int yearValue;
            String value;
            StringTokenizer tokenizer;
            boolean isMatched;
            String wrkStr = XFUtility.getOptionValueWithKeyword((String)this.dataTypeOptions, (String)"KUBUN");
            if (!(wrkStr.equals("") || this.isNullable && this.value_.toString().equals(""))) {
                isMatched = false;
                String sql = "select * from " + this.evaluator_.getSession().getTableNameOfUserVariants() + " where IDUSERKUBUN = '" + wrkStr + "' order by SQLIST";
                XFTableOperator operator = this.evaluator_.getInstance().createTableOperator(sql);
                try {
                    while (operator.next()) {
                        if (!operator.getValueOf("KBUSERKUBUN").toString().trim().equals(this.value_)) continue;
                        isMatched = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!isMatched) {
                    this.setError(XFUtility.RESOURCE.getString("FunctionError25"));
                }
            }
            if (!((wrkStr = XFUtility.getOptionValueWithKeyword((String)this.dataTypeOptions, (String)"VALUES")).equals("") || this.isNullable && this.value_.toString().equals(""))) {
                isMatched = false;
                tokenizer = new StringTokenizer(wrkStr, ";");
                while (tokenizer.hasMoreTokens()) {
                    if (!tokenizer.nextToken().equals(this.value_)) continue;
                    isMatched = true;
                    break;
                }
                if (!isMatched) {
                    this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                }
            }
            if (!((wrkStr = XFUtility.getOptionValueWithKeyword((String)this.dataTypeOptions, (String)"BOOLEAN")).equals("") || this.isNullable && this.value_.toString().equals(""))) {
                isMatched = false;
                tokenizer = new StringTokenizer(wrkStr, ";");
                while (tokenizer.hasMoreTokens()) {
                    if (!tokenizer.nextToken().equals(this.value_)) continue;
                    isMatched = true;
                    break;
                }
                if (!isMatched) {
                    this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                }
            }
            if (!(!this.dataType.equals("DATE") || this.isNullable && this.value_.toString().equals(""))) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    format.parse(this.value_.toString());
                }
                catch (ParseException e) {
                    this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                }
            }
            if (!(!this.dataTypeOptionList.contains("YMONTH") || this.isNullable && this.value_.toString().equals(""))) {
                GregorianCalendar calendar = new GregorianCalendar();
                int currentYear = calendar.get(1);
                int minimumYear = currentYear - 30;
                int maximumYear = currentYear + 10;
                value = this.value_.toString();
                if (value.length() == 6) {
                    try {
                        yearValue = Integer.parseInt(value.substring(0, 4));
                        int monthValue = Integer.parseInt(value.substring(4, 6));
                        if (yearValue < minimumYear || yearValue > maximumYear || monthValue < 1 || monthValue > 12) {
                            this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                        }
                    }
                    catch (NumberFormatException e) {
                        this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                    }
                } else {
                    this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                }
            }
            if (!(!this.dataTypeOptionList.contains("MSEQ") || this.isNullable && this.value_.toString().equals(""))) {
                try {
                    int monthValue = Integer.parseInt(this.value_.toString());
                    if (monthValue < 1 || monthValue > 12) {
                        this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                    }
                }
                catch (NumberFormatException e) {
                    this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                }
            }
            if (!(!this.dataTypeOptionList.contains("FYEAR") || this.isNullable && this.value_.toString().equals(""))) {
                GregorianCalendar calendar = new GregorianCalendar();
                int currentYear = calendar.get(1);
                int minimumYear = currentYear - 30;
                int maximumYear = currentYear + 10;
                value = this.value_.toString();
                if (value.length() == 4) {
                    try {
                        yearValue = Integer.parseInt(value);
                        if (yearValue < minimumYear || yearValue > maximumYear) {
                            this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                        }
                    }
                    catch (NumberFormatException e) {
                        this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                    }
                } else {
                    this.setError(XFUtility.RESOURCE.getString("FunctionError23"));
                }
            }
        }
    }

    @Override
    public boolean isValueChanged() {
        return !this.getValue().equals(this.getOldValue());
    }

    public String getAutoNumber() {
        String value = "";
        if (!this.autoNumberKey.equals("") && this.isFieldOnPrimaryTable) {
            value = this.evaluator_.getSession().getNextNumber(this.autoNumberKey);
        }
        return value;
    }

    public boolean isAutoNumberField() {
        return !this.autoNumberKey.equals("") && this.isFieldOnPrimaryTable;
    }

    public boolean isError() {
        return this.isError;
    }

    @Override
    public Object getValue() {
        return this.value_;
    }

    @Override
    public void setError(String message) {
        if (!message.equals("")) {
            this.setError(true);
            this.errorMessage = this.errorMessage.equals("") ? message : String.valueOf(this.errorMessage) + " " + message;
        }
    }

    @Override
    public String getError() {
        return this.errorMessage;
    }

    @Override
    public void setColor(String color) {
        this.foreground = XFUtility.convertStringToColor((String)color);
    }

    @Override
    public String getColor() {
        return XFUtility.convertColorToString((Color)this.foreground);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void setValueList(String[] valueList) {
    }

    @Override
    public String[] getValueList() {
        return new String[0];
    }
}

