/*
 * Decompiled with CFR 0.152.
 */
package xeadServer;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import xeadDriver.XFUtility;
import xeadServer.XFTableEvaluator;
import xeadServer.XFTableEvaluator_Field;

class XFTableEvaluator_ReferTable {
    private Element referElement_ = null;
    private Element tableElement = null;
    private String tableID = "";
    private String moduleID = "";
    private String tableAlias = "";
    private String activeWhere = "";
    private ArrayList<String> fieldIDList = new ArrayList();
    private ArrayList<XFTableEvaluator_Field> fieldList = new ArrayList();
    private ArrayList<String> toKeyFieldIDList = new ArrayList();
    private ArrayList<String> withKeyFieldIDList = new ArrayList();
    private boolean isOptional = false;
    private String dbName = "";
    private XFTableEvaluator evaluator_;

    public XFTableEvaluator_ReferTable(Element referElement, XFTableEvaluator evaluator) {
        String dbID;
        this.referElement_ = referElement;
        this.evaluator_ = evaluator;
        this.tableID = this.referElement_.getAttribute("ToTable");
        this.tableElement = this.evaluator_.getSession().getTableElement(this.tableID);
        this.moduleID = this.tableID;
        if (!this.tableElement.getAttribute("ModuleID").equals("")) {
            this.moduleID = this.tableElement.getAttribute("ModuleID");
        }
        this.dbName = (dbID = this.tableElement.getAttribute("DB")).equals("") ? this.evaluator_.getSession().getDatabaseName() : this.evaluator_.getSession().getSubDBName(dbID);
        this.activeWhere = this.tableElement.getAttribute("ActiveWhere");
        this.tableAlias = this.referElement_.getAttribute("TableAlias");
        if (this.tableAlias.equals("")) {
            this.tableAlias = this.tableID;
        }
        StringTokenizer workTokenizer = new StringTokenizer(this.referElement_.getAttribute("Fields"), ";");
        while (workTokenizer.hasMoreTokens()) {
            String workFieldID = workTokenizer.nextToken();
            this.fieldIDList.add(workFieldID);
            this.fieldList.add(new XFTableEvaluator_Field(this.tableID, this.tableAlias, workFieldID, this.evaluator_));
        }
        if (this.referElement_.getAttribute("ToKeyFields").equals("")) {
            Element workElement = this.evaluator_.getSession().getTablePKElement(this.tableID);
            workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
            while (workTokenizer.hasMoreTokens()) {
                this.toKeyFieldIDList.add(workTokenizer.nextToken());
            }
        } else {
            workTokenizer = new StringTokenizer(this.referElement_.getAttribute("ToKeyFields"), ";");
            while (workTokenizer.hasMoreTokens()) {
                this.toKeyFieldIDList.add(workTokenizer.nextToken());
            }
        }
        workTokenizer = new StringTokenizer(this.referElement_.getAttribute("WithKeyFields"), ";");
        while (workTokenizer.hasMoreTokens()) {
            this.withKeyFieldIDList.add(workTokenizer.nextToken());
        }
        if (this.referElement_.getAttribute("Optional").equals("T")) {
            this.isOptional = true;
        }
    }

    public String getSelectSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append("select ");
        int count = 0;
        int i = 0;
        while (i < this.fieldIDList.size()) {
            Element workElement = this.evaluator_.getSession().getFieldElement(this.tableID, this.fieldIDList.get(i));
            if (!XFUtility.getOptionList((String)workElement.getAttribute("TypeOptions")).contains("VIRTUAL")) {
                if (count > 0) {
                    buf.append(",");
                }
                ++count;
                buf.append(this.fieldIDList.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.toKeyFieldIDList.size()) {
            if (count > 0) {
                buf.append(",");
            }
            ++count;
            buf.append(this.toKeyFieldIDList.get(i));
            ++i;
        }
        buf.append(" from ");
        buf.append(this.moduleID);
        count = 0;
        int i2 = 0;
        while (i2 < this.toKeyFieldIDList.size()) {
            if (count == 0) {
                buf.append(" where ");
            } else {
                buf.append(" and ");
            }
            buf.append(this.toKeyFieldIDList.get(i2));
            buf.append("=");
            int j = 0;
            while (j < this.evaluator_.getFieldList().size()) {
                String dataSourceName = String.valueOf(this.evaluator_.getFieldList().get(j).getTableAlias()) + "." + this.evaluator_.getFieldList().get(j).getFieldID();
                if (this.withKeyFieldIDList.get(i2).equals(dataSourceName)) {
                    buf.append(XFUtility.getTableOperationValue((String)this.evaluator_.getFieldList().get(j).getBasicType(), (Object)this.evaluator_.getFieldList().get(j).getValue(), (String)this.dbName));
                    break;
                }
                ++j;
            }
            ++count;
            ++i2;
        }
        if (!this.activeWhere.equals("")) {
            if (count == 0) {
                buf.append(" where ");
            } else {
                buf.append(" and ");
            }
            buf.append(this.activeWhere);
        }
        return buf.toString();
    }

    public String getTableID() {
        return this.tableID;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isKeyNullable() {
        boolean isKeyNullable = false;
        int i = 0;
        while (i < this.withKeyFieldIDList.size()) {
            int j = 0;
            while (j < this.evaluator_.getFieldList().size()) {
                String dataSourceName = String.valueOf(this.evaluator_.getFieldList().get(j).getTableAlias()) + "." + this.evaluator_.getFieldList().get(j).getFieldID();
                if (this.withKeyFieldIDList.get(i).equals(dataSourceName) && this.evaluator_.getFieldList().get(j).isNullable()) {
                    isKeyNullable = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return isKeyNullable;
    }

    public boolean isKeyNull() {
        boolean isKeyNull = false;
        int i = 0;
        while (i < this.withKeyFieldIDList.size()) {
            int j = 0;
            while (j < this.evaluator_.getFieldList().size()) {
                String dataSourceName = String.valueOf(this.evaluator_.getFieldList().get(j).getTableAlias()) + "." + this.evaluator_.getFieldList().get(j).getFieldID();
                if (this.withKeyFieldIDList.get(i).equals(dataSourceName) && this.evaluator_.getFieldList().get(j).isNull()) {
                    isKeyNull = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return isKeyNull;
    }

    public void setErrorOnRelatedFields() {
        int i = 0;
        while (i < this.toKeyFieldIDList.size()) {
            int j = 0;
            while (j < this.evaluator_.getFieldList().size()) {
                String dataSourceName = String.valueOf(this.evaluator_.getFieldList().get(j).getTableAlias()) + "." + this.evaluator_.getFieldList().get(j).getFieldID();
                if (this.withKeyFieldIDList.get(i).equals(dataSourceName) && !this.evaluator_.getFieldList().get(j).isError()) {
                    this.evaluator_.getFieldList().get(j).setError(String.valueOf(XFUtility.RESOURCE.getString("FunctionError53")) + this.tableElement.getAttribute("Name") + XFUtility.RESOURCE.getString("FunctionError45"));
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public ArrayList<String> getKeyFieldIDList() {
        return this.toKeyFieldIDList;
    }

    public ArrayList<String> getFieldIDList() {
        return this.fieldIDList;
    }

    public ArrayList<XFTableEvaluator_Field> getFieldList() {
        return this.fieldList;
    }

    public ArrayList<String> getWithKeyFieldIDList() {
        return this.withKeyFieldIDList;
    }
}

