/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.LOBInputStream;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

final class ClobUpdatableReader
extends Reader {
    private Reader streamReader;
    private long pos;
    private InputStream stream = null;
    private ConnectionChild conChild;
    private boolean materialized;
    private final EmbedClob clob;
    private final long maxPos;

    ClobUpdatableReader(LOBInputStream lOBInputStream, ConnectionChild connectionChild) throws IOException {
        this.clob = null;
        this.materialized = true;
        this.conChild = connectionChild;
        this.stream = lOBInputStream;
        this.maxPos = Long.MAX_VALUE;
        this.init(lOBInputStream, 0L);
    }

    ClobUpdatableReader(EmbedClob embedClob) throws IOException, SQLException {
        this(embedClob, 0L, Long.MAX_VALUE);
    }

    ClobUpdatableReader(EmbedClob embedClob, long l, long l2) throws IOException, SQLException {
        this.clob = embedClob;
        this.conChild = embedClob;
        this.maxPos = l + l2;
        InternalClob internalClob = embedClob.getInternalClob();
        this.materialized = internalClob.isWritable();
        if (this.materialized) {
            long l3 = internalClob.getByteLength();
            this.stream = internalClob.getRawByteStream();
            this.init((LOBInputStream)this.stream, l);
        } else {
            this.streamReader = internalClob.getReader(l + 1L);
            this.pos = l;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.updateIfRequired();
        if (this.pos >= this.maxPos) {
            return -1;
        }
        int n3 = (int)Math.min((long)n2, this.maxPos - this.pos);
        int n4 = this.streamReader.read(cArray, n, n3);
        if (n4 >= 0) {
            this.pos += (long)n4;
        }
        return n4;
    }

    public void close() throws IOException {
        this.streamReader.close();
    }

    private void init(LOBInputStream lOBInputStream, long l) throws IOException {
        long l2;
        this.streamReader = new UTF8Reader(lOBInputStream, 0L, lOBInputStream.length(), this.conChild, this.conChild.getConnectionSynchronization());
        for (long i = l; i > 0L; i -= l2) {
            l2 = this.streamReader.skip(i);
            if (l2 != 0L) continue;
            if (this.streamReader.read() == -1) {
                throw new EOFException(MessageService.getCompleteMessage("XJ085.S", new Object[0]));
            }
            l2 = 1L;
        }
        this.pos = l;
    }

    private void updateIfRequired() throws IOException {
        if (this.materialized) {
            LOBInputStream lOBInputStream = (LOBInputStream)this.stream;
            if (lOBInputStream.isObsolete()) {
                lOBInputStream.reInitialize();
                this.init(lOBInputStream, this.pos);
            }
        } else if (this.clob.getInternalClob().isWritable()) {
            try {
                this.stream = this.clob.getInternalClob().getRawByteStream();
            }
            catch (SQLException sQLException) {
                throw Util.newIOException(sQLException);
            }
            this.init((LOBInputStream)this.stream, this.pos);
            this.materialized = true;
        }
    }
}

