/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.PlainDocument;
import xeadDriver.ModifyPasswordDialog_jButtonClose_actionAdapter;
import xeadDriver.ModifyPasswordDialog_jButtonOK_actionAdapter;
import xeadDriver.Session;
import xeadDriver.XFTableOperator;
import xeadDriver.XFUtility;

public class DialogModifyPassword
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelMain = new JPanel();
    private JButton jButtonOK = new JButton();
    private JButton jButtonClose = new JButton();
    private JLabel jLabelUserName = new JLabel();
    private JTextField jTextFieldUserName = new JTextField();
    private JLabel jLabelPasswordCurrent = new JLabel();
    private JPasswordField jPasswordCurrent = new JPasswordField();
    private JLabel jLabelPasswordNew1 = new JLabel();
    private JPasswordField jPasswordNew1 = new JPasswordField();
    private JLabel jLabelPasswordNew2 = new JLabel();
    private JPasswordField jPasswordNew2 = new JPasswordField();
    private Session session = null;
    private String userID = "";
    private boolean modified = false;
    private Image imageTitle;

    public DialogModifyPassword(Session session) {
        super(session, "", true);
        try {
            this.imageTitle = Toolkit.getDefaultToolkit().createImage(DialogModifyPassword.class.getResource("ikey.png"));
            this.setIconImage(this.imageTitle);
            this.session = session;
            this.setTitle(XFUtility.RESOURCE.getString("ModifyPassword"));
            this.jPanelMain.setBorder(BorderFactory.createEtchedBorder());
            this.jPanelMain.setPreferredSize(new Dimension(395, 200));
            this.jPanelMain.setLayout(null);
            this.jLabelUserName.setHorizontalAlignment(4);
            this.jLabelUserName.setBounds(new Rectangle(5, 17, 150, 25));
            this.jLabelUserName.setFont(new Font(session.systemFont, 0, 18));
            this.jLabelUserName.setText(XFUtility.RESOURCE.getString("UserName"));
            this.jTextFieldUserName.setFont(new Font(session.systemFont, 0, 18));
            this.jTextFieldUserName.setBounds(new Rectangle(160, 17, 220, 25));
            this.jTextFieldUserName.setEditable(false);
            this.jLabelPasswordCurrent.setHorizontalAlignment(4);
            this.jLabelPasswordCurrent.setBounds(new Rectangle(5, 50, 150, 25));
            this.jLabelPasswordCurrent.setFont(new Font(session.systemFont, 0, 18));
            this.jLabelPasswordCurrent.setText(XFUtility.RESOURCE.getString("PasswordCurrent"));
            this.jPasswordCurrent.setFont(new Font(session.systemFont, 0, 18));
            this.jPasswordCurrent.setBounds(new Rectangle(160, 50, 220, 25));
            this.jPasswordCurrent.setDocument(new LimitedDocument(10));
            this.jLabelPasswordNew1.setHorizontalAlignment(4);
            this.jLabelPasswordNew1.setBounds(new Rectangle(5, 83, 150, 25));
            this.jLabelPasswordNew1.setFont(new Font(session.systemFont, 0, 18));
            this.jLabelPasswordNew1.setText(XFUtility.RESOURCE.getString("PasswordNew"));
            this.jPasswordNew1.setFont(new Font(session.systemFont, 0, 18));
            this.jPasswordNew1.setBounds(new Rectangle(160, 83, 220, 25));
            this.jPasswordNew1.setDocument(new LimitedDocument(10));
            this.jLabelPasswordNew2.setHorizontalAlignment(4);
            this.jLabelPasswordNew2.setBounds(new Rectangle(5, 116, 150, 25));
            this.jLabelPasswordNew2.setFont(new Font(session.systemFont, 0, 18));
            this.jLabelPasswordNew2.setText(XFUtility.RESOURCE.getString("PasswordNew"));
            this.jPasswordNew2.setFont(new Font(session.systemFont, 0, 18));
            this.jPasswordNew2.setBounds(new Rectangle(160, 116, 220, 25));
            this.jPasswordNew2.setDocument(new LimitedDocument(10));
            this.jButtonClose.setBounds(new Rectangle(25, 158, 150, 30));
            this.jButtonClose.setFont(new Font(session.systemFont, 0, 18));
            this.jButtonClose.setText(XFUtility.RESOURCE.getString("Close"));
            this.jButtonClose.addActionListener(new ModifyPasswordDialog_jButtonClose_actionAdapter(this));
            this.jButtonOK.setBounds(new Rectangle(220, 158, 150, 30));
            this.jButtonOK.setFont(new Font(session.systemFont, 0, 18));
            this.jButtonOK.setText(XFUtility.RESOURCE.getString("Modify"));
            this.jButtonOK.addActionListener(new ModifyPasswordDialog_jButtonOK_actionAdapter(this));
            this.getContentPane().add((Component)this.jPanelMain, "Center");
            this.jPanelMain.add((Component)this.jButtonClose, null);
            this.jPanelMain.add((Component)this.jButtonOK, null);
            this.jPanelMain.add((Component)this.jLabelUserName, null);
            this.jPanelMain.add((Component)this.jTextFieldUserName, null);
            this.jPanelMain.add((Component)this.jLabelPasswordCurrent, null);
            this.jPanelMain.add((Component)this.jPasswordCurrent, null);
            this.jPanelMain.add((Component)this.jLabelPasswordNew1, null);
            this.jPanelMain.add((Component)this.jPasswordNew1, null);
            this.jPanelMain.add((Component)this.jLabelPasswordNew2, null);
            this.jPanelMain.add((Component)this.jPasswordNew2, null);
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean passwordModified() {
        this.userID = this.session.getUserID();
        this.jTextFieldUserName.setText(this.session.getUserName());
        this.jPanelMain.getRootPane().setDefaultButton(this.jButtonOK);
        Dimension dlgSize = this.getPreferredSize();
        Rectangle screenRect = this.session.getMenuRectangle();
        this.setLocation((screenRect.width - dlgSize.width) / 2 + screenRect.x, (screenRect.height - dlgSize.height) / 2 + screenRect.y);
        this.pack();
        this.jPasswordCurrent.setText("");
        this.jPasswordNew1.setText("");
        this.jPasswordNew2.setText("");
        this.jPasswordCurrent.requestFocus();
        super.setVisible(true);
        return this.modified;
    }

    void jButtonOK_actionPerformed(ActionEvent e) {
        try {
            this.setCursor(new Cursor(3));
            if (this.passwordValidated()) {
                this.modified = true;
                this.setVisible(false);
            } else {
                this.jPasswordCurrent.setText("");
                this.jPasswordNew1.setText("");
                this.jPasswordNew2.setText("");
                this.jPasswordCurrent.requestFocus();
            }
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    boolean passwordValidated() {
        boolean validated;
        block7: {
            String passwordNew1 = "";
            String passwordNew2 = "";
            String passwordCurrent = "";
            validated = false;
            passwordCurrent = new String(this.jPasswordCurrent.getPassword());
            String passwordCurrentDigested = this.session.getDigestedValueForUser(passwordCurrent);
            passwordNew1 = new String(this.jPasswordNew1.getPassword());
            String passwordNewDigested = this.session.getDigestedValueForUser(passwordNew1);
            passwordNew2 = new String(this.jPasswordNew2.getPassword());
            if (passwordNew1.length() < 5) {
                JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("ModifyPasswordError1"));
            } else if (passwordNew1.equals(passwordNew2)) {
                try {
                    StringBuffer statementBuf = new StringBuffer();
                    statementBuf.append("update ");
                    statementBuf.append(this.session.getTableNameOfUser());
                    statementBuf.append(" set TXPASSWORD = '");
                    statementBuf.append(passwordNewDigested);
                    statementBuf.append("' where IDUSER = '");
                    statementBuf.append(this.userID);
                    statementBuf.append("' and TXPASSWORD = '");
                    statementBuf.append(passwordCurrentDigested);
                    statementBuf.append("'");
                    XFTableOperator operator = new XFTableOperator(this.session, null, statementBuf.toString(), true);
                    int count = operator.execute();
                    if (count == 1) {
                        validated = true;
                        break block7;
                    }
                    JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("ModifyPasswordError2"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("ModifyPasswordError3"));
            }
        }
        return validated;
    }

    void jButtonClose_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    class LimitedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        int limit;

        LimitedDocument(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) {
            if (offset >= this.limit) {
                return;
            }
            try {
                super.insertString(offset, str, a);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

