/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;
import xeadDriver.Session;
import xeadDriver.XFExecutable;
import xeadDriver.XFScriptable;
import xeadDriver.XFTableEvaluator;
import xeadDriver.XFTableOperator;
import xeadDriver.XFUtility;

public class XF000
extends JDialog
implements XFExecutable,
XFScriptable {
    private static final long serialVersionUID = 1L;
    private Element functionElement_ = null;
    private HashMap<String, Object> parmMap_ = null;
    private HashMap<String, Object> returnMap_ = new HashMap();
    private Session session_ = null;
    private boolean instanceIsAvailable_ = true;
    private int programSequence;
    private int instanceArrayIndex_ = -1;
    private StringBuffer processLog = new StringBuffer();
    private ScriptEngine scriptEngine;
    private Bindings engineScriptBindings;
    private ByteArrayOutputStream exceptionLog;
    private PrintStream exceptionStream;
    private String exceptionHeader = "";
    private JPanel jPanelMain = new JPanel();
    private Action helpAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            XF000.this.session_.browseHelp();
        }
    };
    private Action escapeAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            XF000.this.returnTo("MENU");
        }
    };
    private Dimension scrSize;
    private JPanel jPanelTimer = new JPanel();
    private JPanel jPanelTop = new JPanel();
    private JPanel jPanelBottom = new JPanel();
    private JPanel jPanelButtons = new JPanel();
    private JPanel jPanelInfo = new JPanel();
    private JLabel jLabelTime = new JLabel();
    private JTextField jTextFieldTime = new JTextField();
    private ArrayList<String> timeList = new ArrayList();
    private String timeRepeatFrom = "";
    private String timeRepeatThru = "";
    private int intervalMilliSeconds = 0;
    private JLabel jLabelCondition = new JLabel();
    private JCheckBox jCheckBoxRepeat = new JCheckBox();
    private JCheckBox jCheckBoxRunOffDay = new JCheckBox();
    private JCheckBox jCheckBoxRunNow = new JCheckBox();
    private Calendar calendar;
    private SimpleDateFormat formatter = new SimpleDateFormat("dd-HH:mm:ss");
    private Timer timer;
    private TimerTaskScript task = null;
    private boolean alreadyRun = false;
    private boolean errorHasOccured = false;
    private String errorMessage = "";
    private boolean isExecuted = false;
    private GridLayout gridLayoutInfo = new GridLayout();
    private JLabel jLabelFunctionID = new JLabel();
    private JLabel jLabelSessionID = new JLabel();
    private JProgressBar jProgressBar = new JProgressBar();
    private JScrollPane jScrollPaneMessages = new JScrollPane();
    private JTextArea jTextAreaMessages = new JTextArea();
    private JButton jButtonExit = new JButton();
    private JButton jButtonStart = new JButton();
    private JButton jButtonStop = new JButton();
    private JButton jButtonIconify = new JButton();
    private final int FONT_SIZE = 14;
    private HashMap<String, Object> variantMap = new HashMap();

    public XF000(Session session, int instanceArrayIndex) {
        super(session, "", true);
        this.session_ = session;
        this.instanceArrayIndex_ = instanceArrayIndex;
        this.initConsole();
    }

    void initConsole() {
        this.scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.jPanelMain.setLayout(new BorderLayout());
        InputMap inputMap = this.jPanelMain.getInputMap(1);
        inputMap.clear();
        ActionMap actionMap = this.jPanelMain.getActionMap();
        actionMap.clear();
        inputMap.put(KeyStroke.getKeyStroke(112, 0), "HELP");
        actionMap.put("HELP", this.helpAction);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        actionMap.put("ESCAPE", this.escapeAction);
        this.jPanelTop.setLayout(new BorderLayout());
        this.jPanelTimer.setLayout(null);
        this.jPanelTimer.setFocusable(false);
        this.jPanelTimer.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelTimer.setPreferredSize(new Dimension(10, 75));
        this.jLabelTime.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jLabelTime.setHorizontalAlignment(4);
        this.jLabelTime.setHorizontalTextPosition(10);
        this.jLabelTime.setText(XFUtility.RESOURCE.getString("TimerTime"));
        this.jLabelTime.setBounds(new Rectangle(10, 42, 100, 20));
        this.jTextFieldTime.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jTextFieldTime.setBounds(new Rectangle(115, 40, 740, 25));
        this.jLabelCondition.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jLabelCondition.setHorizontalAlignment(4);
        this.jLabelCondition.setHorizontalTextPosition(10);
        this.jLabelCondition.setText(XFUtility.RESOURCE.getString("TimerCondition"));
        this.jLabelCondition.setBounds(new Rectangle(10, 11, 100, 20));
        this.jCheckBoxRepeat.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jCheckBoxRepeat.setText(XFUtility.RESOURCE.getString("TimerRepeat"));
        this.jCheckBoxRepeat.setBounds(new Rectangle(295, 11, 180, 20));
        this.jCheckBoxRunOffDay.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jCheckBoxRunOffDay.setText(XFUtility.RESOURCE.getString("TimerRunOffDay"));
        this.jCheckBoxRunOffDay.setBounds(new Rectangle(485, 11, 180, 20));
        this.jCheckBoxRunNow.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jCheckBoxRunNow.setText(XFUtility.RESOURCE.getString("TimerRunNow"));
        this.jCheckBoxRunNow.setBounds(new Rectangle(115, 11, 180, 20));
        this.jCheckBoxRunNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XF000.this.setRunNow();
            }
        });
        this.jPanelTimer.add(this.jLabelTime);
        this.jPanelTimer.add(this.jTextFieldTime);
        this.jPanelTimer.add(this.jLabelCondition);
        this.jPanelTimer.add(this.jCheckBoxRepeat);
        this.jPanelTimer.add(this.jCheckBoxRunOffDay);
        this.jPanelTimer.add(this.jCheckBoxRunNow);
        this.jTextAreaMessages.setEditable(false);
        this.jTextAreaMessages.setBorder(BorderFactory.createEtchedBorder());
        this.jTextAreaMessages.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jTextAreaMessages.setFocusable(false);
        this.jTextAreaMessages.setLineWrap(true);
        this.jTextAreaMessages.setWrapStyleWord(true);
        this.jTextAreaMessages.setOpaque(false);
        this.jTextAreaMessages.setFocusable(true);
        this.jScrollPaneMessages.getViewport().add((Component)this.jTextAreaMessages, null);
        this.jPanelBottom.setPreferredSize(new Dimension(10, 35));
        this.jPanelBottom.setLayout(new BorderLayout());
        this.jPanelBottom.setBorder(null);
        this.jLabelFunctionID.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jLabelFunctionID.setHorizontalAlignment(4);
        this.jLabelFunctionID.setForeground(Color.gray);
        this.jLabelFunctionID.setFocusable(false);
        this.jLabelSessionID.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jLabelSessionID.setHorizontalAlignment(4);
        this.jLabelSessionID.setForeground(Color.gray);
        this.jLabelSessionID.setFocusable(false);
        this.jPanelButtons.setBorder(null);
        this.jPanelButtons.setLayout(null);
        this.jPanelButtons.setFocusable(false);
        this.gridLayoutInfo.setColumns(1);
        this.gridLayoutInfo.setRows(2);
        this.gridLayoutInfo.setVgap(0);
        this.jPanelInfo.setLayout(this.gridLayoutInfo);
        this.jPanelInfo.add(this.jLabelSessionID);
        this.jPanelInfo.add(this.jLabelFunctionID);
        this.jPanelInfo.setFocusable(false);
        this.jProgressBar.setStringPainted(true);
        this.jPanelMain.add((Component)this.jPanelTop, "Center");
        this.jPanelMain.add((Component)this.jPanelBottom, "South");
        this.jPanelTop.add((Component)this.jPanelTimer, "North");
        this.jPanelTop.add((Component)this.jScrollPaneMessages, "Center");
        this.jPanelBottom.add((Component)this.jPanelInfo, "East");
        this.jPanelBottom.add((Component)this.jPanelButtons, "Center");
        this.jButtonExit.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jButtonExit.setText(XFUtility.RESOURCE.getString("ExitButton"));
        this.jButtonExit.setBounds(new Rectangle(5, 2, 140, 32));
        this.jButtonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XF000.this.timer != null) {
                    XF000.this.stopTimer();
                }
                if (XF000.this.functionElement_.getAttribute("TimerOption").equals("CONSOLE") && !XF000.this.isExecuted) {
                    XF000.this.returnMap_.put("RETURN_CODE", "01");
                }
                XF000.this.closeFunction();
            }
        });
        this.jButtonStart.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jButtonStart.setText(XFUtility.RESOURCE.getString("TimerStart"));
        this.jButtonStart.setBounds(new Rectangle(210, 2, 140, 32));
        this.jButtonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XF000.this.isExecuted = true;
                XF000.this.startTimer();
            }
        });
        this.jButtonStop.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jButtonStop.setText(XFUtility.RESOURCE.getString("TimerStop"));
        this.jButtonStop.setBounds(new Rectangle(415, 2, 140, 32));
        this.jButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XF000.this.timer != null) {
                    XF000.this.stopTimer();
                }
            }
        });
        this.jButtonIconify.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jButtonIconify.setText(XFUtility.RESOURCE.getString("Iconify"));
        this.jButtonIconify.setBounds(new Rectangle(620, 2, 140, 32));
        this.jButtonIconify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XF000.this.session_.setExtendedState(1 | XF000.this.session_.getExtendedState());
            }
        });
        this.jPanelButtons.add(this.jButtonExit);
        this.jPanelButtons.add(this.jButtonStart);
        this.jPanelButtons.add(this.jButtonStop);
        this.jPanelButtons.add(this.jButtonIconify);
        this.getContentPane().add((Component)this.jPanelMain, "Center");
    }

    @Override
    public HashMap<String, Object> execute(HashMap<String, Object> parmMap) {
        if (this.functionElement_ == null) {
            JOptionPane.showMessageDialog(null, "Calling function without specifications.");
            return parmMap;
        }
        return this.execute(null, parmMap);
    }

    @Override
    public HashMap<String, Object> execute(Element functionElement, HashMap<String, Object> parmMap) {
        try {
            try {
                this.parmMap_ = parmMap;
                if (this.parmMap_ == null) {
                    this.parmMap_ = new HashMap();
                }
                this.returnMap_.clear();
                this.returnMap_.putAll(this.parmMap_);
                this.returnMap_.put("RETURN_CODE", "00");
                this.instanceIsAvailable_ = false;
                this.errorHasOccured = false;
                this.exceptionLog = new ByteArrayOutputStream();
                this.exceptionStream = new PrintStream(this.exceptionLog);
                this.exceptionHeader = "";
                this.processLog.delete(0, this.processLog.length());
                this.variantMap.clear();
                this.scriptEngine = this.session_.getScriptEngineManager().getEngineByName("js");
                this.engineScriptBindings = this.scriptEngine.getBindings(100);
                this.timer = null;
                if (!(functionElement == null || this.functionElement_ != null && this.functionElement_.getAttribute("ID").equals(functionElement.getAttribute("ID")))) {
                    this.setFunctionSpecifications(functionElement);
                }
                if (this.functionElement_.getAttribute("TimerOption").equals("")) {
                    this.runScript();
                    this.closeFunction();
                } else {
                    this.jLabelSessionID.setText(this.session_.getSessionID());
                    if (this.instanceArrayIndex_ >= 0) {
                        this.jLabelFunctionID.setText("000-" + this.instanceArrayIndex_ + "-" + this.functionElement_.getAttribute("ID"));
                    } else {
                        this.jLabelFunctionID.setText("000-" + this.functionElement_.getAttribute("ID"));
                    }
                    FontMetrics metrics = this.jLabelFunctionID.getFontMetrics(new Font("Dialog", 0, 14));
                    this.jPanelInfo.setPreferredSize(new Dimension(metrics.stringWidth(this.jLabelFunctionID.getText()), 35));
                    if (this.functionElement_.getAttribute("TimerOption").contains(":") || this.functionElement_.getAttribute("TimerOption").equals("NOW")) {
                        this.setupConsoleWithTimer();
                    } else if (this.functionElement_.getAttribute("TimerOption").equals("CONSOLE")) {
                        this.setupConsoleWithoutTimer();
                    }
                    this.session_.setMessageComponent(this.jScrollPaneMessages);
                    this.setVisible(true);
                }
            }
            catch (ScriptException e) {
                this.cancelWithScriptException(e, "");
                this.instanceIsAvailable_ = true;
            }
            catch (Exception e) {
                this.cancelWithException(e);
                this.instanceIsAvailable_ = true;
            }
        }
        finally {
            this.instanceIsAvailable_ = true;
        }
        return this.returnMap_;
    }

    @Override
    public void setFunctionSpecifications(Element functionElement) throws Exception {
        this.functionElement_ = functionElement;
        this.programSequence = this.session_.writeLogOfFunctionStarted(this.functionElement_.getAttribute("ID"), this.functionElement_.getAttribute("Name"));
        if (!this.functionElement_.getAttribute("TimerOption").equals("")) {
            this.setTitle(this.functionElement_.getAttribute("Name"));
            this.setSize(new Dimension(this.scrSize.width, this.scrSize.height));
            int width = 900;
            int height = 600;
            this.setPreferredSize(new Dimension(width, height));
            int posX = (this.scrSize.width - width) / 2;
            int posY = (this.scrSize.height - height) / 2;
            this.setLocation(posX, posY);
            this.pack();
        }
    }

    void setupConsoleWithTimer() {
        if (this.functionElement_.getAttribute("TimerOption").contains(":")) {
            this.jLabelCondition.setEnabled(true);
            this.jCheckBoxRunNow.setSelected(false);
            this.jCheckBoxRunNow.setEnabled(true);
            this.jCheckBoxRepeat.setSelected(true);
            this.jCheckBoxRepeat.setEnabled(true);
            this.jCheckBoxRunOffDay.setSelected(false);
            this.jCheckBoxRunOffDay.setEnabled(true);
            this.jLabelTime.setEnabled(true);
            this.jTextFieldTime.setText(this.functionElement_.getAttribute("TimerOption"));
            this.jTextFieldTime.setEnabled(true);
        } else {
            this.jLabelCondition.setEnabled(false);
            this.jCheckBoxRunNow.setSelected(true);
            this.jCheckBoxRunNow.setEnabled(false);
            this.jCheckBoxRepeat.setSelected(false);
            this.jCheckBoxRepeat.setEnabled(false);
            this.jCheckBoxRunOffDay.setSelected(false);
            this.jCheckBoxRunOffDay.setEnabled(false);
            this.jLabelTime.setEnabled(false);
            this.jTextFieldTime.setText("");
            this.jTextFieldTime.setEnabled(false);
        }
        if (this.functionElement_.getAttribute("TimerMessage").equals("")) {
            if (this.functionElement_.getAttribute("TimerOption").contains(":")) {
                this.jTextAreaMessages.setText("> " + XFUtility.RESOURCE.getString("FunctionMessage44"));
            } else {
                this.jTextAreaMessages.setText("> " + XFUtility.RESOURCE.getString("FunctionMessage66"));
            }
        } else {
            this.jTextAreaMessages.setText(this.functionElement_.getAttribute("TimerMessage"));
        }
        this.jButtonStart.setEnabled(true);
        this.jButtonStop.setEnabled(false);
        this.jButtonIconify.setEnabled(false);
        this.jPanelBottom.remove(this.jProgressBar);
        this.jPanelBottom.add((Component)this.jPanelInfo, "East");
        this.getRootPane().setDefaultButton(this.jButtonStart);
    }

    void setupConsoleWithoutTimer() {
        this.isExecuted = false;
        this.jLabelCondition.setEnabled(false);
        this.jLabelTime.setEnabled(false);
        this.jTextFieldTime.setEnabled(false);
        this.jTextFieldTime.setText("");
        this.jTextAreaMessages.setText("");
        this.jCheckBoxRunNow.setSelected(true);
        this.jCheckBoxRunNow.setEnabled(false);
        this.jCheckBoxRepeat.setSelected(false);
        this.jCheckBoxRepeat.setEnabled(false);
        this.jCheckBoxRunOffDay.setSelected(false);
        this.jCheckBoxRunOffDay.setEnabled(false);
        if (this.functionElement_.getAttribute("TimerMessage").equals("")) {
            this.jTextAreaMessages.setText("> " + XFUtility.RESOURCE.getString("FunctionMessage66"));
        } else {
            this.jTextAreaMessages.setText("> " + this.functionElement_.getAttribute("TimerMessage"));
        }
        this.jButtonStart.setEnabled(true);
        this.jButtonStop.setEnabled(false);
        this.jButtonIconify.setEnabled(false);
        this.jPanelBottom.remove(this.jProgressBar);
        this.jPanelBottom.add((Component)this.jPanelInfo, "East");
        this.getRootPane().setDefaultButton(this.jButtonStart);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            if (this.timer != null) {
                this.stopTimer();
            }
            this.closeFunction();
        }
    }

    @Override
    public boolean isAvailable() {
        return this.instanceIsAvailable_;
    }

    @Override
    public void callFunction(String functionID) {
        if (this.isVisible()) {
            this.jTextAreaMessages.setText(this.getNewMessage(String.valueOf(this.session_.getFunctionName(functionID)) + "(" + functionID + ")", XFUtility.RESOURCE.getString("FunctionMessage38")));
            this.jScrollPaneMessages.getViewport().scrollRectToVisible(new Rectangle(0, 0x7FFFFFFE, 1, 1));
            this.jScrollPaneMessages.paintImmediately(0, 0, this.jScrollPaneMessages.getWidth(), this.jScrollPaneMessages.getHeight());
        } else {
            this.setBackgroundMessage(String.valueOf(this.session_.getFunctionName(functionID)) + "(" + functionID + ")", XFUtility.RESOURCE.getString("FunctionMessage38"));
        }
        try {
            this.returnMap_ = this.session_.executeFunction(functionID, this.parmMap_);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            if (this.isVisible()) {
                this.jTextAreaMessages.setText(this.getNewMessage(e.getMessage(), ""));
            }
            this.exceptionHeader = e.getMessage();
            this.setErrorAndCloseFunction();
        }
        if (this.returnMap_.get("RETURN_TO") != null) {
            this.returnTo(this.returnMap_.get("RETURN_TO").toString());
        }
        if (this.returnMap_.get("RETURN_CODE").equals("99")) {
            this.errorHasOccured = true;
        }
    }

    @Override
    public void setStatusMessage(String message) {
        this.setStatusMessage(message, false);
    }

    @Override
    public void setStatusMessage(String message, boolean isToReplaceLastLine) {
        if (this.isVisible()) {
            this.jTextAreaMessages.setText(this.getNewMessage(message, "", isToReplaceLastLine));
            this.jScrollPaneMessages.getViewport().scrollRectToVisible(new Rectangle(0, 0x7FFFFFFE, 1, 1));
            this.jScrollPaneMessages.paintImmediately(0, 0, this.jScrollPaneMessages.getWidth(), this.jScrollPaneMessages.getHeight());
        } else {
            this.setBackgroundMessage(message, "");
        }
    }

    private void setBackgroundMessage(String message1, String message2) {
        JScrollPane scrollPane = this.session_.getMessageComponent();
        if (scrollPane != null) {
            JTextArea textArea = (JTextArea)scrollPane.getViewport().getComponent(0);
            StringBuffer bf = new StringBuffer();
            if (!textArea.getText().equals("")) {
                bf.append(textArea.getText());
                bf.append("\n");
            }
            bf.append("> ");
            bf.append(message1);
            if (!message2.equals("")) {
                bf.append(" ");
                bf.append(message2);
            }
            this.calendar = Calendar.getInstance();
            bf.append("(");
            bf.append(this.formatter.format(this.calendar.getTime()));
            bf.append(")");
            textArea.setText(bf.toString());
            scrollPane.getViewport().scrollRectToVisible(new Rectangle(0, 0x7FFFFFFE, 1, 1));
            scrollPane.paintImmediately(0, 0, this.jScrollPaneMessages.getWidth(), this.jScrollPaneMessages.getHeight());
        }
    }

    @Override
    public void commit() {
        this.session_.commit(true, this.processLog);
    }

    @Override
    public void rollback() {
        this.session_.commit(false, this.processLog);
    }

    @Override
    public void startProgress(String text, int maxValue) {
        this.jProgressBar.setMaximum(maxValue);
        this.jProgressBar.setValue(0);
        this.jPanelBottom.remove(this.jPanelInfo);
        this.jProgressBar.setString(text);
        this.jProgressBar.setPreferredSize(this.jPanelInfo.getPreferredSize());
        this.jPanelBottom.add((Component)this.jProgressBar, "East");
        this.pack();
    }

    @Override
    public void incrementProgress() {
        this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
        this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
        if (this.jProgressBar.getValue() >= this.jProgressBar.getMaximum()) {
            this.endProgress();
        }
    }

    @Override
    public void endProgress() {
        this.jPanelBottom.remove(this.jProgressBar);
        this.jPanelBottom.add((Component)this.jPanelInfo, "East");
        this.pack();
        this.jPanelBottom.repaint();
    }

    @Override
    public void cancelWithMessage(String message) {
        if (!message.equals("")) {
            JOptionPane.showMessageDialog(null, message);
            this.errorMessage = message;
        }
        this.errorHasOccured = true;
    }

    @Override
    public void cancelWithScriptException(ScriptException e, String scriptName) {
        if (scriptName.equals("")) {
            JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("FunctionError12"));
            this.exceptionHeader = "'Script error in the function'\n";
        } else {
            JOptionPane.showMessageDialog(this, String.valueOf(XFUtility.RESOURCE.getString("FunctionError7")) + scriptName + XFUtility.RESOURCE.getString("FunctionError8"));
            this.exceptionHeader = "'" + scriptName + "' Script error\n";
        }
        e.printStackTrace(this.exceptionStream);
        this.rollback();
        this.setErrorAndCloseFunction();
    }

    @Override
    public void cancelWithException(Exception e) {
        JOptionPane.showMessageDialog(this, String.valueOf(XFUtility.RESOURCE.getString("FunctionError5")) + "\n" + e.getMessage());
        e.printStackTrace(this.exceptionStream);
        this.rollback();
        this.setErrorAndCloseFunction();
    }

    @Override
    public void setErrorAndCloseFunction() {
        this.errorHasOccured = true;
        this.closeFunction();
    }

    void returnTo(String target) {
        if (!target.equals("") && !target.equals(this.functionElement_.getAttribute("ID"))) {
            if (target.equals("MENU")) {
                this.returnMap_.put("RETURN_TO", "MENU");
            }
            this.closeFunction();
        }
        if (target.equals(this.functionElement_.getAttribute("ID"))) {
            this.returnMap_.remove("RETURN_TO");
        }
    }

    void closeFunction() {
        if (this.errorHasOccured) {
            this.returnMap_.put("RETURN_CODE", "99");
            this.rollback();
        }
        if (this.returnMap_.get("RETURN_MESSAGE") != null && !this.returnMap_.get("RETURN_MESSAGE").equals("")) {
            this.setProcessLog(this.returnMap_.get("RETURN_MESSAGE").toString());
        }
        this.instanceIsAvailable_ = true;
        String errorLog = "";
        if (this.exceptionLog.size() > 0 || !this.exceptionHeader.equals("")) {
            errorLog = String.valueOf(this.exceptionHeader) + this.exceptionLog.toString();
        }
        String wrkStr = this.processLog.toString();
        if (!this.functionElement_.getAttribute("TimerOption").equals("")) {
            wrkStr = String.valueOf(wrkStr) + "\n\n<Console Log>\n" + this.jTextAreaMessages.getText();
        }
        this.session_.writeLogOfFunctionClosed(this.programSequence, this.returnMap_.get("RETURN_CODE").toString(), wrkStr, errorLog);
        if (this.isVisible()) {
            this.session_.removeMessageComponent(this.jScrollPaneMessages);
            this.setVisible(false);
        }
    }

    @Override
    public String getFunctionID() {
        return this.functionElement_.getAttribute("ID");
    }

    @Override
    public HashMap<String, Object> getParmMap() {
        return this.parmMap_;
    }

    @Override
    public String getUserValueOf(String dataSourceName) {
        return this.session_.getFilterValue(this.getFunctionID(), dataSourceName);
    }

    @Override
    public void setUserValueOf(String dataSourceName, Object value) {
        this.session_.setFilterValue(this.getFunctionID(), dataSourceName, value.toString());
    }

    @Override
    public void setProcessLog(String text) {
        XFUtility.appendLog(text, this.processLog);
    }

    @Override
    public StringBuffer getProcessLog() {
        return this.processLog;
    }

    @Override
    public Object getVariant(String variantID) {
        if (this.variantMap.containsKey(variantID)) {
            return this.variantMap.get(variantID);
        }
        return "";
    }

    @Override
    public void setVariant(String variantID, Object value) {
        this.variantMap.put(variantID, value);
    }

    @Override
    public XFTableOperator createTableOperator(String oparation, String tableID) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this.session_, this.processLog, oparation, tableID);
        }
        catch (Exception e) {
            e.printStackTrace(this.exceptionStream);
            this.setErrorAndCloseFunction();
        }
        return operator;
    }

    @Override
    public XFTableOperator createTableOperator(String sqlText) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this.session_, this.processLog, sqlText);
        }
        catch (Exception e) {
            e.printStackTrace(this.exceptionStream);
            this.setErrorAndCloseFunction();
        }
        return operator;
    }

    @Override
    public XFTableEvaluator createTableEvaluator(String tableID) {
        return new XFTableEvaluator(this, tableID);
    }

    @Override
    public HashMap<String, Object> getReturnMap() {
        return this.returnMap_;
    }

    @Override
    public Session getSession() {
        return this.session_;
    }

    @Override
    public PrintStream getExceptionStream() {
        return this.exceptionStream;
    }

    @Override
    public Object getFieldObjectByID(String tableID, String fieldID) {
        return null;
    }

    @Override
    public void executeScript(String scriptText) {
        block2: {
            try {
                JOptionPane.showMessageDialog(null, "2:" + this.engineScriptBindings.keySet());
                StringBuffer bf = new StringBuffer();
                bf.append(scriptText);
                bf.append(this.session_.getScriptFunctions());
                this.scriptEngine.eval(bf.toString());
            }
            catch (Exception e) {
                if (!this.isVisible()) break block2;
                this.jTextAreaMessages.setText(this.getNewMessage(XFUtility.RESOURCE.getString("FunctionMessage67"), String.valueOf(e.getMessage()) + "\n"));
            }
        }
    }

    public void runScript() throws ScriptException, Exception {
        this.engineScriptBindings.clear();
        this.engineScriptBindings.put("instance", (Object)this);
        String scriptText = XFUtility.substringLinesWithTokenOfEOL(this.functionElement_.getAttribute("Script"), "\n");
        if (!scriptText.equals("")) {
            StringBuffer bf = new StringBuffer();
            bf.append(scriptText);
            bf.append(this.session_.getScriptFunctions());
            this.scriptEngine.eval(bf.toString());
            if (this.returnMap_.get("RETURN_CODE").equals("99")) {
                this.errorHasOccured = true;
                if (this.isVisible()) {
                    if (this.returnMap_.get("RETURN_MESSAGE") != null && !this.returnMap_.get("RETURN_MESSAGE").equals("")) {
                        this.jTextAreaMessages.setText(this.getNewMessage(this.returnMap_.get("RETURN_MESSAGE").toString(), ""));
                        this.returnMap_.remove("RETURN_MESSAGE");
                    } else {
                        this.jTextAreaMessages.setText(String.valueOf(this.getNewMessage(XFUtility.RESOURCE.getString("FunctionMessage51"), this.errorMessage)) + "\n");
                    }
                }
            } else if (this.isVisible()) {
                if (this.returnMap_.get("RETURN_MESSAGE") != null && !this.returnMap_.get("RETURN_MESSAGE").equals("")) {
                    this.jTextAreaMessages.setText(this.getNewMessage(this.returnMap_.get("RETURN_MESSAGE").toString(), ""));
                    this.returnMap_.remove("RETURN_MESSAGE");
                } else if (this.errorHasOccured) {
                    this.jTextAreaMessages.setText(String.valueOf(this.getNewMessage(XFUtility.RESOURCE.getString("FunctionMessage51"), this.errorMessage)) + "\n");
                } else {
                    this.jTextAreaMessages.setText(String.valueOf(this.getNewMessage(XFUtility.RESOURCE.getString("FunctionMessage48"), "")) + "\n");
                }
            }
        }
    }

    private void runNow() {
        try {
            try {
                this.setCursor(new Cursor(3));
                this.jTextAreaMessages.setText(this.getNewMessage(XFUtility.RESOURCE.getString("FunctionMessage47"), ""));
                this.jScrollPaneMessages.paintImmediately(0, 0, this.jScrollPaneMessages.getWidth(), this.jScrollPaneMessages.getHeight());
                this.runScript();
                this.jButtonStart.setEnabled(false);
            }
            catch (ScriptException e) {
                this.cancelWithScriptException(e, "");
                this.setCursor(new Cursor(0));
            }
            catch (Exception e) {
                this.cancelWithException(e);
                this.setCursor(new Cursor(0));
            }
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    private void startTimer() {
        if (this.jCheckBoxRunNow.isSelected()) {
            this.runNow();
        } else if (this.isValidTimeValue()) {
            this.jLabelCondition.setEnabled(false);
            this.jLabelTime.setEnabled(false);
            this.jTextFieldTime.setEnabled(false);
            this.jCheckBoxRunNow.setEnabled(false);
            this.jCheckBoxRepeat.setEnabled(false);
            this.jCheckBoxRunOffDay.setEnabled(false);
            this.jButtonStart.setEnabled(false);
            this.jButtonStop.setEnabled(true);
            this.jButtonIconify.setEnabled(true);
            this.getRootPane().setDefaultButton(this.jButtonStop);
            Calendar date = this.getNextDateTimeToRun();
            if (date != null) {
                this.alreadyRun = false;
                this.timer = new Timer(true);
                this.task = new TimerTaskScript();
                this.timer.schedule((TimerTask)this.task, date.getTime());
                this.jTextAreaMessages.setText(this.getNewMessage(this.formatter.format(date.getTime()), String.valueOf(XFUtility.RESOURCE.getString("FunctionMessage45")) + "\n"));
            }
        } else {
            JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("TimerError"));
        }
    }

    boolean isValidTimeValue() {
        StringTokenizer workTokenizer1;
        boolean isValid = false;
        int previousHour = 0;
        int previousMin = 0;
        String hourFrom = "";
        String hourThru = "";
        String minFrom = "";
        String minThru = "";
        this.timeList.clear();
        this.timeRepeatFrom = "";
        this.timeRepeatThru = "";
        this.intervalMilliSeconds = 0;
        if (this.jTextFieldTime.getText().contains("LIST(") || this.jTextFieldTime.getText().contains("REPEAT(")) {
            int wrkInt2;
            int wrkInt1;
            StringTokenizer workTokenizer2;
            StringTokenizer workTokenizer12;
            String wrkStr;
            int pos2;
            isValid = true;
            int pos1 = this.jTextFieldTime.getText().indexOf("LIST(");
            if (pos1 >= 0 && (pos2 = this.jTextFieldTime.getText().indexOf(")", pos1)) >= 0) {
                wrkStr = this.jTextFieldTime.getText().substring(pos1 + 5, pos2).replace(" ", "");
                workTokenizer12 = new StringTokenizer(wrkStr, ",");
                if (workTokenizer12.countTokens() > 0) {
                    while (workTokenizer12.hasMoreTokens()) {
                        wrkStr = workTokenizer12.nextToken();
                        workTokenizer2 = new StringTokenizer(wrkStr, ":");
                        if (workTokenizer2.countTokens() == 2) {
                            try {
                                String hour = workTokenizer2.nextToken();
                                String min = workTokenizer2.nextToken();
                                wrkInt1 = Integer.parseInt(hour);
                                wrkInt2 = Integer.parseInt(min);
                                if (wrkInt1 >= 0 && wrkInt1 <= 23 && wrkInt2 >= 0 && wrkInt2 <= 59) {
                                    if (wrkInt1 > previousHour || wrkInt1 == previousHour && wrkInt2 >= previousMin) {
                                        this.timeList.add(wrkStr);
                                        previousHour = wrkInt1;
                                        previousMin = wrkInt2;
                                        continue;
                                    }
                                    isValid = false;
                                    break;
                                }
                                isValid = false;
                            }
                            catch (NumberFormatException e) {
                                isValid = false;
                            }
                            break;
                        }
                        isValid = false;
                        break;
                    }
                } else {
                    isValid = false;
                }
            }
            if (isValid && (pos1 = this.jTextFieldTime.getText().indexOf("REPEAT(")) >= 0) {
                pos2 = this.jTextFieldTime.getText().indexOf(")", pos1);
                if (pos2 >= 0) {
                    wrkStr = this.jTextFieldTime.getText().substring(pos1 + 7, pos2).replace(" ", "");
                    workTokenizer12 = new StringTokenizer(wrkStr, ",");
                    if (workTokenizer12.countTokens() == 3) {
                        this.timeRepeatFrom = workTokenizer12.nextToken();
                        this.timeRepeatThru = workTokenizer12.nextToken();
                        String sec = workTokenizer12.nextToken();
                        workTokenizer2 = new StringTokenizer(this.timeRepeatFrom, ":");
                        if (workTokenizer2.countTokens() == 2) {
                            try {
                                hourFrom = workTokenizer2.nextToken();
                                minFrom = workTokenizer2.nextToken();
                                wrkInt1 = Integer.parseInt(hourFrom);
                                wrkInt2 = Integer.parseInt(minFrom);
                                if (wrkInt1 < 0 || wrkInt1 > 23 || wrkInt2 < 0 || wrkInt2 > 59) {
                                    isValid = false;
                                }
                            }
                            catch (NumberFormatException e) {
                                isValid = false;
                            }
                        } else {
                            isValid = false;
                        }
                        if ((workTokenizer2 = new StringTokenizer(this.timeRepeatThru, ":")).countTokens() == 2) {
                            try {
                                hourThru = workTokenizer2.nextToken();
                                minThru = workTokenizer2.nextToken();
                                wrkInt1 = Integer.parseInt(hourThru);
                                wrkInt2 = Integer.parseInt(minThru);
                                if (wrkInt1 < 0 || wrkInt1 > 23 || wrkInt2 < 0 || wrkInt2 > 59) {
                                    isValid = false;
                                }
                            }
                            catch (NumberFormatException e) {
                                isValid = false;
                            }
                        } else {
                            isValid = false;
                        }
                        if (isValid) {
                            int diff = this.timeRepeatFrom.compareTo(this.timeRepeatThru);
                            if (diff >= 0) {
                                isValid = false;
                            } else {
                                try {
                                    float wrkFloat = Float.parseFloat(sec) * 1000.0f;
                                    this.intervalMilliSeconds = (int)wrkFloat;
                                    if (this.intervalMilliSeconds <= 0 || this.intervalMilliSeconds >= 86400000) {
                                        isValid = false;
                                    }
                                }
                                catch (NumberFormatException e) {
                                    isValid = false;
                                }
                            }
                        }
                    } else {
                        isValid = false;
                    }
                } else {
                    isValid = false;
                }
            }
        } else if (!this.jTextFieldTime.getText().equals("") && (workTokenizer1 = new StringTokenizer(this.jTextFieldTime.getText(), ":")).countTokens() == 2) {
            isValid = true;
            try {
                String hour = workTokenizer1.nextToken();
                String min = workTokenizer1.nextToken();
                int wrkInt1 = Integer.parseInt(hour);
                int wrkInt2 = Integer.parseInt(min);
                if (wrkInt1 >= 0 && wrkInt1 <= 23 && wrkInt2 >= 0 && wrkInt2 <= 59) {
                    this.timeList.add(this.jTextFieldTime.getText());
                } else {
                    isValid = false;
                }
            }
            catch (NumberFormatException e) {
                isValid = false;
            }
        }
        return isValid;
    }

    private void stopTimer() {
        this.jLabelCondition.setEnabled(true);
        this.jLabelTime.setEnabled(true);
        this.jTextFieldTime.setEnabled(true);
        this.jCheckBoxRunNow.setEnabled(true);
        this.jCheckBoxRepeat.setEnabled(true);
        this.jCheckBoxRunOffDay.setEnabled(true);
        this.jButtonStart.setEnabled(true);
        this.jButtonStop.setEnabled(false);
        this.jButtonIconify.setEnabled(false);
        this.getRootPane().setDefaultButton(this.jButtonStart);
        if (this.timer != null) {
            this.timer.cancel();
            this.task = null;
        }
        this.jTextAreaMessages.setText(this.getNewMessage(XFUtility.RESOURCE.getString("FunctionMessage46"), ""));
    }

    private Calendar getNextDateTimeToRun() {
        Calendar date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (this.jCheckBoxRepeat.isSelected() || !this.alreadyRun) {
            Calendar currentDateTime = Calendar.getInstance();
            Calendar targetDateTime = this.getTargetDateTime(currentDateTime);
            int diff = targetDateTime.compareTo(currentDateTime);
            if (diff <= 0) {
                targetDateTime.add(5, 1);
            }
            if (!this.jCheckBoxRunOffDay.isSelected()) {
                Date wrkDate = targetDateTime.getTime();
                String wrkStr = df.format(wrkDate);
                while (this.session_.isOffDate(wrkStr)) {
                    targetDateTime.add(5, 1);
                    wrkDate = targetDateTime.getTime();
                    wrkStr = df.format(wrkDate);
                }
            }
            date = targetDateTime;
            this.alreadyRun = true;
        }
        return date;
    }

    Calendar getTargetDateTime(Calendar currentDateTime) {
        int diff;
        int min;
        int hour;
        StringTokenizer workTokenizer;
        int hour1 = 0;
        int min1 = 0;
        int hour2 = 0;
        int min2 = 0;
        Calendar targetDateTime = null;
        Calendar dateTime1 = null;
        Calendar dateTime2 = null;
        Calendar dateTime3 = null;
        if (this.timeList.size() > 0) {
            dateTime1 = Calendar.getInstance();
            int i = 0;
            while (i < this.timeList.size()) {
                workTokenizer = new StringTokenizer(this.timeList.get(i), ":");
                hour = Integer.parseInt(workTokenizer.nextToken());
                min = Integer.parseInt(workTokenizer.nextToken());
                dateTime1.set(11, hour);
                dateTime1.set(12, min);
                dateTime1.set(13, 0);
                dateTime1.set(14, 0);
                diff = dateTime1.compareTo(currentDateTime);
                if (diff >= 0) break;
                ++i;
            }
            diff = dateTime1.compareTo(currentDateTime);
            if (diff < 0) {
                dateTime1 = null;
            }
        }
        if (!this.timeRepeatFrom.equals("")) {
            dateTime2 = Calendar.getInstance();
            workTokenizer = new StringTokenizer(this.timeRepeatFrom, ":");
            hour = Integer.parseInt(workTokenizer.nextToken());
            min = Integer.parseInt(workTokenizer.nextToken());
            dateTime2.set(11, hour);
            dateTime2.set(12, min);
            dateTime2.set(13, 0);
            dateTime2.set(14, 0);
            dateTime3 = Calendar.getInstance();
            workTokenizer = new StringTokenizer(this.timeRepeatThru, ":");
            hour = Integer.parseInt(workTokenizer.nextToken());
            min = Integer.parseInt(workTokenizer.nextToken());
            dateTime3.set(11, hour);
            dateTime3.set(12, min);
            dateTime3.set(13, 0);
            dateTime3.set(14, 0);
            diff = dateTime2.compareTo(currentDateTime);
            if (diff < 0) {
                int wrkInt = 0;
                do {
                    dateTime2.set(14, wrkInt += this.intervalMilliSeconds);
                    diff = dateTime3.compareTo(dateTime2);
                    if (diff >= 0) continue;
                    dateTime2 = null;
                    break;
                } while ((diff = dateTime2.compareTo(currentDateTime)) < 0);
            }
        }
        targetDateTime = dateTime1 != null && dateTime2 != null ? ((diff = dateTime1.compareTo(dateTime2)) < 0 ? dateTime1 : dateTime2) : (dateTime1 != null ? dateTime1 : dateTime2);
        if (targetDateTime == null) {
            targetDateTime = Calendar.getInstance();
            if (this.timeList.size() > 0) {
                workTokenizer = new StringTokenizer(this.timeList.get(0), ":");
                hour1 = Integer.parseInt(workTokenizer.nextToken());
                min1 = Integer.parseInt(workTokenizer.nextToken());
            }
            if (!this.timeRepeatFrom.equals("")) {
                workTokenizer = new StringTokenizer(this.timeRepeatFrom, ":");
                hour2 = Integer.parseInt(workTokenizer.nextToken());
                min2 = Integer.parseInt(workTokenizer.nextToken());
            }
            if (this.timeList.size() > 0 && this.timeRepeatFrom.equals("")) {
                targetDateTime.set(11, hour1);
                targetDateTime.set(12, min1);
            }
            if (this.timeList.size() == 0 && !this.timeRepeatFrom.equals("")) {
                targetDateTime.set(11, hour2);
                targetDateTime.set(12, min2);
            }
            if (this.timeList.size() > 0 && !this.timeRepeatFrom.equals("")) {
                if (hour1 < hour2) {
                    targetDateTime.set(11, hour1);
                    targetDateTime.set(12, min1);
                } else if (hour1 == hour2) {
                    if (min1 <= min2) {
                        targetDateTime.set(11, hour1);
                        targetDateTime.set(12, min1);
                    } else {
                        targetDateTime.set(11, hour2);
                        targetDateTime.set(12, min2);
                    }
                } else {
                    targetDateTime.set(11, hour2);
                    targetDateTime.set(12, min2);
                }
            }
            targetDateTime.set(13, 0);
            targetDateTime.set(14, 0);
        }
        return targetDateTime;
    }

    private void setRunNow() {
        if (this.jCheckBoxRunNow.isSelected()) {
            this.jLabelTime.setEnabled(false);
            this.jTextFieldTime.setEnabled(false);
            this.jCheckBoxRepeat.setEnabled(false);
            this.jCheckBoxRunOffDay.setEnabled(false);
        } else {
            this.jLabelTime.setEnabled(true);
            this.jTextFieldTime.setEnabled(true);
            this.jCheckBoxRepeat.setEnabled(true);
            this.jCheckBoxRunOffDay.setEnabled(true);
        }
    }

    private String getNewMessage(String newMessage1, String newMessage2) {
        return this.getNewMessage(newMessage1, newMessage2, false);
    }

    private String getNewMessage(String newMessage1, String newMessage2, boolean isToReplaceLastLine) {
        String lastTimeInfo = "";
        StringBuffer bf = new StringBuffer();
        if (!this.jTextAreaMessages.getText().equals("")) {
            if (isToReplaceLastLine) {
                int pos1 = this.jTextAreaMessages.getText().lastIndexOf("\n");
                bf.append(this.jTextAreaMessages.getText().substring(0, pos1));
                String text2 = this.jTextAreaMessages.getText().substring(pos1, this.jTextAreaMessages.getText().length());
                int pos2 = text2.lastIndexOf("(");
                lastTimeInfo = String.valueOf(text2.substring(pos2, text2.length())) + " - ";
            } else {
                bf.append(this.jTextAreaMessages.getText());
            }
            bf.append("\n");
        }
        bf.append("> ");
        bf.append(newMessage1);
        if (!newMessage2.equals("")) {
            bf.append(" ");
            bf.append(newMessage2);
        }
        bf.append(lastTimeInfo);
        this.calendar = Calendar.getInstance();
        bf.append("(");
        bf.append(this.formatter.format(this.calendar.getTime()));
        bf.append(")");
        return bf.toString();
    }

    class TimerTaskScript
    extends TimerTask {
        TimerTaskScript() {
        }

        @Override
        public void run() {
            try {
                try {
                    XF000.this.setCursor(new Cursor(3));
                    XF000.this.jTextAreaMessages.setText(XF000.this.getNewMessage(XFUtility.RESOURCE.getString("FunctionMessage47"), ""));
                    XF000.this.runScript();
                    XF000.this.jButtonStart.setEnabled(false);
                    if (XF000.this.jCheckBoxRepeat.isSelected()) {
                        XF000.this.startTimer();
                    } else {
                        XF000.this.stopTimer();
                    }
                }
                catch (ScriptException e) {
                    XF000.this.cancelWithScriptException(e, "");
                    XF000.this.setCursor(new Cursor(0));
                }
                catch (Exception e) {
                    XF000.this.cancelWithException(e);
                    XF000.this.setCursor(new Cursor(0));
                }
            }
            finally {
                XF000.this.setCursor(new Cursor(0));
            }
        }
    }
}

