/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

class XF290_Phrase {
    Element phraseElement_ = null;
    private String block = "";
    private String alignment = "";
    private ArrayList<String> valueKeywordList = new ArrayList();
    private ArrayList<String> dataSourceNameList = new ArrayList();
    private String fontID = "";
    private int fontSize = 0;
    private float alignmentMargin;
    private float marginLeft;
    private float marginRight;
    private float spacingAfter;
    private String fontStyle = "";

    public XF290_Phrase(Element phraseElement) {
        this.phraseElement_ = phraseElement;
        this.block = this.phraseElement_.getAttribute("Block");
        this.alignment = this.phraseElement_.getAttribute("Alignment");
        try {
            this.alignmentMargin = Float.parseFloat(this.phraseElement_.getAttribute("AlignmentMargin"));
        }
        catch (NumberFormatException e) {
            this.alignmentMargin = 0.0f;
        }
        if (this.alignmentMargin > 0.0f) {
            if (this.alignment.equals("LEFT")) {
                this.marginLeft = this.alignmentMargin;
                this.marginRight = 0.0f;
            }
            if (this.alignment.equals("RIGHT")) {
                this.marginLeft = 0.0f;
                this.marginRight = this.alignmentMargin;
            }
            if (this.alignment.equals("CENTER")) {
                this.marginLeft = this.alignmentMargin;
                this.marginRight = this.alignmentMargin;
            }
        } else {
            try {
                this.marginRight = Float.parseFloat(this.phraseElement_.getAttribute("MarginRight"));
            }
            catch (NumberFormatException e) {
                this.marginRight = 0.0f;
            }
            try {
                this.marginLeft = Float.parseFloat(this.phraseElement_.getAttribute("MarginLeft"));
            }
            catch (NumberFormatException e) {
                this.marginLeft = 0.0f;
            }
        }
        try {
            this.spacingAfter = Float.parseFloat(this.phraseElement_.getAttribute("SpacingAfter"));
        }
        catch (NumberFormatException e) {
            this.spacingAfter = 0.0f;
        }
        String phraseValue = this.phraseElement_.getAttribute("Value");
        int pos1 = phraseValue.indexOf("&", 0);
        while (pos1 > -1) {
            int pos2 = phraseValue.indexOf("&", pos1 + 1);
            if (pos2 == -1) {
                this.valueKeywordList.add(phraseValue.substring(pos1, phraseValue.length()).trim());
                break;
            }
            this.valueKeywordList.add(phraseValue.substring(pos1, pos2).trim());
            pos1 = pos2;
        }
        int i = 0;
        while (i < this.valueKeywordList.size()) {
            String wrkStr;
            StringTokenizer workTokenizer;
            if (this.valueKeywordList.get(i).contains("&DataSource(")) {
                pos1 = this.valueKeywordList.get(i).indexOf(")", 0);
                workTokenizer = new StringTokenizer(this.valueKeywordList.get(i).substring(12, pos1), ";");
                wrkStr = workTokenizer.nextToken().trim();
                this.dataSourceNameList.add(wrkStr);
            }
            if (this.valueKeywordList.get(i).contains("&DataSourceImage(")) {
                pos1 = this.valueKeywordList.get(i).indexOf(")", 0);
                workTokenizer = new StringTokenizer(this.valueKeywordList.get(i).substring(17, pos1), ";");
                wrkStr = workTokenizer.nextToken().trim();
                this.dataSourceNameList.add(wrkStr);
            }
            if (this.valueKeywordList.get(i).contains("&Barcode(")) {
                pos1 = this.valueKeywordList.get(i).indexOf(")", 0);
                workTokenizer = new StringTokenizer(this.valueKeywordList.get(i).substring(9, pos1), ";");
                wrkStr = workTokenizer.nextToken().trim();
                this.dataSourceNameList.add(wrkStr);
            }
            ++i;
        }
        this.fontID = this.phraseElement_.getAttribute("FontID");
        this.fontSize = Integer.parseInt(this.phraseElement_.getAttribute("FontSize"));
        this.fontStyle = this.phraseElement_.getAttribute("FontStyle");
    }

    public String getBlock() {
        return this.block;
    }

    public float getMarginLeft() {
        return this.marginLeft;
    }

    public float getMarginRight() {
        return this.marginRight;
    }

    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public int getAlignment() {
        int result = 0;
        if (this.alignment.equals("LEFT")) {
            result = 0;
        }
        if (this.alignment.equals("CENTER")) {
            result = 1;
        }
        if (this.alignment.equals("RIGHT")) {
            result = 2;
        }
        return result;
    }

    public ArrayList<String> getValueKeywordList() {
        return this.valueKeywordList;
    }

    public ArrayList<String> getDataSourceNameList() {
        return this.dataSourceNameList;
    }

    public String getFontID() {
        return this.fontID;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getFontStyle() {
        int result = 0;
        if (this.fontStyle.equals("BOLD")) {
            result = 1;
        }
        if (this.fontStyle.equals("ITALIC")) {
            result = 2;
        }
        if (this.fontStyle.contains("BOLDITALIC")) {
            result = 3;
        }
        if (this.fontStyle.equals("UNDERLINE")) {
            result = 4;
        }
        return result;
    }
}

