/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.sql.Date;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;
import xeadDriver.TableCellReadOnly;
import xeadDriver.XF300;
import xeadDriver.XFByteArray;
import xeadDriver.XFFieldScriptable;
import xeadDriver.XFTableOperator;
import xeadDriver.XFUtility;

class XF300_DetailColumn
implements XFFieldScriptable {
    private Element functionColumnElement_ = null;
    private Element tableElement = null;
    private XF300 dialog_ = null;
    private String tableID_ = "";
    private String tableAlias_ = "";
    private String fieldID_ = "";
    private String fieldName = "";
    private String fieldRemarks = "";
    private String dataType = "";
    private int dataSize = 5;
    private int decimalSize = 0;
    private String dataTypeOptions = "";
    private ArrayList<String> dataTypeOptionList;
    private String fieldOptions = "";
    private String fieldCaption = "";
    private String byteaTypeFieldID = "";
    private int fieldWidth = 50;
    private int columnIndex = -1;
    private boolean isEnabled = true;
    private boolean isVisibleOnPanel = true;
    private boolean isVirtualField = false;
    private boolean isReadyToValidate = false;
    private String valueType = "STRING";
    private String linkedFunctionID_;
    private ArrayList<String> fieldsToPutList_ = new ArrayList();
    private ArrayList<String> fieldsToPutToList_ = new ArrayList();
    private String flagTrue = "";
    private ArrayList<String> kubunValueList = new ArrayList();
    private ArrayList<String> kubunTextList = new ArrayList();
    private Object value_ = null;
    private Color foreground = Color.black;
    private int fieldRows = 1;
    private String fieldLayout = "HORIZONTAL";

    public XF300_DetailColumn(String detailTableID, Element functionColumnElement, XF300 dialog, int index) {
        this.functionColumnElement_ = functionColumnElement;
        this.dialog_ = dialog;
        this.fieldOptions = this.functionColumnElement_.getAttribute("FieldOptions");
        StringTokenizer workTokenizer = new StringTokenizer(this.functionColumnElement_.getAttribute("DataSource"), ".");
        this.tableAlias_ = workTokenizer.nextToken();
        this.tableID_ = dialog.getTableIDOfTableAlias(this.tableAlias_, index);
        this.fieldID_ = workTokenizer.nextToken();
        Element workElement = dialog.getSession().getFieldElement(this.tableID_, this.fieldID_);
        if (workElement == null) {
            JOptionPane.showMessageDialog(null, String.valueOf(this.tableID_) + "." + this.fieldID_ + XFUtility.RESOURCE.getString("FunctionError11"));
        }
        this.fieldName = workElement.getAttribute("Name");
        this.fieldRemarks = XFUtility.getLayoutedString(workElement.getAttribute("Remarks"), "<br>", this.dialog_.getSession().systemFont);
        this.dataType = workElement.getAttribute("Type");
        this.dataTypeOptions = workElement.getAttribute("TypeOptions");
        this.dataTypeOptionList = XFUtility.getOptionList(this.dataTypeOptions);
        String wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "CAPTION");
        this.fieldCaption = wrkStr.equals("") ? (workElement.getAttribute("ColumnName").equals("") ? (workElement.getAttribute("Name").equals("") ? workElement.getAttribute("ID") : this.fieldName) : workElement.getAttribute("ColumnName")) : XFUtility.getCaptionValue(wrkStr, this.dialog_.getSession());
        this.dataSize = Integer.parseInt(workElement.getAttribute("Size"));
        if (!workElement.getAttribute("Decimal").equals("")) {
            this.decimalSize = Integer.parseInt(workElement.getAttribute("Decimal"));
        }
        this.byteaTypeFieldID = workElement.getAttribute("ByteaTypeField");
        this.tableElement = (Element)workElement.getParentNode();
        if (this.dataTypeOptionList.contains("VIRTUAL")) {
            this.isVirtualField = true;
        }
        JLabel jLabel = new JLabel();
        FontMetrics metrics = jLabel.getFontMetrics(new Font(this.dialog_.getSession().systemFont, 0, 18));
        int captionWidth = metrics.stringWidth(this.fieldCaption) + 18;
        ArrayList<String> fieldOptionList = XFUtility.getOptionList(this.fieldOptions);
        if (fieldOptionList.contains("VERTICAL")) {
            this.fieldLayout = "VERTICAL";
        } else if (fieldOptionList.contains("HIDDEN")) {
            this.isVisibleOnPanel = false;
        }
        wrkStr = XFUtility.getOptionValueWithKeyword(this.dataTypeOptions, "BOOLEAN");
        if (!wrkStr.equals("")) {
            workTokenizer = new StringTokenizer(wrkStr, ";");
            if (workTokenizer.countTokens() >= 1) {
                this.flagTrue = workTokenizer.nextToken();
            }
            this.valueType = "FLAG";
            this.fieldWidth = 25;
        } else {
            String basicType = this.getBasicType();
            wrkStr = XFUtility.getOptionValueWithKeyword(this.dataTypeOptions, "KUBUN");
            if (!wrkStr.equals("")) {
                try {
                    XFTableOperator operator = this.dialog_.createTableOperator("Select", this.dialog_.getSession().getTableNameOfUserVariants());
                    operator.addKeyValue("IDUSERKUBUN", wrkStr);
                    operator.setOrderBy("SQLIST");
                    while (operator.next()) {
                        this.kubunValueList.add(operator.getValueOf("KBUSERKUBUN").toString().trim());
                        wrkStr = operator.getValueOf("TXUSERKUBUN").toString().trim();
                        if (metrics.stringWidth(wrkStr) + 10 > this.fieldWidth) {
                            this.fieldWidth = metrics.stringWidth(wrkStr) + 10;
                        }
                        this.kubunTextList.add(wrkStr);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(this.dialog_.getExceptionStream());
                    this.dialog_.setErrorAndCloseFunction();
                }
            } else if (this.dataTypeOptionList.contains("KANJI") || this.dataTypeOptionList.contains("ZIPADRS")) {
                this.fieldWidth = this.dataSize * 18 + 5;
            } else if (this.dataTypeOptionList.contains("FYEAR")) {
                this.fieldWidth = 100;
            } else if (this.dataTypeOptionList.contains("YMONTH")) {
                this.fieldWidth = 120;
            } else if (this.dataTypeOptionList.contains("MSEQ")) {
                this.fieldWidth = 80;
            } else if (this.dataTypeOptionList.contains("URL")) {
                this.valueType = "URL";
                this.fieldWidth = this.dataSize * 11 + 15;
            } else if (basicType.equals("INTEGER") || basicType.equals("FLOAT")) {
                this.fieldWidth = XFUtility.getLengthOfEdittedNumericValue(this.dataSize, this.decimalSize, this.dataTypeOptionList) * 11 + 15;
            } else if (basicType.equals("DATE")) {
                this.fieldWidth = XFUtility.getWidthOfDateValue(this.dialog_.getSession().getDateFormat(), this.dialog_.getSession().systemFont, 18);
            } else if (basicType.equals("BYTEA")) {
                this.valueType = "BYTEA";
                this.fieldWidth = 100;
            } else if (this.dataTypeOptionList.contains("IMAGE")) {
                this.valueType = "IMAGE";
                this.fieldWidth = 60;
                this.fieldRows = 2;
            } else {
                this.fieldWidth = this.dataSize * 11 + 15;
            }
        }
        this.linkedFunctionID_ = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "LINKED_CALL");
        if (!this.linkedFunctionID_.equals("")) {
            this.valueType = "LINKED";
            wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "LINKED_CALL_TO_PUT");
            if (!wrkStr.equals("")) {
                workTokenizer = new StringTokenizer(wrkStr, ";");
                while (workTokenizer.hasMoreTokens()) {
                    this.fieldsToPutList_.add(workTokenizer.nextToken());
                }
            }
            if (!(wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "LINKED_CALL_TO_PUT_TO")).equals("")) {
                workTokenizer = new StringTokenizer(wrkStr, ";");
                while (workTokenizer.hasMoreTokens()) {
                    this.fieldsToPutToList_.add(workTokenizer.nextToken());
                }
            }
        }
        if (this.fieldWidth > 400) {
            this.fieldWidth = 400;
        }
        if (captionWidth > this.fieldWidth) {
            this.fieldWidth = captionWidth;
        }
        if (!(wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "WIDTH")).equals("")) {
            this.fieldWidth = Integer.parseInt(wrkStr);
        }
        if (!(wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "ROWS")).equals("")) {
            this.fieldRows = Integer.parseInt(wrkStr);
        }
    }

    public XF300_DetailColumn(String detailTableID, String tableID, String tableAlias, String fieldID, XF300 dialog, int index) {
        this.functionColumnElement_ = null;
        this.dialog_ = dialog;
        this.fieldOptions = "";
        this.isVisibleOnPanel = false;
        this.tableID_ = tableID;
        this.tableAlias_ = tableAlias.equals("") ? tableID : tableAlias;
        this.fieldID_ = fieldID;
        Element workElement = dialog.getSession().getFieldElement(this.tableID_, this.fieldID_);
        if (workElement == null) {
            JOptionPane.showMessageDialog(null, String.valueOf(this.tableID_) + "." + this.fieldID_ + XFUtility.RESOURCE.getString("FunctionError11"));
        }
        this.dataType = workElement.getAttribute("Type");
        this.dataTypeOptions = workElement.getAttribute("TypeOptions");
        this.dataTypeOptionList = XFUtility.getOptionList(this.dataTypeOptions);
        this.fieldCaption = workElement.getAttribute("Name").equals("") ? workElement.getAttribute("ID") : workElement.getAttribute("Name");
        this.dataSize = Integer.parseInt(workElement.getAttribute("Size"));
        this.byteaTypeFieldID = workElement.getAttribute("ByteaTypeField");
        this.tableElement = (Element)workElement.getParentNode();
        if (this.dataTypeOptionList.contains("VIRTUAL")) {
            this.isVirtualField = true;
        }
    }

    public boolean isVisibleOnPanel() {
        return this.isVisibleOnPanel;
    }

    public boolean isVirtualField() {
        return this.isVirtualField;
    }

    public boolean isReadyToValidate() {
        return this.isReadyToValidate;
    }

    public void setReadyToValidate(boolean isReady) {
        this.isReadyToValidate = isReady;
    }

    public Element getTableElement() {
        return this.tableElement;
    }

    public String getBasicType() {
        return XFUtility.getBasicTypeOf(this.dataType);
    }

    public String getByteaTypeFieldID() {
        return this.byteaTypeFieldID;
    }

    public ArrayList<String> getTypeOptionList() {
        return this.dataTypeOptionList;
    }

    public Object getNullValue() {
        return XFUtility.getNullValueOfBasicType(this.getBasicType());
    }

    @Override
    public String getTableID() {
        return this.tableID_;
    }

    @Override
    public String getFieldID() {
        return this.fieldID_;
    }

    @Override
    public String getDataSourceID() {
        return String.valueOf(this.tableAlias_) + "_" + this.fieldID_;
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    @Override
    public void setValueList(String[] valueList) {
    }

    @Override
    public String[] getValueList() {
        return new String[0];
    }

    public String getFieldRemarks() {
        return this.fieldRemarks;
    }

    public String getTableAlias() {
        return this.tableAlias_;
    }

    public String getDataSourceName() {
        return String.valueOf(this.tableAlias_) + "." + this.fieldID_;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getDecimalSize() {
        return this.decimalSize;
    }

    public Object getInternalValue() {
        return this.value_;
    }

    public Object getExternalValue() {
        Object value = null;
        String basicType = this.getBasicType();
        if (basicType.equals("INTEGER") && !this.dataTypeOptionList.contains("MSEQ") && !this.dataTypeOptionList.contains("FYEAR")) {
            value = this.value_ == null || this.value_.toString().equals("") ? "" : XFUtility.getFormattedIntegerValue(this.value_.toString(), this.dataTypeOptionList, this.dataSize);
        } else if (basicType.equals("FLOAT")) {
            value = this.value_ == null || this.value_.toString().equals("") ? "" : XFUtility.getFormattedFloatValue(this.value_.toString(), this.decimalSize);
        } else if (basicType.equals("DATE")) {
            if (this.value_ == null || this.value_.equals("")) {
                value = "";
            } else {
                String wrkStr = this.value_.toString().substring(0, 10);
                value = XFUtility.getUserExpressionOfUtilDate(XFUtility.convertDateFromSqlToUtil(Date.valueOf(wrkStr)), this.dialog_.getSession().getDateFormat(), false);
            }
        } else if (basicType.equals("DATETIME")) {
            if (this.value_ != null) {
                value = this.value_.toString().replace("-", "/");
            }
        } else if (!XFUtility.getOptionValueWithKeyword(this.dataTypeOptions, "KUBUN").equals("")) {
            String wrkStr = this.value_.toString().trim();
            int i = 0;
            while (i < this.kubunValueList.size()) {
                if (this.kubunValueList.get(i).equals(wrkStr)) {
                    value = this.kubunTextList.get(i);
                    break;
                }
                ++i;
            }
        } else {
            if ((this.valueType.equals("STRING") || this.valueType.equals("URL") || this.valueType.equals("LINKED")) && this.value_ != null) {
                String wrkStr;
                value = this.value_.toString().trim();
                if ((this.dataTypeOptionList.contains("YMONTH") || this.dataTypeOptionList.contains("FYEAR")) && !(wrkStr = value.toString()).equals("")) {
                    value = XFUtility.getUserExpressionOfYearMonth(wrkStr, this.dialog_.getSession().getDateFormat());
                }
                if (this.dataTypeOptionList.contains("MSEQ") && !(wrkStr = value.toString()).equals("")) {
                    value = XFUtility.getUserExpressionOfMSeq(Integer.parseInt(wrkStr), this.dialog_.getSession());
                }
            }
            if (this.valueType.equals("IMAGE")) {
                String fileName = String.valueOf(this.dialog_.getSession().getImageFileFolder()) + this.value_.toString().trim();
                int iconHeight = this.fieldRows * 25;
                value = XFUtility.createSmallIcon(fileName, this.fieldWidth, iconHeight);
            }
            if (this.valueType.equals("FLAG")) {
                value = this.value_.toString().trim().equals(this.flagTrue) ? XFUtility.ICON_CHECK_1D : XFUtility.ICON_CHECK_0D;
            }
            if (this.valueType.equals("BYTEA")) {
                value = ((XFByteArray)this.value_).getExternalValue();
            }
        }
        return value;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getLinkedFunctionID() {
        return this.linkedFunctionID_;
    }

    public ArrayList<String> getFieldsToPutList() {
        return this.fieldsToPutList_;
    }

    public ArrayList<String> getFieldsToPutToList() {
        return this.fieldsToPutToList_;
    }

    public TableCellReadOnly getCellObject() {
        return new TableCellReadOnly(this.getInternalValue(), this.getExternalValue(), this.getForeground(), this.valueType);
    }

    public String getCaption() {
        return this.fieldCaption;
    }

    public int getWidth() {
        return this.fieldWidth;
    }

    public void setWidth(int width) {
        this.fieldWidth = width;
    }

    public int getRows() {
        return this.fieldRows;
    }

    public String getLayout() {
        return this.fieldLayout;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int index) {
        this.columnIndex = index;
    }

    public boolean setValueOfResultSet(XFTableOperator operator) {
        String basicType = this.getBasicType();
        boolean isFoundInResultSet = false;
        this.setColor("");
        try {
            if (!this.isVirtualField) {
                if (basicType.equals("BYTEA")) {
                    isFoundInResultSet = true;
                    this.value_ = new XFByteArray(null);
                } else {
                    Object value = operator.getValueOf(this.getFieldID());
                    isFoundInResultSet = true;
                    if (basicType.equals("INTEGER")) {
                        if (value == null || value.equals("")) {
                            this.value_ = "0";
                        } else {
                            String wrkStr = value.toString();
                            int pos = wrkStr.indexOf(".");
                            if (pos >= 0) {
                                wrkStr = wrkStr.substring(0, pos);
                            }
                            this.value_ = Long.parseLong(wrkStr);
                        }
                    } else {
                        this.value_ = basicType.equals("FLOAT") ? (value == null || value.equals("") ? "0.0" : Double.valueOf(Double.parseDouble(value.toString()))) : (value == null ? "" : value.toString().trim());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.dialog_.getExceptionStream());
            this.dialog_.setErrorAndCloseFunction();
        }
        return isFoundInResultSet;
    }

    public void initialize() {
        this.value_ = XFUtility.getNullValueOfBasicType(this.getBasicType());
    }

    @Override
    public void setValue(Object value) {
        this.value_ = XFUtility.getValueAccordingToBasicType(this.getBasicType(), value);
    }

    public void setByteaType(ArrayList<XF300_DetailColumn> columnList) {
        if (this.isVisibleOnPanel) {
            int i = 0;
            while (i < columnList.size()) {
                if (columnList.get(i).getFieldID().equals(this.byteaTypeFieldID)) {
                    ((XFByteArray)this.value_).setType(columnList.get(i).getValue().toString());
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public Object getValue() {
        return this.getInternalValue();
    }

    @Override
    public void setOldValue(Object value) {
    }

    @Override
    public Object getOldValue() {
        return this.getInternalValue();
    }

    @Override
    public boolean isValueChanged() {
        return !this.getValue().equals(this.getOldValue());
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public void setPrompter(String prompterSpec) {
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setError(String message) {
    }

    @Override
    public String getError() {
        return "";
    }

    @Override
    public void setWarning(String message) {
    }

    @Override
    public String getWarning() {
        return "";
    }

    @Override
    public void setColor(String color) {
        this.foreground = XFUtility.convertStringToColor(color);
    }

    @Override
    public String getColor() {
        return XFUtility.convertColorToString(this.foreground);
    }

    public Color getForeground() {
        return this.foreground;
    }
}

