/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.script.ScriptException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadDriver.SortableDomElementListModel;
import xeadDriver.XF300;
import xeadDriver.XF300_HeaderReferTable;
import xeadDriver.XFScript;
import xeadDriver.XFUtility;

class XF300_HeaderTable {
    private Element tableElement = null;
    private Element functionElement_ = null;
    private String tableID = "";
    private String fixedWhere = "";
    private ArrayList<String> keyFieldIDList = new ArrayList();
    private ArrayList<XFScript> scriptList = new ArrayList();
    private XF300 dialog_;
    private StringTokenizer workTokenizer;
    private String dbName = "";

    public XF300_HeaderTable(Element functionElement, XF300 dialog) {
        this.functionElement_ = functionElement;
        this.dialog_ = dialog;
        this.tableID = this.functionElement_.getAttribute("HeaderTable");
        this.tableElement = this.dialog_.getSession().getTableElement(this.tableID);
        this.dbName = this.tableElement.getAttribute("DB").equals("") ? this.dialog_.getSession().getDatabaseName() : this.dialog_.getSession().getSubDBName(this.tableElement.getAttribute("DB"));
        if (this.functionElement_.getAttribute("HeaderKeyFields").equals("")) {
            NodeList nodeList = this.tableElement.getElementsByTagName("Key");
            int i = 0;
            while (i < nodeList.getLength()) {
                Element workElement = (Element)nodeList.item(i);
                if (workElement.getAttribute("Type").equals("PK")) {
                    this.workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
                    while (this.workTokenizer.hasMoreTokens()) {
                        String workString = this.workTokenizer.nextToken();
                        this.keyFieldIDList.add(workString);
                    }
                    break;
                }
                ++i;
            }
        } else {
            this.workTokenizer = new StringTokenizer(this.functionElement_.getAttribute("HeaderKeyFields"), ";");
            while (this.workTokenizer.hasMoreTokens()) {
                this.keyFieldIDList.add(this.workTokenizer.nextToken());
            }
        }
        NodeList workList = this.tableElement.getElementsByTagName("Script");
        SortableDomElementListModel sortList = XFUtility.getSortedListModel(workList, "Order");
        int i = 0;
        while (i < sortList.size()) {
            Element element = (Element)sortList.getElementAt(i);
            this.scriptList.add(new XFScript(this.tableID, element, this.dialog_.getSession().getTableNodeList()));
            ++i;
        }
    }

    public String getSelectSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append("select ");
        int count = -1;
        int i = 0;
        while (i < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(i).isFieldOnPrimaryTable() && !this.dialog_.getHeaderFieldList().get(i).isVirtualField()) {
                if (++count > 0) {
                    buf.append(",");
                }
                buf.append(this.dialog_.getHeaderFieldList().get(i).getFieldID());
            }
            ++i;
        }
        buf.append(" from ");
        buf.append(this.tableID);
        this.fixedWhere = XFUtility.getFixedWhereValue(this.functionElement_.getAttribute("FixedWhere"), this.dialog_.getSession());
        buf.append(" where ");
        count = -1;
        i = 0;
        while (i < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(i).isKey()) {
                if (++count > 0) {
                    buf.append(" and ");
                }
                buf.append(this.dialog_.getHeaderFieldList().get(i).getFieldID());
                buf.append("=");
                if (this.dialog_.getParmMap().containsKey(this.dialog_.getHeaderFieldList().get(i).getFieldID())) {
                    buf.append(XFUtility.getTableOperationValue(this.dialog_.getHeaderFieldList().get(i).getBasicType(), this.dialog_.getParmMap().get(this.dialog_.getHeaderFieldList().get(i).getFieldID()), this.dbName));
                } else {
                    buf.append(XFUtility.getTableOperationValue(this.dialog_.getHeaderFieldList().get(i).getBasicType(), this.dialog_.getParmMap().get(this.dialog_.getHeaderFieldList().get(i).getDataSourceName()), this.dbName));
                }
            }
            ++i;
        }
        if (!this.fixedWhere.equals("")) {
            buf.append(" and (");
            buf.append(this.fixedWhere);
            buf.append(") ");
        }
        return buf.toString();
    }

    public String getTableID() {
        return this.tableID;
    }

    public Element getTableElement() {
        return this.tableElement;
    }

    public ArrayList<String> getKeyFieldIDList() {
        return this.keyFieldIDList;
    }

    public ArrayList<XFScript> getScriptList() {
        return this.scriptList;
    }

    public boolean isValidDataSource(String tableID, String tableAlias, String fieldID) {
        boolean isValid = false;
        if (this.getTableID().equals(tableID) && this.getTableID().equals(tableAlias)) {
            NodeList nodeList = this.tableElement.getElementsByTagName("Field");
            int i = 0;
            while (i < nodeList.getLength()) {
                Element workElement = (Element)nodeList.item(i);
                if (workElement.getAttribute("ID").equals(fieldID)) {
                    isValid = true;
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.dialog_.getHeaderReferTableList().size()) {
                XF300_HeaderReferTable referTable = this.dialog_.getHeaderReferTableList().get(i);
                if (referTable.getTableID().equals(tableID) && referTable.getTableAlias().equals(tableAlias)) {
                    int j = 0;
                    while (j < referTable.getFieldIDList().size()) {
                        if (referTable.getFieldIDList().get(j).equals(fieldID)) {
                            isValid = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!isValid) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        return isValid;
    }

    public void runScript(String event1, String event2) throws ScriptException {
        ArrayList<XFScript> validScriptList = new ArrayList<XFScript>();
        int i = 0;
        while (i < this.scriptList.size()) {
            XFScript script = this.scriptList.get(i);
            if (script.isToBeRunAtEvent(event1, event2)) {
                validScriptList.add(script);
            }
            ++i;
        }
        this.dialog_.setEvaluatingScriptTabIndex(-1);
        i = 0;
        while (i < validScriptList.size()) {
            this.dialog_.evalHeaderTableScript(((XFScript)validScriptList.get(i)).getName(), ((XFScript)validScriptList.get(i)).getScriptText());
            ++i;
        }
    }
}

