/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Element;
import xeadDriver.XF300;
import xeadDriver.XF300_HeaderField;
import xeadDriver.XFUtility;

class XF300_KeyInputDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelMain = new JPanel();
    private JPanel jPanelKeyFields = new JPanel();
    private JPanel jPanelTop = new JPanel();
    private JPanel jPanelBottom = new JPanel();
    private JPanel jPanelButtons = new JPanel();
    private JPanel jPanelInfo = new JPanel();
    private GridLayout gridLayoutInfo = new GridLayout();
    private JLabel jLabelFunctionID = new JLabel();
    private JLabel jLabelSessionID = new JLabel();
    private JScrollPane jScrollPaneMessages = new JScrollPane();
    private JTextArea jTextAreaMessages = new JTextArea();
    private JButton jButtonCancel = new JButton();
    private JButton jButtonOK = new JButton();
    private XF300 dialog_;
    private ArrayList<XF300_HeaderField> fieldList = new ArrayList();
    private HashMap<String, Object> keyMap_ = new HashMap();

    public XF300_KeyInputDialog(XF300 dialog) {
        super(dialog, "", true);
        this.dialog_ = dialog;
        this.initComponentsAndVariants();
    }

    void initComponentsAndVariants() {
        this.jPanelMain.setLayout(new BorderLayout());
        this.jPanelTop.setLayout(new BorderLayout());
        this.jPanelKeyFields.setLayout(null);
        this.jPanelKeyFields.setFocusable(false);
        this.jTextAreaMessages.setEditable(false);
        this.jTextAreaMessages.setBorder(BorderFactory.createEtchedBorder());
        this.jTextAreaMessages.setFont(new Font(this.dialog_.getSession().systemFont, 0, 18));
        this.jTextAreaMessages.setFocusable(false);
        this.jTextAreaMessages.setLineWrap(true);
        this.jScrollPaneMessages.getViewport().add((Component)this.jTextAreaMessages, null);
        this.jScrollPaneMessages.setPreferredSize(new Dimension(10, 50));
        this.jPanelBottom.setPreferredSize(new Dimension(10, 50));
        this.jPanelBottom.setLayout(new BorderLayout());
        this.jPanelBottom.setBorder(null);
        this.jLabelFunctionID.setFont(new Font(this.dialog_.getSession().systemFont, 0, 16));
        this.jLabelFunctionID.setHorizontalAlignment(4);
        this.jLabelFunctionID.setForeground(Color.gray);
        this.jLabelFunctionID.setFocusable(false);
        this.jLabelSessionID.setFont(new Font(this.dialog_.getSession().systemFont, 0, 16));
        this.jLabelSessionID.setHorizontalAlignment(4);
        this.jLabelSessionID.setForeground(Color.gray);
        this.jLabelSessionID.setFocusable(false);
        this.jPanelButtons.setBorder(null);
        this.jPanelButtons.setLayout(null);
        this.jPanelButtons.setFocusable(false);
        this.gridLayoutInfo.setColumns(1);
        this.gridLayoutInfo.setRows(2);
        this.jPanelInfo.setLayout(this.gridLayoutInfo);
        this.jPanelInfo.add(this.jLabelSessionID);
        this.jPanelInfo.add(this.jLabelFunctionID);
        this.jPanelInfo.setFocusable(false);
        this.jPanelMain.add((Component)this.jPanelTop, "Center");
        this.jPanelMain.add((Component)this.jPanelBottom, "South");
        this.jPanelTop.add((Component)this.jPanelKeyFields, "Center");
        this.jPanelTop.add((Component)this.jScrollPaneMessages, "South");
        this.jPanelBottom.add((Component)this.jPanelInfo, "East");
        this.jPanelBottom.add((Component)this.jPanelButtons, "Center");
        this.jButtonCancel.setFont(new Font(this.dialog_.getSession().systemFont, 0, 16));
        this.jButtonCancel.setText(XFUtility.RESOURCE.getString("Cancel"));
        this.jButtonCancel.setBounds(new Rectangle(20, 9, 100, 32));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XF300_KeyInputDialog.this.keyMap_.clear();
                XF300_KeyInputDialog.this.setVisible(false);
            }
        });
        this.jButtonOK.setFont(new Font(this.dialog_.getSession().systemFont, 0, 16));
        this.jButtonOK.setText("OK");
        this.jButtonOK.setBounds(new Rectangle(200, 9, 100, 32));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean anyOfFieldsAreNull = false;
                int i = 0;
                while (i < XF300_KeyInputDialog.this.fieldList.size()) {
                    if (((XF300_HeaderField)XF300_KeyInputDialog.this.fieldList.get(i)).getInternalValue().equals(((XF300_HeaderField)XF300_KeyInputDialog.this.fieldList.get(i)).getNullValue())) {
                        anyOfFieldsAreNull = true;
                        break;
                    }
                    XF300_KeyInputDialog.this.keyMap_.put(((XF300_HeaderField)XF300_KeyInputDialog.this.fieldList.get(i)).getFieldID(), ((XF300_HeaderField)XF300_KeyInputDialog.this.fieldList.get(i)).getInternalValue());
                    ++i;
                }
                if (anyOfFieldsAreNull) {
                    XF300_KeyInputDialog.this.jTextAreaMessages.setText(XFUtility.RESOURCE.getString("FunctionError23"));
                } else {
                    XF300_KeyInputDialog.this.setVisible(false);
                }
            }
        });
        this.jPanelButtons.add(this.jButtonCancel);
        this.jPanelButtons.add(this.jButtonOK);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        int posX = 0;
        int posY = 0;
        int biggestWidth = 0;
        int biggestHeight = 0;
        Dimension dim = new Dimension();
        Dimension dimOfPriviousField = new Dimension();
        boolean topField = true;
        this.setTitle(this.dialog_.getTitle());
        this.jLabelSessionID.setText(this.dialog_.getSession().getSessionID());
        this.jLabelFunctionID.setText(this.dialog_.getFunctionInfo());
        FontMetrics metrics = this.jLabelFunctionID.getFontMetrics(this.jLabelFunctionID.getFont());
        this.jPanelInfo.setPreferredSize(new Dimension(metrics.stringWidth(this.jLabelFunctionID.getText()), 35));
        ArrayList<String> keyFieldList = this.dialog_.getHeaderTable().getKeyFieldIDList();
        int i = 0;
        while (i < keyFieldList.size()) {
            Element element = this.dialog_.getSession().getDomDocument().createElement("Field");
            element.setAttribute("DataSource", String.valueOf(this.dialog_.getHeaderTable().getTableID()) + "." + keyFieldList.get(i));
            XF300_HeaderField field = new XF300_HeaderField(element, this.dialog_);
            field.setEditable(true);
            this.fieldList.add(field);
            if (topField) {
                posX = 0;
                posY = 13;
                topField = false;
            } else {
                posX = 0;
                posY = posY + dimOfPriviousField.height + field.getPositionMargin() + 5;
            }
            dim = field.getPreferredSize();
            field.setBounds(posX, posY, dim.width, dim.height);
            this.jPanelKeyFields.add(field);
            if (posX + dim.width > biggestWidth) {
                biggestWidth = posX + dim.width;
            }
            if (posY + dim.height > biggestHeight) {
                biggestHeight = posY + dim.height;
            }
            dimOfPriviousField = new Dimension(dim.width, dim.height);
            ++i;
        }
        int width = 500;
        if (biggestWidth > 480) {
            width = biggestWidth + 20;
        }
        int height = biggestHeight + 170;
        this.setPreferredSize(new Dimension(width, height));
        this.pack();
    }

    public HashMap<String, Object> requestKeyValues(String message) {
        this.keyMap_.clear();
        if (message.equals("")) {
            this.jTextAreaMessages.setText(XFUtility.RESOURCE.getString("FunctionMessage29"));
        } else {
            this.jTextAreaMessages.setText(message);
        }
        Rectangle screenRect = this.dialog_.getSession().getMenuRectangle();
        int posX = (screenRect.width - (int)this.getPreferredSize().getWidth()) / 2 + screenRect.x;
        int posY = (screenRect.height - (int)this.getPreferredSize().getHeight()) / 2 + screenRect.y;
        this.setLocation(posX, posY);
        this.setVisible(true);
        return this.keyMap_;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.keyMap_.clear();
            this.setVisible(false);
        }
        super.processWindowEvent(e);
    }
}

