/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.script.ScriptException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadDriver.SortableDomElementListModel;
import xeadDriver.XF310;
import xeadDriver.XF310_HeaderReferTable;
import xeadDriver.XFScript;
import xeadDriver.XFTableOperator;
import xeadDriver.XFUtility;

class XF310_HeaderTable {
    private Element tableElement = null;
    private Element functionElement_ = null;
    private String tableID = "";
    private String fixedWhere = "";
    private ArrayList<String> keyFieldIDList = new ArrayList();
    private ArrayList<String> uniqueKeyList = new ArrayList();
    private ArrayList<XFScript> scriptList = new ArrayList();
    private XF310 dialog_;
    private StringTokenizer workTokenizer;
    private String updateCounterID = "";
    private long updateCounterValue = 0L;
    private String dbName = "";

    public XF310_HeaderTable(Element functionElement, XF310 dialog) {
        Element workElement;
        int i;
        NodeList nodeList;
        this.functionElement_ = functionElement;
        this.dialog_ = dialog;
        this.tableID = this.functionElement_.getAttribute("HeaderTable");
        this.tableElement = this.dialog_.getSession().getTableElement(this.tableID);
        this.updateCounterID = this.tableElement.getAttribute("UpdateCounter");
        if (this.updateCounterID.equals("")) {
            this.updateCounterID = "UPDCOUNTER";
        } else if (this.updateCounterID.toUpperCase().equals("*NONE")) {
            this.updateCounterID = "";
        }
        this.dbName = this.tableElement.getAttribute("DB").equals("") ? this.dialog_.getSession().getDatabaseName() : this.dialog_.getSession().getSubDBName(this.tableElement.getAttribute("DB"));
        if (this.functionElement_.getAttribute("HeaderKeyFields").equals("")) {
            nodeList = this.tableElement.getElementsByTagName("Key");
            i = 0;
            while (i < nodeList.getLength()) {
                workElement = (Element)nodeList.item(i);
                if (workElement.getAttribute("Type").equals("PK")) {
                    this.workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
                    while (this.workTokenizer.hasMoreTokens()) {
                        String workString = this.workTokenizer.nextToken();
                        this.keyFieldIDList.add(workString);
                    }
                    break;
                }
                ++i;
            }
        } else {
            this.workTokenizer = new StringTokenizer(this.functionElement_.getAttribute("HeaderKeyFields"), ";");
            while (this.workTokenizer.hasMoreTokens()) {
                this.keyFieldIDList.add(this.workTokenizer.nextToken());
            }
        }
        nodeList = this.tableElement.getElementsByTagName("Key");
        i = 0;
        while (i < nodeList.getLength()) {
            workElement = (Element)nodeList.item(i);
            if (workElement.getAttribute("Type").equals("SK")) {
                this.uniqueKeyList.add(workElement.getAttribute("Fields"));
            }
            ++i;
        }
        NodeList workList = this.tableElement.getElementsByTagName("Script");
        SortableDomElementListModel sortList = XFUtility.getSortedListModel(workList, "Order");
        int i2 = 0;
        while (i2 < sortList.size()) {
            Element element = (Element)sortList.getElementAt(i2);
            this.scriptList.add(new XFScript(this.tableID, element, this.dialog_.getSession().getTableNodeList()));
            ++i2;
        }
    }

    public String getUpdateCounterID() {
        return this.updateCounterID;
    }

    public void setUpdateCounterValue(XFTableOperator operator) throws Exception {
        if (!this.updateCounterID.equals("")) {
            this.updateCounterValue = Long.parseLong(operator.getValueOf(this.updateCounterID).toString());
        }
    }

    public String getSQLToSelect() {
        StringBuffer buf = new StringBuffer();
        buf.append("select ");
        int count = -1;
        int i = 0;
        while (i < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(i).isFieldOnPrimaryTable() && !this.dialog_.getHeaderFieldList().get(i).isVirtualField()) {
                if (++count > 0) {
                    buf.append(",");
                }
                buf.append(this.dialog_.getHeaderFieldList().get(i).getFieldID());
            }
            ++i;
        }
        if (!this.updateCounterID.equals("")) {
            buf.append(",");
            buf.append(this.updateCounterID);
        }
        buf.append(" from ");
        buf.append(this.tableID);
        this.fixedWhere = XFUtility.getFixedWhereValue(this.functionElement_.getAttribute("HeaderFixedWhere"), this.dialog_.getSession());
        buf.append(" where ");
        count = -1;
        i = 0;
        while (i < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(i).isKey()) {
                if (++count > 0) {
                    buf.append(" and ");
                }
                buf.append(this.dialog_.getHeaderFieldList().get(i).getFieldID());
                buf.append("=");
                buf.append(XFUtility.getTableOperationValue(this.dialog_.getHeaderFieldList().get(i).getBasicType(), this.dialog_.getParmMap().get(this.dialog_.getHeaderFieldList().get(i).getFieldID()), this.dbName));
            }
            ++i;
        }
        if (!this.fixedWhere.equals("")) {
            buf.append(" and (");
            buf.append(this.fixedWhere);
            buf.append(") ");
        }
        return buf.toString();
    }

    String getSQLToUpdate() {
        StringBuffer statementBuf = new StringBuffer();
        statementBuf.append("update ");
        statementBuf.append(this.tableID);
        statementBuf.append(" set ");
        boolean firstField = true;
        int i = 0;
        while (i < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(i).isFieldOnPrimaryTable() && !this.dialog_.getHeaderFieldList().get(i).isKey() && !this.dialog_.getHeaderFieldList().get(i).isVirtualField()) {
                if (!firstField) {
                    statementBuf.append(", ");
                }
                statementBuf.append(this.dialog_.getHeaderFieldList().get(i).getFieldID());
                statementBuf.append("=");
                statementBuf.append(XFUtility.getTableOperationValue(this.dialog_.getHeaderFieldList().get(i).getBasicType(), this.dialog_.getHeaderFieldList().get(i).getInternalValue(), this.dbName));
                firstField = false;
            }
            ++i;
        }
        if (!this.updateCounterID.equals("")) {
            if (!firstField) {
                statementBuf.append(", ");
            }
            statementBuf.append(this.updateCounterID);
            statementBuf.append("=");
            statementBuf.append(this.updateCounterValue + 1L);
        }
        statementBuf.append(" where ");
        firstField = true;
        i = 0;
        while (i < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(i).isKey()) {
                if (!firstField) {
                    statementBuf.append(" and ");
                }
                statementBuf.append(this.dialog_.getHeaderFieldList().get(i).getFieldID());
                statementBuf.append("=");
                statementBuf.append(XFUtility.getTableOperationValue(this.dialog_.getHeaderFieldList().get(i).getBasicType(), this.dialog_.getHeaderFieldList().get(i).getInternalValue(), this.dbName));
                firstField = false;
            }
            ++i;
        }
        if (!this.updateCounterID.equals("")) {
            statementBuf.append(" and ");
            statementBuf.append(this.updateCounterID);
            statementBuf.append("=");
            statementBuf.append(this.updateCounterValue);
        }
        return statementBuf.toString();
    }

    String getSQLToDelete() {
        StringBuffer statementBuf = new StringBuffer();
        statementBuf.append("delete from ");
        statementBuf.append(this.tableID);
        statementBuf.append(" where ");
        boolean firstField = true;
        int i = 0;
        while (i < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(i).isKey()) {
                if (!firstField) {
                    statementBuf.append(" and ");
                }
                statementBuf.append(this.dialog_.getHeaderFieldList().get(i).getFieldID());
                statementBuf.append("=");
                statementBuf.append(XFUtility.getTableOperationValue(this.dialog_.getHeaderFieldList().get(i).getBasicType(), this.dialog_.getHeaderFieldList().get(i).getInternalValue(), this.dbName));
                firstField = false;
            }
            ++i;
        }
        if (!this.updateCounterID.equals("")) {
            statementBuf.append(" and ");
            statementBuf.append(this.updateCounterID);
            statementBuf.append("=");
            statementBuf.append(this.updateCounterValue);
        }
        return statementBuf.toString();
    }

    public String getSQLToCheckSKDuplication(ArrayList<String> keyFieldList) {
        StringBuffer statementBuf = new StringBuffer();
        statementBuf.append("select ");
        boolean firstField = true;
        int i = 0;
        while (i < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(i).isFieldOnPrimaryTable() && !this.dialog_.getHeaderFieldList().get(i).isVirtualField()) {
                if (!firstField) {
                    statementBuf.append(",");
                }
                statementBuf.append(this.dialog_.getHeaderFieldList().get(i).getFieldID());
                firstField = false;
            }
            ++i;
        }
        statementBuf.append(" from ");
        statementBuf.append(this.tableID);
        statementBuf.append(" where ");
        firstField = true;
        int j = 0;
        while (j < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(j).isFieldOnPrimaryTable()) {
                int p = 0;
                while (p < keyFieldList.size()) {
                    if (this.dialog_.getHeaderFieldList().get(j).getFieldID().equals(keyFieldList.get(p))) {
                        if (!firstField) {
                            statementBuf.append(" and ");
                        }
                        statementBuf.append(this.dialog_.getHeaderFieldList().get(j).getFieldID());
                        statementBuf.append("=");
                        statementBuf.append(XFUtility.getTableOperationValue(this.dialog_.getHeaderFieldList().get(j).getBasicType(), this.dialog_.getHeaderFieldList().get(j).getInternalValue(), this.dbName));
                        firstField = false;
                    }
                    ++p;
                }
            }
            ++j;
        }
        firstField = true;
        j = 0;
        while (j < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(j).isFieldOnPrimaryTable() && this.dialog_.getHeaderFieldList().get(j).isKey()) {
                if (firstField) {
                    statementBuf.append(" and (");
                } else {
                    statementBuf.append(" or ");
                }
                statementBuf.append(this.dialog_.getHeaderFieldList().get(j).getFieldID());
                statementBuf.append("!=");
                statementBuf.append(XFUtility.getTableOperationValue(this.dialog_.getHeaderFieldList().get(j).getBasicType(), this.dialog_.getHeaderFieldList().get(j).getInternalValue(), this.dbName));
                firstField = false;
            }
            ++j;
        }
        statementBuf.append(")");
        return statementBuf.toString();
    }

    boolean hasPrimaryKeyValueAltered() {
        boolean altered = false;
        int i = 0;
        while (i < this.dialog_.getHeaderFieldList().size()) {
            if (this.dialog_.getHeaderFieldList().get(i).isKey() && !this.dialog_.getHeaderFieldList().get(i).getValue().equals(this.dialog_.getHeaderFieldList().get(i).getOldValue())) {
                altered = true;
            }
            ++i;
        }
        return altered;
    }

    public String getTableID() {
        return this.tableID;
    }

    public Element getTableElement() {
        return this.tableElement;
    }

    public ArrayList<String> getKeyFieldIDList() {
        return this.keyFieldIDList;
    }

    public ArrayList<String> getUniqueKeyList() {
        return this.uniqueKeyList;
    }

    public ArrayList<XFScript> getScriptList() {
        return this.scriptList;
    }

    public boolean isValidDataSource(String tableID, String tableAlias, String fieldID) {
        boolean isValid = false;
        if (this.getTableID().equals(tableID) && this.getTableID().equals(tableAlias)) {
            NodeList nodeList = this.tableElement.getElementsByTagName("Field");
            int i = 0;
            while (i < nodeList.getLength()) {
                Element workElement = (Element)nodeList.item(i);
                if (workElement.getAttribute("ID").equals(fieldID)) {
                    isValid = true;
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.dialog_.getHeaderReferTableList().size()) {
                XF310_HeaderReferTable referTable = this.dialog_.getHeaderReferTableList().get(i);
                if (referTable.getTableID().equals(tableID) && referTable.getTableAlias().equals(tableAlias)) {
                    int j = 0;
                    while (j < referTable.getFieldIDList().size()) {
                        if (referTable.getFieldIDList().get(j).equals(fieldID)) {
                            isValid = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!isValid) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        return isValid;
    }

    public int runScript(String event1, String event2) throws ScriptException {
        int countOfErrors = 0;
        ArrayList<XFScript> validScriptList = new ArrayList<XFScript>();
        int i = 0;
        while (i < this.scriptList.size()) {
            XFScript script = this.scriptList.get(i);
            if (script.isToBeRunAtEvent(event1, event2)) {
                validScriptList.add(script);
            }
            ++i;
        }
        if (validScriptList.size() > 0) {
            i = 0;
            while (i < validScriptList.size()) {
                this.dialog_.evalScript(((XFScript)validScriptList.get(i)).getName(), ((XFScript)validScriptList.get(i)).getScriptText(), this.dialog_.getScriptBindings());
                ++i;
            }
            i = 0;
            while (i < this.dialog_.getHeaderFieldList().size()) {
                if (this.dialog_.getHeaderFieldList().get(i).isError()) {
                    ++countOfErrors;
                }
                ++i;
            }
        }
        return countOfErrors;
    }
}

