/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.script.ScriptException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadDriver.SortableDomElementListModel;
import xeadDriver.XF390;
import xeadDriver.XF390_HeaderReferTable;
import xeadDriver.XFScript;
import xeadDriver.XFUtility;

class XF390_HeaderTable {
    private Element tableElement = null;
    private Element functionElement_ = null;
    private String tableID = "";
    private ArrayList<String> keyFieldList = new ArrayList();
    private ArrayList<String> orderByFieldList = new ArrayList();
    private ArrayList<XFScript> scriptList = new ArrayList();
    private XF390 dialog_;
    private StringTokenizer workTokenizer;
    private String updateCounterID = "";
    private String dbName = "";

    public XF390_HeaderTable(Element functionElement, XF390 dialog) {
        this.functionElement_ = functionElement;
        this.dialog_ = dialog;
        this.tableID = this.functionElement_.getAttribute("HeaderTable");
        this.tableElement = this.dialog_.getSession().getTableElement(this.tableID);
        if (!this.tableElement.getAttribute("UpdateCounter").toUpperCase().equals("*NONE")) {
            this.updateCounterID = this.tableElement.getAttribute("UpdateCounter");
            if (this.updateCounterID.equals("")) {
                this.updateCounterID = "UPDCOUNTER";
            }
        }
        this.dbName = this.tableElement.getAttribute("DB").equals("") ? this.dialog_.getSession().getDatabaseName() : this.dialog_.getSession().getSubDBName(this.tableElement.getAttribute("DB"));
        if (this.functionElement_.getAttribute("KeyFields").equals("")) {
            NodeList nodeList = this.tableElement.getElementsByTagName("Key");
            int i = 0;
            while (i < nodeList.getLength()) {
                Element workElement = (Element)nodeList.item(i);
                if (workElement.getAttribute("Type").equals("PK")) {
                    this.workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
                    while (this.workTokenizer.hasMoreTokens()) {
                        String wrkStr1 = this.workTokenizer.nextToken();
                        this.keyFieldList.add(wrkStr1);
                    }
                }
                ++i;
            }
        } else {
            this.workTokenizer = new StringTokenizer(this.functionElement_.getAttribute("KeyFields"), ";");
            while (this.workTokenizer.hasMoreTokens()) {
                this.keyFieldList.add(this.workTokenizer.nextToken());
            }
        }
        this.workTokenizer = new StringTokenizer(this.functionElement_.getAttribute("OrderBy"), ";");
        while (this.workTokenizer.hasMoreTokens()) {
            this.orderByFieldList.add(this.workTokenizer.nextToken());
        }
        NodeList workList = this.tableElement.getElementsByTagName("Script");
        SortableDomElementListModel sortList = XFUtility.getSortedListModel(workList, "Order");
        int i = 0;
        while (i < sortList.size()) {
            Element element = (Element)sortList.getElementAt(i);
            this.scriptList.add(new XFScript(this.tableID, element, this.dialog_.getSession().getTableNodeList()));
            ++i;
        }
    }

    public String getName() {
        return this.tableElement.getAttribute("Name");
    }

    public String getSQLToSelect() {
        StringBuffer buf = new StringBuffer();
        buf.append("select ");
        boolean firstField = true;
        int i = 0;
        while (i < this.dialog_.getFieldList().size()) {
            if (this.dialog_.getFieldList().get(i).isFieldOnPrimaryTable() && !this.dialog_.getFieldList().get(i).isVirtualField() && !this.dialog_.getFieldList().get(i).getBasicType().equals("BYTEA")) {
                if (!firstField) {
                    buf.append(",");
                }
                buf.append(this.dialog_.getFieldList().get(i).getFieldID());
                firstField = false;
            }
            ++i;
        }
        if (!this.updateCounterID.equals("")) {
            buf.append(",");
            buf.append(this.updateCounterID);
        }
        buf.append(" from ");
        buf.append(this.tableID);
        if (this.orderByFieldList.size() > 0) {
            buf.append(" order by ");
            i = 0;
            while (i < this.orderByFieldList.size()) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.orderByFieldList.get(i));
                ++i;
            }
        }
        buf.append(" where ");
        int orderOfFieldInKey = 0;
        int i2 = 0;
        while (i2 < this.dialog_.getFieldList().size()) {
            if (this.dialog_.getFieldList().get(i2).isKey()) {
                if (orderOfFieldInKey > 0) {
                    buf.append(" and ");
                }
                buf.append(this.dialog_.getFieldList().get(i2).getFieldID());
                buf.append("=");
                buf.append(XFUtility.getTableOperationValue(this.dialog_.getFieldList().get(i2).getBasicType(), this.dialog_.getFieldList().get(i2).getInternalValue(), this.dbName));
                ++orderOfFieldInKey;
            }
            ++i2;
        }
        return buf.toString();
    }

    public String getTableID() {
        return this.tableID;
    }

    public Element getTableElement() {
        return this.tableElement;
    }

    public ArrayList<String> getKeyFieldList() {
        return this.keyFieldList;
    }

    public ArrayList<XFScript> getScriptList() {
        return this.scriptList;
    }

    public boolean isValidDataSource(String tableID, String tableAlias, String fieldID) {
        boolean isValid = false;
        if (this.getTableID().equals(tableID) && this.getTableID().equals(tableAlias)) {
            NodeList nodeList = this.tableElement.getElementsByTagName("Field");
            int i = 0;
            while (i < nodeList.getLength()) {
                Element workElement = (Element)nodeList.item(i);
                if (workElement.getAttribute("ID").equals(fieldID)) {
                    isValid = true;
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.dialog_.getHeaderReferTableList().size()) {
                XF390_HeaderReferTable referTable = this.dialog_.getHeaderReferTableList().get(i);
                if (referTable.getTableID().equals(tableID) && referTable.getTableAlias().equals(tableAlias)) {
                    int j = 0;
                    while (j < referTable.getFieldIDList().size()) {
                        if (referTable.getFieldIDList().get(j).equals(fieldID)) {
                            isValid = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!isValid) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        return isValid;
    }

    public void runScript(String event1, String event2) throws ScriptException {
        ArrayList<XFScript> validScriptList = new ArrayList<XFScript>();
        int i = 0;
        while (i < this.scriptList.size()) {
            XFScript script = this.scriptList.get(i);
            if (script.isToBeRunAtEvent(event1, event2)) {
                validScriptList.add(script);
            }
            ++i;
        }
        i = 0;
        while (i < validScriptList.size()) {
            this.dialog_.evalHeaderScript(((XFScript)validScriptList.get(i)).getName(), ((XFScript)validScriptList.get(i)).getScriptText());
            ++i;
        }
    }
}

