/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.codec.binary.Base64;
import xeadDriver.Session;
import xeadDriver.XFByteArray;
import xeadDriver.XFEditableField;
import xeadDriver.XFFieldScriptable;
import xeadDriver.XFUtility;

class XFByteaColumn
extends JPanel
implements XFEditableField {
    private static final long serialVersionUID = 1L;
    private int rows_ = 1;
    private String typeColumnID_ = "";
    private XFFieldScriptable typeColumn_ = null;
    private String fieldOptions_ = "";
    private JLabel jLabel = new JLabel();
    private JButton jButton = new JButton();
    private XFByteArray value_ = null;
    private XFByteArray oldValue_ = null;
    private boolean isEditable_ = false;
    private Session session_;

    public XFByteaColumn(String typeFieldID, String fieldOptions, Session session) {
        this.typeColumnID_ = typeFieldID;
        this.fieldOptions_ = fieldOptions;
        this.session_ = session;
        this.jLabel.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jLabel.setText(this.getExternalValue().toString());
        ImageIcon imageIcon = new ImageIcon(XFUtility.class.getResource("prompt.png"));
        this.jButton.setIcon(imageIcon);
        this.jButton.setPreferredSize(new Dimension(26, 25));
        this.jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XFByteaColumn.this.processBytea();
            }
        });
        this.jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getModifiersEx() & 0x40) != 0 && e.getKeyCode() == 10) {
                    XFByteaColumn.this.jButton.doClick();
                }
            }
        });
        int fieldWidth = 100;
        int fieldHeight = 25;
        String wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions_, "WIDTH");
        if (!wrkStr.equals("")) {
            fieldWidth = Integer.parseInt(wrkStr);
        }
        JTextField field = new JTextField();
        this.setBorder(field.getBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)this.jLabel, "Center");
        this.add((Component)this.jButton, "East");
        this.setSize(new Dimension(fieldWidth, fieldHeight));
        this.setFocusable(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                XFByteaColumn.this.jButton.requestFocus();
            }
        });
    }

    @Override
    public boolean isComponentFocusable() {
        return this.isFocusable();
    }

    @Override
    public boolean isEditable() {
        return this.isEditable_;
    }

    @Override
    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    @Override
    public void setEditable(boolean isEditable) {
        this.isEditable_ = isEditable;
    }

    public void setTypeColumn(XFFieldScriptable typeColumn) {
        if (typeColumn != null) {
            this.typeColumn_ = typeColumn;
            this.jLabel.setText(this.getExternalValue().toString());
        }
    }

    @Override
    public Object getInternalValue() {
        return this.value_;
    }

    @Override
    public void setOldValue(Object value) {
        this.oldValue_ = (XFByteArray)value;
    }

    @Override
    public Object getOldValue() {
        return this.oldValue_;
    }

    @Override
    public Object getExternalValue() {
        if (this.typeColumn_ == null) {
            return "<null>";
        }
        return "<" + this.typeColumn_.getValue().toString() + ">";
    }

    @Override
    public void setValue(Object value) {
        this.value_ = (XFByteArray)value;
        if (this.value_ == null) {
            this.typeColumn_.setValue("null");
        } else {
            this.typeColumn_ = this.value_.getTypeColumn();
            if (this.value_.getInternalValue().equals("")) {
                this.typeColumn_.setValue("null");
            }
        }
        this.jLabel.setText(this.getExternalValue().toString());
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    public String getTypeColumnID() {
        return this.typeColumnID_;
    }

    public boolean isUpdated() {
        return !this.oldValue_.getInternalValue().equals(this.value_.getInternalValue());
    }

    private void processBytea() {
        if (this.isEditable_) {
            Object[] bts = new Object[]{XFUtility.RESOURCE.getString("ByteaFieldMessage1"), XFUtility.RESOURCE.getString("ByteaFieldMessage2"), XFUtility.RESOURCE.getString("ByteaFieldMessage3")};
            int rtn = JOptionPane.showOptionDialog(this.session_, XFUtility.RESOURCE.getString("ByteaFieldMessage5"), XFUtility.RESOURCE.getString("ByteaFieldMessage4"), -1, 1, null, bts, bts[0]);
            if (rtn == 0) {
                this.browseBytea();
            }
            if (rtn == 1) {
                this.session_.jFileChooser.resetChoosableFileFilters();
                this.session_.jFileChooser.setDialogTitle(XFUtility.RESOURCE.getString("ByteaFieldMessage6"));
                int reply = this.session_.jFileChooser.showDialog(this.session_, XFUtility.RESOURCE.getString("ByteaFieldMessage7"));
                if (reply == 0) {
                    try {
                        File file = new File(this.session_.jFileChooser.getSelectedFile().getPath());
                        int point = file.getAbsolutePath().lastIndexOf(".");
                        if (point == -1) {
                            JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("ByteaFieldMessage8"));
                        } else {
                            if (this.typeColumn_ != null) {
                                this.typeColumn_.setValue(file.getAbsolutePath().substring(point + 1));
                            }
                            this.jLabel.setText(this.getExternalValue().toString());
                            FileInputStream inputStream = new FileInputStream(file);
                            byte[] binaryByteArray = new byte[(int)file.length()];
                            inputStream.read(binaryByteArray);
                            inputStream.close();
                            this.setValue(Base64.encodeBase64((byte[])binaryByteArray));
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("ByteaFieldMessage9")) + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            if (rtn == 2) {
                this.setValue(null);
            }
        } else {
            this.browseBytea();
        }
    }

    private void browseBytea() {
        if (this.typeColumn_ == null || this.typeColumn_.getValue().equals("") || this.typeColumn_.getValue().equals("null")) {
            JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("ByteaFieldMessage10"));
        } else {
            try {
                XFByteArray byteArray = this.value_;
                byte[] base64ByteArray = (byte[])byteArray.getInternalValue();
                byte[] binaryByteArray = Base64.decodeBase64((byte[])base64ByteArray);
                File binaryFile = this.session_.createTempFile("BYTEA", "." + this.typeColumn_.getValue());
                FileOutputStream outputStream = new FileOutputStream(binaryFile);
                outputStream.write(binaryByteArray);
                outputStream.close();
                this.session_.getDesktop().browse(binaryFile.toURI());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("ByteaFieldMessage11")) + e.getMessage());
            }
        }
    }
}

