/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import xeadDriver.Session;
import xeadDriver.XFCalendar_actionAdapter;
import xeadDriver.XFCalendar_changeAdapter;
import xeadDriver.XFCalendar_keyAdapter;
import xeadDriver.XFTableOperator;
import xeadDriver.XFUtility;

class XFCalendar
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Session session_;
    private DateButton[] dateButtonArray = new DateButton[42];
    private JPanel jPanelMain = new JPanel();
    private JPanel jPanelTop = new JPanel();
    private JTextArea jTextAreaBottom = new JTextArea();
    private JPanel jPanelCenter = new JPanel();
    private JTabbedPane jTabbedPaneCenter = new JTabbedPane();
    private JLabel jLabelYearMonth = new JLabel();
    private JLabel jLabelDateComment = new JLabel();
    private JLabel jLabelSun = new JLabel();
    private JLabel jLabelMon = new JLabel();
    private JLabel jLabelTue = new JLabel();
    private JLabel jLabelWed = new JLabel();
    private JLabel jLabelThu = new JLabel();
    private JLabel jLabelFri = new JLabel();
    private JLabel jLabelSat = new JLabel();
    private Calendar calendarForToday;
    private Date maxValueDate = new Date();
    private Dimension scrSize;
    private Dimension dlgSize;
    private SimpleDateFormat day = new SimpleDateFormat("d");
    private SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
    private Date date = new Date();
    private Date selectedDate = null;
    private ArrayList<String> kbCalendarList = new ArrayList();
    private HashMap<String, String> offDateMap = new HashMap();
    private Color lightRedGray = new Color(228, 192, 192);

    public XFCalendar(Session session) {
        this.setModal(true);
        this.setTitle(XFUtility.RESOURCE.getString("Calendar"));
        this.session_ = session;
        this.jPanelMain.setLayout(new BorderLayout());
        this.scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.jPanelTop.setPreferredSize(new Dimension(346, 20));
        this.jPanelTop.setLayout(null);
        this.jLabelYearMonth.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jLabelYearMonth.setBounds(5, 0, 200, 20);
        this.jLabelDateComment.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jLabelDateComment.setHorizontalAlignment(4);
        this.jLabelDateComment.setForeground(Color.gray);
        this.jLabelDateComment.setBounds(200, 3, 142, 17);
        this.jPanelTop.add(this.jLabelYearMonth);
        this.jPanelTop.add(this.jLabelDateComment);
        this.jPanelCenter.setBackground(Color.white);
        this.jPanelCenter.setBorder(null);
        this.jPanelCenter.setLayout(null);
        this.jPanelCenter.setPreferredSize(new Dimension(332, 158));
        this.jLabelSun.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jLabelSun.setHorizontalAlignment(0);
        this.jLabelSun.setBounds(3, 2, 48, 13);
        this.jPanelCenter.add(this.jLabelSun);
        this.jLabelMon.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jLabelMon.setHorizontalAlignment(0);
        this.jLabelMon.setBounds(50, 2, 48, 13);
        this.jPanelCenter.add(this.jLabelMon);
        this.jLabelTue.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jLabelTue.setHorizontalAlignment(0);
        this.jLabelTue.setBounds(98, 2, 48, 13);
        this.jPanelCenter.add(this.jLabelTue);
        this.jLabelWed.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jLabelWed.setHorizontalAlignment(0);
        this.jLabelWed.setBounds(146, 2, 48, 13);
        this.jPanelCenter.add(this.jLabelWed);
        this.jLabelThu.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jLabelThu.setHorizontalAlignment(0);
        this.jLabelThu.setBounds(194, 2, 48, 13);
        this.jPanelCenter.add(this.jLabelThu);
        this.jLabelFri.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jLabelFri.setHorizontalAlignment(0);
        this.jLabelFri.setBounds(242, 2, 48, 13);
        this.jPanelCenter.add(this.jLabelFri);
        this.jLabelSat.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jLabelSat.setHorizontalAlignment(0);
        this.jLabelSat.setBounds(290, 2, 48, 13);
        this.jPanelCenter.add(this.jLabelSat);
        String language = this.session_.getDateFormat().substring(0, 2);
        if (language.equals("en")) {
            this.jLabelSun.setText("Sun");
            this.jLabelMon.setText("Mon");
            this.jLabelTue.setText("Tue");
            this.jLabelWed.setText("Wed");
            this.jLabelThu.setText("Thur");
            this.jLabelFri.setText("Fri");
            this.jLabelSat.setText("Sat");
        }
        if (language.equals("jp")) {
            this.jLabelSun.setText("\u65e5");
            this.jLabelMon.setText("\u6708");
            this.jLabelTue.setText("\u706b");
            this.jLabelWed.setText("\u6c34");
            this.jLabelThu.setText("\u6728");
            this.jLabelFri.setText("\u91d1");
            this.jLabelSat.setText("\u571f");
        }
        int posX = 2;
        int i = 0;
        while (i < 42) {
            this.dateButtonArray[i] = new DateButton();
            this.dateButtonArray[i].addActionListener(new XFCalendar_actionAdapter(this));
            this.dateButtonArray[i].addKeyListener(new XFCalendar_keyAdapter(this));
            if (i == 7 || i == 14 || i == 21 || i == 28 || i == 35) {
                posX = 2;
            }
            if (i >= 0 && i <= 6) {
                this.dateButtonArray[i].setBounds(posX, 15, 48, 20);
            }
            if (i >= 7 && i <= 13) {
                this.dateButtonArray[i].setBounds(posX, 36, 48, 20);
            }
            if (i >= 14 && i <= 20) {
                this.dateButtonArray[i].setBounds(posX, 57, 48, 20);
            }
            if (i >= 21 && i <= 27) {
                this.dateButtonArray[i].setBounds(posX, 78, 48, 20);
            }
            if (i >= 28 && i <= 34) {
                this.dateButtonArray[i].setBounds(posX, 99, 48, 20);
            }
            if (i >= 35 && i <= 41) {
                this.dateButtonArray[i].setBounds(posX, 120, 48, 20);
            }
            this.jPanelCenter.add(this.dateButtonArray[i]);
            posX += 48;
            ++i;
        }
        this.calendarForToday = Calendar.getInstance();
        this.calendarForToday.setTime(new Date());
        try {
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy'\u5e74'MM'\u6708'dd'\u65e5'");
            String str1 = "9999\u5e7412\u670831\u65e5";
            this.maxValueDate = sdf1.parse(str1);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.jTextAreaBottom.setPreferredSize(new Dimension(346, 40));
        this.jTextAreaBottom.setFont(new Font(this.session_.systemFont, 0, 12));
        this.jTextAreaBottom.setEditable(false);
        this.jTextAreaBottom.setBackground(SystemColor.control);
        this.jTextAreaBottom.setText(XFUtility.RESOURCE.getString("CalendarComment"));
        try {
            StringBuffer statementBuf = new StringBuffer();
            statementBuf.append("select * from ");
            statementBuf.append(this.session_.getTableNameOfCalendar());
            XFTableOperator operator = new XFTableOperator(this.session_, null, statementBuf.toString(), true);
            while (operator.next()) {
                this.offDateMap.put(String.valueOf(operator.getValueOf("KBCALENDAR").toString().trim()) + ";" + operator.getValueOf("DTOFF").toString(), operator.getValueOf("TXOFF").toString().trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int count = 0;
        this.jTabbedPaneCenter.setFont(new Font(this.session_.systemFont, 0, 14));
        this.jTabbedPaneCenter.setTabPlacement(3);
        this.jTabbedPaneCenter.setTabLayoutPolicy(1);
        this.jTabbedPaneCenter.addChangeListener(new XFCalendar_changeAdapter(this));
        try {
            StringBuffer statementBuf = new StringBuffer();
            statementBuf.append("select * from ");
            statementBuf.append(this.session_.getTableNameOfUserVariants());
            statementBuf.append(" where IDUSERKUBUN = 'KBCALENDAR' order by SQLIST");
            XFTableOperator operator = new XFTableOperator(this.session_, null, statementBuf.toString(), true);
            while (operator.next()) {
                this.kbCalendarList.add(operator.getValueOf("KBUSERKUBUN").toString().trim());
                if (count == 0) {
                    this.jTabbedPaneCenter.addTab(operator.getValueOf("TXUSERKUBUN").toString().trim(), this.jPanelCenter);
                } else {
                    this.jTabbedPaneCenter.addTab(operator.getValueOf("TXUSERKUBUN").toString().trim(), null);
                }
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (count == 0) {
            this.jTabbedPaneCenter.addTab("User variants for calendar are missing", this.jPanelCenter);
        }
        this.jPanelMain.add((Component)this.jPanelTop, "North");
        this.jPanelMain.add((Component)this.jTabbedPaneCenter, "Center");
        this.jPanelMain.add((Component)this.jTextAreaBottom, "South");
        this.getContentPane().add(this.jPanelMain);
        this.dlgSize = new Dimension(352, 272);
        this.setPreferredSize(this.dlgSize);
        this.setResizable(false);
        this.pack();
    }

    public Date getDateOnCalendar(Date date, String kbCalendar, Point position) {
        this.selectedDate = date;
        this.date = date;
        this.jLabelDateComment.setText("");
        int index = this.kbCalendarList.indexOf(kbCalendar);
        if (index >= 0) {
            this.jTabbedPaneCenter.setSelectedIndex(index);
        }
        this.setupDates(this.date, 0);
        int posX = position.x;
        int posY = position.y;
        if (position.y + this.dlgSize.height > this.scrSize.height) {
            posY = position.y - this.dlgSize.height;
        }
        if (position.x + this.dlgSize.width > this.scrSize.width) {
            posX = position.x - this.dlgSize.width;
        }
        this.setLocation(posX, posY);
        super.setVisible(true);
        return this.selectedDate;
    }

    public void setupDates(Date focusedDate, int offset) {
        int shownMonth = 0;
        int indexOfFocusedDate = 0;
        Calendar cal = Calendar.getInstance();
        if (focusedDate == null) {
            focusedDate = cal.getTime();
        }
        cal.setTime(focusedDate);
        if (offset < 0) {
            cal.add(5, offset);
            focusedDate = cal.getTime();
        }
        if (offset > 0) {
            cal.add(5, offset);
            focusedDate = cal.getTime();
        }
        cal.set(5, 1);
        shownMonth = cal.get(2);
        this.jLabelYearMonth.setText(this.getYearMonthText(cal));
        String strWrk = "";
        cal.add(5, -cal.get(7) + 1);
        int i = 0;
        while (i < 42) {
            this.dateButtonArray[i].setEnabled(true);
            strWrk = this.kbCalendarList.get(this.jTabbedPaneCenter.getSelectedIndex());
            strWrk = String.valueOf(strWrk) + ";" + this.yyyyMMdd.format(cal.getTime());
            if (this.offDateMap.containsKey(strWrk)) {
                this.dateButtonArray[i].setToolTipText(this.offDateMap.get(strWrk));
                if (cal.get(2) == shownMonth) {
                    this.dateButtonArray[i].setForeground(Color.red);
                } else {
                    this.dateButtonArray[i].setEnabled(false);
                    this.dateButtonArray[i].setForeground(this.lightRedGray);
                }
            } else {
                this.dateButtonArray[i].setToolTipText("");
                if (cal.get(2) == shownMonth) {
                    this.dateButtonArray[i].setForeground(Color.black);
                } else {
                    this.dateButtonArray[i].setEnabled(false);
                    this.dateButtonArray[i].setForeground(Color.lightGray);
                }
            }
            if (cal.getTime().equals(focusedDate)) {
                indexOfFocusedDate = i;
            }
            this.dateButtonArray[i].setDate(cal.getTime());
            if (cal.get(1) == this.calendarForToday.get(1) && cal.get(2) == this.calendarForToday.get(2) && cal.get(5) == this.calendarForToday.get(5)) {
                this.dateButtonArray[i].setText("<html><u>" + this.dateButtonArray[i].getText());
            }
            cal.add(5, 1);
            ++i;
        }
        this.dateButtonArray[indexOfFocusedDate].requestFocus();
        this.jLabelDateComment.setText(this.dateButtonArray[indexOfFocusedDate].getToolTipText());
    }

    String getYearMonthText(Calendar cal) {
        SimpleDateFormat formatter;
        String result = "";
        String dateFormat = this.session_.getDateFormat();
        String language = this.session_.getDateFormat().substring(0, 2);
        if (language.equals("en")) {
            formatter = new SimpleDateFormat("MMMMM, yyyy", new Locale("en", "US", "US"));
            result = formatter.format(cal.getTime());
        }
        if (dateFormat.equals("jp00") || dateFormat.equals("jp01") || dateFormat.equals("jp10") || dateFormat.equals("jp11") || dateFormat.equals("jp20") || dateFormat.equals("jp21")) {
            formatter = new SimpleDateFormat("yyyy\u5e74 M\u6708");
            result = formatter.format(cal.getTime());
        }
        if (dateFormat.equals("jp30") || dateFormat.equals("jp31") || dateFormat.equals("jp40") || dateFormat.equals("jp41") || dateFormat.equals("jp50") || dateFormat.equals("jp51")) {
            formatter = new SimpleDateFormat("GGGGy\u5e74 M\u6708", new Locale("ja", "JP", "JP"));
            result = formatter.format(cal.getTime());
        }
        return result;
    }

    void jTabbedPaneCenter_stateChanged(ChangeEvent e) {
        if (this.isVisible()) {
            Component com = this.getFocusOwner();
            int i = 0;
            while (i < 42) {
                if (com.equals(this.dateButtonArray[i])) {
                    DateButton button = this.dateButtonArray[i];
                    this.setupDates(button.getDate(), 0);
                    break;
                }
                ++i;
            }
        }
    }

    void jButton_actionPerformed(ActionEvent e) {
        DateButton button = (DateButton)e.getSource();
        this.selectedDate = button.getDate();
        this.setVisible(false);
    }

    void jButton_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 57 && e.isControlDown()) {
            this.selectedDate = this.maxValueDate;
            this.setVisible(false);
        }
        if (e.getKeyCode() == 80 && e.isControlDown()) {
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            boolean ready = false;
            String answer = "2000-01-01";
            if (this.date != null) {
                answer = sdf1.format(this.date);
            }
            String message = XFUtility.RESOURCE.getString("CalendarMessage1");
            while (!ready) {
                if ((answer = JOptionPane.showInputDialog(null, message, answer)) == null || answer.equals("")) {
                    ready = true;
                    continue;
                }
                try {
                    this.selectedDate = sdf1.parse(answer);
                    ready = true;
                    this.setVisible(false);
                }
                catch (ParseException e1) {
                    message = XFUtility.RESOURCE.getString("CalendarMessage2");
                }
            }
        }
        if (e.getKeyCode() == 39 || e.getKeyCode() == 37 || e.getKeyCode() == 38 || e.getKeyCode() == 40) {
            Component com = this.getFocusOwner();
            int i = 0;
            while (i < 42) {
                if (com.equals(this.dateButtonArray[i])) {
                    if ((e.getModifiersEx() & 0x40) == 0) {
                        if (e.getKeyCode() == 39) {
                            this.setFocusOnNextButton(i, "RIGHT");
                        }
                        if (e.getKeyCode() == 37) {
                            this.setFocusOnNextButton(i, "LEFT");
                        }
                        if (e.getKeyCode() == 38) {
                            this.setFocusOnNextButton(i, "UP");
                        }
                        if (e.getKeyCode() != 40) break;
                        this.setFocusOnNextButton(i, "DOWN");
                        break;
                    }
                    if (e.getKeyCode() == 39) {
                        this.gotoNextMonth(this.dateButtonArray[i].getDate());
                    }
                    if (e.getKeyCode() != 37) break;
                    this.gotoPreviousMonth(this.dateButtonArray[i].getDate());
                    break;
                }
                ++i;
            }
        }
    }

    void gotoPreviousMonth(Date currentDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.set(5, 1);
        cal.add(5, -1);
        cal.set(5, 1);
        this.setupDates(cal.getTime(), 0);
    }

    void gotoNextMonth(Date currentDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        int month = cal.get(2);
        while (cal.get(2) == month) {
            cal.add(5, 1);
        }
        this.setupDates(cal.getTime(), 0);
    }

    void setFocusOnNextButton(int index, String direction) {
        int i = index;
        if (direction.equals("RIGHT")) {
            this.setupDates(this.dateButtonArray[i].getDate(), 1);
        }
        if (direction.equals("LEFT")) {
            this.setupDates(this.dateButtonArray[i].getDate(), -1);
        }
        if (direction.equals("DOWN")) {
            this.setupDates(this.dateButtonArray[i].getDate(), 7);
        }
        if (direction.equals("UP")) {
            this.setupDates(this.dateButtonArray[i].getDate(), -7);
        }
    }

    class DateButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private Date date;

        public DateButton() {
            this.setFont(new Font("SansSerif", 1, 12));
            this.addFocusListener(new DateButton_FocusAdapter());
        }

        public void setDate(Date date) {
            this.date = date;
            this.setText(XFCalendar.this.day.format(date));
        }

        public Date getDate() {
            return this.date;
        }
    }

    class DateButton_FocusAdapter
    implements FocusListener {
        DateButton_FocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component com = XFCalendar.this.getFocusOwner();
            int i = 0;
            while (i < 42) {
                if (com.equals(XFCalendar.this.dateButtonArray[i])) {
                    XFCalendar.this.jLabelDateComment.setText(XFCalendar.this.dateButtonArray[i].getToolTipText());
                }
                ++i;
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

