/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import xeadDriver.Session;
import xeadDriver.XFCheckListDialog_jButtonCancel_actionAdapter;
import xeadDriver.XFCheckListDialog_jButtonOK_actionAdapter;
import xeadDriver.XFUtility;

public class XFCheckListDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelMain = new JPanel();
    private DefaultListModel<JCheckBox> listModel = new DefaultListModel();
    private JList<JCheckBox> jList = new JList<JCheckBox>(this.listModel);
    private JScrollPane jScrollPane = new JScrollPane();
    private JButton jButtonOK = new JButton();
    private JButton jButtonCancel = new JButton();
    private JPanel jPanelButtons = new JPanel();
    private Dimension scrSize;
    private Dimension dlgSize;
    private HashMap<String, String> textKeyMap = new HashMap();
    private int sortMode = 0;
    private ArrayList<String> initialSelectKeyList = new ArrayList();
    private int reply = -1;
    private String checkedKeyList = "";
    private XFCheckListDialog_keyAdapter keyListener = new XFCheckListDialog_keyAdapter();
    private XFCheckListDialog_mouseAdapter mouseListener = new XFCheckListDialog_mouseAdapter();
    private Session session_;
    private GridLayout gridLayoutButtons = new GridLayout();
    private int width_ = 300;

    public XFCheckListDialog(Session session) {
        this.session_ = session;
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.jPanelMain.setLayout(new BorderLayout());
        this.jList.setBorder(null);
        this.jList.setSelectionMode(0);
        this.jList.setFixedCellHeight(25);
        this.jList.addKeyListener(this.keyListener);
        this.jList.addMouseListener(this.mouseListener);
        XFCheckListDialog_CheckBoxListRenderer renderer = new XFCheckListDialog_CheckBoxListRenderer();
        this.jList.setCellRenderer(renderer);
        this.jList.setBackground(this.jPanelMain.getBackground());
        this.jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane.getViewport().add(this.jList, null);
        this.jPanelMain.add((Component)this.jScrollPane, "Center");
        this.jPanelButtons.setBorder(null);
        this.jButtonCancel.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jButtonCancel.setText(XFUtility.RESOURCE.getString("Cancel"));
        this.jButtonCancel.addActionListener(new XFCheckListDialog_jButtonCancel_actionAdapter(this));
        this.jButtonOK.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new XFCheckListDialog_jButtonOK_actionAdapter(this));
        this.gridLayoutButtons.setColumns(2);
        this.gridLayoutButtons.setRows(1);
        this.jPanelButtons.setLayout(this.gridLayoutButtons);
        this.jPanelButtons.add(this.jButtonCancel);
        this.jPanelButtons.add(this.jButtonOK);
        this.scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.getContentPane().add((Component)this.jPanelButtons, "South");
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.jPanelButtons.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void clear() {
        this.textKeyMap.clear();
        this.initialSelectKeyList.clear();
    }

    public void addRow(String key, String text, boolean isSelected) {
        if (!this.textKeyMap.containsValue(key.trim())) {
            this.textKeyMap.put(text, key.trim());
            if (isSelected) {
                this.initialSelectKeyList.add(key.trim());
            }
        }
    }

    public void addRow(String key, String text) {
        this.addRow(key, text, false);
    }

    public int request(String title) {
        this.reply = -1;
        this.checkedKeyList = "";
        this.listModel.clear();
        Object[] mapkey = this.textKeyMap.keySet().toArray();
        if (this.sortMode == 1) {
            Arrays.sort(mapkey);
        }
        if (this.sortMode == -1) {
            Arrays.sort(mapkey, Collections.reverseOrder());
        }
        int i = 0;
        while (i < mapkey.length) {
            JCheckBox checkBox = new JCheckBox();
            checkBox.setFont(new Font(this.session_.systemFont, 0, 18));
            checkBox.setText(mapkey[i].toString());
            if (this.initialSelectKeyList.contains(this.textKeyMap.get(mapkey[i].toString()))) {
                checkBox.setSelected(true);
            }
            this.listModel.addElement(checkBox);
            ++i;
        }
        this.jList.setSelectedIndex(0);
        this.jList.requestFocus();
        int height = this.textKeyMap.size() * 25 + 70;
        if (height > 400) {
            height = 400;
        }
        this.dlgSize = new Dimension(this.width_, height + 30);
        this.setLocation((this.scrSize.width - this.dlgSize.width) / 2, (this.scrSize.height - this.dlgSize.height) / 2);
        this.setPreferredSize(this.dlgSize);
        this.setTitle(title);
        this.pack();
        this.setVisible(true);
        return this.reply;
    }

    public void sortList() {
        this.sortList(true);
    }

    public void sortList(boolean isAscent) {
        this.sortMode = isAscent ? 1 : -1;
    }

    public void setWidth(int width) {
        this.width_ = width;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.clear();
        }
    }

    public void jButtonOK_actionPerformed(ActionEvent e) {
        StringBuffer bf = new StringBuffer();
        int i = 0;
        while (i < this.listModel.size()) {
            JCheckBox checkBox = this.listModel.getElementAt(i);
            if (checkBox.isSelected()) {
                if (!bf.toString().equals("")) {
                    bf.append(";");
                }
                bf.append(this.textKeyMap.get(checkBox.getText()));
            }
            ++i;
        }
        this.checkedKeyList = bf.toString();
        if (!this.checkedKeyList.equals("")) {
            this.reply = 0;
        }
        this.clear();
        this.setVisible(false);
    }

    public void jButtonCancel_actionPerformed(ActionEvent e) {
        this.clear();
        this.setVisible(false);
    }

    public int getRowCount() {
        return this.listModel.size();
    }

    public void setListSelected(String keyList) {
        this.initialSelectKeyList.clear();
        StringTokenizer workTokenizer = new StringTokenizer(keyList, ";");
        while (workTokenizer.hasMoreTokens()) {
            this.initialSelectKeyList.add(workTokenizer.nextToken());
        }
    }

    public String getListSelected() {
        return this.checkedKeyList;
    }

    public boolean isSelected(String key) {
        StringTokenizer workTokenizer = new StringTokenizer(this.checkedKeyList, ";");
        while (workTokenizer.hasMoreTokens()) {
            if (!workTokenizer.nextToken().equals(key)) continue;
            return true;
        }
        return false;
    }

    class XFCheckListDialog_CheckBoxListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkBox = (JCheckBox)value;
            this.setText(checkBox.getText());
            this.setFont(new Font(((XFCheckListDialog)XFCheckListDialog.this).session_.systemFont, 0, 18));
            this.setSelected(checkBox.isSelected());
            this.setEnabled(checkBox.isEnabled());
            if (isSelected) {
                this.setBackground(XFCheckListDialog.this.jList.getSelectionBackground());
                this.setForeground(XFCheckListDialog.this.jList.getSelectionForeground());
            } else {
                this.setBackground(XFCheckListDialog.this.jList.getBackground());
                this.setForeground(XFCheckListDialog.this.jList.getForeground());
            }
            return this;
        }
    }

    class XFCheckListDialog_keyAdapter
    extends KeyAdapter {
        XFCheckListDialog_keyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 32) {
                int index = XFCheckListDialog.this.jList.getSelectedIndex();
                JCheckBox checkBox = (JCheckBox)XFCheckListDialog.this.listModel.getElementAt(index);
                if (checkBox.isSelected()) {
                    checkBox.setSelected(false);
                } else {
                    checkBox.setSelected(true);
                }
                XFCheckListDialog.this.jList.repaint();
            }
        }
    }

    class XFCheckListDialog_mouseAdapter
    extends MouseAdapter {
        XFCheckListDialog_mouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int index = XFCheckListDialog.this.jList.locationToIndex(p);
            if (index > -1) {
                JCheckBox checkBox = (JCheckBox)XFCheckListDialog.this.listModel.getElementAt(index);
                if (checkBox.isSelected()) {
                    checkBox.setSelected(false);
                } else {
                    checkBox.setSelected(true);
                }
                XFCheckListDialog.this.jList.repaint();
            }
        }
    }
}

