/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import xeadDriver.Session;
import xeadDriver.XFEditableField;
import xeadDriver.XFFYearBox_keyAdapter;
import xeadDriver.XFUtility;

class XFFYearBox
extends JPanel
implements XFEditableField {
    private static final long serialVersionUID = 1L;
    private int rows_ = 1;
    private JTextField jTextField = new JTextField();
    private JComboBox<String> jComboBoxYear = new JComboBox();
    private ArrayList<String> listYear = new ArrayList();
    private boolean isEditable = false;
    private String oldValue = "";
    private Session session_;
    private String dateFormat = "";
    private String language = "";

    public XFFYearBox(Session session) {
        this.session_ = session;
        this.dateFormat = this.session_.getDateFormat();
        this.language = this.session_.getDateFormat().substring(0, 2);
        this.jTextField.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jTextField.setEditable(false);
        this.jTextField.setBounds(new Rectangle(0, 0, 110, 25));
        GregorianCalendar calendar = new GregorianCalendar();
        int currentYear = calendar.get(1);
        int minimumYear = currentYear - 30;
        int maximumYear = currentYear + 10;
        this.jComboBoxYear.setFont(new Font(this.session_.systemFont, 0, 16));
        this.jComboBoxYear.addKeyListener(new XFFYearBox_keyAdapter(this));
        this.jComboBoxYear.setBounds(new Rectangle(0, 0, 110, 25));
        this.listYear.add("");
        this.jComboBoxYear.addItem("");
        int i = minimumYear;
        while (i <= maximumYear) {
            this.listYear.add(String.valueOf(i));
            this.jComboBoxYear.addItem(XFUtility.getUserExpressionOfYearMonth(String.valueOf(i), this.dateFormat));
            ++i;
        }
        this.listYear.add("9999");
        if (this.language.equals("en") || this.dateFormat.equals("jp00") || this.dateFormat.equals("jp01") || this.dateFormat.equals("jp10") || this.dateFormat.equals("jp11") || this.dateFormat.equals("jp20") || this.dateFormat.equals("jp21")) {
            this.jComboBoxYear.addItem(XFUtility.getUserExpressionOfYearMonth("9999", this.session_.getDateFormat()));
        } else {
            this.jComboBoxYear.addItem("H99");
        }
        this.setLayout(null);
        this.setSize(new Dimension(110, 25));
    }

    public void addActionListener(ActionListener listener) {
        this.jComboBoxYear.addActionListener(listener);
    }

    @Override
    public void setEditable(boolean editable) {
        this.removeAll();
        if (editable) {
            this.add(this.jComboBoxYear);
        } else {
            this.add(this.jTextField);
            this.setFocusable(false);
        }
        this.isEditable = editable;
    }

    @Override
    public void setToolTipText(String text) {
        this.jTextField.setToolTipText(text);
        this.jComboBoxYear.setToolTipText(text);
    }

    @Override
    public Object getInternalValue() {
        String year = this.listYear.get(this.jComboBoxYear.getSelectedIndex());
        return year;
    }

    @Override
    public Object getExternalValue() {
        return this.jComboBoxYear.getSelectedItem();
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isComponentFocusable() {
        return this.isEditable;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setValue(Object obj) {
        String value = obj.toString();
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.equals("")) {
            this.jComboBoxYear.setSelectedIndex(0);
            this.jTextField.setText("");
        } else if (value.length() == 4) {
            String yearValue = value.substring(0, 4);
            int index = this.listYear.indexOf(yearValue);
            if (index == -1) {
                this.jComboBoxYear.setSelectedIndex(0);
            } else {
                this.jComboBoxYear.setSelectedIndex(index);
            }
            this.jTextField.setText(this.jComboBoxYear.getItemAt(this.jComboBoxYear.getSelectedIndex()).toString());
        }
    }

    @Override
    public void setWidth(int width) {
    }

    @Override
    public void setOldValue(Object obj) {
        this.oldValue = (String)obj;
    }

    @Override
    public Object getOldValue() {
        return this.oldValue;
    }

    @Override
    public void setForeground(Color color) {
        if (this.jComboBoxYear != null) {
            this.jComboBoxYear.setForeground(color);
        }
        if (this.jTextField != null) {
            this.jTextField.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.jComboBoxYear != null) {
            this.jComboBoxYear.setBackground(color);
        }
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    void jComboBoxYear_keyPressed(KeyEvent e) {
        if ((e.getModifiersEx() & 0x40) != 0 && e.getKeyCode() == 10) {
            this.jComboBoxYear.showPopup();
        }
        if (e.getKeyCode() == 10 && !this.jComboBoxYear.isPopupVisible()) {
            this.requestFocus();
            this.dispatchEvent(e);
        }
    }
}

