/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import xeadDriver.Session;
import xeadDriver.XFInputDialogField;
import xeadDriver.XFInputDialog_jButtonClose_actionAdapter;
import xeadDriver.XFInputDialog_jButtonOK_actionAdapter;
import xeadDriver.XFUtility;

public class XFInputDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int BUTTONS_PANEL_HEIGHT = 43;
    private JPanel jPanelMain = new JPanel();
    private JPanel jPanelTop = new JPanel();
    private JPanel jPanelCenter = new JPanel();
    private JPanel jPanelBottom = new JPanel();
    private JPanel jPanelButtons = new JPanel();
    private JButton jButtonClose = new JButton();
    private JButton jButtonOK = new JButton();
    private JTextArea jTextArea = new JTextArea();
    private JScrollPane jScrollPane = new JScrollPane();
    private Dimension scrSize;
    private Dimension dlgSize;
    private ArrayList<XFInputDialogField> fieldList = new ArrayList();
    private ArrayList<Integer> areaIndexList = new ArrayList();
    private Action helpAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            XFInputDialog.this.session_.browseHelp();
        }
    };
    private Action escapeAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            XFInputDialog.this.returnTo("MENU");
        }
    };
    private int reply;
    private int nextLocationTopY = 6;
    private int nextLocationCenterY = 6;
    private int messageHeight = 55;
    private int dialogWidth = 300;
    private Session session_;

    public XFInputDialog(Session session) {
        this.setModal(true);
        this.session_ = session;
        this.scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.jPanelMain.setLayout(new BorderLayout());
        this.jPanelMain.setBorder(null);
        InputMap inputMap = this.jPanelMain.getInputMap(1);
        inputMap.clear();
        ActionMap actionMap = this.jPanelMain.getActionMap();
        actionMap.clear();
        inputMap.put(KeyStroke.getKeyStroke(112, 0), "HELP");
        actionMap.put("HELP", this.helpAction);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        actionMap.put("ESCAPE", this.escapeAction);
        this.jPanelTop.setLayout(null);
        this.jPanelTop.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelCenter.setLayout(null);
        this.jPanelBottom.setLayout(new BorderLayout());
        this.jPanelButtons.setLayout(null);
        this.jTextArea.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jTextArea.setEditable(false);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setWrapStyleWord(true);
        this.jScrollPane.getViewport().add(this.jTextArea);
        this.jScrollPane.setFocusable(false);
        this.jButtonClose.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jButtonClose.setText(XFUtility.RESOURCE.getString("Close"));
        this.jButtonClose.addActionListener(new XFInputDialog_jButtonClose_actionAdapter(this));
        this.jButtonOK.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new XFInputDialog_jButtonOK_actionAdapter(this));
        this.jPanelButtons.setPreferredSize(new Dimension(100, 43));
        this.jPanelButtons.add(this.jButtonClose);
        this.jPanelButtons.add(this.jButtonOK);
        this.jPanelBottom.add((Component)this.jScrollPane, "Center");
        this.jPanelBottom.add((Component)this.jPanelButtons, "South");
        this.jPanelMain.add((Component)this.jPanelBottom, "South");
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.setResizable(false);
    }

    public void clear() {
        this.jPanelTop.removeAll();
        this.jPanelCenter.removeAll();
        this.fieldList.clear();
        this.areaIndexList.clear();
        this.nextLocationTopY = 6;
        this.nextLocationCenterY = 6;
        this.jTextArea.setText("");
        this.messageHeight = 55;
        this.dialogWidth = 300;
        this.jButtonClose.requestFocus();
    }

    public void setMessage(String message) {
        this.jTextArea.setText(message);
    }

    public void setMessageHeight(int height) {
        this.messageHeight = height;
    }

    public void setWidth(int width) {
        this.dialogWidth = width;
    }

    public XFInputDialogField addField(String caption, String inputType) {
        return this.addField(caption, inputType, 0, "");
    }

    public XFInputDialogField addField(String caption, String inputType, int areaIndex) {
        return this.addField(caption, inputType, areaIndex, "");
    }

    public XFInputDialogField addField(String caption, String inputType, int areaIndex, String parmID) {
        if (areaIndex != 0 && areaIndex != 1 && areaIndex != -1) {
            areaIndex = 0;
        }
        XFInputDialogField field = new XFInputDialogField(caption, inputType, parmID, this);
        if (areaIndex == 0) {
            field.setBounds(new Rectangle(5, this.nextLocationTopY, field.getBounds().width, field.getBounds().height));
            this.nextLocationTopY = inputType.equals("TEXTAREA") ? this.nextLocationTopY + 75 + 5 : this.nextLocationTopY + 25 + 5;
            this.jPanelTop.add(field);
        }
        if (areaIndex == 1) {
            field.setBounds(new Rectangle(5, this.nextLocationCenterY, field.getBounds().width, field.getBounds().height));
            this.nextLocationCenterY = inputType.equals("TEXTAREA") ? this.nextLocationCenterY + 75 + 5 : this.nextLocationCenterY + 25 + 5;
            this.jPanelCenter.add(field);
        }
        this.fieldList.add(field);
        this.areaIndexList.add(areaIndex);
        return field;
    }

    public int request(String title) {
        int wrkInt;
        this.reply = -1;
        JComponent firstEditableFieldOnTopPanel = null;
        JComponent firstEditableFieldOnCenterPanel = null;
        int width = 300;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).isEditable() && this.areaIndexList.get(i) == 0 && firstEditableFieldOnTopPanel == null) {
                firstEditableFieldOnTopPanel = this.fieldList.get(i);
            }
            if (this.fieldList.get(i).isEditable() && this.areaIndexList.get(i) == 1 && firstEditableFieldOnCenterPanel == null) {
                firstEditableFieldOnCenterPanel = this.fieldList.get(i);
            }
            if ((wrkInt = this.fieldList.get((int)i).getBounds().width + 30) > width) {
                width = wrkInt;
            }
            ++i;
        }
        if (this.dialogWidth > width) {
            width = this.dialogWidth;
        }
        if (firstEditableFieldOnTopPanel != null) {
            firstEditableFieldOnTopPanel.requestFocus();
        } else if (firstEditableFieldOnCenterPanel != null) {
            firstEditableFieldOnCenterPanel.requestFocus();
        } else {
            this.jButtonClose.requestFocus();
        }
        if (this.nextLocationTopY > 6 && this.nextLocationCenterY > 6) {
            this.dlgSize = new Dimension(width, this.nextLocationTopY + 6 + this.nextLocationCenterY + this.messageHeight + 43);
            this.jPanelTop.setPreferredSize(new Dimension(width, this.nextLocationTopY + 2));
            this.jPanelMain.add((Component)this.jPanelTop, "North");
            this.jPanelMain.add((Component)this.jPanelCenter, "Center");
        }
        if (this.nextLocationTopY == 6 && this.nextLocationCenterY > 6) {
            this.dlgSize = new Dimension(width, this.nextLocationCenterY + 2 + this.messageHeight + 43);
            this.jPanelMain.remove(this.jPanelTop);
            this.jPanelMain.add((Component)this.jPanelCenter, "Center");
        }
        if (this.nextLocationTopY > 6 && this.nextLocationCenterY == 6) {
            this.dlgSize = new Dimension(width, this.nextLocationTopY + 2 + this.messageHeight + 43);
            this.jPanelMain.add((Component)this.jPanelTop, "Center");
            this.jPanelMain.remove(this.jPanelCenter);
        }
        if (this.nextLocationTopY == 6 && this.nextLocationCenterY == 6) {
            this.dlgSize = new Dimension(width, this.messageHeight + 43);
            this.jPanelMain.remove(this.jPanelTop);
            this.jPanelMain.remove(this.jPanelCenter);
        }
        this.jPanelBottom.setPreferredSize(new Dimension(width, this.messageHeight + 43));
        wrkInt = (width - 240) / 2;
        this.jButtonClose.setBounds(wrkInt, 8, 100, 27);
        this.jButtonOK.setBounds(wrkInt + 140, 8, 100, 27);
        this.jTextArea.setCaretPosition(0);
        FontMetrics metricsTitle = this.getFontMetrics(this.getFont());
        int titleWidth = metricsTitle.stringWidth(title) + 50;
        if (titleWidth > width) {
            width = titleWidth;
            this.dlgSize = new Dimension(width, this.dlgSize.height);
        }
        this.jPanelMain.setPreferredSize(this.dlgSize);
        this.setTitle(title);
        this.setLocation((this.scrSize.width - this.dlgSize.width) / 2, (this.scrSize.height - this.dlgSize.height) / 2);
        this.pack();
        this.setVisible(true);
        return this.reply;
    }

    public Object getValueOfFieldByParmID(String parmID) {
        Object obj = null;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).getParmID().equals(parmID)) {
                obj = this.fieldList.get(i).getValue();
                break;
            }
            ++i;
        }
        return obj;
    }

    public ArrayList<XFInputDialogField> getFieldList() {
        return this.fieldList;
    }

    public Session getSession() {
        return this.session_;
    }

    void returnTo(String target) {
        if (target.equals("MENU")) {
            this.setVisible(false);
        }
    }

    void jButtonClose_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void jButtonOK_actionPerformed(ActionEvent e) {
        this.reply = 0;
        this.setVisible(false);
    }
}

