/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.awt.im.InputSubset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import xeadDriver.XFEditableField;
import xeadDriver.XFUtility;

class XFTextField
extends JPanel
implements XFEditableField {
    private static final long serialVersionUID = 1L;
    private String basicType_ = "";
    private String fontName_ = "";
    private int digits_ = 5;
    private int decimal_ = 0;
    private int rows_ = 1;
    private ArrayList<String> dataTypeOptionList;
    private String fieldOptions_;
    private String autoNumberKey = "";
    private String oldValue = "";
    private JTextField jTextField = new JTextField();
    private JComboBox<String> jComboBox = null;
    private String[] valueList_ = null;
    private boolean itemSelectionControled = true;
    private boolean isFilter_ = true;

    public XFTextField(String basicType, int digits, int decimal, String dataTypeOptions, String fieldOptions, String fontName) {
        this(basicType, digits, decimal, dataTypeOptions, fieldOptions, fontName, false);
    }

    public XFTextField(String basicType, int digits, int decimal, String dataTypeOptions, String fieldOptions, String fontName, boolean isFilter) {
        this.basicType_ = basicType;
        this.fontName_ = fontName;
        this.isFilter_ = isFilter;
        this.digits_ = digits == 0 ? 10 : digits;
        this.decimal_ = decimal;
        this.dataTypeOptionList = XFUtility.getOptionList(dataTypeOptions);
        this.fieldOptions_ = fieldOptions;
        if (this.dataTypeOptionList.contains("PERCENT")) {
            ++this.digits_;
        }
        String alignment = XFUtility.getOptionValueWithKeyword(this.fieldOptions_, "ALIGNMENT");
        if (this.basicType_.equals("INTEGER")) {
            if (alignment.equals("") || alignment.equals("RIGHT")) {
                this.jTextField.setHorizontalAlignment(4);
            }
            if (alignment.equals("CENTER")) {
                this.jTextField.setHorizontalAlignment(0);
            }
            if (alignment.equals("LEFT")) {
                this.jTextField.setHorizontalAlignment(2);
            }
            if (!this.isFilter_) {
                this.jTextField.setText(this.getFormattedNumber("0"));
            }
        } else if (this.basicType_.equals("FLOAT")) {
            if (alignment.equals("") || alignment.equals("RIGHT")) {
                this.jTextField.setHorizontalAlignment(4);
            }
            if (alignment.equals("CENTER")) {
                this.jTextField.setHorizontalAlignment(0);
            }
            if (alignment.equals("LEFT")) {
                this.jTextField.setHorizontalAlignment(2);
            }
            if (!this.isFilter_) {
                String wrkStr = "";
                if (this.decimal_ == 0) {
                    wrkStr = "0";
                }
                if (this.decimal_ == 1) {
                    wrkStr = "0.0";
                }
                if (this.decimal_ == 2) {
                    wrkStr = "0.00";
                }
                if (this.decimal_ == 3) {
                    wrkStr = "0.000";
                }
                if (this.decimal_ == 4) {
                    wrkStr = "0.0000";
                }
                if (this.decimal_ == 5) {
                    wrkStr = "0.00000";
                }
                if (this.decimal_ == 6) {
                    wrkStr = "0.000000";
                }
                this.jTextField.setText(this.getFormattedNumber(wrkStr));
            }
        } else {
            if (alignment.equals("") || alignment.equals("LEFT")) {
                this.jTextField.setHorizontalAlignment(2);
            }
            if (alignment.equals("CENTER")) {
                this.jTextField.setHorizontalAlignment(0);
            }
            if (alignment.equals("RIGHT")) {
                this.jTextField.setHorizontalAlignment(4);
            }
        }
        this.jTextField.addFocusListener(new ComponentFocusListener());
        this.jTextField.setFont(new Font(this.fontName_, 0, 18));
        this.jTextField.setDocument(new LimitedDocument(this));
        this.jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && XFTextField.this.basicType_.equals("STRING") && !XFTextField.this.autoNumberKey.equals("")) {
                    XFTextField.this.fillZero();
                }
            }
        });
        int fieldWidth = this.dataTypeOptionList.contains("KANJI") || this.dataTypeOptionList.contains("ZIPADRS") ? this.digits_ * 18 + 10 : (this.basicType_.equals("INTEGER") || this.basicType_.equals("FLOAT") ? XFUtility.getLengthOfEdittedNumericValue(this.digits_, this.decimal_, this.dataTypeOptionList) * 11 + 15 : (this.basicType_.equals("DATETIME") ? 264 : this.digits_ * 11 + 10));
        if (fieldWidth > 800) {
            fieldWidth = 800;
        }
        int fieldHeight = 25;
        String wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions_, "WIDTH");
        if (!wrkStr.equals("")) {
            fieldWidth = Integer.parseInt(wrkStr);
        }
        if (!(wrkStr = XFUtility.getOptionValueWithKeyword(dataTypeOptions, "AUTO_NUMBER")).equals("")) {
            this.autoNumberKey = wrkStr;
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                XFTextField.this.jTextField.requestFocus();
                if (XFTextField.this.jComboBox != null) {
                    XFTextField.this.jComboBox.requestFocus();
                }
            }
        });
        this.setSize(new Dimension(fieldWidth, fieldHeight));
        this.jTextField.setBorder(null);
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTextField, "Center");
    }

    public void addKeyListener(KeyAdapter adapter) {
        this.jTextField.addKeyListener(adapter);
    }

    @Override
    public boolean isComponentFocusable() {
        return this.jTextField.isFocusable();
    }

    @Override
    public boolean isEditable() {
        return this.jTextField.isEditable();
    }

    public String[] getValueList() {
        return this.valueList_;
    }

    @Override
    public void setForeground(Color color) {
        if (this.jComboBox == null) {
            if (this.jTextField != null) {
                this.jTextField.setForeground(color);
            }
        } else {
            this.jComboBox.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.jComboBox == null) {
            if (this.jTextField != null) {
                this.jTextField.setBackground(color);
            }
        } else {
            this.jComboBox.setBackground(color);
        }
    }

    public void setValueList(String[] valueList) {
        if (!Arrays.equals(valueList, this.valueList_)) {
            this.valueList_ = valueList;
            if (this.valueList_ == null || this.valueList_.length == 0) {
                if (this.jComboBox != null) {
                    this.remove(this.jComboBox);
                }
                this.add(this.jTextField);
                this.jComboBox = null;
            } else {
                this.itemSelectionControled = true;
                this.jComboBox = new JComboBox();
                this.jComboBox.setBorder(null);
                DefaultListCellRenderer renderer = new DefaultListCellRenderer();
                ((JLabel)renderer).setHorizontalAlignment(this.jTextField.getHorizontalAlignment());
                this.jComboBox.setRenderer(renderer);
                this.jComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!XFTextField.this.itemSelectionControled || XFTextField.this.jTextField.getText().equals("")) {
                            XFTextField.this.jTextField.setText((String)XFTextField.this.jComboBox.getSelectedItem());
                        }
                    }
                });
                InputMap inputMap = this.jComboBox.getInputMap(1);
                ActionMap actionMap = this.jComboBox.getActionMap();
                inputMap.put(KeyStroke.getKeyStroke(10, 0), "CHECK");
                actionMap.put("CHECK", null);
                int i = 0;
                while (i < this.valueList_.length) {
                    this.jComboBox.addItem(this.valueList_[i]);
                    ++i;
                }
                int index = -1;
                int i2 = 0;
                while (i2 < this.jComboBox.getItemCount()) {
                    if (this.jComboBox.getItemAt(i2).toString().equals(this.jTextField.getText())) {
                        index = i2;
                        break;
                    }
                    ++i2;
                }
                if (index > -1) {
                    this.jComboBox.setSelectedIndex(index);
                }
                this.itemSelectionControled = false;
                this.remove(this.jTextField);
                this.add(this.jComboBox);
            }
        }
    }

    public void setHorizontalAlignment(int alignment) {
        this.jTextField.setHorizontalAlignment(alignment);
        if (this.jComboBox != null) {
            ((JLabel)((Object)this.jComboBox.getRenderer())).setHorizontalAlignment(alignment);
        }
    }

    @Override
    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    @Override
    public void setEditable(boolean editable) {
        this.jTextField.setEditable(editable);
        if (this.jComboBox == null) {
            if (editable) {
                this.jTextField.setFont(new Font(this.fontName_, 0, 16));
            } else {
                this.jTextField.setFont(new Font(this.fontName_, 0, 18));
            }
        } else {
            this.jComboBox.setFocusable(editable);
            if (editable) {
                this.remove(this.jTextField);
                this.add(this.jComboBox);
            } else {
                this.remove(this.jComboBox);
                this.add(this.jTextField);
            }
        }
    }

    public String getStringNumber(String text) {
        String numberString = XFUtility.getStringNumber(text);
        if (numberString.equals("")) {
            if (!this.isFilter_) {
                if (this.basicType_.equals("INTEGER")) {
                    numberString = "0";
                }
                if (this.basicType_.equals("FLOAT")) {
                    if (this.decimal_ == 0) {
                        numberString = "0";
                    }
                    if (this.decimal_ == 1) {
                        numberString = "0.0";
                    }
                    if (this.decimal_ == 2) {
                        numberString = "0.00";
                    }
                    if (this.decimal_ == 3) {
                        numberString = "0.000";
                    }
                    if (this.decimal_ == 4) {
                        numberString = "0.0000";
                    }
                    if (this.decimal_ == 5) {
                        numberString = "0.00000";
                    }
                    if (this.decimal_ == 6) {
                        numberString = "0.000000";
                    }
                }
            }
        } else if (this.dataTypeOptionList.contains("ZIPNO")) {
            numberString = numberString.replace("-", "");
            int workLength = 7 - numberString.length();
            int i = 0;
            while (i < workLength) {
                numberString = String.valueOf(numberString) + "0";
                ++i;
            }
            numberString = String.valueOf(numberString.substring(0, 3)) + "-" + numberString.substring(3, 7);
        }
        return numberString;
    }

    @Override
    public Object getInternalValue() {
        String text = "";
        text = this.basicType_.equals("INTEGER") || this.basicType_.equals("FLOAT") || this.dataTypeOptionList.contains("DIAL") || this.dataTypeOptionList.contains("ZIPNO") ? (this.jTextField.getText().equals("*AUTO") ? this.jTextField.getText() : this.getStringNumber(this.jTextField.getText())) : this.jTextField.getText();
        return text;
    }

    @Override
    public void setOldValue(Object obj) {
        this.oldValue = obj.toString();
    }

    @Override
    public Object getOldValue() {
        String text = "";
        text = this.basicType_.equals("INTEGER") || this.basicType_.equals("FLOAT") || this.dataTypeOptionList.contains("DIAL") || this.dataTypeOptionList.contains("ZIPNO") ? this.getStringNumber(this.oldValue) : this.oldValue;
        return text;
    }

    public String getText() {
        return this.jTextField.getText();
    }

    public void setText(String text) {
        this.jTextField.setText(text);
    }

    @Override
    public Object getExternalValue() {
        return this.getInternalValue();
    }

    @Override
    public void setValue(Object obj) {
        String text = null;
        if (obj != null) {
            text = obj.toString();
        }
        if (text != null) {
            if (this.basicType_.equals("INTEGER")) {
                if (text.equals("*AUTO")) {
                    this.jTextField.setText(text);
                } else {
                    this.jTextField.setText(this.getFormattedNumber(text));
                }
            }
            if (this.basicType_.equals("FLOAT")) {
                this.jTextField.setText(this.getFormattedNumber(text));
            }
            if (this.basicType_.equals("DATE")) {
                this.jTextField.setText(text);
            }
            if (this.basicType_.equals("TIME")) {
                this.jTextField.setText(text);
            }
            if (this.basicType_.equals("DATETIME")) {
                text = text.replace("-", "/");
                this.jTextField.setText(text);
            }
            if (this.basicType_.equals("STRING") || this.basicType_.equals("BYTEA")) {
                text = text.trim();
                this.jTextField.setText(text);
            }
        }
    }

    public String getFormattedNumber(String text) {
        String value = "0";
        if (text != null) {
            if (this.basicType_.equals("INTEGER")) {
                value = XFUtility.getFormattedIntegerValue(this.getStringNumber(text), this.dataTypeOptionList, this.digits_);
            }
            if (this.basicType_.equals("FLOAT")) {
                value = XFUtility.getFormattedFloatValue(this.getStringNumber(text), this.decimal_);
            }
            if (this.isFilter_ && text.equals("")) {
                value = "";
            }
        }
        return value;
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    private void fillZero() {
        int stringDigitFrom = -1;
        int numberDigitFrom = 0;
        if (this.jTextField.getText().length() < this.digits_ && !this.jTextField.getText().equals("")) {
            int i = 0;
            while (i < this.jTextField.getText().length()) {
                try {
                    Integer.parseInt(this.jTextField.getText().substring(i, i + 1));
                    numberDigitFrom = i;
                    break;
                }
                catch (NumberFormatException e) {
                    stringDigitFrom = i++;
                }
            }
            StringBuffer sb = new StringBuffer();
            if (stringDigitFrom > -1 && numberDigitFrom > stringDigitFrom) {
                sb.append(this.jTextField.getText().substring(stringDigitFrom, numberDigitFrom));
            }
            int zeroLen = this.digits_ - this.jTextField.getText().length();
            int i2 = 0;
            while (i2 < zeroLen) {
                sb.append("0");
                ++i2;
            }
            sb.append(this.jTextField.getText().substring(numberDigitFrom, this.jTextField.getText().length()));
            this.jTextField.setText(sb.toString());
        }
    }

    class ComponentFocusListener
    implements FocusListener {
        ComponentFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (XFTextField.this.basicType_.equals("INTEGER") && !XFTextField.this.jTextField.getText().equals("*AUTO")) {
                XFTextField.this.jTextField.setText(XFTextField.this.getFormattedNumber(XFTextField.this.jTextField.getText()));
            }
            if (XFTextField.this.basicType_.equals("FLOAT")) {
                XFTextField.this.jTextField.setText(XFTextField.this.getFormattedNumber(XFTextField.this.jTextField.getText()));
            }
            if (XFTextField.this.getInputContext() != null) {
                XFTextField.this.getInputContext().setCompositionEnabled(false);
            }
            if (XFTextField.this.basicType_.equals("STRING") && !XFTextField.this.autoNumberKey.equals("")) {
                XFTextField.this.fillZero();
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            if (XFTextField.this.jTextField.isEditable()) {
                XFTextField.this.jTextField.selectAll();
            }
            Character.Subset[] subsets = new Character.Subset[]{InputSubset.LATIN_DIGITS};
            String lang = Locale.getDefault().getLanguage();
            if (XFTextField.this.basicType_.equals("STRING")) {
                if (XFTextField.this.dataTypeOptionList.contains("KANJI") || XFTextField.this.dataTypeOptionList.contains("ZIPADRS")) {
                    if (lang.equals("ja")) {
                        subsets = new Character.Subset[]{InputSubset.KANJI};
                    }
                    if (lang.equals("ko")) {
                        subsets = new Character.Subset[]{InputSubset.HANJA};
                    }
                    if (lang.equals("zh")) {
                        subsets = new Character.Subset[]{InputSubset.TRADITIONAL_HANZI};
                    }
                    XFTextField.this.getInputContext().setCharacterSubsets(subsets);
                    XFTextField.this.getInputContext().setCompositionEnabled(true);
                } else if (XFTextField.this.dataTypeOptionList.contains("KATAKANA") && lang.equals("ja")) {
                    subsets = new Character.Subset[]{InputSubset.HALFWIDTH_KATAKANA};
                    XFTextField.this.getInputContext().setCharacterSubsets(subsets);
                    XFTextField.this.getInputContext().setCompositionEnabled(true);
                } else {
                    InputContext ic = XFTextField.this.getInputContext();
                    if (ic != null) {
                        ic.setCharacterSubsets(subsets);
                        ic.setCompositionEnabled(false);
                    }
                }
            } else {
                InputContext ic = XFTextField.this.getInputContext();
                if (ic != null) {
                    ic.setCharacterSubsets(subsets);
                    ic.setCompositionEnabled(false);
                }
            }
        }
    }

    class LimitedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        XFTextField adaptee;

        LimitedDocument(XFTextField adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) {
            try {
                int integerSizeOfField = this.adaptee.digits_ - this.adaptee.decimal_;
                if (this.adaptee.decimal_ > 0 && str.length() == 1) {
                    if (this.adaptee.isEditable() && (XFTextField.this.basicType_.equals("INTEGER") || XFTextField.this.basicType_.equals("FLOAT")) && !XFTextField.this.dataTypeOptionList.contains("ACCEPT_MINUS") && str.contains("-")) {
                        JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("MinusError")) + ": " + str);
                    } else {
                        String wrkStr0 = super.getText(0, super.getLength());
                        wrkStr0 = String.valueOf(wrkStr0.substring(0, offset)) + str + wrkStr0.substring(offset, wrkStr0.length());
                        String wrkStr1 = wrkStr0.replace(".", "");
                        wrkStr1 = wrkStr1.replace(",", "");
                        wrkStr1 = wrkStr1.replace("-", "");
                        if ((wrkStr1 = wrkStr1.replace(":", "")).length() > this.adaptee.digits_) {
                            wrkStr1 = String.valueOf(wrkStr1.substring(0, integerSizeOfField)) + "." + wrkStr1.substring(integerSizeOfField, wrkStr1.length() - 1);
                            super.replace(0, super.getLength(), wrkStr1, attr);
                        } else if (XFTextField.this.basicType_.equals("INTEGER") && str.contains(".")) {
                            JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("NumberFormatError"));
                        } else {
                            int posOfDecimal = wrkStr0.indexOf(".");
                            if (posOfDecimal == -1) {
                                if (wrkStr1.length() > integerSizeOfField) {
                                    wrkStr1 = String.valueOf(wrkStr1.substring(0, integerSizeOfField)) + "." + wrkStr1.substring(integerSizeOfField, wrkStr1.length());
                                    super.replace(0, super.getLength(), wrkStr1, attr);
                                } else {
                                    super.insertString(offset, str, attr);
                                }
                            } else {
                                int decimalLengthOfInputData = wrkStr0.length() - posOfDecimal - 1;
                                if (decimalLengthOfInputData <= this.adaptee.decimal_) {
                                    super.insertString(offset, str, attr);
                                }
                            }
                        }
                    }
                } else if (this.adaptee.isEditable() && (XFTextField.this.basicType_.equals("INTEGER") || XFTextField.this.basicType_.equals("FLOAT")) && !XFTextField.this.dataTypeOptionList.contains("ACCEPT_MINUS") && str.contains("-")) {
                    JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("MinusError")) + ": " + str);
                } else if (XFTextField.this.basicType_.equals("INTEGER")) {
                    if (str.contains(".")) {
                        JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("NumberFormatError"));
                    } else {
                        String wrkStr0 = super.getText(0, super.getLength());
                        wrkStr0 = String.valueOf(wrkStr0.substring(0, offset)) + str + wrkStr0.substring(offset, wrkStr0.length());
                        String wrkStr1 = wrkStr0.replace(".", "");
                        wrkStr1 = wrkStr1.replace(",", "");
                        wrkStr1 = wrkStr1.replace("-", "");
                        if ((wrkStr1 = wrkStr1.replace(":", "")).length() <= this.adaptee.digits_ || wrkStr1.equals("*AUTO")) {
                            super.insertString(offset, str, attr);
                        }
                    }
                } else if (XFTextField.this.basicType_.equals("FLOAT")) {
                    String wrkStr0 = super.getText(0, super.getLength());
                    wrkStr0 = String.valueOf(wrkStr0.substring(0, offset)) + str + wrkStr0.substring(offset, wrkStr0.length());
                    String wrkStr1 = wrkStr0.replace(".", "");
                    wrkStr1 = wrkStr1.replace(",", "");
                    if ((wrkStr1 = wrkStr1.replace("-", "")).length() <= this.adaptee.digits_) {
                        super.insertString(offset, str, attr);
                    }
                } else if (offset < this.adaptee.digits_ && super.getLength() < this.adaptee.digits_) {
                    super.insertString(offset, str, attr);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

