/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class XFTextFileOperator {
    private String operation_ = "";
    private String fileName_ = "";
    private String separator_ = "";
    private String charset_ = "";
    private ArrayList<String> rowList = new ArrayList();
    private ArrayList<Object> columnList = new ArrayList();
    private int cursorPos = -1;
    private FileInputStream inputFile = null;
    private InputStreamReader reader = null;
    private FileOutputStream outputFile = null;
    private OutputStreamWriter writer = null;
    private boolean isExecuted = false;

    public XFTextFileOperator(String operation, String fileName, String separator, String charset) {
        this.operation_ = operation;
        this.fileName_ = fileName;
        this.separator_ = separator;
        this.charset_ = charset;
        if (this.charset_.equals("")) {
            if (this.operation_.equals("Read")) {
                this.charset_ = "JISAutoDetect";
            }
            if (this.operation_.equals("Write")) {
                this.charset_ = "UTF-8";
            }
        }
        try {
            if (this.operation_.equals("Read")) {
                this.inputFile = new FileInputStream(this.fileName_);
                this.reader = new InputStreamReader((InputStream)this.inputFile, this.charset_);
            }
            if (this.operation_.equals("Write")) {
                this.outputFile = new FileOutputStream(this.fileName_);
                this.writer = new OutputStreamWriter((OutputStream)this.outputFile, this.charset_);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int execute() throws Exception {
        int count;
        block15: {
            block13: {
                count = 0;
                if (this.operation_.equals("Read")) {
                    BufferedReader bfReader = new BufferedReader(this.reader);
                    try {
                        try {
                            String line;
                            while ((line = bfReader.readLine()) != null) {
                                this.rowList.add(line);
                            }
                            count = this.rowList.size();
                        }
                        catch (Exception e) {
                            count = -1;
                            bfReader.close();
                            this.inputFile.close();
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        bfReader.close();
                        this.inputFile.close();
                        throw throwable;
                    }
                    bfReader.close();
                    this.inputFile.close();
                }
            }
            if (this.operation_.equals("Write")) {
                BufferedWriter bfWriter = new BufferedWriter(this.writer);
                try {
                    try {
                        int i = 0;
                        while (i < this.rowList.size()) {
                            bfWriter.write(this.rowList.get(i));
                            bfWriter.write("\n");
                            ++i;
                        }
                        count = this.rowList.size();
                    }
                    catch (Exception e) {
                        count = -1;
                        bfWriter.close();
                        this.outputFile.close();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    bfWriter.close();
                    this.outputFile.close();
                    throw throwable;
                }
                bfWriter.close();
                this.outputFile.close();
            }
        }
        this.isExecuted = true;
        return count;
    }

    public boolean next() throws Exception {
        if (!this.isExecuted) {
            this.execute();
            this.cursorPos = 0;
        } else {
            ++this.cursorPos;
        }
        return this.isValidCursorPos();
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    public int getRowIndex() {
        return this.cursorPos;
    }

    public boolean previous() throws Exception {
        if (!this.isExecuted) {
            this.execute();
            this.cursorPos = -1;
        } else {
            --this.cursorPos;
        }
        return this.isValidCursorPos();
    }

    public void resetCursor() {
        this.cursorPos = -1;
    }

    private boolean isValidCursorPos() {
        if (this.operation_.equals("Read")) {
            this.columnList.clear();
            boolean hasNext = false;
            if (this.cursorPos >= 0 && this.cursorPos < this.rowList.size()) {
                hasNext = true;
                this.columnList = this.processRowIntoColumnList(this.rowList.get(this.cursorPos));
            }
            return hasNext;
        }
        return false;
    }

    private ArrayList<Object> processRowIntoColumnList(String rowData) {
        ArrayList<Object> array = new ArrayList<Object>();
        if (this.separator_.equals("")) {
            array.add(rowData);
        } else {
            String[] strValue = rowData.split(this.separator_, -1);
            int i = 0;
            while (i < strValue.length) {
                array.add(strValue[i]);
                ++i;
            }
        }
        return array;
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    public Object getValueAt(int index) {
        Object value = "";
        if (index >= 0 && index < this.columnList.size()) {
            value = this.columnList.get(index);
        }
        return value;
    }

    public int addValue(Object value) {
        this.columnList.add(value);
        return this.columnList.size() - 1;
    }

    public int addRow() {
        StringBuffer bf = new StringBuffer();
        int i = 0;
        while (i < this.columnList.size()) {
            if (i > 0) {
                bf.append(this.separator_);
            }
            bf.append(this.columnList.get(i));
            ++i;
        }
        this.rowList.add(bf.toString());
        this.columnList.clear();
        return this.rowList.size() - 1;
    }
}

