/*
 * Decompiled with CFR 0.152.
 */
package xeadModeler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadModeler.DialogTableSynchronize_jButtonClose_actionAdapter;
import xeadModeler.DialogTableSynchronize_jButtonImport_actionAdapter;
import xeadModeler.Modeler;

public class DialogTableSynchronize
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadModeler.Res");
    private JButton jButtonClose = new JButton();
    private JButton jButtonImport = new JButton();
    private JScrollPane jScrollPaneMessage = new JScrollPane();
    private JTextArea jTextAreaMessage = new JTextArea();
    private JPanel jPanelButtons = new JPanel();
    private boolean isSynchError_ = false;
    private boolean isImported_ = false;
    private String errorMessage_ = "";
    private Document synchFileDomDocument_ = null;
    private Element synchFileTableElement_ = null;
    private Element targetTableElement_ = null;
    private int countOfErrors = 0;
    private Modeler frame_;

    public DialogTableSynchronize(Modeler frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogTableSynchronize(Modeler frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.jScrollPaneMessage.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().setLayout(new BorderLayout());
        this.jTextAreaMessage.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jTextAreaMessage.setEditable(false);
        this.jTextAreaMessage.setOpaque(false);
        this.jTextAreaMessage.setLineWrap(true);
        this.jTextAreaMessage.setTabSize(4);
        this.jScrollPaneMessage.getViewport().add(this.jTextAreaMessage);
        this.jButtonClose.setText(res.getString("DialogTableSynchronize02"));
        this.jButtonClose.setBounds(new Rectangle(20, 7, 150, 29));
        this.jButtonClose.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jButtonClose.addActionListener(new DialogTableSynchronize_jButtonClose_actionAdapter(this));
        this.jButtonImport.setText(res.getString("DialogTableSynchronize03"));
        this.jButtonImport.setBounds(new Rectangle(455, 7, 220, 29));
        this.jButtonImport.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jButtonImport.addActionListener(new DialogTableSynchronize_jButtonImport_actionAdapter(this));
        this.jPanelButtons.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelButtons.setPreferredSize(new Dimension(100, 43));
        this.jPanelButtons.setLayout(null);
        this.jPanelButtons.add((Component)this.jButtonClose, null);
        this.jPanelButtons.add((Component)this.jButtonImport, null);
        this.setTitle(res.getString("DialogTableSynchronize01"));
        this.getContentPane().add((Component)this.jPanelButtons, "South");
        this.setResizable(false);
        this.setPreferredSize(new Dimension(700, 400));
        this.getContentPane().add((Component)this.jScrollPaneMessage, "Center");
    }

    public boolean request(Modeler.XeadTreeNode tableNode) {
        this.isSynchError_ = tableNode.isError();
        this.isImported_ = false;
        if (tableNode.getType().equals("Table")) {
            try {
                this.setCursor(new Cursor(3));
                this.isSynchError_ = this.isSynchError(tableNode.getElement(), null);
                if (this.isSynchError_) {
                    this.jTextAreaMessage.setText(this.errorMessage_);
                } else {
                    this.jTextAreaMessage.setText(res.getString("DialogTableSynchronize05"));
                }
                this.jTextAreaMessage.setCaretPosition(0);
                this.jPanelButtons.getRootPane().setDefaultButton(this.jButtonClose);
                Dimension dlgSize = this.getPreferredSize();
                Dimension frmSize = this.frame_.getSize();
                Point loc = this.frame_.getLocation();
                this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            }
            finally {
                this.setCursor(new Cursor(0));
            }
            super.setVisible(true);
        }
        return this.isSynchError_;
    }

    public boolean isSynchError(Element tableElement, Document domDocumentComparedTo) {
        this.isSynchError_ = false;
        this.errorMessage_ = "";
        Element workElement = null;
        this.jButtonImport.setEnabled(false);
        this.synchFileTableElement_ = null;
        this.targetTableElement_ = tableElement;
        if (!this.targetTableElement_.getAttribute("SynchFile").equals("")) {
            if (this.targetTableElement_.getAttribute("SortKey").equals("")) {
                this.isSynchError_ = true;
                this.errorMessage_ = res.getString("DialogTableSynchronize06");
            } else {
                this.synchFileDomDocument_ = domDocumentComparedTo == null ? this.frame_.getSynchFileDocument(this.targetTableElement_.getAttribute("SynchFile")) : domDocumentComparedTo;
                if (this.synchFileDomDocument_ == null) {
                    this.isSynchError_ = true;
                    this.errorMessage_ = res.getString("DialogTableSynchronize07");
                } else {
                    boolean isFound = false;
                    NodeList tableList = this.synchFileDomDocument_.getElementsByTagName("Table");
                    int i = 0;
                    while (i < tableList.getLength()) {
                        workElement = (Element)tableList.item(i);
                        if (workElement.getAttribute("SortKey").equals(this.targetTableElement_.getAttribute("SortKey"))) {
                            isFound = true;
                            this.synchFileTableElement_ = workElement;
                            break;
                        }
                        ++i;
                    }
                    if (isFound) {
                        if (this.synchFileTableElement_.getAttribute("SynchFile").equals("")) {
                            this.jButtonImport.setEnabled(true);
                            this.isSynchError_ = this.compareDefinitions(this.targetTableElement_, this.synchFileTableElement_);
                            this.errorMessage_ = String.valueOf(this.errorMessage_) + "\n\n" + res.getString("DialogTableSynchronize04");
                        } else {
                            this.isSynchError_ = true;
                            this.errorMessage_ = res.getString("DialogTableSynchronize25");
                        }
                    } else {
                        this.isSynchError_ = true;
                        this.errorMessage_ = res.getString("DialogTableSynchronize08");
                    }
                }
            }
        }
        return this.isSynchError_;
    }

    boolean compareDefinitions(Element targetElement, Element synchFileElement) {
        int j;
        boolean isFound;
        int j2;
        Element targetFieldElement;
        boolean isFound2;
        Element synchFileFieldElement = null;
        Element targetKeyElement = null;
        Element synchFileKeyElement = null;
        this.countOfErrors = 0;
        StringBuffer bf = new StringBuffer();
        if (!targetElement.getAttribute("Name").equals(synchFileElement.getAttribute("Name"))) {
            ++this.countOfErrors;
            bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize09"));
        }
        if (!targetElement.getAttribute("Alias").equals(synchFileElement.getAttribute("Alias"))) {
            ++this.countOfErrors;
            bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize30"));
        }
        if (this.isDifferentTableType(targetElement, synchFileElement)) {
            ++this.countOfErrors;
            bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize31"));
        }
        if (!targetElement.getAttribute("Descriptions").equals(synchFileElement.getAttribute("Descriptions"))) {
            ++this.countOfErrors;
            bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize10"));
        }
        NodeList targetFieldList = targetElement.getElementsByTagName("TableField");
        NodeList synchFileFieldList = synchFileElement.getElementsByTagName("TableField");
        int i = 0;
        while (i < targetFieldList.getLength()) {
            isFound2 = false;
            targetFieldElement = (Element)targetFieldList.item(i);
            j2 = 0;
            while (j2 < synchFileFieldList.getLength()) {
                synchFileFieldElement = (Element)synchFileFieldList.item(j2);
                if (targetFieldElement.getAttribute("Alias").equals(synchFileFieldElement.getAttribute("Alias"))) {
                    isFound2 = true;
                    break;
                }
                ++j2;
            }
            if (isFound2) {
                if (!targetFieldElement.getAttribute("Name").equals(synchFileFieldElement.getAttribute("Name"))) {
                    ++this.countOfErrors;
                    bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize11") + targetFieldElement.getAttribute("Alias") + res.getString("DialogTableSynchronize12"));
                }
                if (this.isDifferentDataType(targetFieldElement, synchFileFieldElement)) {
                    ++this.countOfErrors;
                    bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize11") + targetFieldElement.getAttribute("Alias") + res.getString("DialogTableSynchronize13"));
                }
                if (!targetFieldElement.getAttribute("Descriptions").equals(synchFileFieldElement.getAttribute("Descriptions"))) {
                    ++this.countOfErrors;
                    bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize11") + targetFieldElement.getAttribute("Alias") + res.getString("DialogTableSynchronize14"));
                }
                if (!targetFieldElement.getAttribute("AttributeType").equals(synchFileFieldElement.getAttribute("AttributeType"))) {
                    ++this.countOfErrors;
                    bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize11") + targetFieldElement.getAttribute("Alias") + res.getString("DialogTableSynchronize26"));
                }
                if (!targetFieldElement.getAttribute("NotNull").equals(synchFileFieldElement.getAttribute("NotNull"))) {
                    ++this.countOfErrors;
                    bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize11") + targetFieldElement.getAttribute("Alias") + res.getString("DialogTableSynchronize27"));
                }
                if (!targetFieldElement.getAttribute("Default").equals(synchFileFieldElement.getAttribute("Default"))) {
                    ++this.countOfErrors;
                    bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize11") + targetFieldElement.getAttribute("Alias") + res.getString("DialogTableSynchronize28"));
                }
                if (!(targetFieldElement.getAttribute("NoUpdate").equals("") || synchFileFieldElement.getAttribute("NoUpdate").equals("") || targetFieldElement.getAttribute("NoUpdate").equals(synchFileFieldElement.getAttribute("NoUpdate")))) {
                    ++this.countOfErrors;
                    bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize11") + targetFieldElement.getAttribute("Alias") + res.getString("DialogTableSynchronize29"));
                }
            } else {
                ++this.countOfErrors;
                bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize11") + targetFieldElement.getAttribute("Alias") + res.getString("DialogTableSynchronize15"));
            }
            ++i;
        }
        i = 0;
        while (i < synchFileFieldList.getLength()) {
            isFound2 = false;
            synchFileFieldElement = (Element)synchFileFieldList.item(i);
            j2 = 0;
            while (j2 < targetFieldList.getLength()) {
                targetFieldElement = (Element)targetFieldList.item(j2);
                if (targetFieldElement.getAttribute("Alias").equals(synchFileFieldElement.getAttribute("Alias"))) {
                    isFound2 = true;
                    break;
                }
                ++j2;
            }
            if (!isFound2) {
                ++this.countOfErrors;
                bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize16") + synchFileFieldElement.getAttribute("Alias") + res.getString("DialogTableSynchronize17"));
            }
            ++i;
        }
        NodeList targetKeyList = targetElement.getElementsByTagName("TableKey");
        NodeList synchFileKeyList = synchFileElement.getElementsByTagName("TableKey");
        int i2 = 0;
        while (i2 < targetKeyList.getLength()) {
            targetKeyElement = (Element)targetKeyList.item(i2);
            if (targetKeyElement.getAttribute("Type").equals("PK")) {
                int j3 = 0;
                while (j3 < synchFileKeyList.getLength()) {
                    synchFileKeyElement = (Element)synchFileKeyList.item(j3);
                    if (synchFileKeyElement.getAttribute("Type").equals(targetKeyElement.getAttribute("Type"))) {
                        if (!this.isEquivalentKey(targetKeyElement, synchFileKeyElement, targetFieldList, synchFileFieldList)) {
                            ++this.countOfErrors;
                            bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize18"));
                        }
                        break;
                    }
                    ++j3;
                }
            } else {
                isFound = false;
                j = 0;
                while (j < synchFileKeyList.getLength()) {
                    synchFileKeyElement = (Element)synchFileKeyList.item(j);
                    if (synchFileKeyElement.getAttribute("Type").equals(targetKeyElement.getAttribute("Type")) && this.isEquivalentKey(targetKeyElement, synchFileKeyElement, targetFieldList, synchFileFieldList)) {
                        isFound = true;
                        break;
                    }
                    ++j;
                }
                if (!isFound) {
                    ++this.countOfErrors;
                    bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize20"));
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < synchFileKeyList.getLength()) {
            isFound = false;
            synchFileKeyElement = (Element)synchFileKeyList.item(i2);
            if (!synchFileKeyElement.getAttribute("Type").equals("PK")) {
                j = 0;
                while (j < targetKeyList.getLength()) {
                    targetKeyElement = (Element)targetKeyList.item(j);
                    if (targetKeyElement.getAttribute("Type").equals(synchFileKeyElement.getAttribute("Type")) && this.isEquivalentKey(targetKeyElement, synchFileKeyElement, targetFieldList, synchFileFieldList)) {
                        isFound = true;
                        break;
                    }
                    ++j;
                }
                if (!isFound) {
                    ++this.countOfErrors;
                    bf.append("\n" + this.countOfErrors + res.getString("DialogTableSynchronize22"));
                }
            }
            ++i2;
        }
        if (this.countOfErrors == 0) {
            return false;
        }
        this.errorMessage_ = String.valueOf(res.getString("DialogTableSynchronize23")) + this.countOfErrors + res.getString("DialogTableSynchronize24") + bf.toString();
        return true;
    }

    boolean isDifferentTableType(Element targetTableElement, Element synchFileTableElement) {
        Element element;
        boolean isDifferent = false;
        Element targetTableTypeElement = null;
        NodeList targetTableTypeList = targetTableElement.getOwnerDocument().getElementsByTagName("TableType");
        int i = 0;
        while (i < targetTableTypeList.getLength()) {
            element = (Element)targetTableTypeList.item(i);
            if (element.getAttribute("ID").equals(targetTableElement.getAttribute("TableTypeID"))) {
                targetTableTypeElement = element;
            }
            ++i;
        }
        Element synchFileTableTypeElement = null;
        NodeList synchFileTableTypeList = this.synchFileDomDocument_.getElementsByTagName("TableType");
        int i2 = 0;
        while (i2 < synchFileTableTypeList.getLength()) {
            element = (Element)synchFileTableTypeList.item(i2);
            if (element.getAttribute("ID").equals(synchFileTableElement.getAttribute("TableTypeID"))) {
                synchFileTableTypeElement = element;
            }
            ++i2;
        }
        if (targetTableTypeElement != null && synchFileTableTypeElement != null) {
            if (!targetTableTypeElement.getAttribute("SortKey").equals(synchFileTableTypeElement.getAttribute("SortKey")) || !targetTableTypeElement.getAttribute("Name").equals(synchFileTableTypeElement.getAttribute("Name"))) {
                isDifferent = true;
            }
        } else {
            isDifferent = true;
        }
        return isDifferent;
    }

    boolean isDifferentDataType(Element targetFieldElement, Element synchFileFieldElement) {
        Element element;
        boolean isDifferent = false;
        Element targetDataTypeElement = null;
        NodeList targetDataTypeList = targetFieldElement.getOwnerDocument().getElementsByTagName("DataType");
        int i = 0;
        while (i < targetDataTypeList.getLength()) {
            element = (Element)targetDataTypeList.item(i);
            if (element.getAttribute("ID").equals(targetFieldElement.getAttribute("DataTypeID"))) {
                targetDataTypeElement = element;
            }
            ++i;
        }
        Element synchFileDataTypeElement = null;
        NodeList synchFileDataTypeList = this.synchFileDomDocument_.getElementsByTagName("DataType");
        int i2 = 0;
        while (i2 < synchFileDataTypeList.getLength()) {
            element = (Element)synchFileDataTypeList.item(i2);
            if (element.getAttribute("ID").equals(synchFileFieldElement.getAttribute("DataTypeID"))) {
                synchFileDataTypeElement = element;
            }
            ++i2;
        }
        if (targetDataTypeElement != null && synchFileDataTypeElement != null) {
            if (!(targetDataTypeElement.getAttribute("BasicType").equals(synchFileDataTypeElement.getAttribute("BasicType")) && targetDataTypeElement.getAttribute("Name").equals(synchFileDataTypeElement.getAttribute("Name")) && targetDataTypeElement.getAttribute("SQLExpression").equals(synchFileDataTypeElement.getAttribute("SQLExpression")) && targetDataTypeElement.getAttribute("Length").equals(synchFileDataTypeElement.getAttribute("Length")) && targetDataTypeElement.getAttribute("Decimal").equals(synchFileDataTypeElement.getAttribute("Decimal")))) {
                isDifferent = true;
            }
        } else {
            isDifferent = true;
        }
        return isDifferent;
    }

    boolean isEquivalentKey(Element targetKeyElement, Element synchFileKeyElement, NodeList targetFieldList, NodeList synchFileFieldList) {
        boolean isEquivalent = true;
        Element targetKeyFieldElement = null;
        Element synchFileKeyFieldElement = null;
        NodeList targetKeyFieldList = targetKeyElement.getElementsByTagName("TableKeyField");
        NodeList synchFileKeyFieldList = synchFileKeyElement.getElementsByTagName("TableKeyField");
        if (targetKeyFieldList.getLength() == synchFileKeyFieldList.getLength()) {
            int i = 0;
            while (i < targetKeyFieldList.getLength()) {
                boolean isFound = false;
                String targetKeyFieldAlias = "";
                targetKeyFieldElement = (Element)targetKeyFieldList.item(i);
                int j = 0;
                while (j < targetFieldList.getLength()) {
                    Element element = (Element)targetFieldList.item(j);
                    if (targetKeyFieldElement.getAttribute("FieldID").equals(element.getAttribute("ID"))) {
                        targetKeyFieldAlias = element.getAttribute("Alias");
                        break;
                    }
                    ++j;
                }
                String synchFileKeyFieldAlias = "";
                j = 0;
                while (j < synchFileKeyFieldList.getLength()) {
                    synchFileKeyFieldElement = (Element)synchFileKeyFieldList.item(j);
                    int k = 0;
                    while (k < synchFileFieldList.getLength()) {
                        Element element = (Element)synchFileFieldList.item(k);
                        if (synchFileKeyFieldElement.getAttribute("FieldID").equals(element.getAttribute("ID"))) {
                            synchFileKeyFieldAlias = element.getAttribute("Alias");
                            break;
                        }
                        ++k;
                    }
                    if (targetKeyFieldAlias.equals(synchFileKeyFieldAlias)) {
                        if (!targetKeyFieldElement.getAttribute("AscDesc").equals(synchFileKeyFieldElement.getAttribute("AscDesc"))) break;
                        isFound = true;
                        break;
                    }
                    ++j;
                }
                if (!isFound) {
                    isEquivalent = false;
                }
                ++i;
            }
        } else {
            isEquivalent = false;
        }
        return isEquivalent;
    }

    void jButtonClose_actionPerformed(ActionEvent e) {
        super.setVisible(false);
    }

    void jButtonImport_actionPerformed(ActionEvent e) {
        try {
            this.setCursor(new Cursor(3));
            this.isImported_ = true;
            this.importIntoTarget(this.targetTableElement_, this.synchFileTableElement_);
            this.isSynchError_ = this.compareDefinitions(this.targetTableElement_, this.synchFileTableElement_);
            if (this.isSynchError_) {
                this.jTextAreaMessage.setText(String.valueOf(this.errorMessage_) + "\n\n" + res.getString("DialogTableSynchronize04"));
            } else {
                this.jTextAreaMessage.setText(res.getString("DialogTableSynchronize05"));
            }
            this.jTextAreaMessage.setCaretPosition(0);
            this.jButtonImport.setEnabled(false);
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    void importIntoTarget(Element targetTableElement, Element synchFileTableElement) {
        targetTableElement.setAttribute("Name", synchFileTableElement.getAttribute("Name"));
        targetTableElement.setAttribute("Alias", synchFileTableElement.getAttribute("Alias"));
        targetTableElement.setAttribute("Descriptions", synchFileTableElement.getAttribute("Descriptions"));
        if (this.isDifferentTableType(targetTableElement, synchFileTableElement)) {
            String tableTypeID = this.getEquivalentTableTypeIDFromTargetDocument(targetTableElement, synchFileTableElement.getAttribute("TableTypeID"));
            targetTableElement.setAttribute("TableTypeID", tableTypeID);
        }
        Element targetFieldElement = null;
        Element synchFileFieldElement = null;
        NodeList targetFieldList = targetTableElement.getElementsByTagName("TableField");
        NodeList synchFileFieldList = synchFileTableElement.getElementsByTagName("TableField");
        int i = 0;
        while (i < synchFileFieldList.getLength()) {
            String dataTypeID;
            boolean isFound = false;
            synchFileFieldElement = (Element)synchFileFieldList.item(i);
            int j = 0;
            while (j < targetFieldList.getLength()) {
                targetFieldElement = (Element)targetFieldList.item(j);
                if (targetFieldElement.getAttribute("Alias").equals(synchFileFieldElement.getAttribute("Alias"))) {
                    isFound = true;
                    break;
                }
                ++j;
            }
            if (isFound) {
                targetFieldElement.setAttribute("Name", synchFileFieldElement.getAttribute("Name"));
                if (this.isDifferentDataType(targetFieldElement, synchFileFieldElement)) {
                    dataTypeID = this.getEquivalentDataTypeIDFromTargetDocument(synchFileFieldElement.getAttribute("DataTypeID"));
                    targetFieldElement.setAttribute("DataTypeID", dataTypeID);
                }
                targetFieldElement.setAttribute("Descriptions", synchFileFieldElement.getAttribute("Descriptions"));
                targetFieldElement.setAttribute("AttributeType", synchFileFieldElement.getAttribute("AttributeType"));
                targetFieldElement.setAttribute("NotNull", synchFileFieldElement.getAttribute("NotNull"));
                targetFieldElement.setAttribute("Default", synchFileFieldElement.getAttribute("Default"));
                targetFieldElement.setAttribute("NoUpdate", synchFileFieldElement.getAttribute("NoUpdate"));
                targetFieldElement.setAttribute("SortKey", synchFileFieldElement.getAttribute("SortKey"));
            } else {
                targetFieldElement = targetTableElement.getOwnerDocument().createElement("TableField");
                targetFieldElement.setAttribute("ID", this.getNextIDOfNodeType("TableField"));
                targetFieldElement.setAttribute("Name", synchFileFieldElement.getAttribute("Name"));
                targetFieldElement.setAttribute("Alias", synchFileFieldElement.getAttribute("Alias"));
                dataTypeID = this.getEquivalentDataTypeIDFromTargetDocument(synchFileFieldElement.getAttribute("DataTypeID"));
                targetFieldElement.setAttribute("DataTypeID", dataTypeID);
                targetFieldElement.setAttribute("Descriptions", synchFileFieldElement.getAttribute("Descriptions"));
                targetFieldElement.setAttribute("AttributeType", synchFileFieldElement.getAttribute("AttributeType"));
                targetFieldElement.setAttribute("NotNull", synchFileFieldElement.getAttribute("NotNull"));
                targetFieldElement.setAttribute("Default", synchFileFieldElement.getAttribute("Default"));
                targetFieldElement.setAttribute("NoUpdate", synchFileFieldElement.getAttribute("NoUpdate"));
                targetFieldElement.setAttribute("ShowOnModel", synchFileFieldElement.getAttribute("ShowOnModel"));
                targetFieldElement.setAttribute("SortKey", synchFileFieldElement.getAttribute("SortKey"));
                targetTableElement.appendChild(targetFieldElement);
            }
            ++i;
        }
        Element element = null;
        Element targetKeyElement = null;
        Element targetKeyFieldElement = null;
        Element synchFileKeyElement = null;
        Element synchFileKeyFieldElement = null;
        int biggestKeyID = 0;
        NodeList targetKeyList = targetTableElement.getElementsByTagName("TableKey");
        int i2 = 0;
        while (i2 < targetKeyList.getLength()) {
            targetKeyElement = (Element)targetKeyList.item(i2);
            int wrkInt = Integer.parseInt(targetKeyElement.getAttribute("ID"));
            if (wrkInt > biggestKeyID) {
                biggestKeyID = wrkInt;
            }
            ++i2;
        }
        NodeList targetRelationshipList = targetTableElement.getElementsByTagName("Relationship");
        NodeList synchFileKeyList = synchFileTableElement.getElementsByTagName("TableKey");
        int i3 = 0;
        while (i3 < synchFileKeyList.getLength()) {
            NodeList synchFileKeyFieldList;
            synchFileKeyElement = (Element)synchFileKeyList.item(i3);
            if (synchFileKeyElement.getAttribute("Type").equals("PK")) {
                int j = 0;
                while (j < targetKeyList.getLength()) {
                    targetKeyElement = (Element)targetKeyList.item(j);
                    if (targetKeyElement.getAttribute("Type").equals(synchFileKeyElement.getAttribute("Type"))) {
                        if (this.isEquivalentKey(targetKeyElement, synchFileKeyElement, targetFieldList, synchFileFieldList)) break;
                        boolean hasRelationships = false;
                        int k = 0;
                        while (k < targetRelationshipList.getLength()) {
                            element = (Element)targetRelationshipList.item(k);
                            if (element.getAttribute("Table1ID").equals(targetTableElement.getAttribute("ID")) && element.getAttribute("TableKey1ID").equals(targetKeyElement.getAttribute("ID")) || element.getAttribute("Table2ID").equals(targetTableElement.getAttribute("ID")) && element.getAttribute("TableKey2ID").equals(targetKeyElement.getAttribute("ID"))) {
                                hasRelationships = true;
                                break;
                            }
                            ++k;
                        }
                        if (hasRelationships) {
                            JOptionPane.showMessageDialog(this, res.getString("DialogTableSynchronize19"));
                        } else {
                            NodeList targetKeyFieldList = targetKeyElement.getElementsByTagName("TableKeyField");
                            int workCount = targetKeyFieldList.getLength();
                            int k2 = 0;
                            while (k2 < workCount) {
                                targetKeyElement.removeChild(targetKeyElement.getFirstChild());
                                ++k2;
                            }
                            synchFileKeyFieldList = synchFileKeyElement.getElementsByTagName("TableKeyField");
                            k2 = 0;
                            while (k2 < synchFileKeyFieldList.getLength()) {
                                synchFileKeyFieldElement = (Element)synchFileKeyFieldList.item(k2);
                                targetKeyFieldElement = targetTableElement.getOwnerDocument().createElement("TableKeyField");
                                targetKeyFieldElement.setAttribute("FieldID", this.getEquivalentFieldIDFromTargetTable(synchFileKeyFieldElement.getAttribute("FieldID"), synchFileTableElement, targetTableElement));
                                targetKeyFieldElement.setAttribute("AscDesc", synchFileKeyFieldElement.getAttribute("AscDesc"));
                                targetKeyFieldElement.setAttribute("SortKey", synchFileKeyFieldElement.getAttribute("SortKey"));
                                targetKeyElement.appendChild(targetKeyFieldElement);
                                ++k2;
                            }
                        }
                        break;
                    }
                    ++j;
                }
            } else {
                boolean isFound = false;
                int j = 0;
                while (j < targetKeyList.getLength()) {
                    targetKeyElement = (Element)targetKeyList.item(j);
                    if (targetKeyElement.getAttribute("Type").equals(synchFileKeyElement.getAttribute("Type")) && this.isEquivalentKey(targetKeyElement, synchFileKeyElement, targetFieldList, synchFileFieldList)) {
                        isFound = true;
                        break;
                    }
                    ++j;
                }
                if (!isFound) {
                    targetKeyElement = targetTableElement.getOwnerDocument().createElement("TableKey");
                    targetKeyElement.setAttribute("ID", Integer.toString(++biggestKeyID));
                    targetKeyElement.setAttribute("Type", synchFileKeyElement.getAttribute("Type"));
                    targetKeyElement.setAttribute("SortKey", synchFileKeyElement.getAttribute("SortKey"));
                    targetTableElement.appendChild(targetKeyElement);
                    synchFileKeyFieldList = synchFileKeyElement.getElementsByTagName("TableKeyField");
                    j = 0;
                    while (j < synchFileKeyFieldList.getLength()) {
                        synchFileKeyFieldElement = (Element)synchFileKeyFieldList.item(j);
                        targetKeyFieldElement = targetTableElement.getOwnerDocument().createElement("TableKeyField");
                        targetKeyFieldElement.setAttribute("FieldID", this.getEquivalentFieldIDFromTargetTable(synchFileKeyFieldElement.getAttribute("FieldID"), synchFileTableElement, targetTableElement));
                        targetKeyFieldElement.setAttribute("AscDesc", synchFileKeyFieldElement.getAttribute("AscDesc"));
                        targetKeyFieldElement.setAttribute("SortKey", synchFileKeyFieldElement.getAttribute("SortKey"));
                        targetKeyElement.appendChild(targetKeyFieldElement);
                        ++j;
                    }
                }
            }
            ++i3;
        }
    }

    private String getEquivalentTableTypeIDFromTargetDocument(Element targetTableElement, String synchFileTableTypeID) {
        Element element;
        Element synchFileTableTypeElement = null;
        NodeList synchFileTableTypeList = this.synchFileDomDocument_.getElementsByTagName("TableType");
        int i = 0;
        while (i < synchFileTableTypeList.getLength()) {
            element = (Element)synchFileTableTypeList.item(i);
            if (element.getAttribute("ID").equals(synchFileTableTypeID)) {
                synchFileTableTypeElement = element;
                break;
            }
            ++i;
        }
        String targetTableTypeID = "";
        Element targetTableTypeElement = null;
        NodeList targetTableTypeList = targetTableElement.getOwnerDocument().getElementsByTagName("TableType");
        int i2 = 0;
        while (i2 < targetTableTypeList.getLength()) {
            element = (Element)targetTableTypeList.item(i2);
            if (element.getAttribute("SortKey").equals(synchFileTableTypeElement.getAttribute("SortKey")) && element.getAttribute("Name").equals(synchFileTableTypeElement.getAttribute("Name"))) {
                targetTableTypeID = element.getAttribute("ID");
                break;
            }
            ++i2;
        }
        if (targetTableTypeID.equals("")) {
            NodeList workElementList = targetTableElement.getOwnerDocument().getElementsByTagName("System");
            Element systemElement = (Element)workElementList.item(0);
            targetTableTypeElement = this.frame_.domDocument.createElement("TableType");
            targetTableTypeID = this.getNextIDOfNodeType("TableType");
            targetTableTypeElement.setAttribute("ID", targetTableTypeID);
            targetTableTypeElement.setAttribute("Name", synchFileTableTypeElement.getAttribute("Name"));
            targetTableTypeElement.setAttribute("SortKey", synchFileTableTypeElement.getAttribute("SortKey"));
            targetTableTypeElement.setAttribute("Descriptions", synchFileTableTypeElement.getAttribute("Descriptions"));
            systemElement.appendChild(targetTableTypeElement);
        }
        return targetTableTypeID;
    }

    private String getEquivalentDataTypeIDFromTargetDocument(String synchFileDataTypeID) {
        Element element;
        Element synchFileDataTypeElement = null;
        NodeList synchFileDataTypeList = this.synchFileDomDocument_.getElementsByTagName("DataType");
        int i = 0;
        while (i < synchFileDataTypeList.getLength()) {
            element = (Element)synchFileDataTypeList.item(i);
            if (element.getAttribute("ID").equals(synchFileDataTypeID)) {
                synchFileDataTypeElement = element;
                break;
            }
            ++i;
        }
        String targetDataTypeID = "";
        Element targetDataTypeElement = null;
        NodeList targetDataTypeList = this.frame_.domDocument.getElementsByTagName("DataType");
        int i2 = 0;
        while (i2 < targetDataTypeList.getLength()) {
            element = (Element)targetDataTypeList.item(i2);
            if (element.getAttribute("BasicType").equals(synchFileDataTypeElement.getAttribute("BasicType")) && element.getAttribute("Name").equals(synchFileDataTypeElement.getAttribute("Name")) && element.getAttribute("SQLExpression").equals(synchFileDataTypeElement.getAttribute("SQLExpression")) && element.getAttribute("Length").equals(synchFileDataTypeElement.getAttribute("Length")) && element.getAttribute("Decimal").equals(synchFileDataTypeElement.getAttribute("Decimal"))) {
                targetDataTypeID = element.getAttribute("ID");
                break;
            }
            ++i2;
        }
        if (targetDataTypeID.equals("")) {
            NodeList workElementList = this.frame_.domDocument.getElementsByTagName("System");
            Element systemElement = (Element)workElementList.item(0);
            targetDataTypeElement = this.frame_.domDocument.createElement("DataType");
            targetDataTypeID = this.getNextIDOfNodeType("DataType");
            targetDataTypeElement.setAttribute("ID", targetDataTypeID);
            targetDataTypeElement.setAttribute("Name", synchFileDataTypeElement.getAttribute("Name"));
            targetDataTypeElement.setAttribute("SortKey", synchFileDataTypeElement.getAttribute("SortKey"));
            targetDataTypeElement.setAttribute("BasicType", synchFileDataTypeElement.getAttribute("BasicType"));
            targetDataTypeElement.setAttribute("SQLExpression", synchFileDataTypeElement.getAttribute("SQLExpression"));
            targetDataTypeElement.setAttribute("Length", synchFileDataTypeElement.getAttribute("Length"));
            targetDataTypeElement.setAttribute("Decimal", synchFileDataTypeElement.getAttribute("Decimal"));
            systemElement.appendChild(targetDataTypeElement);
        }
        return targetDataTypeID;
    }

    private String getEquivalentFieldIDFromTargetTable(String synchFileFieldID, Element synchFileTableElement, Element targetTableElement) {
        Element element;
        Element synchFileFieldElement = null;
        NodeList synchFileFieldList = synchFileTableElement.getElementsByTagName("TableField");
        int i = 0;
        while (i < synchFileFieldList.getLength()) {
            element = (Element)synchFileFieldList.item(i);
            if (element.getAttribute("ID").equals(synchFileFieldID)) {
                synchFileFieldElement = element;
                break;
            }
            ++i;
        }
        String targetFieldID = "";
        NodeList targetFieldList = targetTableElement.getElementsByTagName("TableField");
        int i2 = 0;
        while (i2 < targetFieldList.getLength()) {
            element = (Element)targetFieldList.item(i2);
            if (element.getAttribute("Alias").equals(synchFileFieldElement.getAttribute("Alias"))) {
                targetFieldID = element.getAttribute("ID");
                break;
            }
            ++i2;
        }
        return targetFieldID;
    }

    private String getNextIDOfNodeType(String tagName) {
        String nextID = "1";
        Element element = null;
        Element lastDomElement = null;
        int lastDomElementID = 0;
        int elementID = 0;
        NodeList nodeList = this.frame_.domDocument.getElementsByTagName(tagName);
        int i = 0;
        while (i < nodeList.getLength()) {
            element = (Element)nodeList.item(i);
            if (lastDomElement == null) {
                lastDomElement = element;
            } else {
                elementID = Integer.parseInt(element.getAttribute("ID"));
                if (elementID > (lastDomElementID = Integer.parseInt(lastDomElement.getAttribute("ID")))) {
                    lastDomElement = element;
                }
            }
            ++i;
        }
        if (lastDomElement != null) {
            int lastID = Integer.parseInt(lastDomElement.getAttribute("ID"));
            nextID = Integer.toString(lastID + 1);
        }
        return nextID;
    }

    public boolean isImported() {
        return this.isImported_;
    }
}

