/*
 * Decompiled with CFR 0.152.
 */
package xeadModeler;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import xeadModeler.DialogToListChangesOfFiles_jButtonCancel_actionAdapter;
import xeadModeler.DialogToListChangesOfFiles_jButtonStart_actionAdapter;
import xeadModeler.Modeler;

public class DialogToListChangesOfFiles
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadModeler.Res");
    private JPanel panelMain = new JPanel();
    private JScrollPane jScrollPane = new JScrollPane();
    private JProgressBar jProgressBar = new JProgressBar();
    private JButton jButtonStart = new JButton();
    private JCheckBox jCheckBoxListDiffDDL = new JCheckBox();
    private JButton jButtonCancel = new JButton();
    private JTextArea jTextArea = new JTextArea();
    private JLabel jLabel1 = new JLabel();
    private JTextField jTextFieldImportFileName = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JTextField jTextFieldImportSystemName = new JTextField();
    private Modeler frame_;
    private Document domDocumentOld;
    private Element systemElementOld;
    private Element systemElementNew;
    private int countOfChanges = 0;
    private boolean containsValueToBeCorrected = false;
    private StringBuffer buffer;
    private HashMap<String, Element> newDataTypeElementMap = new HashMap();
    private HashMap<String, Element> oldDataTypeElementMap = new HashMap();

    public DialogToListChangesOfFiles(Modeler frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogToListChangesOfFiles(Modeler frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.setResizable(false);
        this.setTitle(res.getString("DialogToListChangesOfFiles1"));
        this.jLabel1.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(res.getString("DialogToListChangesOfFiles3"));
        this.jLabel1.setBounds(new Rectangle(5, 12, 170, 20));
        this.jTextFieldImportFileName.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jTextFieldImportFileName.setBounds(new Rectangle(180, 9, 650, 25));
        this.jTextFieldImportFileName.setEditable(false);
        this.jLabel2.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(res.getString("DialogToListChangesOfFiles4"));
        this.jLabel2.setBounds(new Rectangle(5, 43, 170, 20));
        this.jTextFieldImportSystemName.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jTextFieldImportSystemName.setBounds(new Rectangle(180, 40, 650, 25));
        this.jTextFieldImportSystemName.setEditable(false);
        this.jScrollPane.setBounds(new Rectangle(9, 73, 822, 458));
        this.jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jScrollPane.getViewport().add(this.jTextArea);
        this.jTextArea.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jTextArea.setEditable(false);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setBackground(SystemColor.control);
        this.jTextArea.setBorder(null);
        this.jProgressBar.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jProgressBar.setBounds(new Rectangle(30, 540, 420, 30));
        this.jProgressBar.setStringPainted(true);
        this.jProgressBar.setVisible(false);
        this.jButtonStart.setBounds(new Rectangle(30, 540, 420, 30));
        this.jButtonStart.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jButtonStart.setText(res.getString("DialogToListChangesOfFiles5"));
        this.jButtonStart.addActionListener(new DialogToListChangesOfFiles_jButtonStart_actionAdapter(this));
        this.jCheckBoxListDiffDDL.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jCheckBoxListDiffDDL.setText(res.getString("DialogToListChangesOfFiles36"));
        this.jCheckBoxListDiffDDL.setBounds(new Rectangle(460, 545, 235, 20));
        this.jButtonCancel.setBounds(new Rectangle(700, 540, 110, 30));
        this.jButtonCancel.setFont(new Font(this.frame_.mainFontName, 0, Modeler.MAIN_FONT_SIZE));
        this.jButtonCancel.setText(res.getString("DialogToListChangesOfFiles6"));
        this.jButtonCancel.addActionListener(new DialogToListChangesOfFiles_jButtonCancel_actionAdapter(this));
        this.panelMain.setLayout(null);
        this.panelMain.setPreferredSize(new Dimension(840, 583));
        this.panelMain.setBorder(BorderFactory.createEtchedBorder());
        this.panelMain.add((Component)this.jLabel1, null);
        this.panelMain.add((Component)this.jLabel2, null);
        this.panelMain.add((Component)this.jTextFieldImportFileName, null);
        this.panelMain.add((Component)this.jTextFieldImportSystemName, null);
        this.panelMain.add((Component)this.jScrollPane, null);
        this.panelMain.add((Component)this.jProgressBar, null);
        this.panelMain.add((Component)this.jButtonStart, null);
        this.panelMain.add((Component)this.jCheckBoxListDiffDDL, null);
        this.panelMain.add((Component)this.jButtonCancel, null);
        this.getContentPane().add((Component)this.panelMain, "South");
        this.getRootPane().setDefaultButton(this.jButtonStart);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = this.getPreferredSize();
        this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
        this.pack();
    }

    public void request(String fileName) {
        try {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new FileInputStream(fileName)));
            this.domDocumentOld = parser.getDocument();
            NodeList elementList = this.domDocumentOld.getElementsByTagName("System");
            this.systemElementOld = (Element)elementList.item(0);
            elementList = this.frame_.domDocument.getElementsByTagName("System");
            this.systemElementNew = (Element)elementList.item(0);
            float importFileFormat = Float.parseFloat(this.systemElementOld.getAttribute("FormatVersion"));
            float appliFormat = Float.parseFloat("1.2");
            if (importFileFormat > appliFormat) {
                JOptionPane.showMessageDialog(this, String.valueOf(res.getString("S1")) + this.systemElementOld.getAttribute("FormatVersion") + res.getString("S2") + "1.2" + res.getString("S3"));
            } else {
                this.jTextFieldImportFileName.setText(fileName);
                this.jTextFieldImportSystemName.setText(String.valueOf(this.systemElementOld.getAttribute("Name")) + " V" + this.systemElementOld.getAttribute("Version"));
                this.jTextArea.setText(res.getString("DialogToListChangesOfFiles2"));
                this.jProgressBar.setValue(0);
                this.jProgressBar.setString(res.getString("DialogToListChangesOfFiles37"));
                this.jButtonStart.setEnabled(true);
                this.jCheckBoxListDiffDDL.setEnabled(true);
                this.getRootPane().setDefaultButton(this.jButtonStart);
                super.setVisible(true);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "XML format of the file is invalid. Process is canceled.");
        }
    }

    void jButtonStart_actionPerformed(ActionEvent e) {
        block16: {
            try {
                this.setCursor(new Cursor(3));
                this.jButtonStart.setVisible(false);
                this.jProgressBar.setVisible(true);
                this.setupProgressMaxValue();
                this.buffer = new StringBuffer();
                this.countOfChanges = 0;
                this.listChangesOfBasicInfo();
                this.listChangesOfDataflow();
                this.listChangesOfRoleAndTask();
                this.listChangesOfSubsystem();
                this.listChangesOfTable();
                this.listChangesOfFunction();
                if (!this.jCheckBoxListDiffDDL.isSelected()) break block16;
                FileWriter fileWriter = null;
                NodeList oldTableElementList = this.systemElementOld.getElementsByTagName("Table");
                NodeList newTableElementList = this.systemElementNew.getElementsByTagName("Table");
                BufferedWriter bufferedWriter = null;
                try {
                    try {
                        String diffDDL = this.getDiffDDL(newTableElementList, oldTableElementList);
                        if (!diffDDL.equals("")) {
                            File textFile = File.createTempFile("AlterTables" + this.frame_.getStringValueOfDateTime("withTime"), ".txt");
                            String textFileName = textFile.getPath();
                            fileWriter = new FileWriter(textFileName);
                            bufferedWriter = new BufferedWriter(fileWriter);
                            if (this.containsValueToBeCorrected) {
                                diffDDL = String.valueOf(this.frame_.ddlCommentMark) + "Warning: It contains constraint id(s) indicated as '???' that should be checked and corrected before executing.\n\n" + diffDDL;
                            }
                            bufferedWriter.write(diffDDL);
                            bufferedWriter.flush();
                            this.frame_.desktop.open(textFile);
                        }
                    }
                    catch (Exception ex1) {
                        ex1.printStackTrace();
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                this.jTextArea.setText(String.valueOf(this.countOfChanges) + res.getString("DialogToListChangesOfFiles35") + this.buffer.toString());
                this.jTextArea.setCaretPosition(0);
                this.jProgressBar.setVisible(false);
                this.jButtonStart.setVisible(true);
                this.jButtonStart.setEnabled(false);
                this.jCheckBoxListDiffDDL.setEnabled(false);
                this.getRootPane().setDefaultButton(this.jButtonCancel);
                this.setCursor(new Cursor(0));
            }
        }
    }

    void setupProgressMaxValue() {
        int countOfElementsProcessed = 0;
        NodeList workElementList = this.systemElementOld.getElementsByTagName("Department");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Department");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("TaskType");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("TaskType");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("TableType");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("TableType");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("DataType");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("DataType");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("FunctionType");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("FunctionType");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Terms");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Terms");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("MaintenanceLog");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("MaintenanceLog");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("SubjectArea");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("SubjectArea");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Role");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Role");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Task");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Task");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Subsystem");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Subsystem");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Table");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Table");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Function");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Function");
        this.jProgressBar.setMaximum((countOfElementsProcessed += workElementList.getLength()) + 1);
    }

    void listChangesOfBasicInfo() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        this.buffer.append("\n\n<" + res.getString("DialogToListChangesOfFiles8") + ">");
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "Name", res.getString("DialogToListChangesOfFiles9"));
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "Version", res.getString("DialogToListChangesOfFiles9"));
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "RefFiles", res.getString("DialogToListChangesOfFiles9"));
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "Descriptions", res.getString("DialogToListChangesOfFiles9"));
        String tagName = "Department";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Descriptions");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
        tagName = "TaskType";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Descriptions");
        oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
        tagName = "TableType";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Descriptions");
        oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        newElementList = this.systemElementNew.getElementsByTagName("TableType");
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
        tagName = "DataType";
        attrList.clear();
        attrList.add("Name");
        attrList.add("BasicType");
        attrList.add("Length");
        attrList.add("Decimal");
        attrList.add("SQLExpression");
        oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
        tagName = "FunctionType";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Descriptions");
        oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
        tagName = "Terms";
        attrList.clear();
        attrList.add("Header");
        attrList.add("HtmlFileName");
        attrList.add("Descriptions");
        oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Header");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Header");
        tagName = "MaintenanceLog";
        attrList.clear();
        attrList.add("Headder");
        attrList.add("Descriptions");
        oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Header");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Header");
        if (this.countOfChanges == workCount) {
            this.buffer.append("\n" + res.getString("DialogToListChangesOfFiles7"));
        }
    }

    boolean hasNoDuplicatedID(NodeList nodeList) {
        ArrayList<String> idList = new ArrayList<String>();
        boolean hasNone = true;
        int i = 0;
        while (i < nodeList.getLength()) {
            Element workElement = (Element)nodeList.item(i);
            if (idList.contains(workElement.getAttribute("SortKey"))) {
                this.buffer.append("\n" + workElement.getAttribute("SortKey") + res.getString("DialogToListChangesOfFiles39"));
                hasNone = false;
            } else {
                idList.add(workElement.getAttribute("SortKey"));
            }
            ++i;
        }
        return hasNone;
    }

    void listChangesOfDataflow() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        this.buffer.append("\n\n<" + res.getString("S3385") + ">");
        String tagName = "SubjectArea";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Descriptions");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        if (this.hasNoDuplicatedID(newElementList)) {
            this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
            this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
            if (this.countOfChanges == workCount) {
                this.buffer.append("\n" + res.getString("DialogToListChangesOfFiles7"));
            }
        }
    }

    void listChangesOfRoleAndTask() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        this.buffer.append("\n\n<" + res.getString("S3391") + ">");
        String tagName = "Role";
        attrList.clear();
        attrList.add("Name");
        attrList.add("DepartmentID");
        attrList.add("Descriptions");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        if (this.hasNoDuplicatedID(newElementList)) {
            this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
            this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
        }
        tagName = "Task";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Descriptions");
        attrList.add("Event");
        attrList.add("TaskTypeID");
        attrList.add("RoleID");
        oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        newElementList = this.systemElementNew.getElementsByTagName(tagName);
        if (this.hasNoDuplicatedID(newElementList)) {
            this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
            this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
        }
        if (this.countOfChanges == workCount) {
            this.buffer.append("\n" + res.getString("DialogToListChangesOfFiles7"));
        }
    }

    void listChangesOfSubsystem() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        this.buffer.append("\n\n<" + res.getString("S413") + ">");
        String tagName = "Subsystem";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Descriptions");
        attrList.add("DatamodelDescriptions");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        if (this.hasNoDuplicatedID(newElementList)) {
            this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
            this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
            if (this.countOfChanges == workCount) {
                this.buffer.append("\n" + res.getString("DialogToListChangesOfFiles7"));
            }
        }
    }

    void listChangesOfTable() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        this.containsValueToBeCorrected = false;
        this.buffer.append("\n\n<" + res.getString("DialogToListChangesOfFiles10") + ">");
        String tagName = "Table";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Descriptions");
        attrList.add("Alias");
        attrList.add("SynchFile");
        attrList.add("TableTypeID");
        attrList.add("SubsystemID");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        if (this.hasNoDuplicatedID(newElementList)) {
            this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
            this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
            if (this.countOfChanges == workCount) {
                this.buffer.append("\n" + res.getString("DialogToListChangesOfFiles7"));
            }
        }
    }

    String getDiffDDL(NodeList newTableElementList, NodeList oldTableElementList) {
        Element oldTableElement;
        Element newTableElement;
        int j;
        Element workElement;
        StringBuffer bf = new StringBuffer();
        String tableID = "";
        NodeList relationshipList = this.frame_.getDomDocument().getElementsByTagName("Relationship");
        NodeList oldSubsystemList = this.systemElementOld.getElementsByTagName("Subsystem");
        this.jProgressBar.setValue(0);
        this.jProgressBar.setString(res.getString("DialogToListChangesOfFiles38"));
        this.jProgressBar.setMaximum(newTableElementList.getLength() + oldTableElementList.getLength());
        this.newDataTypeElementMap.clear();
        NodeList dataTypeList = this.systemElementNew.getElementsByTagName("DataType");
        int i = 0;
        while (i < dataTypeList.getLength()) {
            workElement = (Element)dataTypeList.item(i);
            this.newDataTypeElementMap.put(workElement.getAttribute("ID"), workElement);
            ++i;
        }
        this.oldDataTypeElementMap.clear();
        dataTypeList = this.systemElementOld.getElementsByTagName("DataType");
        i = 0;
        while (i < dataTypeList.getLength()) {
            workElement = (Element)dataTypeList.item(i);
            this.oldDataTypeElementMap.put(workElement.getAttribute("ID"), workElement);
            ++i;
        }
        i = 0;
        while (i < this.frame_.getSubsystemListNode().getChildCount()) {
            Modeler.XeadTreeNode subsystemNode = (Modeler.XeadTreeNode)this.frame_.getSubsystemListNode().getChildAt(i);
            j = 0;
            while (j < subsystemNode.getChildAt(0).getChildCount()) {
                Modeler.XeadTreeNode tableNode = (Modeler.XeadTreeNode)subsystemNode.getChildAt(0).getChildAt(j);
                newTableElement = tableNode.getElement();
                this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
                this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
                oldTableElement = null;
                int k = 0;
                while (k < oldTableElementList.getLength()) {
                    workElement = (Element)oldTableElementList.item(k);
                    if (this.frame_.useTableNameAsTableNameInCreateTableStatement) {
                        if (workElement.getAttribute("Name").equals(newTableElement.getAttribute("Name"))) {
                            oldTableElement = workElement;
                            break;
                        }
                    } else if (workElement.getAttribute("Alias").equals("")) {
                        if (newTableElement.getAttribute("Alias").equals("")) {
                            if (workElement.getAttribute("SortKey").equals(newTableElement.getAttribute("SortKey"))) {
                                oldTableElement = workElement;
                                break;
                            }
                        } else if (workElement.getAttribute("SortKey").equals(newTableElement.getAttribute("Alias"))) {
                            oldTableElement = workElement;
                            break;
                        }
                    } else if (newTableElement.getAttribute("Alias").equals("")) {
                        if (workElement.getAttribute("Alias").equals(newTableElement.getAttribute("SortKey"))) {
                            oldTableElement = workElement;
                            break;
                        }
                    } else if (workElement.getAttribute("Alias").equals(newTableElement.getAttribute("Alias"))) {
                        oldTableElement = workElement;
                        break;
                    }
                    ++k;
                }
                if (oldTableElement == null) {
                    bf.append(this.frame_.getCreateStatementByTable(subsystemNode, tableNode, relationshipList));
                } else {
                    String wrkStr = this.getAlterStatementsByTable(subsystemNode, tableNode, oldTableElement);
                    if (!wrkStr.equals("")) {
                        bf.append(String.valueOf(wrkStr) + "\n");
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < oldTableElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            oldTableElement = (Element)oldTableElementList.item(i);
            newTableElement = null;
            j = 0;
            while (j < newTableElementList.getLength()) {
                workElement = (Element)newTableElementList.item(j);
                if (this.frame_.useTableNameAsTableNameInCreateTableStatement) {
                    tableID = oldTableElement.getAttribute("Name");
                    if (workElement.getAttribute("Name").equals(tableID)) {
                        newTableElement = workElement;
                        break;
                    }
                } else if (workElement.getAttribute("Alias").equals("")) {
                    if (oldTableElement.getAttribute("Alias").equals("")) {
                        tableID = oldTableElement.getAttribute("SortKey");
                        if (workElement.getAttribute("SortKey").equals(tableID)) {
                            newTableElement = workElement;
                            break;
                        }
                    } else {
                        tableID = oldTableElement.getAttribute("Alias");
                        if (workElement.getAttribute("SortKey").equals(tableID)) {
                            newTableElement = workElement;
                            break;
                        }
                    }
                } else if (oldTableElement.getAttribute("Alias").equals("")) {
                    tableID = oldTableElement.getAttribute("SortKey");
                    if (workElement.getAttribute("Alias").equals(tableID)) {
                        newTableElement = workElement;
                        break;
                    }
                } else {
                    tableID = oldTableElement.getAttribute("Alias");
                    if (workElement.getAttribute("Alias").equals(tableID)) {
                        newTableElement = workElement;
                        break;
                    }
                }
                ++j;
            }
            if (newTableElement == null) {
                j = 0;
                while (j < oldSubsystemList.getLength()) {
                    workElement = (Element)oldSubsystemList.item(j);
                    if (oldTableElement.getAttribute("SubsystemID").equals(workElement.getAttribute("ID"))) {
                        if (oldTableElement.getAttribute("Alias").equals("")) {
                            if (oldTableElement.getAttribute("SortKey").equals("")) {
                                bf.append(String.valueOf(this.frame_.ddlCommentMark) + workElement.getAttribute("Name") + "(" + workElement.getAttribute("SortKey") + ")" + " - " + oldTableElement.getAttribute("Name") + "\nDROP TABLE " + tableID + this.frame_.ddlSectionMark + "\n\n");
                                break;
                            }
                            bf.append(String.valueOf(this.frame_.ddlCommentMark) + workElement.getAttribute("Name") + "(" + workElement.getAttribute("SortKey") + ")" + " - " + oldTableElement.getAttribute("Name") + "(" + oldTableElement.getAttribute("SortKey") + ")" + "\nDROP TABLE " + tableID + this.frame_.ddlSectionMark + "\n\n");
                            break;
                        }
                        bf.append(String.valueOf(this.frame_.ddlCommentMark) + workElement.getAttribute("Name") + "(" + workElement.getAttribute("SortKey") + ")" + " - " + oldTableElement.getAttribute("Name") + "(" + oldTableElement.getAttribute("Alias") + ")" + "\nDROP TABLE " + tableID + this.frame_.ddlSectionMark + "\n\n");
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return bf.toString();
    }

    String getAlterStatementsByTable(Modeler.XeadTreeNode subsystemNode, Modeler.XeadTreeNode tableNode, Element oldTableElement) {
        String wrkStr;
        String keyFieldsOld;
        boolean isNotFound;
        String keyFields;
        Modeler.XeadTreeNode keyNode;
        Element workElement;
        int j;
        Element correspondingFieldElement;
        String fieldName;
        boolean firstFieldStatement = true;
        int indexOfSK = 0;
        int indexOfFK = 0;
        String statement = "";
        NodeList oldFieldList = oldTableElement.getElementsByTagName("TableField");
        NodeList oldKeyList = oldTableElement.getElementsByTagName("TableKey");
        NodeList newRelationshipList = this.systemElementNew.getElementsByTagName("Relationship");
        NodeList oldRelationshipList = this.systemElementOld.getElementsByTagName("Relationship");
        ArrayList<String> addFieldIDList = new ArrayList<String>();
        ArrayList<String> addFieldTypeList = new ArrayList<String>();
        ArrayList<String> addFieldDefaultList = new ArrayList<String>();
        ArrayList<Boolean> addFieldNotNullList = new ArrayList<Boolean>();
        ArrayList<String> addFieldCommentList = new ArrayList<String>();
        ArrayList<String> modifyFieldIDList = new ArrayList<String>();
        ArrayList<String> modifyFieldTypeList = new ArrayList<String>();
        ArrayList<String> modifyFieldDefaultList = new ArrayList<String>();
        ArrayList<Boolean> modifyFieldNotNullList = new ArrayList<Boolean>();
        ArrayList<String> dropFieldIDList = new ArrayList<String>();
        boolean isToDropOldPrimaryKey = false;
        String addPrimaryKeyFieldIDs = "";
        ArrayList<String> dropUniqueKeyList = new ArrayList<String>();
        ArrayList<String> addUniqueKeyList = new ArrayList<String>();
        ArrayList<String> addUniqueKeyConstraintIDList = new ArrayList<String>();
        ArrayList<String> dropIndexKeyList = new ArrayList<String>();
        ArrayList<String> addIndexKeyList = new ArrayList<String>();
        ArrayList<String> addForeignKeyConstraintIDList = new ArrayList<String>();
        ArrayList<String> addForeignKeyFieldIDsList = new ArrayList<String>();
        ArrayList<String> addForeignKeyRefferencesList = new ArrayList<String>();
        ArrayList<String> dropForeignKeyFieldIDsList = new ArrayList<String>();
        ArrayList<String> dropForeignKeyRefferencesList = new ArrayList<String>();
        String tableName = this.frame_.useTableNameAsTableNameInCreateTableStatement ? tableNode.getElement().getAttribute("Name") : (tableNode.getElement().getAttribute("Alias").equals("") ? (tableNode.getElement().getAttribute("SortKey").equals("") ? tableNode.getElement().getAttribute("Name") : tableNode.getElement().getAttribute("SortKey")) : tableNode.getElement().getAttribute("Alias"));
        int i = 0;
        while (i < tableNode.getChildAt(0).getChildCount()) {
            String fieldComment;
            Modeler.XeadTreeNode fieldNode = (Modeler.XeadTreeNode)tableNode.getChildAt(0).getChildAt(i);
            if (fieldNode.getElement().getAttribute("Alias").equals("")) {
                fieldName = fieldNode.getElement().getAttribute("Name");
                fieldComment = "";
            } else {
                fieldName = fieldNode.getElement().getAttribute("Alias");
                fieldComment = fieldNode.getElement().getAttribute("Name");
            }
            Element dataTypeElement = this.newDataTypeElementMap.get(fieldNode.getElement().getAttribute("DataTypeID"));
            String dataType = dataTypeElement == null ? "Invalid-data-type" : (dataTypeElement.getAttribute("SQLExpression").equals("") ? "Invalid-data-type" : dataTypeElement.getAttribute("SQLExpression"));
            String defaultValue = fieldNode.getElement().getAttribute("Default").equals("") ? "" : fieldNode.getElement().getAttribute("Default");
            boolean isNotNull = fieldNode.getElement().getAttribute("NotNull").equals("true");
            correspondingFieldElement = null;
            j = 0;
            while (j < oldFieldList.getLength()) {
                workElement = (Element)oldFieldList.item(j);
                if (workElement.getAttribute("Alias").equals("")) {
                    if (workElement.getAttribute("Name").equals(fieldName)) {
                        correspondingFieldElement = workElement;
                        break;
                    }
                } else if (workElement.getAttribute("Alias").equals(fieldName)) {
                    correspondingFieldElement = workElement;
                    break;
                }
                ++j;
            }
            if (correspondingFieldElement == null) {
                addFieldIDList.add(fieldName);
                addFieldTypeList.add(dataType);
                addFieldDefaultList.add(defaultValue);
                addFieldNotNullList.add(isNotNull);
                addFieldCommentList.add(fieldComment);
            } else {
                workElement = this.oldDataTypeElementMap.get(correspondingFieldElement.getAttribute("DataTypeID"));
                String dataTypeOld = workElement == null ? "Invalid-data-type" : (workElement.getAttribute("SQLExpression").equals("") ? "Invalid-data-type" : workElement.getAttribute("SQLExpression"));
                String defaultValueOld = correspondingFieldElement.getAttribute("Default").equals("") ? "" : correspondingFieldElement.getAttribute("Default");
                boolean isNotNullOld = correspondingFieldElement.getAttribute("NotNull").equals("true");
                if (!dataType.equals(dataTypeOld) || !defaultValue.equals(defaultValueOld) || isNotNull != isNotNullOld) {
                    modifyFieldIDList.add(fieldName);
                    if (dataType.equals(dataTypeOld)) {
                        modifyFieldTypeList.add(null);
                    } else {
                        modifyFieldTypeList.add(dataType);
                    }
                    if (defaultValue.equals(defaultValueOld)) {
                        modifyFieldDefaultList.add(null);
                    } else {
                        modifyFieldDefaultList.add(defaultValue);
                    }
                    if (isNotNull == isNotNullOld) {
                        modifyFieldNotNullList.add(null);
                    } else {
                        modifyFieldNotNullList.add(isNotNull);
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < oldFieldList.getLength()) {
            Element fieldElement = (Element)oldFieldList.item(i);
            fieldName = fieldElement.getAttribute("Alias").equals("") ? fieldElement.getAttribute("Name") : fieldElement.getAttribute("Alias");
            correspondingFieldElement = null;
            j = 0;
            while (j < tableNode.getChildAt(0).getChildCount()) {
                workElement = ((Modeler.XeadTreeNode)tableNode.getChildAt(0).getChildAt(j)).getElement();
                if (workElement.getAttribute("Alias").equals("")) {
                    if (workElement.getAttribute("Name").equals(fieldName)) {
                        correspondingFieldElement = workElement;
                        break;
                    }
                } else if (workElement.getAttribute("Alias").equals(fieldName)) {
                    correspondingFieldElement = workElement;
                    break;
                }
                ++j;
            }
            if (correspondingFieldElement == null) {
                dropFieldIDList.add(fieldName);
            }
            ++i;
        }
        i = 0;
        while (i < tableNode.getChildAt(1).getChildCount()) {
            keyNode = (Modeler.XeadTreeNode)tableNode.getChildAt(1).getChildAt(i);
            if (keyNode.getElement().getAttribute("Type").equals("SK")) {
                ++indexOfSK;
            }
            if (keyNode.getElement().getAttribute("Type").equals("PK") || keyNode.getElement().getAttribute("Type").equals("SK") || keyNode.getElement().getAttribute("Type").equals("XK")) {
                keyFields = this.getKeyFieldIDs(tableNode.getElement(), keyNode.getElement(), this.systemElementNew);
                isNotFound = true;
                j = 0;
                while (j < oldKeyList.getLength()) {
                    workElement = (Element)oldKeyList.item(j);
                    if (workElement.getAttribute("Type").equals(keyNode.getElement().getAttribute("Type")) && (keyFieldsOld = this.getKeyFieldIDs(oldTableElement, workElement, this.systemElementOld)).equals(keyFields)) {
                        isNotFound = false;
                        break;
                    }
                    ++j;
                }
                if (isNotFound) {
                    isToDropOldPrimaryKey = false;
                    if (keyNode.getElement().getAttribute("Type").equals("PK")) {
                        j = 0;
                        while (j < oldKeyList.getLength()) {
                            workElement = (Element)oldKeyList.item(j);
                            if (workElement.equals("PK")) {
                                isToDropOldPrimaryKey = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    this.frame_.sortableDomElementListModel.removeAllElements();
                    NodeList keyFieldList = keyNode.getElement().getElementsByTagName("TableKeyField");
                    int m = 0;
                    while (m < keyFieldList.getLength()) {
                        this.frame_.sortableDomElementListModel.addElement(keyFieldList.item(m));
                        ++m;
                    }
                    if (this.frame_.sortableDomElementListModel.getSize() > 0) {
                        this.frame_.sortableDomElementListModel.sortElements();
                        wrkStr = "";
                        m = 0;
                        while (m < this.frame_.sortableDomElementListModel.getSize()) {
                            Element keyFieldElement = (Element)this.frame_.sortableDomElementListModel.getElementAt(m);
                            Modeler.XeadTreeNode workFieldNode = this.frame_.getSpecificXeadTreeNode("TableField", tableNode.getElement().getAttribute("ID"), keyFieldElement.getAttribute("FieldID"));
                            if (keyNode.getElement().getAttribute("Type").equals("PK")) {
                                if (m > 0) {
                                    addPrimaryKeyFieldIDs = String.valueOf(addPrimaryKeyFieldIDs) + ", ";
                                }
                                addPrimaryKeyFieldIDs = workFieldNode.getElement().getAttribute("Alias").equals("") ? String.valueOf(addPrimaryKeyFieldIDs) + workFieldNode.getElement().getAttribute("Name") : String.valueOf(addPrimaryKeyFieldIDs) + workFieldNode.getElement().getAttribute("Alias");
                            } else {
                                if (m > 0) {
                                    wrkStr = String.valueOf(wrkStr) + ", ";
                                }
                                wrkStr = workFieldNode.getElement().getAttribute("Alias").equals("") ? String.valueOf(wrkStr) + workFieldNode.getElement().getAttribute("Name") : String.valueOf(wrkStr) + workFieldNode.getElement().getAttribute("Alias");
                            }
                            ++m;
                        }
                        if (keyNode.getElement().getAttribute("Type").equals("SK")) {
                            addUniqueKeyList.add(wrkStr);
                            addUniqueKeyConstraintIDList.add(Integer.toString(indexOfSK));
                        }
                        if (keyNode.getElement().getAttribute("Type").equals("XK")) {
                            addIndexKeyList.add(wrkStr);
                        }
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < oldKeyList.getLength()) {
            workElement = (Element)oldKeyList.item(i);
            if (workElement.getAttribute("Type").equals("PK") || workElement.getAttribute("Type").equals("SK") || workElement.getAttribute("Type").equals("XK")) {
                keyFieldsOld = this.getKeyFieldIDs(oldTableElement, workElement, this.systemElementOld);
                isNotFound = true;
                j = 0;
                while (j < tableNode.getChildAt(1).getChildCount()) {
                    keyNode = (Modeler.XeadTreeNode)tableNode.getChildAt(1).getChildAt(j);
                    if (workElement.getAttribute("Type").equals(keyNode.getElement().getAttribute("Type")) && (keyFields = this.getKeyFieldIDs(tableNode.getElement(), keyNode.getElement(), this.systemElementNew)).equals(keyFieldsOld)) {
                        isNotFound = false;
                        break;
                    }
                    ++j;
                }
                if (isNotFound && !(wrkStr = this.getKeyFieldIDs(oldTableElement, workElement, this.systemElementOld)).equals("")) {
                    if (workElement.getAttribute("Type").equals("PK") || workElement.getAttribute("Type").equals("SK")) {
                        dropUniqueKeyList.add(wrkStr);
                        this.containsValueToBeCorrected = true;
                    }
                    if (workElement.getAttribute("Type").equals("XK")) {
                        dropIndexKeyList.add(wrkStr);
                    }
                }
            }
            ++i;
        }
        if (!this.frame_.ignoreForeignKeyConstraints) {
            i = 0;
            while (i < tableNode.getChildAt(1).getChildCount()) {
                keyNode = (Modeler.XeadTreeNode)tableNode.getChildAt(1).getChildAt(i);
                ++indexOfFK;
                if (keyNode.getElement().getAttribute("Type").equals("PK") || keyNode.getElement().getAttribute("Type").equals("SK") || keyNode.getElement().getAttribute("Type").equals("FK")) {
                    j = 0;
                    while (j < newRelationshipList.getLength()) {
                        workElement = (Element)newRelationshipList.item(j);
                        if (workElement.getAttribute("Table2ID").equals(tableNode.getElement().getAttribute("ID")) && workElement.getAttribute("TableKey2ID").equals(keyNode.getElement().getAttribute("ID")) && workElement.getAttribute("ExistWhen1").equals("")) {
                            if (!this.isLackingForeignKeyConstraint(workElement, tableNode.getElement(), this.systemElementNew, oldTableElement, this.systemElementOld)) break;
                            addForeignKeyConstraintIDList.add(Integer.toString(indexOfFK));
                            addForeignKeyFieldIDsList.add(this.getKeyFieldIDs(tableNode.getElement(), keyNode.getElement(), this.systemElementNew));
                            addForeignKeyRefferencesList.add(this.getRefferences(workElement, this.systemElementNew));
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (!this.frame_.ignoreForeignKeyConstraints) {
            i = 0;
            while (i < oldKeyList.getLength()) {
                Element keyElement = (Element)oldKeyList.item(i);
                if (keyElement.getAttribute("Type").equals("PK") || keyElement.getAttribute("Type").equals("SK") || keyElement.getAttribute("Type").equals("FK")) {
                    j = 0;
                    while (j < oldRelationshipList.getLength()) {
                        workElement = (Element)oldRelationshipList.item(j);
                        if (workElement.getAttribute("Table2ID").equals(oldTableElement.getAttribute("ID")) && workElement.getAttribute("TableKey2ID").equals(keyElement.getAttribute("ID")) && workElement.getAttribute("ExistWhen1").equals("")) {
                            if (!this.isLackingForeignKeyConstraint(workElement, oldTableElement, this.systemElementOld, tableNode.getElement(), this.systemElementNew)) break;
                            dropForeignKeyFieldIDsList.add(this.getKeyFieldIDs(oldTableElement, keyElement, this.systemElementOld));
                            dropForeignKeyRefferencesList.add(this.getRefferences(workElement, this.systemElementOld));
                            this.containsValueToBeCorrected = true;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < dropUniqueKeyList.size()) {
            statement = String.valueOf(statement) + this.frame_.ddlCommentMark + "Following is the statement to drop unique-constraint with keys(" + (String)dropUniqueKeyList.get(i) + "). Check value of constraint id and correct '???' before executing.\n";
            statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " DROP CONSTRAINT ???" + this.frame_.ddlSectionMark + "\n";
            ++i;
        }
        i = 0;
        while (i < dropIndexKeyList.size()) {
            statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " DROP INDEX (" + (String)dropIndexKeyList.get(i) + ")" + this.frame_.ddlSectionMark + "\n";
            ++i;
        }
        i = 0;
        while (i < dropForeignKeyFieldIDsList.size()) {
            statement = String.valueOf(statement) + this.frame_.ddlCommentMark + "Following is the statement to drop refference-constraint with keys(" + (String)dropForeignKeyFieldIDsList.get(i) + ") to " + (String)dropForeignKeyRefferencesList.get(i) + ". Check value of constraint id and correct '???' before executing.\n";
            statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " DROP CONSTRAINT ???" + this.frame_.ddlSectionMark + "\n";
            ++i;
        }
        firstFieldStatement = true;
        i = 0;
        while (i < dropFieldIDList.size()) {
            if (firstFieldStatement) {
                firstFieldStatement = false;
                statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " DROP (" + "\n";
            } else {
                statement = String.valueOf(statement) + "," + "\n";
            }
            statement = String.valueOf(statement) + "\t" + (String)dropFieldIDList.get(i);
            ++i;
        }
        if (dropFieldIDList.size() > 0) {
            statement = String.valueOf(statement) + ")" + this.frame_.ddlSectionMark + "\n";
        }
        firstFieldStatement = true;
        i = 0;
        while (i < addFieldIDList.size()) {
            if (firstFieldStatement) {
                firstFieldStatement = false;
                statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " ADD (" + "\n";
            } else {
                statement = String.valueOf(statement) + "," + "\n";
            }
            statement = String.valueOf(statement) + "\t" + (String)addFieldIDList.get(i);
            statement = String.valueOf(statement) + " " + (String)addFieldTypeList.get(i);
            if (((Boolean)addFieldNotNullList.get(i)).booleanValue()) {
                statement = String.valueOf(statement) + " NOT NULL";
            }
            statement = String.valueOf(statement) + " DEFAULT " + (String)addFieldDefaultList.get(i);
            if (!((String)addFieldCommentList.get(i)).equals("") && this.frame_.ddlFieldCommentType.equals("1")) {
                statement = String.valueOf(statement) + " COMMENT '" + (String)addFieldCommentList.get(i) + "'";
            }
            ++i;
        }
        if (addFieldIDList.size() > 0) {
            statement = String.valueOf(statement) + ")" + this.frame_.ddlSectionMark + "\n";
        }
        firstFieldStatement = true;
        i = 0;
        while (i < modifyFieldIDList.size()) {
            if (firstFieldStatement) {
                firstFieldStatement = false;
                statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " MODIFY (" + "\n";
            } else {
                statement = String.valueOf(statement) + "," + "\n";
            }
            statement = String.valueOf(statement) + "\t" + (String)modifyFieldIDList.get(i);
            if (modifyFieldTypeList.get(i) != null) {
                statement = String.valueOf(statement) + " " + (String)modifyFieldTypeList.get(i);
            }
            if (modifyFieldNotNullList.get(i) != null) {
                statement = (Boolean)modifyFieldNotNullList.get(i) != false ? String.valueOf(statement) + " NOT NULL" : String.valueOf(statement) + " NULL";
            }
            if (modifyFieldDefaultList.get(i) != null) {
                statement = String.valueOf(statement) + " DEFAULT " + (String)modifyFieldDefaultList.get(i);
            }
            ++i;
        }
        if (modifyFieldIDList.size() > 0) {
            statement = String.valueOf(statement) + ")" + this.frame_.ddlSectionMark + "\n";
        }
        if (!addPrimaryKeyFieldIDs.equals("")) {
            if (isToDropOldPrimaryKey) {
                statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " DROP CONSTRAINT " + tableName + "_PK PRIMARY KEY" + this.frame_.ddlSectionMark + "\n";
            }
            statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " ADD CONSTRAINT " + tableName + "_PK PRIMARY KEY (" + addPrimaryKeyFieldIDs + ")" + this.frame_.ddlSectionMark + "\n";
        }
        i = 0;
        while (i < addUniqueKeyList.size()) {
            statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " ADD CONSTRAINT " + tableName + "_SK" + (String)addUniqueKeyConstraintIDList.get(i) + " UNIQUE (" + (String)addUniqueKeyList.get(i) + ")" + this.frame_.ddlSectionMark + "\n";
            ++i;
        }
        i = 0;
        while (i < addIndexKeyList.size()) {
            statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " ADD INDEX (" + (String)addIndexKeyList.get(i) + ")" + this.frame_.ddlSectionMark + "\n";
            ++i;
        }
        i = 0;
        while (i < addForeignKeyConstraintIDList.size()) {
            statement = String.valueOf(statement) + "ALTER TABLE " + tableName + " ADD CONSTRAINT " + tableName + "_FK" + (String)addForeignKeyConstraintIDList.get(i) + " FOREIGN KEY (" + (String)addForeignKeyFieldIDsList.get(i) + ") REFFERENCES " + (String)addForeignKeyRefferencesList.get(i) + this.frame_.ddlSectionMark + "\n";
            ++i;
        }
        if (!statement.equals("")) {
            statement = tableNode.getElement().getAttribute("Alias").equals("") ? (tableNode.getElement().getAttribute("SortKey").equals("") ? String.valueOf(this.frame_.ddlCommentMark) + subsystemNode.getElement().getAttribute("Name") + "(" + subsystemNode.getElement().getAttribute("SortKey") + ")" + " - " + tableNode.getElement().getAttribute("Name") + "\n" + statement : String.valueOf(this.frame_.ddlCommentMark) + subsystemNode.getElement().getAttribute("Name") + "(" + subsystemNode.getElement().getAttribute("SortKey") + ")" + " - " + tableNode.getElement().getAttribute("Name") + "(" + tableNode.getElement().getAttribute("SortKey") + ")" + "\n" + statement) : String.valueOf(this.frame_.ddlCommentMark) + subsystemNode.getElement().getAttribute("Name") + "(" + subsystemNode.getElement().getAttribute("SortKey") + ")" + " - " + tableNode.getElement().getAttribute("Name") + "(" + tableNode.getElement().getAttribute("Alias") + ")" + "\n" + statement;
        }
        return statement;
    }

    String getKeyFieldIDs(Element tableElement, Element keyElement, Element systemElement) {
        String keyFieldIDs = "";
        NodeList keyFieldList = keyElement.getElementsByTagName("TableKeyField");
        this.frame_.sortableDomElementListModel.removeAllElements();
        int m = 0;
        while (m < keyFieldList.getLength()) {
            this.frame_.sortableDomElementListModel.addElement(keyFieldList.item(m));
            ++m;
        }
        if (this.frame_.sortableDomElementListModel.getSize() > 0) {
            this.frame_.sortableDomElementListModel.sortElements();
            m = 0;
            while (m < this.frame_.sortableDomElementListModel.getSize()) {
                Element keyFieldElement = (Element)this.frame_.sortableDomElementListModel.getElementAt(m);
                Element fieldElement = this.getFieldElementAccordingToID(tableElement.getAttribute("ID"), keyFieldElement.getAttribute("FieldID"), systemElement);
                if (m > 0) {
                    keyFieldIDs = String.valueOf(keyFieldIDs) + ", ";
                }
                keyFieldIDs = fieldElement.getAttribute("Alias").equals("") ? String.valueOf(keyFieldIDs) + fieldElement.getAttribute("Name") : String.valueOf(keyFieldIDs) + fieldElement.getAttribute("Alias");
                if (keyElement.getAttribute("Type").equals("XK") && keyFieldElement.getAttribute("AscDesc").equals("D")) {
                    keyFieldIDs = String.valueOf(keyFieldIDs) + "(D)";
                }
                ++m;
            }
        }
        return keyFieldIDs;
    }

    String getRefferences(Element relationshipElement, Element systemElement) {
        Element workElement;
        String value = "";
        String tableName = "";
        String fieldNames = "";
        Element tableElement = null;
        Element tableKeyElement = null;
        String tableID = relationshipElement.getAttribute("Table1ID");
        String tableKeyID = relationshipElement.getAttribute("TableKey1ID");
        NodeList tableElementList = systemElement.getElementsByTagName("Table");
        int i = 0;
        while (i < tableElementList.getLength()) {
            workElement = (Element)tableElementList.item(i);
            if (workElement.getAttribute("ID").equals(tableID)) {
                tableElement = workElement;
                break;
            }
            ++i;
        }
        if (tableElement != null) {
            tableName = this.frame_.useTableNameAsTableNameInCreateTableStatement ? tableElement.getAttribute("Name") : (tableElement.getAttribute("Alias").equals("") ? (tableElement.getAttribute("SortKey").equals("") ? tableElement.getAttribute("Name") : tableElement.getAttribute("SortKey")) : tableElement.getAttribute("Alias"));
            NodeList tableKeyElementList = tableElement.getElementsByTagName("TableKey");
            int i2 = 0;
            while (i2 < tableKeyElementList.getLength()) {
                workElement = (Element)tableKeyElementList.item(i2);
                if (workElement.getAttribute("ID").equals(tableKeyID)) {
                    tableKeyElement = workElement;
                    break;
                }
                ++i2;
            }
            if (tableKeyElement != null) {
                fieldNames = this.getKeyFieldIDs(tableElement, tableKeyElement, systemElement);
            }
            value = String.valueOf(tableName) + "(" + fieldNames + ")";
        }
        return value;
    }

    boolean isLackingForeignKeyConstraint(Element relationshipElement, Element tableElement, Element systemElement, Element targetTableElement, Element targetSystemElement) {
        String wrkStr;
        int m;
        Element fieldElement;
        Element keyFieldElement;
        Element workElement;
        boolean reply = true;
        String tableIDFrom = relationshipElement.getAttribute("Table2ID");
        String tableKeyIDFrom = relationshipElement.getAttribute("TableKey2ID");
        int countOfTableKeyFieldsFrom = 0;
        String tableIDThru = relationshipElement.getAttribute("Table1ID");
        String tableKeyIDThru = relationshipElement.getAttribute("TableKey1ID");
        int countOfTableKeyFieldsThru = 0;
        String tableKeyTypeFrom = "";
        String tableKeyFieldsFrom = "";
        String tableNameThru = "";
        String tableKeyTypeThru = "";
        String tableKeyFieldsThru = "";
        String tableIDFromTarget = targetTableElement.getAttribute("ID");
        String tableKeyIDFromTarget = "";
        String tableIDThruTarget = "";
        String tableKeyIDThruTarget = "";
        NodeList keyElementList = tableElement.getElementsByTagName("TableKey");
        int i = 0;
        block0: while (i < keyElementList.getLength()) {
            workElement = (Element)keyElementList.item(i);
            if (workElement.getAttribute("ID").equals(tableKeyIDFrom)) {
                tableKeyTypeFrom = workElement.getAttribute("Type");
                NodeList keyFieldList = workElement.getElementsByTagName("TableKeyField");
                this.frame_.sortableDomElementListModel.removeAllElements();
                int m2 = 0;
                while (m2 < keyFieldList.getLength()) {
                    this.frame_.sortableDomElementListModel.addElement(keyFieldList.item(m2));
                    ++m2;
                }
                if (this.frame_.sortableDomElementListModel.getSize() <= 0) break;
                this.frame_.sortableDomElementListModel.sortElements();
                m2 = 0;
                while (m2 < this.frame_.sortableDomElementListModel.getSize()) {
                    ++countOfTableKeyFieldsFrom;
                    keyFieldElement = (Element)this.frame_.sortableDomElementListModel.getElementAt(m2);
                    fieldElement = this.getFieldElementAccordingToID(tableIDFrom, keyFieldElement.getAttribute("FieldID"), systemElement);
                    if (fieldElement == null) {
                        tableKeyFieldsFrom = "";
                        break block0;
                    }
                    if (m2 > 0) {
                        tableKeyFieldsFrom = String.valueOf(tableKeyFieldsFrom) + ", ";
                    }
                    tableKeyFieldsFrom = fieldElement.getAttribute("Alias").equals("") ? String.valueOf(tableKeyFieldsFrom) + fieldElement.getAttribute("Name") : String.valueOf(tableKeyFieldsFrom) + fieldElement.getAttribute("Alias");
                    ++m2;
                }
                break;
            }
            ++i;
        }
        if (tableKeyFieldsFrom.equals("")) {
            return false;
        }
        NodeList tableElementList = systemElement.getElementsByTagName("Table");
        int i2 = 0;
        block3: while (i2 < tableElementList.getLength()) {
            workElement = (Element)tableElementList.item(i2);
            if (workElement.getAttribute("ID").equals(tableIDThru)) {
                tableNameThru = this.frame_.useTableNameAsTableNameInCreateTableStatement ? workElement.getAttribute("Name") : (workElement.getAttribute("Alias").equals("") ? (workElement.getAttribute("SortKey").equals("") ? workElement.getAttribute("Name") : workElement.getAttribute("SortKey")) : workElement.getAttribute("Alias"));
                keyElementList = workElement.getElementsByTagName("TableKey");
                int j = 0;
                while (j < keyElementList.getLength()) {
                    workElement = (Element)keyElementList.item(j);
                    if (workElement.getAttribute("ID").equals(tableKeyIDThru)) {
                        tableKeyTypeThru = workElement.getAttribute("Type");
                        NodeList keyFieldList = workElement.getElementsByTagName("TableKeyField");
                        this.frame_.sortableDomElementListModel.removeAllElements();
                        m = 0;
                        while (m < keyFieldList.getLength()) {
                            this.frame_.sortableDomElementListModel.addElement(keyFieldList.item(m));
                            ++m;
                        }
                        if (this.frame_.sortableDomElementListModel.getSize() <= 0) break block3;
                        this.frame_.sortableDomElementListModel.sortElements();
                        m = 0;
                        while (m < this.frame_.sortableDomElementListModel.getSize()) {
                            ++countOfTableKeyFieldsThru;
                            keyFieldElement = (Element)this.frame_.sortableDomElementListModel.getElementAt(m);
                            fieldElement = this.getFieldElementAccordingToID(tableIDThru, keyFieldElement.getAttribute("FieldID"), systemElement);
                            if (fieldElement == null) {
                                tableKeyFieldsThru = "";
                                break block3;
                            }
                            if (m > 0) {
                                tableKeyFieldsThru = String.valueOf(tableKeyFieldsThru) + ", ";
                            }
                            tableKeyFieldsThru = fieldElement.getAttribute("Alias").equals("") ? String.valueOf(tableKeyFieldsThru) + fieldElement.getAttribute("Name") : String.valueOf(tableKeyFieldsThru) + fieldElement.getAttribute("Alias");
                            ++m;
                        }
                        break block3;
                    }
                    ++j;
                }
                break;
            }
            ++i2;
        }
        if (tableNameThru.equals("") || tableKeyFieldsThru.equals("")) {
            return false;
        }
        if (countOfTableKeyFieldsFrom > countOfTableKeyFieldsThru) {
            return false;
        }
        keyElementList = targetTableElement.getElementsByTagName("TableKey");
        i2 = 0;
        while (i2 < keyElementList.getLength()) {
            workElement = (Element)keyElementList.item(i2);
            if (workElement.getAttribute("Type").equals(tableKeyTypeFrom)) {
                NodeList keyFieldList = workElement.getElementsByTagName("TableKeyField");
                this.frame_.sortableDomElementListModel.removeAllElements();
                int m3 = 0;
                while (m3 < keyFieldList.getLength()) {
                    this.frame_.sortableDomElementListModel.addElement(keyFieldList.item(m3));
                    ++m3;
                }
                if (this.frame_.sortableDomElementListModel.getSize() > 0) {
                    this.frame_.sortableDomElementListModel.sortElements();
                    wrkStr = "";
                    m3 = 0;
                    while (m3 < this.frame_.sortableDomElementListModel.getSize()) {
                        keyFieldElement = (Element)this.frame_.sortableDomElementListModel.getElementAt(m3);
                        fieldElement = this.getFieldElementAccordingToID(targetTableElement.getAttribute("ID"), keyFieldElement.getAttribute("FieldID"), targetSystemElement);
                        if (fieldElement == null) {
                            wrkStr = "";
                            break;
                        }
                        if (m3 > 0) {
                            wrkStr = String.valueOf(wrkStr) + ", ";
                        }
                        wrkStr = fieldElement.getAttribute("Alias").equals("") ? String.valueOf(wrkStr) + fieldElement.getAttribute("Name") : String.valueOf(wrkStr) + fieldElement.getAttribute("Alias");
                        ++m3;
                    }
                    if (wrkStr.equals(tableKeyFieldsFrom)) {
                        tableKeyIDFromTarget = workElement.getAttribute("ID");
                        break;
                    }
                }
            }
            ++i2;
        }
        tableElementList = targetSystemElement.getElementsByTagName("Table");
        i2 = 0;
        block10: while (i2 < tableElementList.getLength()) {
            workElement = (Element)tableElementList.item(i2);
            wrkStr = this.frame_.useTableNameAsTableNameInCreateTableStatement ? workElement.getAttribute("Name") : (workElement.getAttribute("Alias").equals("") ? (workElement.getAttribute("SortKey").equals("") ? workElement.getAttribute("Name") : workElement.getAttribute("SortKey")) : workElement.getAttribute("Alias"));
            if (wrkStr.equals(tableNameThru)) {
                tableIDThruTarget = workElement.getAttribute("ID");
                keyElementList = workElement.getElementsByTagName("TableKey");
                int j = 0;
                while (j < keyElementList.getLength()) {
                    workElement = (Element)keyElementList.item(j);
                    if (workElement.getAttribute("Type").equals(tableKeyTypeThru)) {
                        NodeList keyFieldList = workElement.getElementsByTagName("TableKeyField");
                        this.frame_.sortableDomElementListModel.removeAllElements();
                        m = 0;
                        while (m < keyFieldList.getLength()) {
                            this.frame_.sortableDomElementListModel.addElement(keyFieldList.item(m));
                            ++m;
                        }
                        if (this.frame_.sortableDomElementListModel.getSize() > 0) {
                            this.frame_.sortableDomElementListModel.sortElements();
                            wrkStr = "";
                            m = 0;
                            while (m < this.frame_.sortableDomElementListModel.getSize()) {
                                keyFieldElement = (Element)this.frame_.sortableDomElementListModel.getElementAt(m);
                                fieldElement = this.getFieldElementAccordingToID(tableIDThruTarget, keyFieldElement.getAttribute("FieldID"), targetSystemElement);
                                if (fieldElement == null) {
                                    wrkStr = "";
                                    break;
                                }
                                if (m > 0) {
                                    wrkStr = String.valueOf(wrkStr) + ", ";
                                }
                                wrkStr = fieldElement.getAttribute("Alias").equals("") ? String.valueOf(wrkStr) + fieldElement.getAttribute("Name") : String.valueOf(wrkStr) + fieldElement.getAttribute("Alias");
                                ++m;
                            }
                            if (wrkStr.equals(tableKeyFieldsThru)) {
                                tableKeyIDThruTarget = workElement.getAttribute("ID");
                                break block10;
                            }
                        }
                    }
                    ++j;
                }
                break;
            }
            ++i2;
        }
        NodeList relationshipList = targetSystemElement.getElementsByTagName("Relationship");
        int i3 = 0;
        while (i3 < relationshipList.getLength()) {
            workElement = (Element)relationshipList.item(i3);
            if (workElement.getAttribute("Table2ID").equals(tableIDFromTarget) && workElement.getAttribute("TableKey2ID").equals(tableKeyIDFromTarget) && workElement.getAttribute("Table1ID").equals(tableIDThruTarget) && workElement.getAttribute("TableKey1ID").equals(tableKeyIDThruTarget) && workElement.getAttribute("ExistWhen1").equals("")) {
                reply = false;
                break;
            }
            ++i3;
        }
        return reply;
    }

    void listChangesOfFunction() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        this.buffer.append("\n\n<" + res.getString("DialogToListChangesOfFiles14") + ">");
        String tagName = "Function";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Descriptions");
        attrList.add("Summary");
        attrList.add("Parameters");
        attrList.add("Return");
        attrList.add("FunctionTypeID");
        attrList.add("SubsystemID");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        if (this.hasNoDuplicatedID(newElementList)) {
            this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Name");
            this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Name");
            if (this.countOfChanges == workCount) {
                this.buffer.append("\n" + res.getString("DialogToListChangesOfFiles7"));
            }
        }
    }

    void compareNewAndOldElements(Element elementNew, Element elementOld, String attribute, String elementLabel) {
        if (attribute.endsWith("ID")) {
            String sortKeyOld = this.getSortKeyAccordingToID(attribute, elementOld.getAttribute(attribute), this.systemElementOld);
            String sortKeyNew = this.getSortKeyAccordingToID(attribute, elementNew.getAttribute(attribute), this.systemElementNew);
            if (!sortKeyNew.equals(sortKeyOld)) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + attribute.replace("ID", "") + res.getString("DialogToListChangesOfFiles21") + sortKeyOld + res.getString("DialogToListChangesOfFiles22") + sortKeyNew + res.getString("DialogToListChangesOfFiles23"));
            }
        } else if (attribute.equals("NoUpdate")) {
            String notNullNew = elementNew.getAttribute(attribute);
            String notNullOld = elementOld.getAttribute(attribute);
            if (notNullNew.equals("") && notNullOld.equals("true") || notNullNew.equals("false") && notNullOld.equals("true") || notNullNew.equals("true") && notNullOld.equals("") || notNullNew.equals("true") && notNullOld.equals("false")) {
                this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + attribute + res.getString("DialogToListChangesOfFiles21") + elementOld.getAttribute(attribute) + res.getString("DialogToListChangesOfFiles22") + elementNew.getAttribute(attribute) + res.getString("DialogToListChangesOfFiles23"));
            }
        } else if (!elementNew.getAttribute(attribute).equals(elementOld.getAttribute(attribute))) {
            ++this.countOfChanges;
            if (attribute.equals("ImageText")) {
                this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles24"));
            } else if (attribute.equals("Descriptions")) {
                this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles25"));
            } else if (attribute.equals("DatamodelDescriptions")) {
                this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles26"));
            } else if (attribute.equals("Name")) {
                this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles27") + elementOld.getAttribute(attribute) + res.getString("DialogToListChangesOfFiles22") + elementNew.getAttribute(attribute) + res.getString("DialogToListChangesOfFiles23"));
            } else {
                this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + attribute + res.getString("DialogToListChangesOfFiles21") + elementOld.getAttribute(attribute) + res.getString("DialogToListChangesOfFiles22") + elementNew.getAttribute(attribute) + res.getString("DialogToListChangesOfFiles23"));
            }
        }
    }

    private String getSortKeyAccordingToID(String attribute, String id, Element systemElement) {
        String value = "(N/A)";
        String tagName = "";
        if (attribute.equals("DepartmentID")) {
            tagName = "Department";
        }
        if (attribute.equals("TaskTypeID")) {
            tagName = "TaskType";
        }
        if (attribute.equals("RoleID")) {
            tagName = "Role";
        }
        if (attribute.equals("SubsystemID")) {
            tagName = "Subsystem";
        }
        if (attribute.equals("TableTypeID")) {
            tagName = "TableType";
        }
        if (attribute.equals("DataTypeID")) {
            tagName = "DataType";
        }
        if (attribute.equals("FunctionTypeID")) {
            tagName = "FunctionType";
        }
        if (attribute.equals("TableID")) {
            tagName = "Table";
        }
        if (attribute.equals("FunctionID")) {
            tagName = "Function";
        }
        NodeList elementList = systemElement.getElementsByTagName(tagName);
        int i = 0;
        while (i < elementList.getLength()) {
            Element element = (Element)elementList.item(i);
            if (element.getAttribute("ID").equals(id)) {
                value = element.getAttribute("SortKey");
                break;
            }
            ++i;
        }
        return value;
    }

    void checkIfNewElementChangedOrAdded(NodeList newElementList, NodeList oldElementList, ArrayList<String> attrList, String tagName, String nameAttr) {
        String elementName = this.getElementNameAccordingToTagName(tagName);
        int i = 0;
        while (i < newElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            Element newElement = (Element)newElementList.item(i);
            boolean isNotFound = true;
            int j = 0;
            while (j < oldElementList.getLength()) {
                Element oldElement = (Element)oldElementList.item(j);
                if (oldElement.getAttribute("SortKey").equals(newElement.getAttribute("SortKey"))) {
                    int k = 0;
                    while (k < attrList.size()) {
                        String elementLabel = String.valueOf(elementName) + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute(nameAttr) + res.getString("DialogToListChangesOfFiles29");
                        this.compareNewAndOldElements(newElement, oldElement, attrList.get(k), elementLabel);
                        ++k;
                    }
                    isNotFound = false;
                    if (tagName.equals("SubjectArea")) {
                        this.checkSubjectAreaDetails(oldElement, newElement, elementName);
                    }
                    if (tagName.equals("Task")) {
                        this.checkTaskDetails(oldElement, newElement, elementName);
                    }
                    if (tagName.equals("Subsystem")) {
                        this.checkSubsystemDetails(oldElement, newElement, elementName);
                    }
                    if (tagName.equals("Table")) {
                        this.checkTableDetails(oldElement, newElement);
                    }
                    if (!tagName.equals("Function")) break;
                    this.checkFunctionDetails(oldElement, newElement);
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute(nameAttr) + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles30"));
            }
            ++i;
        }
    }

    void checkIfNewElementDeleted(NodeList newElementList, NodeList oldElementList, String tagName, String nameAttr) {
        String elementName = this.getElementNameAccordingToTagName(tagName);
        int i = 0;
        while (i < oldElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            Element oldElement = (Element)oldElementList.item(i);
            boolean isNotFound = true;
            int j = 0;
            while (j < newElementList.getLength()) {
                Element newElement = (Element)newElementList.item(j);
                if (oldElement.getAttribute("SortKey").equals(newElement.getAttribute("SortKey"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("DialogToListChangesOfFiles28") + oldElement.getAttribute("SortKey") + " " + oldElement.getAttribute(nameAttr) + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles31"));
            }
            ++i;
        }
    }

    void checkSubjectAreaDetails(Element oldElement, Element newElement, String elementName) {
        if (!(oldElement.getAttribute("BoundaryPosition").equals(newElement.getAttribute("BoundaryPosition")) && oldElement.getAttribute("BoundarySize").equals(newElement.getAttribute("BoundarySize")) && oldElement.getAttribute("BoundarySetting").equals(newElement.getAttribute("BoundarySetting")))) {
            ++this.countOfChanges;
            this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles24"));
        } else {
            NodeList oldNodeList = oldElement.getElementsByTagName("DataflowNode");
            NodeList newNodeList = newElement.getElementsByTagName("DataflowNode");
            NodeList oldLineList = oldElement.getElementsByTagName("DataflowLine");
            NodeList newLineList = newElement.getElementsByTagName("DataflowLine");
            if (oldNodeList.getLength() != newNodeList.getLength() || oldLineList.getLength() != newLineList.getLength()) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles24"));
            } else if (!oldElement.isEqualNode(newElement)) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles24"));
            }
        }
    }

    void checkTaskDetails(Element oldElement, Element newElement, String elementName) {
        NodeList oldActionList = oldElement.getElementsByTagName("TaskAction");
        NodeList newActionList = newElement.getElementsByTagName("TaskAction");
        if (oldActionList.getLength() != newActionList.getLength()) {
            ++this.countOfChanges;
            this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles32"));
        } else if (!oldElement.isEqualNode(newElement)) {
            ++this.countOfChanges;
            this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles32"));
        }
    }

    void checkSubsystemDetails(Element oldElement, Element newElement, String elementName) {
        NodeList oldTableBoxList = oldElement.getElementsByTagName("SubsystemTable");
        NodeList newTableBoxList = newElement.getElementsByTagName("SubsystemTable");
        NodeList oldTableRelList = oldElement.getElementsByTagName("SubsystemRelationship");
        NodeList newTableRelList = newElement.getElementsByTagName("SubsystemRelationship");
        if (oldTableBoxList.getLength() != newTableBoxList.getLength() || oldTableRelList.getLength() != newTableRelList.getLength()) {
            ++this.countOfChanges;
            this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles33"));
        } else if (!oldElement.isEqualNode(newElement)) {
            ++this.countOfChanges;
            this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles33"));
        }
    }

    void checkTableDetails(Element oldElement, Element newElement) {
        String fieldIDOld;
        Element oldElementWork;
        int j;
        boolean isNotFound;
        String fieldID;
        Element newElementWork;
        ArrayList<Element> newRelList = new ArrayList<Element>();
        ArrayList<Element> oldRelList = new ArrayList<Element>();
        ArrayList<String> attrList = new ArrayList<String>();
        String tableInternalID = newElement.getAttribute("ID");
        String tableLabel = String.valueOf(res.getString("DialogToListChangesOfFiles10")) + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29");
        String tagName = "TableField";
        String elementName = this.getElementNameAccordingToTagName(tagName);
        attrList.clear();
        attrList.add("Name");
        attrList.add("Descriptions");
        attrList.add("AttributeType");
        attrList.add("DataTypeID");
        attrList.add("ShowOnModel");
        attrList.add("NotNull");
        attrList.add("NoUpdate");
        attrList.add("Default");
        attrList.add("SortKey");
        NodeList oldElementList = oldElement.getElementsByTagName(tagName);
        NodeList newElementList = newElement.getElementsByTagName(tagName);
        int i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            fieldID = newElementWork.getAttribute("Alias").equals("") ? newElementWork.getAttribute("Name") : newElementWork.getAttribute("Alias");
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                fieldIDOld = oldElementWork.getAttribute("Alias").equals("") ? oldElementWork.getAttribute("Name") : oldElementWork.getAttribute("Alias");
                if (fieldIDOld.equals(fieldID)) {
                    String elementLabel = String.valueOf(tableLabel) + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + newElementWork.getAttribute("Alias") + " " + newElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29");
                    int k = 0;
                    while (k < attrList.size()) {
                        this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                        ++k;
                    }
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + newElementWork.getAttribute("Alias") + " " + newElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles30"));
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            fieldIDOld = oldElementWork.getAttribute("Alias").equals("") ? oldElementWork.getAttribute("Name") : oldElementWork.getAttribute("Alias");
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                fieldID = newElementWork.getAttribute("Alias").equals("") ? newElementWork.getAttribute("Name") : newElementWork.getAttribute("Alias");
                if (fieldID.equals(fieldIDOld)) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + oldElementWork.getAttribute("Alias") + " " + oldElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles31"));
            }
            ++i;
        }
        tagName = "TableKey";
        elementName = this.getElementNameAccordingToTagName(tagName);
        oldElementList = oldElement.getElementsByTagName(tagName);
        newElementList = newElement.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (oldElementWork.getAttribute("Type").equals(newElementWork.getAttribute("Type")) && oldElementWork.isEqualNode(newElementWork)) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("DialogToListChangesOfFiles20") + elementName + "(" + newElementWork.getAttribute("Type") + ")" + res.getString("DialogToListChangesOfFiles34"));
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("Type").equals(newElementWork.getAttribute("Type"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("DialogToListChangesOfFiles20") + elementName + "(" + oldElementWork.getAttribute("Type") + ")" + res.getString("DialogToListChangesOfFiles31"));
            }
            ++i;
        }
        tagName = "Relationship";
        elementName = this.getElementNameAccordingToTagName(tagName);
        oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        newElementList = this.systemElementNew.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            if (newElementWork.getAttribute("Table1ID").equals(tableInternalID) || newElementWork.getAttribute("Table2ID").equals(tableInternalID)) {
                newRelList.add(newElementWork);
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            if (oldElementWork.getAttribute("Table1ID").equals(tableInternalID) || oldElementWork.getAttribute("Table2ID").equals(tableInternalID)) {
                oldRelList.add(oldElementWork);
            }
            ++i;
        }
        if (newRelList.size() != oldRelList.size()) {
            ++this.countOfChanges;
            this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles34"));
        } else {
            isNotFound = true;
            i = 0;
            while (i < newRelList.size()) {
                newElementWork = (Element)newRelList.get(i);
                j = 0;
                while (j < oldRelList.size()) {
                    oldElementWork = (Element)oldRelList.get(i);
                    if (newElementWork.isEqualNode(oldElementWork)) {
                        isNotFound = false;
                        break;
                    }
                    ++j;
                }
                if (isNotFound) {
                    ++this.countOfChanges;
                    this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles34"));
                    break;
                }
                ++i;
            }
        }
    }

    void checkFunctionDetails(Element oldElement, Element newElement) {
        String tableCRUD2;
        String tableID2;
        String tableCRUD1;
        String tableID1;
        Element oldElementWork2;
        int p;
        boolean isNotFound2;
        Element newElementWork2;
        int m;
        NodeList newElementList2;
        NodeList oldElementList2;
        boolean isAnyChanged;
        int k;
        String elementLabel;
        String wrkStr2;
        String wrkStr1;
        Element oldElementWork;
        int j;
        boolean isNotFound;
        Element newElementWork;
        ArrayList<String> attrList = new ArrayList<String>();
        String functionLabel = String.valueOf(res.getString("DialogToListChangesOfFiles14")) + res.getString("DialogToListChangesOfFiles28") + newElement.getAttribute("SortKey") + " " + newElement.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29");
        String tagName = "FunctionUsedByThis";
        String elementName = this.getElementNameAccordingToTagName(tagName);
        NodeList oldElementList = oldElement.getElementsByTagName(tagName);
        NodeList newElementList = newElement.getElementsByTagName(tagName);
        int i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (oldElementWork.getAttribute("LaunchEvent").equals(newElementWork.getAttribute("LaunchEvent")) && oldElementWork.getAttribute("SortKey").equals(newElementWork.getAttribute("SortKey")) && (wrkStr1 = this.getSortKeyAccordingToID("FunctionID", oldElementWork.getAttribute("FunctionID"), this.systemElementOld)).equals(wrkStr2 = this.getSortKeyAccordingToID("FunctionID", newElementWork.getAttribute("FunctionID"), this.systemElementNew))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles34"));
                break;
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("LaunchEvent").equals(newElementWork.getAttribute("LaunchEvent")) && oldElementWork.getAttribute("SortKey").equals(newElementWork.getAttribute("SortKey")) && (wrkStr1 = this.getSortKeyAccordingToID("FunctionID", oldElementWork.getAttribute("FunctionID"), this.systemElementOld)).equals(wrkStr2 = this.getSortKeyAccordingToID("FunctionID", newElementWork.getAttribute("FunctionID"), this.systemElementNew))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles34"));
            }
            ++i;
        }
        tagName = "IOPanel";
        attrList.clear();
        attrList.add("Descriptions");
        attrList.add("ImageText");
        attrList.add("Background");
        attrList.add("Size");
        attrList.add("FontSize");
        attrList.add("SortKey");
        elementName = this.getElementNameAccordingToTagName(tagName);
        oldElementList = oldElement.getElementsByTagName(tagName);
        newElementList = newElement.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (oldElementWork.getAttribute("Name").equals(newElementWork.getAttribute("Name"))) {
                    elementLabel = String.valueOf(functionLabel) + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + newElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29");
                    k = 0;
                    while (k < attrList.size()) {
                        this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                        ++k;
                    }
                    isAnyChanged = false;
                    oldElementList2 = oldElementWork.getElementsByTagName("IOPanelStyle");
                    newElementList2 = newElementWork.getElementsByTagName("IOPanelStyle");
                    m = 0;
                    while (m < newElementList2.getLength()) {
                        newElementWork2 = (Element)newElementList2.item(m);
                        isNotFound2 = true;
                        p = 0;
                        while (p < oldElementList2.getLength()) {
                            oldElementWork2 = (Element)oldElementList2.item(p);
                            if (oldElementWork2.getAttribute("Value").equals(newElementWork2.getAttribute("Value"))) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            isAnyChanged = true;
                            break;
                        }
                        ++m;
                    }
                    m = 0;
                    while (m < oldElementList2.getLength()) {
                        oldElementWork2 = (Element)oldElementList2.item(m);
                        isNotFound2 = true;
                        p = 0;
                        while (p < newElementList2.getLength()) {
                            newElementWork2 = (Element)newElementList2.item(p);
                            if (oldElementWork2.getAttribute("Value").equals(newElementWork2.getAttribute("Value"))) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            isAnyChanged = true;
                            break;
                        }
                        ++m;
                    }
                    if (isAnyChanged) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + "Style" + res.getString("DialogToListChangesOfFiles34"));
                    }
                    isAnyChanged = false;
                    oldElementList2 = oldElementWork.getElementsByTagName("IOPanelField");
                    newElementList2 = newElementWork.getElementsByTagName("IOPanelField");
                    m = 0;
                    while (m < newElementList2.getLength()) {
                        newElementWork2 = (Element)newElementList2.item(m);
                        isNotFound2 = true;
                        p = 0;
                        while (p < oldElementList2.getLength()) {
                            oldElementWork2 = (Element)oldElementList2.item(p);
                            if (oldElementWork2.getAttribute("Name").equals(newElementWork2.getAttribute("Name")) && oldElementWork2.getAttribute("Label").equals(newElementWork2.getAttribute("Label")) && oldElementWork2.getAttribute("IOType").equals(newElementWork2.getAttribute("IOType")) && oldElementWork2.getAttribute("Descriptions").equals(newElementWork2.getAttribute("Descriptions")) && oldElementWork2.getAttribute("SortKey").equals(newElementWork2.getAttribute("SortKey"))) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            isAnyChanged = true;
                            break;
                        }
                        ++m;
                    }
                    m = 0;
                    while (m < oldElementList2.getLength()) {
                        oldElementWork2 = (Element)oldElementList2.item(m);
                        isNotFound2 = true;
                        p = 0;
                        while (p < newElementList2.getLength()) {
                            newElementWork2 = (Element)newElementList2.item(p);
                            if (oldElementWork2.getAttribute("Name").equals(newElementWork2.getAttribute("Name")) && oldElementWork2.getAttribute("Label").equals(newElementWork2.getAttribute("Label")) && oldElementWork2.getAttribute("IOType").equals(newElementWork2.getAttribute("IOType")) && oldElementWork2.getAttribute("Descriptions").equals(newElementWork2.getAttribute("Descriptions")) && oldElementWork2.getAttribute("SortKey").equals(newElementWork2.getAttribute("SortKey"))) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            isAnyChanged = true;
                            break;
                        }
                        ++m;
                    }
                    if (isAnyChanged) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + "Field" + res.getString("DialogToListChangesOfFiles34"));
                    }
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + newElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles30"));
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("Name").equals(newElementWork.getAttribute("Name"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + oldElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles31"));
            }
            ++i;
        }
        tagName = "IOSpool";
        attrList.clear();
        attrList.add("Descriptions");
        attrList.add("ImageText");
        attrList.add("Background");
        attrList.add("Size");
        attrList.add("FontSize");
        attrList.add("SortKey");
        elementName = this.getElementNameAccordingToTagName(tagName);
        oldElementList = oldElement.getElementsByTagName(tagName);
        newElementList = newElement.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (oldElementWork.getAttribute("Name").equals(newElementWork.getAttribute("Name"))) {
                    elementLabel = String.valueOf(functionLabel) + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + newElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29");
                    k = 0;
                    while (k < attrList.size()) {
                        this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                        ++k;
                    }
                    isAnyChanged = false;
                    oldElementList2 = oldElementWork.getElementsByTagName("IOSpoolStyle");
                    newElementList2 = newElementWork.getElementsByTagName("IOSpoolStyle");
                    m = 0;
                    while (m < newElementList2.getLength()) {
                        newElementWork2 = (Element)newElementList2.item(m);
                        isNotFound2 = true;
                        p = 0;
                        while (p < oldElementList2.getLength()) {
                            oldElementWork2 = (Element)oldElementList2.item(p);
                            if (oldElementWork2.getAttribute("Value").equals(newElementWork2.getAttribute("Value"))) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            isAnyChanged = true;
                            break;
                        }
                        ++m;
                    }
                    m = 0;
                    while (m < oldElementList2.getLength()) {
                        oldElementWork2 = (Element)oldElementList2.item(m);
                        isNotFound2 = true;
                        p = 0;
                        while (p < newElementList2.getLength()) {
                            newElementWork2 = (Element)newElementList2.item(p);
                            if (oldElementWork2.getAttribute("Value").equals(newElementWork2.getAttribute("Value"))) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            isAnyChanged = true;
                            break;
                        }
                        ++m;
                    }
                    if (isAnyChanged) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + "Style" + res.getString("DialogToListChangesOfFiles34"));
                    }
                    isAnyChanged = false;
                    oldElementList2 = oldElementWork.getElementsByTagName("IOSpoolField");
                    newElementList2 = newElementWork.getElementsByTagName("IOSpoolField");
                    m = 0;
                    while (m < newElementList2.getLength()) {
                        newElementWork2 = (Element)newElementList2.item(m);
                        isNotFound2 = true;
                        p = 0;
                        while (p < oldElementList2.getLength()) {
                            oldElementWork2 = (Element)oldElementList2.item(p);
                            if (oldElementWork2.getAttribute("Name").equals(newElementWork2.getAttribute("Name")) && oldElementWork2.getAttribute("Label").equals(newElementWork2.getAttribute("Label")) && oldElementWork2.getAttribute("Descriptions").equals(newElementWork2.getAttribute("Descriptions")) && oldElementWork2.getAttribute("SortKey").equals(newElementWork2.getAttribute("SortKey"))) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            isAnyChanged = true;
                            break;
                        }
                        ++m;
                    }
                    m = 0;
                    while (m < oldElementList2.getLength()) {
                        oldElementWork2 = (Element)oldElementList2.item(m);
                        isNotFound2 = true;
                        p = 0;
                        while (p < newElementList2.getLength()) {
                            newElementWork2 = (Element)newElementList2.item(p);
                            if (oldElementWork2.getAttribute("Name").equals(newElementWork2.getAttribute("Name")) && oldElementWork2.getAttribute("Label").equals(newElementWork2.getAttribute("Label")) && oldElementWork2.getAttribute("Descriptions").equals(newElementWork2.getAttribute("Descriptions")) && oldElementWork2.getAttribute("SortKey").equals(newElementWork2.getAttribute("SortKey"))) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            isAnyChanged = true;
                            break;
                        }
                        ++m;
                    }
                    if (isAnyChanged) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + "Field" + res.getString("DialogToListChangesOfFiles34"));
                    }
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + newElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles30"));
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("Name").equals(newElementWork.getAttribute("Name"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + oldElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles31"));
            }
            ++i;
        }
        tagName = "IOWebPage";
        attrList.clear();
        attrList.add("Descriptions");
        attrList.add("FileName");
        attrList.add("SortKey");
        elementName = this.getElementNameAccordingToTagName(tagName);
        oldElementList = oldElement.getElementsByTagName(tagName);
        newElementList = newElement.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (oldElementWork.getAttribute("Name").equals(newElementWork.getAttribute("Name"))) {
                    elementLabel = String.valueOf(functionLabel) + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + newElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29");
                    k = 0;
                    while (k < attrList.size()) {
                        this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                        ++k;
                    }
                    isAnyChanged = false;
                    oldElementList2 = oldElementWork.getElementsByTagName("IOWebPageField");
                    newElementList2 = newElementWork.getElementsByTagName("IOWebPageField");
                    m = 0;
                    while (m < newElementList2.getLength()) {
                        newElementWork2 = (Element)newElementList2.item(m);
                        isNotFound2 = true;
                        p = 0;
                        while (p < oldElementList2.getLength()) {
                            oldElementWork2 = (Element)oldElementList2.item(p);
                            if (oldElementWork2.getAttribute("Name").equals(newElementWork2.getAttribute("Name")) && oldElementWork2.getAttribute("Label").equals(newElementWork2.getAttribute("Label")) && oldElementWork2.getAttribute("IOType").equals(newElementWork2.getAttribute("IOType")) && oldElementWork2.getAttribute("Descriptions").equals(newElementWork2.getAttribute("Descriptions")) && oldElementWork2.getAttribute("SortKey").equals(newElementWork2.getAttribute("SortKey"))) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            isAnyChanged = true;
                            break;
                        }
                        ++m;
                    }
                    m = 0;
                    while (m < oldElementList2.getLength()) {
                        oldElementWork2 = (Element)oldElementList2.item(m);
                        isNotFound2 = true;
                        p = 0;
                        while (p < newElementList2.getLength()) {
                            newElementWork2 = (Element)newElementList2.item(p);
                            if (oldElementWork2.getAttribute("Name").equals(newElementWork2.getAttribute("Name")) && oldElementWork2.getAttribute("Label").equals(newElementWork2.getAttribute("Label")) && oldElementWork2.getAttribute("IOType").equals(newElementWork2.getAttribute("IOType")) && oldElementWork2.getAttribute("Descriptions").equals(newElementWork2.getAttribute("Descriptions")) && oldElementWork2.getAttribute("SortKey").equals(newElementWork2.getAttribute("SortKey"))) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            isAnyChanged = true;
                            break;
                        }
                        ++m;
                    }
                    if (isAnyChanged) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + "Field" + res.getString("DialogToListChangesOfFiles34"));
                    }
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + newElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles30"));
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("Name").equals(newElementWork.getAttribute("Name"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + oldElementWork.getAttribute("Name") + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles31"));
            }
            ++i;
        }
        tagName = "IOTable";
        attrList.clear();
        attrList.add("Descriptions");
        attrList.add("NameExtension");
        attrList.add("SortKey");
        attrList.add("Position");
        elementName = this.getElementNameAccordingToTagName(tagName);
        oldElementList = oldElement.getElementsByTagName(tagName);
        newElementList = newElement.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            tableID1 = this.getSortKeyAccordingToID("TableID", newElementWork.getAttribute("TableID"), this.systemElementNew);
            tableCRUD1 = this.getTableCRUD(newElementWork);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                tableID2 = this.getSortKeyAccordingToID("TableID", oldElementWork.getAttribute("TableID"), this.systemElementOld);
                tableCRUD2 = this.getTableCRUD(oldElementWork);
                if (tableID1.equals(tableID2) && tableCRUD1.equals(tableCRUD2) && oldElementWork.getAttribute("Position").equals(newElementWork.getAttribute("Position"))) {
                    String fieldName2;
                    String fieldName1;
                    elementLabel = String.valueOf(functionLabel) + res.getString("DialogToListChangesOfFiles20") + elementName + " " + tableID1 + "(" + tableCRUD1 + ")";
                    k = 0;
                    while (k < attrList.size()) {
                        this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                        ++k;
                    }
                    oldElementList2 = oldElementWork.getElementsByTagName("IOTableField");
                    newElementList2 = newElementWork.getElementsByTagName("IOTableField");
                    m = 0;
                    while (m < newElementList2.getLength()) {
                        newElementWork2 = (Element)newElementList2.item(m);
                        fieldName1 = this.getSortKeyAccordingToID("FieldID", newElementWork2.getAttribute("FieldID"), this.systemElementNew);
                        isNotFound2 = true;
                        p = 0;
                        while (p < oldElementList2.getLength()) {
                            oldElementWork2 = (Element)oldElementList2.item(p);
                            fieldName2 = this.getSortKeyAccordingToID("FieldID", oldElementWork2.getAttribute("FieldID"), this.systemElementOld);
                            if (fieldName1.equals(fieldName2)) {
                                if (newElementWork2.getAttribute("Descriptions").equals(oldElementWork2.getAttribute("Descriptions"))) {
                                    this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + res.getString("DialogToListChangesOfFiles28") + fieldName1 + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles34"));
                                }
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            ++this.countOfChanges;
                            this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + res.getString("DialogToListChangesOfFiles28") + fieldName1 + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles34"));
                            break;
                        }
                        ++m;
                    }
                    m = 0;
                    while (m < oldElementList2.getLength()) {
                        oldElementWork2 = (Element)oldElementList2.item(m);
                        Element workElement = this.getFieldElementAccordingToID(oldElementWork.getAttribute("TableID"), oldElementWork2.getAttribute("FieldID"), this.systemElementOld);
                        fieldName2 = workElement.getAttribute("Name");
                        isNotFound2 = true;
                        p = 0;
                        while (p < newElementList2.getLength()) {
                            newElementWork2 = (Element)newElementList2.item(p);
                            workElement = this.getFieldElementAccordingToID(newElementWork.getAttribute("TableID"), newElementWork2.getAttribute("FieldID"), this.systemElementNew);
                            fieldName1 = workElement.getAttribute("Name");
                            if (fieldName1.equals(fieldName2)) {
                                isNotFound2 = false;
                                break;
                            }
                            ++p;
                        }
                        if (isNotFound2) {
                            ++this.countOfChanges;
                            this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("DialogToListChangesOfFiles20") + res.getString("DialogToListChangesOfFiles28") + fieldName2 + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles31"));
                            break;
                        }
                        ++m;
                    }
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + tableID1 + "(" + tableCRUD1 + ")" + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles30"));
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            tableID2 = this.getSortKeyAccordingToID("TableID", oldElementWork.getAttribute("TableID"), this.systemElementOld);
            tableCRUD2 = this.getTableCRUD(oldElementWork);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                tableID1 = this.getSortKeyAccordingToID("TableID", newElementWork.getAttribute("TableID"), this.systemElementNew);
                tableCRUD1 = this.getTableCRUD(newElementWork);
                if (tableID1.equals(tableID2) && tableCRUD1.equals(tableCRUD2)) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("DialogToListChangesOfFiles20") + elementName + res.getString("DialogToListChangesOfFiles28") + tableID2 + "(" + tableCRUD2 + ")" + res.getString("DialogToListChangesOfFiles29") + res.getString("DialogToListChangesOfFiles31"));
            }
            ++i;
        }
    }

    private String getTableCRUD(Element tableIOElement) {
        String crud = "";
        if (tableIOElement.getAttribute("OpC").equals("+")) {
            crud = "C";
        }
        if (tableIOElement.getAttribute("OpR").equals("+")) {
            crud = String.valueOf(crud) + "R";
        }
        if (tableIOElement.getAttribute("OpU").equals("+")) {
            crud = String.valueOf(crud) + "U";
        }
        if (tableIOElement.getAttribute("OpD").equals("+")) {
            crud = String.valueOf(crud) + "D";
        }
        return crud;
    }

    private Element getFieldElementAccordingToID(String tableID, String fieldID, Element systemElement) {
        Element fieldElement = null;
        NodeList tableList = systemElement.getElementsByTagName("Table");
        int i = 0;
        block0: while (i < tableList.getLength()) {
            Element tableElement = (Element)tableList.item(i);
            if (tableElement.getAttribute("ID").equals(tableID)) {
                NodeList fieldList = tableElement.getElementsByTagName("TableField");
                int j = 0;
                while (j < fieldList.getLength()) {
                    Element workElement = (Element)fieldList.item(j);
                    if (workElement.getAttribute("ID").equals(fieldID)) {
                        fieldElement = workElement;
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return fieldElement;
    }

    private String getElementNameAccordingToTagName(String tagName) {
        String elementName = "???";
        if (tagName.equals("Department")) {
            elementName = res.getString("S341");
        }
        if (tagName.equals("TaskType")) {
            elementName = res.getString("S362");
        }
        if (tagName.equals("TableType")) {
            elementName = res.getString("S477");
        }
        if (tagName.equals("DataType")) {
            elementName = res.getString("S544");
        }
        if (tagName.equals("FunctionType")) {
            elementName = res.getString("S417");
        }
        if (tagName.equals("Terms")) {
            elementName = res.getString("S245");
        }
        if (tagName.equals("MaintenanceLog")) {
            elementName = res.getString("S252");
        }
        if (tagName.equals("SubjectArea")) {
            elementName = res.getString("S3385");
        }
        if (tagName.equals("Role")) {
            elementName = res.getString("S339");
        }
        if (tagName.equals("Task")) {
            elementName = res.getString("S359");
        }
        if (tagName.equals("Subsystem")) {
            elementName = res.getString("S413");
        }
        if (tagName.equals("Table")) {
            elementName = res.getString("DialogToListChangesOfFiles10");
        }
        if (tagName.equals("TableField")) {
            elementName = res.getString("DialogToListChangesOfFiles11");
        }
        if (tagName.equals("TableKey")) {
            elementName = res.getString("DialogToListChangesOfFiles12");
        }
        if (tagName.equals("Relationship")) {
            elementName = res.getString("DialogToListChangesOfFiles13");
        }
        if (tagName.equals("Function")) {
            elementName = res.getString("DialogToListChangesOfFiles14");
        }
        if (tagName.equals("FunctionUsedByThis")) {
            elementName = res.getString("DialogToListChangesOfFiles15");
        }
        if (tagName.equals("IOPanel")) {
            elementName = res.getString("DialogToListChangesOfFiles16");
        }
        if (tagName.equals("IOWebPage")) {
            elementName = res.getString("DialogToListChangesOfFiles17");
        }
        if (tagName.equals("IOSpool")) {
            elementName = res.getString("DialogToListChangesOfFiles18");
        }
        if (tagName.equals("IOTable")) {
            elementName = res.getString("DialogToListChangesOfFiles19");
        }
        return elementName;
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

