/*
 * Decompiled with CFR 0.152.
 */
package xeadModeler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadModeler.DialogEditInstanceOnDatamodel_jMenuItemAddSlideActionAdapter;
import xeadModeler.DialogEditInstanceOnDatamodel_jMenuItemRemoveSlideActionAdapter;
import xeadModeler.DialogEditInstanceOnDatamodel_jMenuItemSetSequenceActionAdapter;
import xeadModeler.DialogEditInstanceOnDatamodel_keyAdapter;
import xeadModeler.DialogEditInstanceOnDatamodel_mouseAdapter;
import xeadModeler.Modeler;

public class DialogEditInstanceOnDatamodel
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadModeler.Res");
    private JTabbedPane jTabbedPane = new JTabbedPane(3);
    private SpinnerNumberModel sModel = new SpinnerNumberModel(0, 0, 30, 1);
    private JSpinner spinner = new JSpinner(this.sModel);
    private Modeler frame_;
    private Element subsystemTableElement_;
    private JPopupMenu jPopupMenu = new JPopupMenu();
    private JMenuItem jMenuItemSetSequence = new JMenuItem(res.getString("DialogEditInstanceOnDatamodel2"));
    private JMenuItem jMenuItemAddSlide = new JMenuItem(res.getString("DialogEditInstanceOnDatamodel3"));
    private JMenuItem jMenuItemRemoveSlide = new JMenuItem(res.getString("DialogEditInstanceOnDatamodel4"));
    private ArrayList<JTextArea> textAreaList = new ArrayList();
    private ArrayList<String> sortKeyList = new ArrayList();
    private boolean isEdited = false;

    public DialogEditInstanceOnDatamodel(Modeler frame) {
        super(frame, "", true);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jPopupMenu.add(this.jMenuItemSetSequence);
        this.jPopupMenu.add(this.jMenuItemAddSlide);
        this.jPopupMenu.add(this.jMenuItemRemoveSlide);
        this.jMenuItemSetSequence.addActionListener(new DialogEditInstanceOnDatamodel_jMenuItemSetSequenceActionAdapter(this));
        this.jMenuItemAddSlide.addActionListener(new DialogEditInstanceOnDatamodel_jMenuItemAddSlideActionAdapter(this));
        this.jMenuItemRemoveSlide.addActionListener(new DialogEditInstanceOnDatamodel_jMenuItemRemoveSlideActionAdapter(this));
        this.setResizable(true);
        this.getContentPane().add(this.jTabbedPane);
    }

    public boolean request(Modeler.DatamodelEntityBox entityBox) {
        this.subsystemTableElement_ = entityBox.getSubsystemTableElement();
        this.jTabbedPane.removeAll();
        this.textAreaList.clear();
        this.sortKeyList.clear();
        this.isEdited = false;
        int maxRows = 0;
        NodeList nodeList = this.subsystemTableElement_.getElementsByTagName("Instance");
        if (nodeList.getLength() == 0) {
            maxRows = this.setupTextAreaForInstance(this.subsystemTableElement_.getAttribute("Instance"), "0");
        } else {
            Modeler.SortableDomElementListModel sortableDomElementListModel = new Modeler.SortableDomElementListModel(this.frame_);
            int i = 0;
            while (i < nodeList.getLength()) {
                sortableDomElementListModel.addElement(nodeList.item(i));
                ++i;
            }
            sortableDomElementListModel.sortElements();
            i = 0;
            while (i < sortableDomElementListModel.getSize()) {
                Element element = (Element)sortableDomElementListModel.getElementAt(i);
                int rows = this.setupTextAreaForInstance(element.getAttribute("Text"), element.getAttribute("SortKey"));
                if (rows > maxRows) {
                    maxRows = rows;
                }
                ++i;
            }
        }
        this.textAreaList.get(0).requestFocus();
        this.setTitle("Instance - " + entityBox.getTableNode().getElement().getAttribute("Name"));
        if (this.frame_.modelSize.equals("S")) {
            this.setPreferredSize(new Dimension(entityBox.getWidth() - 58, 150));
            this.setLocation((int)entityBox.getLocationOnScreen().getX() + 83, (int)(entityBox.getLocationOnScreen().getY() + (double)entityBox.getHeight() - 4.0));
        }
        if (this.frame_.modelSize.equals("M")) {
            this.setPreferredSize(new Dimension(entityBox.getWidth() - 150, 200));
            this.setLocation((int)entityBox.getLocationOnScreen().getX() + 175, (int)(entityBox.getLocationOnScreen().getY() + (double)entityBox.getHeight() - 8.0));
        }
        if (this.frame_.modelSize.equals("L")) {
            this.setPreferredSize(new Dimension(entityBox.getWidth() - 242, 300));
            this.setLocation((int)entityBox.getLocationOnScreen().getX() + 265, (int)(entityBox.getLocationOnScreen().getY() + (double)entityBox.getHeight() - 12.0));
        }
        this.pack();
        this.setVisible(true);
        this.updateAndClose();
        return this.isEdited;
    }

    int setupTextAreaForInstance(String text, String sortKey) {
        JTextArea jTextArea = new JTextArea();
        if (this.frame_.modelSize.equals("S")) {
            jTextArea.setFont(new Font(this.frame_.ioImageFontName, 0, 7));
        }
        if (this.frame_.modelSize.equals("M")) {
            jTextArea.setFont(new Font(this.frame_.ioImageFontName, 0, 14));
        }
        if (this.frame_.modelSize.equals("L")) {
            jTextArea.setFont(new Font(this.frame_.ioImageFontName, 0, 21));
        }
        jTextArea.setLineWrap(false);
        jTextArea.setText(Modeler.substringLinesWithTokenOfEOL(text, "\n"));
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(true);
        jTextArea.addMouseListener(new DialogEditInstanceOnDatamodel_mouseAdapter(this));
        jTextArea.addKeyListener(new DialogEditInstanceOnDatamodel_keyAdapter(this));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jTextArea);
        this.jTabbedPane.add((Component)jScrollPane, "Slide " + sortKey);
        this.textAreaList.add(jTextArea);
        this.sortKeyList.add(sortKey);
        if (this.frame_.isNormalColorConfigOnDataModel) {
            jTextArea.setCaretColor(Color.WHITE);
            jTextArea.setBackground(Modeler.DESKTOP_COLOR);
            jTextArea.setForeground(Color.WHITE);
        } else {
            jTextArea.setCaretColor(Color.BLACK);
            jTextArea.setBackground(Color.WHITE);
            jTextArea.setForeground(Color.BLACK);
        }
        return jTextArea.getRows();
    }

    void jTextArea_mousePressed(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 16) {
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    void jTextArea_keyPressed(KeyEvent e) {
        this.isEdited = true;
    }

    void jMenuItemAddSlide_actionPerformed(ActionEvent e) {
        String text = this.textAreaList.get(this.jTabbedPane.getSelectedIndex()).getText();
        int sortKey = Integer.parseInt(this.sortKeyList.get(this.sortKeyList.size() - 1)) + 1;
        this.setupTextAreaForInstance(text, Integer.toString(sortKey));
        this.isEdited = true;
    }

    void jMenuItemRemoveSlide_actionPerformed(ActionEvent e) {
        this.textAreaList.remove(this.jTabbedPane.getSelectedIndex());
        this.sortKeyList.remove(this.jTabbedPane.getSelectedIndex());
        this.jTabbedPane.remove(this.jTabbedPane.getSelectedIndex());
        this.isEdited = true;
        if (this.jTabbedPane.getTabCount() == 0) {
            this.frame_.informationOnThisPageChanged = this.updateAndClose();
        }
    }

    void jMenuItemSetSequence_actionPerformed(ActionEvent e) {
        this.sModel.setValue(Integer.parseInt(this.sortKeyList.get(this.jTabbedPane.getSelectedIndex())));
        int option = JOptionPane.showOptionDialog(this, this.spinner, res.getString("DialogEditInstanceOnDatamodel2"), 2, 3, null, null, null);
        if (option == 0) {
            this.sortKeyList.set(this.jTabbedPane.getSelectedIndex(), this.sModel.getValue().toString());
            this.jTabbedPane.setTitleAt(this.jTabbedPane.getSelectedIndex(), "Slide " + this.sModel.getValue().toString());
            this.isEdited = true;
        }
    }

    boolean updateAndClose() {
        if (this.isEdited) {
            NodeList nodeList = this.subsystemTableElement_.getElementsByTagName("Instance");
            int count = nodeList.getLength();
            int i = 0;
            while (i < count) {
                this.subsystemTableElement_.removeChild(nodeList.item(0));
                ++i;
            }
            i = 0;
            while (i < this.textAreaList.size()) {
                Element newElement = this.frame_.getDomDocument().createElement("Instance");
                newElement.setAttribute("Text", Modeler.concatLinesWithTokenOfEOL(this.textAreaList.get(i).getText()));
                newElement.setAttribute("SortKey", this.sortKeyList.get(i));
                this.subsystemTableElement_.appendChild(newElement);
                ++i;
            }
        }
        this.setVisible(false);
        return this.isEdited;
    }
}

