/************************************************************/
/* 業務マニュアルブラウザ For XEAD Version1.0               */
/* tasklist.js(javascript)                                  */
/* Copyright(c) 2006 DBC(WATANABE Kozo) All rights reserved.*/
/************************************************************/

var httpObj;
var timerId;
var timeout_sec = 10;
var xeadFile;

var roleID;
var roleInternalID;
var xeadRoleNodes;
var xeadTaskNodes;
var maxTask;
var docTaskList;
var taskArray = new Array(100);

function setupXeadElements(xead) {
    //
    //職務名の検索と設定
    xeadRoleNodes = xead.getElementsByTagName('Role');
    var num = xeadRoleNodes.length;
    for (i=0; i<num; i++) {
        if (xeadRoleNodes[i].getAttribute('SortKey') == roleID) {
            roleInternalID = xeadRoleNodes[i].getAttribute('ID');
            document.getElementById('roleName').childNodes[0].nodeValue = xeadRoleNodes[i].getAttribute('Name') + ' 業務一覧';
            i = num;
        }
    }
    //
    //職務一覧の検索と設定
    setupTaskList(xead);
    //
    //読込中のブランク表示を解除
    if(navigator.userAgent.indexOf("MSIE") == -1){
        document.getElementById('wrapper').setAttribute('class','active');
    } else {
        document.getElementById('wrapper').setAttribute('className','active');
    }
}

function setupTaskList(xead) {
    //
    xeadTaskNodes = xead.getElementsByTagName('Task');
    var num = xeadTaskNodes.length;
    var maxTask = 0;
    for (i=0; i<num; i++) {
        if (xeadTaskNodes[i].getAttribute('RoleID') == roleInternalID) {
            taskArray[maxTask] = xeadTaskNodes[i];
            maxTask++;
        }
    }
    var sortedTaskArray = sortNodesByKey(taskArray, maxTask);
    //
    docTaskList = document.getElementById('taskList');
    var taskRecord;
    var taskDataNumber;
    var taskDataEvent;
    var taskDataName;
    var taskDataAnchor;
    //
    for (i=0; i<maxTask; i++) {
        //
        taskRecord = document.createElement('tr');
        taskDataNumber = document.createElement('td');
        taskDataEvent = document.createElement('td');
        taskDataName = document.createElement('td');
        taskDataAnchor = document.createElement('a');
        //
        taskDataNumber.appendChild(document.createTextNode(i+1));
        taskDataNumber.setAttribute('align','right');
        taskRecord.appendChild(taskDataNumber);
        taskDataEvent.appendChild(document.createTextNode(sortedTaskArray[i].getAttribute('Event')));
        taskRecord.appendChild(taskDataEvent);
        taskDataAnchor.setAttribute('href', 'task.html?file=' + xeadFile + '&id=' + sortedTaskArray[i].getAttribute('ID'));
        taskDataAnchor.appendChild(document.createTextNode(sortedTaskArray[i].getAttribute('Name')));
        taskDataName.appendChild(taskDataAnchor);
        taskRecord.appendChild(taskDataName);
        //
        //docTaskList.childNodes[0].appendChild(taskRecord);
        if(navigator.userAgent.indexOf("MSIE") == -1){
            docTaskList.appendChild(taskRecord);
        } else {
            docTaskList.childNodes[0].appendChild(taskRecord);
        }
    }
}

function sortNodesByKey(nodes, nodesLength) { /* nodesの後ろ側の要素がnullかもしれないので、nullでない先行要素数としてnodesLengthが必要 */
    //
    // nodesからSortKeyの値を取り出して配列に保管する
    var keyArray = new Array(nodesLength);
    for (i=0; i<nodesLength; i++){
        if (nodes[i].getAttribute('SortKey') == '') {
            keyArray[i] = '';
        } else {
            keyArray[i] = nodes[i].getAttribute('SortKey');
        }
    }
    //
    // SortKeyの配列を昇順に並び替える
    for (i=0; i<nodesLength-1; i++){
        for (j=i+1; j<nodesLength; j++){
            if (keyArray[j] < keyArray[i]){
                var n = keyArray[j];
                keyArray[j] = keyArray[i];
                keyArray[i] = n;
            }
        }
    }
    //
    // SortKeyの順序に従って受取配列を結果配列に保管する
    var nodeArray = new Array(nodesLength);
    for (i=0; i<nodesLength; i++){
        for (j=0; j<nodesLength; j++){
                //alert(i+'-'+keyArray[i]+';'+j+'-'+nodes[j].getAttribute('SortKey'));
            if (keyArray[i] == nodes[j].getAttribute('SortKey')){
                var existing = false;
                for (k=0; k<i; k++){
                    if (nodeArray[k] == nodes[j]){
                        existing = true;
                    }
                }
                if (!existing) {
                    nodeArray[i] = nodes[j];
                }
            }
        }
    }
    //
    return nodeArray;
}

function getParmValueBy(keyWord){
   //
   keyWord = "&" + keyWord + "=";
   var value = null;
   var parms = location.search;
   var parmsLength = parms.length;
   var trimmedParms = "&" + parms.substring(1,parmsLength) + "&";
   var parmPos = trimmedParms.indexOf(keyWord);
   //
   if (parmPos != -1){
      var parmStart = parmPos + keyWord.length;
      var parmEnd   = trimmedParms.indexOf("&" , parmStart);
      var parmValue = trimmedParms.substring(parmStart,parmEnd);
      parmValue = unescape(parmValue);
   }
   //
   return parmValue;
}

function loadXeadFile(e) {
    //
    roleID = getParmValueBy("id") + "";     /* 職務定義の内部識別子 */
    xeadFile = getParmValueBy("file"); /* コンテンツファイル名。拡張子が.xeadだと何故かresponseXMLに失敗するのでサーバ上では.xmlに変更しておくこと */
    //
    httpXmlRequest(xeadFile, 'GET', '', setupXeadElements, httpError);
    stopDefaultAndPropagation(e);
    //
    return false;
}

function httpError(error) {
    alert(error);
}

function httpXmlRequest(target_url, method, data, success_func, error_func) {
    try {
        if(window.XMLHttpRequest) {
            httpObj = new XMLHttpRequest();
        } else if(window.ActiveXObject) {
            httpObj = new ActiveXObject("Microsoft.XMLHTTP");
        } else {
            httpObj = false;
        }
    } catch(e) {
        httpObj = false;
    }
    if(! httpObj) {
        httpObjGenerateFail();
    }
    timerId = setInterval('timeoutCheck()', 1000);
    httpObj.open(method, target_url, true);
    httpObj.onreadystatechange = function() {
        if (httpObj.readyState == 4) {
            clearInterval(timerId);
            if (httpObj.status == 200) {
                success_func(httpObj.responseXML);
            } else {
                error_func(httpObj.status + ' : ' + httpObj.statusText);
                return false;
            }
        }
    }
    httpObj.send(data);
}

function timeoutCheck() {
    timeout_sec --;
    if(timeout_sec <= 0) {
        clearInterval(timerId);
        httpObj.abort();
        alert('TIME OUT');
        return false;
    }
}

function stopDefaultAndPropagation(e) {
    if(e.stopPropagation) {
        e.stopPropagation();
    }
    if(window.event) {
        window.event.cancelBubble = true;
    }
    if(e.preventDefault) {
        e.preventDefault();
    }
    if(window.event) {
        window.event.returnValue = false;
    }
}

function addListener(elem, eventType, func, cap) {
    if(elem.addEventListener) {
        elem.addEventListener(eventType, func, cap);
    } else if(elem.attachEvent) {
        elem.attachEvent('on' + eventType, func);
    } else {
        alert('このブラウザはサポートされていません。');
        return false;
    }
}

// ＨＴＭＬのＬＯＡＤ完了時の実行ステップ
addListener(window, 'load', loadXeadFile, false);
