/************************************************************/
/* 業務マニュアルブラウザ For XEAD Version1.0               */
/* rolelist.js(javascript)                                  */
/* Copyright(c) 2006 DBC(WATANABE Kozo) All rights reserved.*/
/************************************************************/

var httpObj;
var timerId;
var timeout_sec = 10;
var xeadFile;

var xeadRoleNodes;
var maxRole;
var docRoleList;

function setupXeadElements(xead) {
    //
    //システム名の検索と設定
    document.getElementById('systemName').childNodes[0].nodeValue = xead.getElementsByTagName('System')[0].getAttribute('Name') + ' 職務一覧';
    //
    //職務一覧の検索と設定
    setupRoleList(xead);
    //
    //読込中のブランク表示を解除
    if(navigator.userAgent.indexOf("MSIE") == -1){
        document.getElementById('wrapper').setAttribute('class','active');
    } else {
        document.getElementById('wrapper').setAttribute('className','active');
    }
}

function setupRoleList(xead) {
    //
    xeadRoleNodes = xead.getElementsByTagName('Role');
    var sortedRoleArray = sortNodesByKey(xeadRoleNodes);
    maxRole= sortedRoleArray.length;
    //
    docRoleList = document.getElementById('roleList');
    var roleRecord;
    var roleDataNumber;
    var roleDataName;
    var roleDataAnchor;
    //
    for (i=0; i<maxRole; i++) {
        //
        roleRecord = document.createElement('tr');
        roleDataNumber = document.createElement('td');
        roleDataName = document.createElement('td');
        roleDataAnchor = document.createElement('a');
        //
        roleDataNumber.appendChild(document.createTextNode(i+1));
        roleDataNumber.setAttribute('align','right');
        roleRecord.appendChild(roleDataNumber);
        roleDataAnchor.setAttribute('href', 'tasklist.html?file=' + xeadFile + '&id=' + sortedRoleArray[i].getAttribute('SortKey'));
        roleDataAnchor.appendChild(document.createTextNode(sortedRoleArray[i].getAttribute('Name')));
        roleDataName.appendChild(roleDataAnchor);
        roleRecord.appendChild(roleDataName);
        //
        //docRoleList.childNodes[0].appendChild(roleRecord);
        if(navigator.userAgent.indexOf("MSIE") == -1){
            docRoleList.appendChild(roleRecord);
        } else {
            docRoleList.childNodes[0].appendChild(roleRecord);
        }
    }
}

function sortNodesByKey(nodes) {
    //
    // nodesからSortKeyの値を取り出して配列に保管する
    var num = nodes.length;
    var keyArray = new Array(num);
    var arrayNum = 0;
    for (i=0; i<num; i++){
        if (nodes[i].getAttribute('SortKey') == '') {
            keyArray[i] = '';
        } else {
            keyArray[i] = nodes[i].getAttribute('SortKey');
        }
        arrayNum++;
    }
    //
    // SortKeyの配列を昇順に並び替える
    for (i=0; i<arrayNum-1; i++){
        for (j=i+1; j<arrayNum; j++){
            if (keyArray[j] < keyArray[i]){
                var n = keyArray[j];
                keyArray[j] = keyArray[i];
                keyArray[i] = n;
            }
        }
    }
    //
    // SortKeyの順序に従って受取配列を結果配列に保管する
    var nodeArray = new Array(arrayNum);
    for (i=0; i<arrayNum; i++){
        for (j=0; j<arrayNum; j++){
            if (keyArray[i] == nodes[j].getAttribute('SortKey')){
                var existing = false;
                for (k=0; k<i; k++){
                    if (nodeArray[k] == nodes[j]){
                        existing = true;
                    }
                }
                if (!existing) {
                    nodeArray[i] = nodes[j];
                }
            }
        }
    }
    //
    return nodeArray;
}

function getParmValueBy(keyWord){
   //
   keyWord = "&" + keyWord + "=";
   var value = null;
   var parms = location.search;
   var parmsLength = parms.length;
   var trimmedParms = "&" + parms.substring(1,parmsLength) + "&";
   var parmPos = trimmedParms.indexOf(keyWord);
   //
   if (parmPos != -1){
      var parmStart = parmPos + keyWord.length;
      var parmEnd   = trimmedParms.indexOf("&" , parmStart);
      var parmValue = trimmedParms.substring(parmStart,parmEnd);
      parmValue = unescape(parmValue);
   }
   //
   return parmValue;
}

function loadXeadFile(e) {
    //
    xeadFile = getParmValueBy("file"); /* コンテンツファイル名。拡張子が.xeadだと何故かresponseXMLに失敗するのでサーバ上では.xmlに変更しておくこと */
    //
    httpXmlRequest(xeadFile, 'GET', '', setupXeadElements, httpError);
    stopDefaultAndPropagation(e);
    //
    return false;
}

function httpError(error) {
    alert(error);
}

function httpXmlRequest(target_url, method, data, success_func, error_func) {
    try {
        if(window.XMLHttpRequest) {
            httpObj = new XMLHttpRequest();
        } else if(window.ActiveXObject) {
            httpObj = new ActiveXObject("Microsoft.XMLHTTP");
        } else {
            httpObj = false;
        }
    } catch(e) {
        httpObj = false;
    }
    //
    if(! httpObj) {
        httpObjGenerateFail();
    }
    //
    timerId = setInterval('timeoutCheck()', 1000);
    httpObj.open(method, target_url, true);
    httpObj.onreadystatechange = function() {
        if (httpObj.readyState == 4) {
            clearInterval(timerId);
	    if (httpObj.status == 200) {
       	        success_func(httpObj.responseXML);
            } else {
                error_func(httpObj.status + ' : ' + httpObj.statusText);
                return false;
            }
        }
    }
    httpObj.send(data);
}

function timeoutCheck() {
    timeout_sec --;
    if(timeout_sec <= 0) {
        clearInterval(timerId);
        httpObj.abort();
        alert('TIME OUT');
        return false;
    }
}

function stopDefaultAndPropagation(e) {
    if(e.stopPropagation) {
        e.stopPropagation();
    }
    if(window.event) {
        window.event.cancelBubble = true;
    }
    if(e.preventDefault) {
        e.preventDefault();
    }
    if(window.event) {
        window.event.returnValue = false;
    }
}

function addListener(elem, eventType, func, cap) {
    if(elem.addEventListener) {
        elem.addEventListener(eventType, func, cap);
    } else if(elem.attachEvent) {
        elem.attachEvent('on' + eventType, func);
    } else {
        alert('このブラウザはサポートされていません。');
    	return false;
    }
}

// ＨＴＭＬのＬＯＡＤ完了時の実行ステップ
addListener(window, 'load', loadXeadFile, false);
