/*
 * Decompiled with CFR 0.152.
 */
package xeadModeler;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import xeadModeler.Modeler;

public class Application {
    private static ResourceBundle res = ResourceBundle.getBundle("xeadModeler.Res");
    private boolean packFrame = false;
    private JWindow splashScreen;
    private JLabel splashIcon;
    private JLabel splashLabel;

    public Application(String[] args) {
        ImageIcon image = new ImageIcon(Application.class.getResource("splash.png"));
        this.splashIcon = new JLabel(image);
        this.splashIcon.setLayout(null);
        this.splashLabel = new JLabel();
        this.splashLabel.setFont(new Font("Dialog", 0, 16));
        this.splashLabel.setOpaque(false);
        this.splashLabel.setBounds(280, 205, 220, 20);
        this.splashLabel.setText(res.getString("SplashMessage0"));
        this.splashIcon.add(this.splashLabel);
        this.splashScreen = new JWindow();
        this.splashScreen.getContentPane().add(this.splashIcon);
        this.splashScreen.pack();
        this.splashScreen.setLocationRelativeTo(null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.this.showSplash();
            }
        });
        Modeler frame = new Modeler(args, this);
        if (this.packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setExtendedState(6);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Application(args);
    }

    public void showSplash() {
        this.splashScreen.setVisible(true);
    }

    public void setTextOnSplash(String text) {
        if (this.splashLabel != null) {
            this.splashLabel.setText(text);
        }
    }

    public void hideSplash() {
        if (this.splashScreen != null) {
            this.splashScreen.setVisible(false);
            this.splashScreen = null;
            this.splashLabel = null;
        }
    }
}

