/************************************************************/
/* 業務マニュアルブラウザ For XEAD Version1.0               */
/* task.js(javascript)   2007.07.30 updated                 */
/* Copyright(c) 2007 DBC(WATANABE Kozo) All rights reserved.*/
/************************************************************/

var httpObj;
var timerId;
var timeout_sec = 10;
var xeadFile;

var taskID;
var roleID;
var xeadTaskNode;
var xeadActionNodes;
var xeadActionIoNodes;
var xeadFunctionNodes;
var docActionList;
var docIoImageList;
var maxImage;
var maxAction;
var maxFunction;

function setupXeadElements(xead) {
    //
    //業務定義の検索
    var taskName;
    var taskList = xead.getElementsByTagName('Task');
    var num = taskList.length;
    for (i=0; i<num; i++) {
        if (taskList[i].getAttribute('ID') == taskID){
            xeadTaskNode = taskList[i];
            taskName = xeadTaskNode.getAttribute('SortKey') + ' ' + xeadTaskNode.getAttribute('Name');
            i = num;
        }
    }
    //
    //職務定義の検索
    var roleName;
    var roleList = xead.getElementsByTagName('Role');
    num = roleList.length;
    for (i=0; i<num; i++) {
        if (roleList[i].getAttribute('ID') == xeadTaskNode.getAttribute('RoleID')){
            roleID = roleList[i].getAttribute('SortKey') + '';
            roleName = roleList[i].getAttribute('SortKey') + ' ' + roleList[i].getAttribute('Name');
            i = num;
        }
    }
    //
    //業務一覧へのリンク設定
    document.getElementById('link1ToTaskList').setAttribute('href', 'tasklist.html?file=' + xeadFile + '&id=' + roleID);
    document.getElementById('link2ToTaskList').setAttribute('href', 'tasklist.html?file=' + xeadFile + '&id=' + roleID);
    //
    //職務名、業務名、イベント、業務説明の設定
    document.getElementById('taskName').childNodes[0].nodeValue = roleName + ' ' + taskName;
    var element = document.createElement('p');
    var paragraph = document.createTextNode(xeadTaskNode.getAttribute('Event'));
    element.appendChild(paragraph);
    document.getElementById('taskEvent').appendChild(element);
    substringParagraphs(xeadTaskNode.getAttribute('Descriptions'), document.getElementById('taskNotes'));
    //
    //アクションの検索とツリー設定
    setupActionTree(xead);
    //
    //読込中のブランク表示を解除
    if(navigator.userAgent.indexOf("MSIE") == -1){
        document.getElementById('wrapper').setAttribute('class','active');
    } else {
        document.getElementById('wrapper').setAttribute('className','active');
    }
}

function setupActionTree(xead) {
    //
    xeadFunctionNodes = xead.getElementsByTagName('Function');
    maxFunction = xeadFunctionNodes.length;
    //
    //xeadActionNodes = sortNodesByKey(xeadTaskNode.childNodes);
    if(navigator.userAgent.indexOf("MSIE") == -1){
        xeadActionNodes = xeadTaskNode.getElementsByTagName('TaskAction');
        xeadActionNodes = sortNodesByKey(xeadActionNodes);
    } else {
        xeadActionNodes = sortNodesByKey(xeadTaskNode.childNodes);
    }
    maxAction = xeadActionNodes.length;
    //
    docActionList = document.getElementById('actionList');
    var actionListItem;
    var actionListItemH4;
    var actionListItemH4Text;
    var actionListItemDiv;
    var actionListItemDivText;
    var topItem;
    //
    var indentArrow = new Array(maxAction);
    for (i=0; i<maxAction; i++) {
        indentArrow[i] = '';
    }
    var indentDigit = new Array(10);
    for (i=0; i<10; i++) {
        indentDigit[i] = '　　';
    }
    var preIndentDigit = new Array(10);
    for (i=0; i<10; i++) {
        preIndentDigit[i] = '　　';
    }
    //
    var level = 0;
    for (i=maxAction-1;i>0;i--) {
        //
        level = xeadActionNodes[i].getAttribute('IndentLevel') - 1;
        //
        for (j=0; j<10; j++) {
            //
            if (j == level) {
                if (preIndentDigit[j] == '　　') {
                    indentDigit[j] = '└→';
                } else {
                    indentDigit[j] = '├→';
                }
                indentArrow[i] += indentDigit[j]
            }
            if (j < level) {
                if (preIndentDigit[j] == '　　') {
                    indentDigit[j] = '　　';
                } else {
                    indentDigit[j] = '｜　';
                }
                indentArrow[i] += indentDigit[j]
            }
            if (j > level) {
                indentDigit[j] = '　　';
            }
            //
            preIndentDigit[j] = indentDigit[j];
        }
    }
    //
    for (i=0; i<maxAction; i++) {
        //
        actionListItemH4 = document.createElement('h4');
        actionListItemH4Text = document.createTextNode(indentArrow[i]);
        actionListItemH4.appendChild(actionListItemH4Text);
        //
        actionListItemDiv = document.createElement('div');
        actionListItemDiv.setAttribute('id', xeadActionNodes[i].getAttribute('SortKey'));
        if(navigator.userAgent.indexOf("MSIE") == -1){
            actionListItemDiv.setAttribute('class', 'normal');
        } else {
            actionListItemDiv.setAttribute('className', 'normal');
        }
        if (xeadActionNodes[i].getAttribute('ExecuteIf') == '') {
            actionListItemDivText = document.createTextNode(xeadActionNodes[i].getAttribute('Label'));
        } else {
            actionListItemDivText = document.createTextNode(xeadActionNodes[i].getAttribute('ExecuteIf') + '、' + xeadActionNodes[i].getAttribute('Label'));
        }
        actionListItemDiv.appendChild(actionListItemDivText);
        //
        actionListItem = document.createElement('li');
        actionListItem.appendChild(actionListItemH4);
        actionListItem.appendChild(actionListItemDiv);
        docActionList.appendChild(actionListItem);
        //
        addListener(actionListItemDiv, 'click', actionElementTrigger, false);
        //
        if (i == 0){
            topItem = actionListItemDiv;
        }
    }
    //
    if (maxAction > 0){
        setActionSelected(topItem);
    }
}

function sortNodesByKey(nodes) {
    //
    // nodesからSortKeyの値を取り出して配列に保管する
    var num = nodes.length;
    var keyArray = new Array(num);
    var arrayNum = 0;
    for (i=0; i<num; i++){
        if (nodes[i].getAttribute('SortKey') == '') {
            keyArray[i] = '';
        } else {
            keyArray[i] = nodes[i].getAttribute('SortKey');
        }
        arrayNum++;
    }
    //
    // SortKeyの配列を昇順に並び替える
    for (i=0; i<arrayNum-1; i++){
        for (j=i+1; j<arrayNum; j++){
            if (keyArray[j] < keyArray[i]){
                var n = keyArray[j];
                keyArray[j] = keyArray[i];
                keyArray[i] = n;
            }
        }
    }
    //
    // SortKeyの順序に従って受取配列を結果配列に保管する
    var nodeArray = new Array(arrayNum);
    for (i=0; i<arrayNum; i++){
        for (j=0; j<arrayNum; j++){
            if (keyArray[i] == nodes[j].getAttribute('SortKey')){
                var existing = false;
                for (k=0; k<i; k++){
                    if (nodeArray[k] == nodes[j]){
                        existing = true;
                    }
                }
                if (!existing) {
                    nodeArray[i] = nodes[j];
                }
            }
        }
    }
    //
    return nodeArray;
}

function actionElementTrigger(e) {
    setActionSelected(getTargetNode(e));
}

function setActionSelected(actionListItem) {
    //
    var imageListItem;
    var imageListItemImg;
    var topImage;
    //
    var workNode = docActionList.getElementsByTagName('div');
    var i;
    docActionList = document.getElementById('actionList');
    for (i=0; i<maxAction; i++) {
        //actionList.childNodes[i].getElementsByTagName('div')[0].setAttribute('className','normal');
        if(navigator.userAgent.indexOf("MSIE") == -1){
            workNode[i].setAttribute('class','normal');
        } else {
            workNode[i].setAttribute('className','normal');
        }
    }
    if(navigator.userAgent.indexOf("MSIE") == -1){
        actionListItem.setAttribute('class','active');
    } else {
        actionListItem.setAttribute('className','active');
    }
    //
    docIoImageList = document.getElementById('ioImageList');
    var max = docIoImageList.childNodes.length;
    for (i=0; i<max; i++) {
        docIoImageList.removeChild(docIoImageList.lastChild);
    }
    //
    for (i=0; i<maxAction; i++) {
        //
        if (xeadActionNodes[i].getAttribute('SortKey') == actionListItem.getAttribute('id')){
            //
            //xeadActionIoNodes = sortNodesByKey(xeadActionNodes[i].childNodes);
            if(navigator.userAgent.indexOf("MSIE") == -1){
                xeadActionIoNodes = xeadActionNodes[i].getElementsByTagName('TaskFunctionIO');
                xeadActionIoNodes = sortNodesByKey(xeadActionIoNodes);
            } else {
                xeadActionIoNodes = sortNodesByKey(xeadActionNodes[i].childNodes);
            }
            maxActionIo = xeadActionIoNodes.length;
            //
            var n;
            var actionNotes = document.getElementById('actionNotes');
            var paragraphList = actionNotes.getElementsByTagName('p');
            var numberOfParagraphs = paragraphList.length;
            for (n=0; n<numberOfParagraphs; n++) {
                elm = paragraphList[0];
                actionNotes.removeChild(elm);
            }
            //
            substringParagraphs(xeadActionNodes[i].getAttribute('Descriptions'), actionNotes);
            //
            for (j=0; j<maxActionIo; j++) {
                //
                var functionID = xeadActionIoNodes[j].getAttribute('FunctionID');
                var ioID = xeadActionIoNodes[j].getAttribute('IOID');
                var functionSortKey;
                var ioSortKey;
                var functionName;
                var ioName;
                //
                var n;
                for (n=0; n<maxFunction; n++) {
                    //
                    if (xeadFunctionNodes[n].getAttribute('ID') == functionID) {
                        //
                        functionName = xeadFunctionNodes[n].getAttribute('Name');
                        functionSortKey = xeadFunctionNodes[n].getAttribute('SortKey');
                        //
                        var ioNode = null;
                        var ioNodes = xeadFunctionNodes[n].getElementsByTagName('IOPanel')
                        max = ioNodes.length;
                        var k;
                        for (k=0; k<max; k++) {
                            if (ioNodes[k].getAttribute('ID') == ioID){
                                ioNode = ioNodes[k];
                            }
                        }
                        if (ioNode == null) {
                            ioNodes = xeadFunctionNodes[n].getElementsByTagName('IOSpool')
                            max = ioNodes.length;
                            for (k=0; k<max; k++) {
                                if (ioNodes[k].getAttribute('ID') == ioID){
                                    ioNode = ioNodes[k];
                                }
                            }
                        }
                        if (ioNode == null) {
                            ioNodes = xeadFunctionNodes[n].getElementsByTagName('IOWebPage')
                            max = ioNodes.length;
                            for (k=0; k<max; k++) {
                                if (ioNodes[k].getAttribute('ID') == ioID){
                                    ioNode = ioNodes[k];
                                }
                            }
                        }
                        //
                        if (ioNode != null) {
                            ioName = ioNode.getAttribute('Name');
                            ioSortKey = ioNode.getAttribute('SortKey');
                        }
                        //
                        n = maxFunction;
                    }
                }
                //
                imageListItem = document.createElement('li');
                imageListItem.setAttribute('id', xeadActionIoNodes[j].getAttribute('SortKey'));
                //
                var imgElement = new Image(0,0);
                if(navigator.userAgent.indexOf("MSIE") == -1){
                    imgElement.class = 'normal';
                } else {
                    imgElement.className = 'normal';
                }
                imgElement.src = 'images/' + functionSortKey + '_' + ioSortKey +'.PNG';
                imgElement.alt = functionName + '(' + ioName + ')' + functionSortKey + '_' + ioSortKey;
                if (j==0) {
                    imgElement.onerror = fireSelectionForDiv;
                    imgElement.onload = fireSelectionForImage;
                    topImage = imgElement;
                } else {
                    imgElement.onerror = setupImageForDiv;
                }
                addListener(imgElement, 'click', imageElementTrigger, false);
                imageListItem.appendChild(imgElement);
                //
                docIoImageList.appendChild(imageListItem);
            }
            //
            if (maxActionIo == 0) {
                clearIoImageSelected();
            } else {
                setIoImageSelected(topImage); /* fireSelectionForImage() が実行されないことがあるので予備として*/
            }
            //
            i = maxAction;
        }
    }
}

function setupImageForDiv(e) {
    //
    var parent = this.parentNode;
    parent.removeChild(this);
    var imageListItemDiv = document.createElement('div');
    if(navigator.userAgent.indexOf("MSIE") == -1){
        imageListItemDiv.setAttribute('class', 'normal');
    } else {
        imageListItemDiv.setAttribute('className', 'normal');
    }
    imageListItemDiv.appendChild(document.createTextNode(this.getAttribute('alt')));
    parent.appendChild(imageListItemDiv);
    addListener(imageListItemDiv, 'click', imageElementTrigger, false);
}

function fireSelectionForDiv(e) {
    //
    //以下の７ステップと同一だからと setupImageForDiv(e) に置き換えると動きがおかしくなるので注意
    var parent = this.parentNode;
    parent.removeChild(this);
    var imageListItemDiv = document.createElement('div');
    if(navigator.userAgent.indexOf("MSIE") == -1){
        imageListItemDiv.setAttribute('class', 'normal');
    } else {
        imageListItemDiv.setAttribute('className', 'normal');
    }
    imageListItemDiv.appendChild(document.createTextNode(this.getAttribute('alt')));
    parent.appendChild(imageListItemDiv);
    addListener(imageListItemDiv, 'click', imageElementTrigger, false);
    //
    setIoImageSelected(imageListItemDiv);
}

function fireSelectionForImage(e) {
    setIoImageSelected(this);
}

function imageElementTrigger(e) {
    setIoImageSelected(getTargetNode(e));
}

function setIoImageSelected(ioImageElement) {
    //
    if (ioImageElement.parentNode != null) { /* 親から切り離された要素に対する処理をスキップさせるための条件文 */
        //
        maxActionIo = docIoImageList.childNodes.length;
        //
        var i;
        for (i=0; i<maxActionIo; i++) {
            if(navigator.userAgent.indexOf("MSIE") == -1){
                docIoImageList.childNodes[i].firstChild.setAttribute('class','normal');
            } else {
                docIoImageList.childNodes[i].firstChild.setAttribute('className','normal');
            }
        }
        if(navigator.userAgent.indexOf("MSIE") == -1){
            ioImageElement.setAttribute('class','active');
        } else {
            ioImageElement.setAttribute('className','active');
        }
        //
        clearIoImageSelected();
        //
        var ioImageSelected = document.getElementById('ioImageSelected');
        var ioImageOperations = document.getElementById('ioImageOperations');
        var ioImageDescriptions = document.getElementById('ioImageDescriptions');
        //
        for (i=0; i<maxActionIo; i++) {
            //
            if (xeadActionIoNodes[i].getAttribute('SortKey') == ioImageElement.parentNode.getAttribute('id')){
                //
                var functionID = xeadActionIoNodes[i].getAttribute('FunctionID');
                var ioID = xeadActionIoNodes[i].getAttribute('IOID');
                //
                var j;
                for (j=0; j<maxFunction; j++) {
                    //
                    if (xeadFunctionNodes[j].getAttribute('ID') == functionID){
                        //
                        //var functionName = xeadFunctionNodes[j].getAttribute('Name');
                        //var functionSortKey = xeadFunctionNodes[j].getAttribute('SortKey');
                        //
                        var ioNode = null;
                        var ioNodes = xeadFunctionNodes[j].getElementsByTagName('IOPanel')
                        var max = ioNodes.length;
                        var k;
                        for (k=0; k<max; k++) {
                            if (ioNodes[k].getAttribute('ID') == ioID){
                                ioNode = ioNodes[k];
                            }
                        }
                        if (ioNode == null) {
                            ioNodes = xeadFunctionNodes[j].getElementsByTagName('IOSpool')
                            max = ioNodes.length;
                            for (k=0; k<max; k++) {
                                if (ioNodes[k].getAttribute('ID') == ioID){
                                    ioNode = ioNodes[k];
                                }
                            }
                        }
                        if (ioNode == null) {
                            ioNodes = xeadFunctionNodes[j].getElementsByTagName('IOWebPage')
                            max = ioNodes.length;
                            for (k=0; k<max; k++) {
                                if (ioNodes[k].getAttribute('ID') == ioID){
                                    ioNode = ioNodes[k];
                                }
                            }
                        }
                        //
                        var ioBackground = ioNode.getAttribute('Background');
                        var ioDescriptions = ioNode.getAttribute('Descriptions');
                        //
                        ioImageSelected.removeChild(ioImageSelected.firstChild);
                        if (ioImageElement.getAttribute('src') == null) {
                            if (ioNode.getAttribute('ImageText')) {
                                var ioImageText = ioNode.getAttribute('ImageText');
                                var ioImageSelectedDiv = document.createElement('div');
                                //ioImageSelectedDiv.appendChild(document.createTextNode(setupTextImage(ioImageText, ioNode.getElementsByTagName('IOPanelStyle'))));
                                ioImageSelectedDiv.innerHTML = setupTextImage(ioImageText, ioNode.getElementsByTagName('IOPanelStyle'));
                                ioImageSelected.appendChild(ioImageSelectedDiv);
                                if(navigator.userAgent.indexOf("MSIE") == -1){
                                    ioImageSelected.setAttribute('class', ioBackground);
                                } else {
                                    ioImageSelected.setAttribute('className', ioBackground);
                                }
                            }
                            if (ioNode.getAttribute('FileName')) {
                                httpXmlRequest(ioNode.getAttribute('FileName'), 'TEXT', 'GET', '', setupWebImage, httpError);
                            }
                        } else {
                            var ioImageSelectedImg = document.createElement('img');
                            ioImageSelectedImg.setAttribute('src', ioImageElement.getAttribute('src'));
                            ioImageSelected.appendChild(ioImageSelectedImg);
                            if(navigator.userAgent.indexOf("MSIE") == -1){
                                ioImageSelected.setAttribute('class', 'DEFAULT');
                            } else {
                                ioImageSelected.setAttribute('className', 'DEFAULT');
                            }
                        }
                        //
                        j = maxFunction;
                    }
                }
                //
                substringParagraphs(xeadActionIoNodes[i].getAttribute('Operations'), ioImageOperations);
                //
                substringParagraphs(ioDescriptions, ioImageDescriptions);
                //
                i = maxActionIo;
            }
        }
    }
}

function setupWebImage(html) {
   var ioImageSelected = document.getElementById('ioImageSelected');
   if(navigator.userAgent.indexOf("MSIE") == -1){
       ioImageSelected.setAttribute('class', 'default');
   } else {
       ioImageSelected.setAttribute('className', 'default');
   }
   var ioImageSelectedDiv = document.createElement('div');
   ioImageSelectedDiv.innerHTML = html;
   ioImageSelected.appendChild(ioImageSelectedDiv);
}

function clearIoImageSelected() {
    //
    var ioImageSelected = document.getElementById('ioImageSelected');
    var max = ioImageSelected.childNodes.length;
    for (i=0; i<max; i++) {
        ioImageSelected.removeChild(ioImageSelected.firstChild);
    }
    var paragraph = document.createTextNode('この手順では入出力フォームを利用しません。');
    ioImageSelected.appendChild(paragraph);
    //
    var ioImageOperations = document.getElementById('ioImageOperations');
    var paragraphList = ioImageOperations.getElementsByTagName('p');
    var numberOfParagraphs = paragraphList.length;
    for (i=0; i<numberOfParagraphs; i++) {
         ioImageOperations.removeChild(paragraphList[0]);
    }
    //
    var ioImageDescriptions = document.getElementById('ioImageDescriptions');
    paragraphList = ioImageDescriptions.getElementsByTagName('p');
    numberOfParagraphs = paragraphList.length;
    for (i=0; i<numberOfParagraphs; i++) {
         ioImageDescriptions.removeChild(paragraphList[0]);
    }
}

function getParmValueBy(keyWord){
   //
   keyWord = "&" + keyWord + "=";
   var value = null;
   var parms = location.search;
   var parmsLength = parms.length;
   var trimmedParms = "&" + parms.substring(1,parmsLength) + "&";
   var parmPos = trimmedParms.indexOf(keyWord);
   //
   if (parmPos != -1){
      var parmStart = parmPos + keyWord.length;
      var parmEnd   = trimmedParms.indexOf("&" , parmStart);
      var parmValue = trimmedParms.substring(parmStart,parmEnd);
      parmValue = unescape(parmValue);
   }
   //
   return parmValue;
}

function substringParagraphs(textData, parentNode) {
    //
    var j = 0;
    var parArray = new Array(20);
    for (i = 0; i < 20; i++) {
        parArray[i] = '';
    }
    //
    var lastEnd = 0;
    for (i = 0; i <= textData.length; i++) {
      //
      //説明文中に'@@TECHNICAL NOTES'のマークがあれば、それ以降の文を読み込まない//
      if (i+17 <= textData.length) {
        if (textData.substring(i,i+17) == '@@TECHNICAL NOTES') {
          break;
        }
      }
      //
      if (i+5 <= textData.length) {
        if (textData.substring(i,i+5) == '#EOL#') {
          j = j + 1;
          if (j<20) {
            parArray[j] = textData.substring(lastEnd, i);
          }
          lastEnd = i+5;
        }
      } else {
        if (i == textData.length) {
          j = j + 1;
          if (j<20) {
            parArray[j] = textData.substring(lastEnd, i);
          }
        }
      }
    }
    //
    for (i=0; i<parArray.length; i++) {
        if (parArray[i] != '') {
            var element = document.createElement('p');
            var paragraph = document.createTextNode(parArray[i]);
            element.appendChild(paragraph);
            parentNode.appendChild(element);
        }
    }
}

function setupTextImage(textData, styleNodes) {
    //
    var processedData = '<pre><font face="ＭＳ ゴシック">';
    var plainText = '';
    var textDataLength = textData.length;
    var styleLength = styleNodes.length;
    var textArray = new Array(textDataLength);
    var styleArray = new Array(textDataLength);
    var posStart = 0;
    var posEnd = 0;
    var type, color;
    var j = 0;
    //
    var i = 0;
    for (i = 0; i < textDataLength; i++) {
        textArray[i] = '';
        styleArray[i] = '';
    }
    //
    // 文字色、背景色、下線のスタイルデータをスタイル配列に組み込む
    for (i = 0; i < styleLength; i++) {
        //
        var val = parseStyleValue(styleNodes[i].getAttribute("Value"));
        //
        posStart = val[0];
        posEnd = val[1];
        type = val[2];
        color = val[3];
        //
        if (type == 'UL') {
            styleArray[posStart] = styleArray[posStart] + '<u>';
        }
        if (type == 'FG') {
            styleArray[posStart] = styleArray[posStart] + '<font color="' + color + '">';
        }
        if (type == 'BG') {
            styleArray[posStart] = styleArray[posStart] + '<font style="background-color: ' + color + '">';
        }
        //
        if (type == 'BG') {
            styleArray[posEnd] = styleArray[posEnd] + '</font>';
        }
        if (type == 'FG') {
            styleArray[posEnd] = styleArray[posEnd] + '</font>';
        }
        if (type == 'UL') {
            styleArray[posEnd] = styleArray[posEnd] + '</u>';
        }
    }
    //
    // テキストデータから改行制御文字(#EOL#)を切り出して、
    // <br/>の配列(styleArray)とテキスト文字配列(textArray)とに分離する
    for (i = 0; i < textDataLength; i++) {
        //
        if (i+5 <= textDataLength) {
            //
            if (textData.substring(i,i+5) == '#EOL#') {
                styleArray[j] = styleArray[j] + '<br/>';
                //textArray[j] = ' ';
                textArray[j] = '';
                i = i+4;
            } else {
                textArray[j] = textData.substring(i,i+1);
            }
        } else {
            textArray[j] = textData.substring(i,textDataLength);
            i = textData.length;
        }
        //
        j++;
    }
    //
    // plainTextデータとスタイル配列とをマージする。
    // <u>タグ指定領域において空白文字に下線がつかないことがあるので、半角空白を'.'に、全角空白を'..'に置き換える
    var ul_mode = false;
    for (i = 0; i < j; i++) {
        //
        processedData = processedData + styleArray[i];
        //
        //if (styleArray[i].indexOf('<u>') != -1) {
        //    if (styleArray[i].indexOf('</u>') == -1) {
        //        ul_mode = true;
        //    }
        //}
        //
        //if (styleArray[i].indexOf('<u>') == -1) {
        //    if (styleArray[i].indexOf('</u>') != -1) {
        //        ul_mode = false;
        //    }
        //}
        //
        //if (ul_mode && textArray[i]==' ') {
        //    processedData = processedData + '.';
        //} else {
        //    if (ul_mode && textArray[i]=='　') {
        //        processedData = processedData + '..';
        //    } else {
        //        processedData = processedData + textArray[i];
        //    }
        //}
        processedData = processedData + textArray[i];
    }
    //
    processedData = processedData + '</font></pre>';
    //
    return processedData;
}

function parseStyleValue(styleValue) {
    var val = new Array(4);
    var j = 0;
    var lastEnd = 0;
    //
    var i;
    for (i = 0; i < styleValue.length; i++) {
        if (i == styleValue.length-1) {
            val[j] = styleValue.substring(lastEnd,i+1);
        } else {
            if (styleValue.substring(i,i+1) == ',') {
                val[j] = styleValue.substring(lastEnd,i);
                j++;
                lastEnd = i+1;
            }
        }
    }
    //
    if (val[3] == 'WINDOW') {
       val[3] = 'GAINSBORO';
    }
    if (val[3] == 'GRAY') {
       val[3] = 'SILVER';
    }
    //
    return val;
}

function loadXeadFile(e) {
    //
    taskID = getParmValueBy("id");     /* 業務定義の内部識別子 */
    xeadFile = getParmValueBy("file"); /* コンテンツファイル名。拡張子が.xeadだと何故かresponseXMLに失敗するのでサーバ上では.xmlに変更しておくこと */
    //
    httpXmlRequest(xeadFile, 'XML', 'GET', '', setupXeadElements, httpError);
    stopDefaultAndPropagation(e);
    //
    return false;
}

function httpError(error) {
    alert(error);
}

function httpXmlRequest(target_url, file_type, method, data, success_func, error_func) {
    try {
        if(window.XMLHttpRequest) {
            httpObj = new XMLHttpRequest();
        } else if(window.ActiveXObject) {
            httpObj = new ActiveXObject("Microsoft.XMLHTTP");
        } else {
            httpObj = false;
        }
    } catch(e) {
        httpObj = false;
    }
    if(! httpObj) {
        httpObjGenerateFail();
    }
    timerId = setInterval('timeoutCheck()', 1000);
    httpObj.open(method, target_url, true);
    httpObj.onreadystatechange = function() {
        if (httpObj.readyState == 4) {
            clearInterval(timerId);
            if (httpObj.status == 200) {
                if (file_type == 'XML') {
                    success_func(httpObj.responseXML);
                }
                if (file_type == 'TEXT') {
                    success_func(httpObj.responseText);
                }
            } else {
                error_func(httpObj.status + ' : ' + httpObj.statusText);
                return false;
            }
        }
    }
    httpObj.send(data);
}

function timeoutCheck() {
    timeout_sec --;
    if(timeout_sec <= 0) {
        clearInterval(timerId);
        httpObj.abort();
        alert('TIME OUT');
        return false;
    }
}

function stopDefaultAndPropagation(e) {
    if(e.stopPropagation) {
        e.stopPropagation();
    }
    if(window.event) {
        window.event.cancelBubble = true;
    }
    if(e.preventDefault) {
        e.preventDefault();
    }
    if(window.event) {
        window.event.returnValue = false;
    }
}

function getTargetNode(e) {
    var target_node;
    if(e.target) {
      target_node = e.target;
    } else {
      target_node = e.srcElement;
    }
    if (target_node.nodeType == 3) {
        target_node = target_node.parentNode;
    }
    return target_node;
}

function addListener(elem, eventType, func, cap) {
    if(elem.addEventListener) {
        elem.addEventListener(eventType, func, cap);
    } else if(elem.attachEvent) {
        elem.attachEvent('on' + eventType, func);
    } else {
        alert('このブラウザはサポートされていません。');
        return false;
    }
}

/*ＨＴＭＬのＬＯＡＤ完了時の実行ステップ*/
addListener(window, 'load', loadXeadFile, false);
